/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.gql;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.graphql.gql.GQLField;
import net.morimekta.providence.graphql.gql.GQLFragment;
import net.morimekta.providence.graphql.gql.GQLUtil;
import net.morimekta.util.collect.UnmodifiableList;

public interface GQLSelection {
    @Nullable
    public List<GQLSelection> getSelectionSet();

    default public boolean hasSelection(PField<?> ... fields) {
        if (this.getSelectionSet() == null) {
            return true;
        }
        if (fields.length == 0) {
            return false;
        }
        for (GQLSelection sel : this.getSelectionSet()) {
            GQLFragment fragment;
            if (sel instanceof GQLField) {
                GQLField sf = (GQLField)sel;
                for (PField<?> field : fields) {
                    if (!sf.representing(field)) continue;
                    return true;
                }
                continue;
            }
            if (!(sel instanceof GQLFragment) || !(fragment = (GQLFragment)sel).hasSelection(fields)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasSelectionPath(PField<?> ... fields) {
        if (fields.length == 0) {
            throw new IllegalArgumentException("No fields to check selection for");
        }
        if (fields.length == 1) {
            return this.hasSelection(fields[0]);
        }
        if (this.getSelectionSet() == null) {
            return true;
        }
        PField<?> field = fields[0];
        PField[] args = new PField[fields.length - 1];
        System.arraycopy(fields, 1, args, 0, args.length);
        for (GQLSelection sel : this.getSelection(field)) {
            if (!sel.hasSelectionPath(args)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    default public List<GQLSelection> getSelection(@Nonnull PField<?> field) {
        if (this.getSelectionSet() == null) {
            return UnmodifiableList.listOf();
        }
        field = GQLUtil.baseField(field);
        ArrayList<GQLSelection> selection = new ArrayList<GQLSelection>();
        for (GQLSelection sel : this.getSelectionSet()) {
            if (sel instanceof GQLField) {
                GQLField sf = (GQLField)sel;
                if (!sf.representing(field)) continue;
                selection.add(sf);
                continue;
            }
            if (!(sel instanceof GQLFragment)) continue;
            GQLFragment fragment = (GQLFragment)sel;
            selection.addAll(fragment.getSelection(field));
        }
        return UnmodifiableList.copyOf(selection);
    }
}

