/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.gql;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.graphql.gql.GQLSelection;
import net.morimekta.providence.graphql.gql.GQLUtil;
import net.morimekta.providence.graphql.introspection.Schema;
import net.morimekta.providence.graphql.introspection.Type;
import net.morimekta.providence.graphql.introspection.TypeArguments;

@Immutable
public class GQLIntrospection
implements GQLSelection {
    private final List<GQLSelection> selectionSet;
    private final PMessage arguments;
    private final Field field;
    private final String alias;

    public static Field findFieldByName(String name) {
        for (Field field : Field.values()) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        return null;
    }

    public GQLIntrospection(@Nonnull Field field, @Nullable String alias, @Nullable PMessage<?> arguments, @Nullable List<GQLSelection> selectionSet) {
        this.field = field;
        this.alias = alias;
        this.arguments = arguments;
        this.selectionSet = selectionSet;
    }

    @Nullable
    public PMessage getArguments() {
        return this.arguments;
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @Nonnull
    public Field getField() {
        return this.field;
    }

    @Override
    public List<GQLSelection> getSelectionSet() {
        return this.selectionSet;
    }

    public String toString() {
        boolean first;
        StringBuilder builder = new StringBuilder();
        if (this.alias != null) {
            builder.append(this.alias).append(": ");
        }
        builder.append(this.field.name());
        if (this.arguments != null) {
            builder.append("(");
            first = true;
            for (PField pf : this.arguments.descriptor().getFields()) {
                if (!this.arguments.has(pf.getId())) continue;
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append(pf.getName()).append(": ").append(GQLUtil.toArgumentString(this.arguments.get(pf.getId())));
            }
            builder.append(")");
        }
        if (this.selectionSet != null && this.selectionSet.size() > 0) {
            if (this.arguments != null) {
                builder.append(" ");
            }
            builder.append("{");
            first = true;
            for (GQLSelection field : this.selectionSet) {
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append(field.toString());
            }
            builder.append("}");
        }
        return builder.toString();
    }

    public static enum Field {
        __type(TypeArguments.kDescriptor, (PDescriptor)Type.kDescriptor),
        __typename(null, (PDescriptor)PPrimitive.STRING),
        __schema(null, (PDescriptor)Schema.kDescriptor);

        public final PStructDescriptor<?> arguments;
        public final PDescriptor response;

        private Field(PStructDescriptor<?> arguments, PDescriptor response) {
            this.arguments = arguments;
            this.response = response;
        }
    }
}

