package net.morimekta.providence.graphql.introspection;

@javax.annotation.Generated(
        value = "net.morimekta.providence:providence-generator-java",
        comments = "java")
public enum DirectiveLocation
        implements net.morimekta.providence.PEnumValue<DirectiveLocation> {
    QUERY(0, "QUERY"),
    MUTATION(1, "MUTATION"),
    SUBSCRIPTION(2, "SUBSCRIPTION"),
    FIELD(3, "FIELD"),
    FRAGMENT_DEFINITION(4, "FRAGMENT_DEFINITION"),
    FRAGMENT_SPREAD(5, "FRAGMENT_SPREAD"),
    INLINE_FRAGMENT(6, "INLINE_FRAGMENT"),
    SCHEMA(7, "SCHEMA"),
    SCALAR(8, "SCALAR"),
    OBJECT(9, "OBJECT"),
    FIELD_DEFINITION(10, "FIELD_DEFINITION"),
    ARGUMENT_DEFINITION(11, "ARGUMENT_DEFINITION"),
    INTERFACE(12, "INTERFACE"),
    UNION(13, "UNION"),
    ENUM(14, "ENUM"),
    ENUM_VALUE(15, "ENUM_VALUE"),
    INPUT_OBJECT(16, "INPUT_OBJECT"),
    INPUT_FIELD_DEFINITION(17, "INPUT_FIELD_DEFINITION"),
    ;

    private final int    mId;
    private final String mName;

    DirectiveLocation(int id, String name) {
        mId = id;
        mName = name;
    }

    @Override
    public int asInteger() {
        return mId;
    }

    @Override
    @javax.annotation.Nonnull
    public String asString() {
        return mName;
    }

    /**
     * Find a value based in its ID
     *
     * @param id Id of value
     * @return Value found or null
     */
    @javax.annotation.Nullable
    public static DirectiveLocation findById(Integer id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case 0: return DirectiveLocation.QUERY;
            case 1: return DirectiveLocation.MUTATION;
            case 2: return DirectiveLocation.SUBSCRIPTION;
            case 3: return DirectiveLocation.FIELD;
            case 4: return DirectiveLocation.FRAGMENT_DEFINITION;
            case 5: return DirectiveLocation.FRAGMENT_SPREAD;
            case 6: return DirectiveLocation.INLINE_FRAGMENT;
            case 7: return DirectiveLocation.SCHEMA;
            case 8: return DirectiveLocation.SCALAR;
            case 9: return DirectiveLocation.OBJECT;
            case 10: return DirectiveLocation.FIELD_DEFINITION;
            case 11: return DirectiveLocation.ARGUMENT_DEFINITION;
            case 12: return DirectiveLocation.INTERFACE;
            case 13: return DirectiveLocation.UNION;
            case 14: return DirectiveLocation.ENUM;
            case 15: return DirectiveLocation.ENUM_VALUE;
            case 16: return DirectiveLocation.INPUT_OBJECT;
            case 17: return DirectiveLocation.INPUT_FIELD_DEFINITION;
            default: return null;
        }
    }

    /**
     * Find a value based in its name
     *
     * @param name Name of value
     * @return Value found or null
     */
    @javax.annotation.Nullable
    public static DirectiveLocation findByName(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "QUERY": return DirectiveLocation.QUERY;
            case "MUTATION": return DirectiveLocation.MUTATION;
            case "SUBSCRIPTION": return DirectiveLocation.SUBSCRIPTION;
            case "FIELD": return DirectiveLocation.FIELD;
            case "FRAGMENT_DEFINITION": return DirectiveLocation.FRAGMENT_DEFINITION;
            case "FRAGMENT_SPREAD": return DirectiveLocation.FRAGMENT_SPREAD;
            case "INLINE_FRAGMENT": return DirectiveLocation.INLINE_FRAGMENT;
            case "SCHEMA": return DirectiveLocation.SCHEMA;
            case "SCALAR": return DirectiveLocation.SCALAR;
            case "OBJECT": return DirectiveLocation.OBJECT;
            case "FIELD_DEFINITION": return DirectiveLocation.FIELD_DEFINITION;
            case "ARGUMENT_DEFINITION": return DirectiveLocation.ARGUMENT_DEFINITION;
            case "INTERFACE": return DirectiveLocation.INTERFACE;
            case "UNION": return DirectiveLocation.UNION;
            case "ENUM": return DirectiveLocation.ENUM;
            case "ENUM_VALUE": return DirectiveLocation.ENUM_VALUE;
            case "INPUT_OBJECT": return DirectiveLocation.INPUT_OBJECT;
            case "INPUT_FIELD_DEFINITION": return DirectiveLocation.INPUT_FIELD_DEFINITION;
            default: return null;
        }
    }

    /**
     * Get a value based in its ID
     *
     * @param id Id of value
     * @return Value found
     * @throws IllegalArgumentException If no value for id is found
     */
    @javax.annotation.Nonnull
    public static DirectiveLocation valueForId(int id) {
        DirectiveLocation value = findById(id);
        if (value == null) {
            throw new IllegalArgumentException("No gql_introspection.__DirectiveLocation for id " + id);
        }
        return value;
    }

    /**
     * Get a value based in its name
     *
     * @param name Name of value
     * @return Value found
     * @throws IllegalArgumentException If no value for name is found, or null name
     */
    @javax.annotation.Nonnull
    public static DirectiveLocation valueForName(@javax.annotation.Nonnull String name) {
        DirectiveLocation value = findByName(name);
        if (value == null) {
            throw new IllegalArgumentException("No gql_introspection.__DirectiveLocation for name \"" + name + "\"");
        }
        return value;
    }

    public static final class _Builder extends net.morimekta.providence.PEnumBuilder<DirectiveLocation> {
        private DirectiveLocation mValue;

        @Override
        @javax.annotation.Nonnull
        public _Builder setById(int value) {
            mValue = DirectiveLocation.findById(value);
            return this;
        }

        @Override
        @javax.annotation.Nonnull
        public _Builder setByName(String name) {
            mValue = DirectiveLocation.findByName(name);
            return this;
        }

        @Override
        public boolean valid() {
            return mValue != null;
        }

        @Override
        public DirectiveLocation build() {
            return mValue;
        }
    }

    public static final net.morimekta.providence.descriptor.PEnumDescriptor<DirectiveLocation> kDescriptor;

    @Override
    @javax.annotation.Nonnull
    public net.morimekta.providence.descriptor.PEnumDescriptor<DirectiveLocation> descriptor() {
        return kDescriptor;
    }

    public static net.morimekta.providence.descriptor.PEnumDescriptorProvider<DirectiveLocation> provider() {
        return new net.morimekta.providence.descriptor.PEnumDescriptorProvider<DirectiveLocation>(kDescriptor);
    }

    private static final class _Descriptor
            extends net.morimekta.providence.descriptor.PEnumDescriptor<DirectiveLocation> {
        public _Descriptor() {
            super("gql_introspection", "__DirectiveLocation", _Builder::new);
        }

        @Override
        @javax.annotation.Nonnull
        public boolean isInnerType() {
            return false;
        }

        @Override
        @javax.annotation.Nonnull
        public boolean isAutoType() {
            return false;
        }

        @Override
        @javax.annotation.Nonnull
        public DirectiveLocation[] getValues() {
            return DirectiveLocation.values();
        }

        @Override
        @javax.annotation.Nullable
        public DirectiveLocation findById(int id) {
            return DirectiveLocation.findById(id);
        }

        @Override
        @javax.annotation.Nullable
        public DirectiveLocation findByName(String name) {
            return DirectiveLocation.findByName(name);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }
}
