/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.introspection;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.graphql.introspection.DirectiveLocation;
import net.morimekta.providence.graphql.introspection.Directive_OrBuilder;
import net.morimekta.providence.graphql.introspection.InputValue;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

@Immutable
public class Directive
implements Directive_OrBuilder,
PMessage<Directive>,
Comparable<Directive>,
BinaryWriter {
    private static final String kDefaultName = "";
    private static final List<InputValue> kDefaultArgs = new PList.DefaultBuilder().build();
    private static final List<DirectiveLocation> kDefaultLocations = new PList.DefaultBuilder().build();
    private final transient String mName;
    private final transient String mDescription;
    private final transient List<InputValue> mArgs;
    private final transient List<DirectiveLocation> mLocations;
    private volatile transient int tHashCode;
    public static final PStructDescriptor<Directive> kDescriptor = new _Descriptor();

    private Directive(_Builder builder) {
        this.mName = builder.isSetName() ? builder.mName : kDefaultName;
        this.mDescription = builder.mDescription;
        this.mArgs = builder.isSetArgs() ? UnmodifiableList.copyOf((Collection)builder.mArgs) : kDefaultArgs;
        this.mLocations = builder.isSetLocations() ? UnmodifiableList.copyOf((Collection)builder.mLocations) : kDefaultLocations;
    }

    @Override
    public boolean hasName() {
        return true;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean hasDescription() {
        return this.mDescription != null;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    @Nonnull
    public Optional<String> optionalDescription() {
        return Optional.ofNullable(this.mDescription);
    }

    @Override
    public int numArgs() {
        return this.mArgs != null ? this.mArgs.size() : 0;
    }

    @Override
    public boolean hasArgs() {
        return true;
    }

    @Override
    @Nonnull
    public List<InputValue> getArgs() {
        return this.mArgs;
    }

    @Override
    public int numLocations() {
        return this.mLocations != null ? this.mLocations.size() : 0;
    }

    @Override
    public boolean hasLocations() {
        return true;
    }

    @Override
    @Nonnull
    public List<DirectiveLocation> getLocations() {
        return this.mLocations;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return true;
            }
            case 2: {
                return this.mDescription != null;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    public <T> T get(int key) {
        switch (key) {
            case 1: {
                return (T)this.mName;
            }
            case 2: {
                return (T)this.mDescription;
            }
            case 3: {
                return (T)this.mArgs;
            }
            case 4: {
                return (T)this.mLocations;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Directive other = (Directive)o;
        return Objects.equals(this.mName, other.mName) && Objects.equals(this.mDescription, other.mDescription) && Objects.equals(this.mArgs, other.mArgs) && Objects.equals(this.mLocations, other.mLocations);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{Directive.class, _Field.NAME, this.mName, _Field.DESCRIPTION, this.mDescription, _Field.ARGS, this.mArgs, _Field.LOCATIONS, this.mLocations});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "gql_introspection.__Directive" + this.asString();
    }

    @Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        out.append("name:").append('\"').append(Strings.escape((CharSequence)this.mName)).append('\"');
        if (this.hasDescription()) {
            out.append(',');
            out.append("description:").append('\"').append(Strings.escape((CharSequence)this.mDescription)).append('\"');
        }
        out.append(',');
        out.append("args:").append(Strings.asString(this.mArgs));
        out.append(',');
        out.append("locations:").append(Strings.asString(this.mLocations));
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Directive other) {
        int c = this.mName.compareTo(other.mName);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mDescription != null, other.mDescription != null);
        if (c != 0) {
            return c;
        }
        if (this.mDescription != null && (c = this.mDescription.compareTo(other.mDescription)) != 0) {
            return c;
        }
        c = Integer.compare(this.mArgs.hashCode(), other.mArgs.hashCode());
        if (c != 0) {
            return c;
        }
        c = Integer.compare(this.mLocations.hashCode(), other.mLocations.hashCode());
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        length += writer.writeByte((byte)11);
        length += writer.writeShort((short)1);
        Binary tmp_1 = Binary.wrap((byte[])this.mName.getBytes(StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_1.length());
        length += writer.writeBinary(tmp_1);
        if (this.hasDescription()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)2);
            Binary tmp_2 = Binary.wrap((byte[])this.mDescription.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }
        length += writer.writeByte((byte)15);
        length += writer.writeShort((short)3);
        length += writer.writeByte((byte)12);
        length += writer.writeUInt32(this.mArgs.size());
        for (InputValue entry_3 : this.mArgs) {
            length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)entry_3);
        }
        length += writer.writeByte((byte)15);
        length += writer.writeShort((short)4);
        length += writer.writeByte((byte)8);
        length += writer.writeUInt32(this.mLocations.size());
        for (DirectiveLocation entry_4 : this.mLocations) {
            length += writer.writeInt(entry_4.asInteger());
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    @Nonnull
    public static PStructDescriptorProvider<Directive> provider() {
        return new _Provider();
    }

    @Nonnull
    public PStructDescriptor<Directive> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<Directive>
    implements Directive_OrBuilder,
    BinaryReader {
        private BitSet optionals = new BitSet(4);
        private BitSet modified = new BitSet(4);
        private String mName = "";
        private String mDescription;
        private List<InputValue> mArgs = Directive.access$400();
        private List<DirectiveLocation> mLocations = Directive.access$600();

        public _Builder() {
        }

        public _Builder(Directive base) {
            this();
            this.optionals.set(0);
            this.mName = base.mName;
            if (base.hasDescription()) {
                this.optionals.set(1);
                this.mDescription = base.mDescription;
            }
            this.optionals.set(2);
            this.mArgs = base.mArgs;
            this.optionals.set(3);
            this.mLocations = base.mLocations;
        }

        @Nonnull
        public _Builder merge(Directive from) {
            this.optionals.set(0);
            this.modified.set(0);
            this.mName = from.getName();
            if (from.hasDescription()) {
                this.optionals.set(1);
                this.modified.set(1);
                this.mDescription = from.getDescription();
            }
            this.optionals.set(2);
            this.modified.set(2);
            this.mArgs = from.getArgs();
            this.optionals.set(3);
            this.modified.set(3);
            this.mLocations = from.getLocations();
            return this;
        }

        @Nonnull
        public _Builder setName(String value) {
            if (value == null) {
                return this.clearName();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(0);
        }

        @Override
        public boolean hasName() {
            return true;
        }

        public boolean isModifiedName() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearName() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mName = Directive.kDefaultName;
            return this;
        }

        @Override
        public String getName() {
            return this.isSetName() ? this.mName : Directive.kDefaultName;
        }

        @Nonnull
        public _Builder setDescription(String value) {
            if (value == null) {
                return this.clearDescription();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mDescription = value;
            return this;
        }

        public boolean isSetDescription() {
            return this.optionals.get(1);
        }

        @Override
        public boolean hasDescription() {
            return this.optionals.get(1);
        }

        public boolean isModifiedDescription() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearDescription() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mDescription = null;
            return this;
        }

        @Override
        public String getDescription() {
            return this.mDescription;
        }

        @Override
        @Nonnull
        public Optional<String> optionalDescription() {
            return Optional.ofNullable(this.mDescription);
        }

        @Nonnull
        public _Builder setArgs(Collection<InputValue> value) {
            if (value == null) {
                return this.clearArgs();
            }
            this.optionals.set(2);
            this.modified.set(2);
            this.mArgs = UnmodifiableList.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder addToArgs(InputValue ... values) {
            this.optionals.set(2);
            this.modified.set(2);
            List<InputValue> _container = this.mutableArgs();
            for (InputValue item : values) {
                _container.add(item);
            }
            return this;
        }

        public boolean isSetArgs() {
            return this.optionals.get(2);
        }

        @Override
        public boolean hasArgs() {
            return true;
        }

        public boolean isModifiedArgs() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearArgs() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mArgs = kDefaultArgs;
            return this;
        }

        public List<InputValue> mutableArgs() {
            this.optionals.set(2);
            this.modified.set(2);
            if (this.mArgs == null) {
                this.mArgs = new ArrayList<InputValue>();
            } else if (!(this.mArgs instanceof ArrayList)) {
                this.mArgs = new ArrayList<InputValue>(this.mArgs);
            }
            return this.mArgs;
        }

        @Override
        public List<InputValue> getArgs() {
            return this.isSetArgs() ? this.mArgs : kDefaultArgs;
        }

        @Override
        public int numArgs() {
            return this.mArgs != null ? this.mArgs.size() : 0;
        }

        @Nonnull
        public _Builder setLocations(Collection<DirectiveLocation> value) {
            if (value == null) {
                return this.clearLocations();
            }
            this.optionals.set(3);
            this.modified.set(3);
            this.mLocations = UnmodifiableList.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder addToLocations(DirectiveLocation ... values) {
            this.optionals.set(3);
            this.modified.set(3);
            List<DirectiveLocation> _container = this.mutableLocations();
            for (DirectiveLocation item : values) {
                _container.add(item);
            }
            return this;
        }

        public boolean isSetLocations() {
            return this.optionals.get(3);
        }

        @Override
        public boolean hasLocations() {
            return true;
        }

        public boolean isModifiedLocations() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearLocations() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mLocations = kDefaultLocations;
            return this;
        }

        public List<DirectiveLocation> mutableLocations() {
            this.optionals.set(3);
            this.modified.set(3);
            if (this.mLocations == null) {
                this.mLocations = new ArrayList<DirectiveLocation>();
            } else if (!(this.mLocations instanceof ArrayList)) {
                this.mLocations = new ArrayList<DirectiveLocation>(this.mLocations);
            }
            return this.mLocations;
        }

        @Override
        public List<DirectiveLocation> getLocations() {
            return this.isSetLocations() ? this.mLocations : kDefaultLocations;
        }

        @Override
        public int numLocations() {
            return this.mLocations != null ? this.mLocations.size() : 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            _Builder other = (_Builder)o;
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mDescription, other.mDescription) && Objects.equals(this.mArgs, other.mArgs) && Objects.equals(this.mLocations, other.mLocations);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{Directive.class, this.optionals, _Field.NAME, this.mName, _Field.DESCRIPTION, this.mDescription, _Field.ARGS, this.mArgs, _Field.LOCATIONS, this.mLocations});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                default: 
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setName((String)value);
                    break;
                }
                case 2: {
                    this.setDescription((String)value);
                    break;
                }
                case 3: {
                    this.setArgs((List)value);
                    break;
                }
                case 4: {
                    this.setLocations((List)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 3: {
                    return this.optionals.get(2);
                }
                case 4: {
                    return this.optionals.get(3);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 3: {
                    return this.modified.get(2);
                }
                case 4: {
                    return this.modified.get(3);
                }
            }
            return false;
        }

        public <T> T get(int key) {
            switch (key) {
                case 1: {
                    return (T)this.getName();
                }
                case 2: {
                    return (T)this.getDescription();
                }
                case 3: {
                    return (T)this.getArgs();
                }
                case 4: {
                    return (T)this.getLocations();
                }
            }
            return null;
        }

        public boolean has(int key) {
            switch (key) {
                case 1: {
                    return true;
                }
                case 2: {
                    return this.mDescription != null;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return true;
                }
            }
            return false;
        }

        @Nonnull
        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 3: {
                    this.addToArgs((InputValue)value);
                    break;
                }
                case 4: {
                    this.addToLocations((DirectiveLocation)((Object)value));
                    break;
                }
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearName();
                    break;
                }
                case 2: {
                    this.clearDescription();
                    break;
                }
                case 3: {
                    this.clearArgs();
                    break;
                }
                case 4: {
                    this.clearLocations();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return this.optionals.get(0) && this.optionals.get(2) && this.optionals.get(3);
        }

        public _Builder validate() {
            if (!this.valid()) {
                ArrayList<String> missing = new ArrayList<String>();
                if (!this.optionals.get(0)) {
                    missing.add("name");
                }
                if (!this.optionals.get(2)) {
                    missing.add("args");
                }
                if (!this.optionals.get(3)) {
                    missing.add("locations");
                }
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message gql_introspection.__Directive");
            }
            return this;
        }

        @Nonnull
        public PStructDescriptor<Directive> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mName = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Directive.name, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            this.mDescription = new String(reader.expectBytes(len_2), StandardCharsets.UTF_8);
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Directive.description, should be struct(12)", new Object[0]);
                    }
                    case 3: {
                        if (type == 15) {
                            UnmodifiableList.Builder b_3;
                            byte t_5 = reader.expectByte();
                            if (t_5 == 12) {
                                int len_4 = reader.expectUInt32();
                                b_3 = UnmodifiableList.builder((int)len_4);
                                for (int i_6 = 0; i_6 < len_4; ++i_6) {
                                    InputValue key_7 = (InputValue)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, InputValue.kDescriptor, (boolean)strict);
                                    b_3.add((Object)key_7);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_5) + " for gql_introspection.__Directive.args, should be struct(12)", new Object[0]);
                            }
                            this.mArgs = b_3.build();
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Directive.args, should be struct(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 15) {
                            UnmodifiableList.Builder b_8;
                            byte t_10 = reader.expectByte();
                            if (t_10 == 8) {
                                int len_9 = reader.expectUInt32();
                                b_8 = UnmodifiableList.builder((int)len_9);
                                for (int i_11 = 0; i_11 < len_9; ++i_11) {
                                    DirectiveLocation key_12 = DirectiveLocation.findById(reader.expectInt());
                                    b_8.add((Object)key_12);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_10) + " for gql_introspection.__Directive.locations, should be i32(8)", new Object[0]);
                            }
                            this.mLocations = b_8.build();
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Directive.locations, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        @Nonnull
        public Directive build() {
            return new Directive(this);
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<Directive> {
        private _Provider() {
        }

        public PStructDescriptor<Directive> descriptor() {
            return kDescriptor;
        }
    }

    private static final class _Descriptor
    extends PStructDescriptor<Directive> {
        public _Descriptor() {
            super("gql_introspection", "__Directive", _Builder::new, false);
        }

        @Nonnull
        public boolean isInnerType() {
            return false;
        }

        @Nonnull
        public boolean isAutoType() {
            return false;
        }

        @Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Nullable
        public _Field findFieldByPojoName(String name) {
            return _Field.findByPojoName(name);
        }

        @Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    public static enum _Field implements PField<Directive>
    {
        NAME(1, PRequirement.REQUIRED, "name", "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null, null),
        DESCRIPTION(2, PRequirement.OPTIONAL, "description", "description", (PDescriptorProvider)PPrimitive.STRING.provider(), null, null),
        ARGS(3, PRequirement.REQUIRED, "args", "args", (PDescriptorProvider)PList.provider(InputValue.provider()), null, (PValueProvider<?>)new PDefaultValueProvider((Object)Directive.access$400())),
        LOCATIONS(4, PRequirement.REQUIRED, "locations", "locations", (PDescriptorProvider)PList.provider(DirectiveLocation.provider()), null, null);

        private final int mId;
        private final PRequirement mRequired;
        private final String mName;
        private final String mPojoName;
        private final PDescriptorProvider mTypeProvider;
        private final PStructDescriptorProvider mArgumentsProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int id, PRequirement required, String name, String pojoName, PDescriptorProvider typeProvider, PStructDescriptorProvider argumentsProvider, PValueProvider<?> defaultValue) {
            this.mId = id;
            this.mRequired = required;
            this.mName = name;
            this.mPojoName = pojoName;
            this.mTypeProvider = typeProvider;
            this.mArgumentsProvider = argumentsProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getId() {
            return this.mId;
        }

        @Nonnull
        public PRequirement getRequirement() {
            return this.mRequired;
        }

        @Nonnull
        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        @Nullable
        public PStructDescriptor getArgumentsType() {
            return this.mArgumentsProvider == null ? null : this.mArgumentsProvider.descriptor();
        }

        @Nonnull
        public String getName() {
            return this.mName;
        }

        @Nonnull
        public String getPojoName() {
            return this.mPojoName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        @Nullable
        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        @Nonnull
        public PMessageDescriptor<Directive> onMessageType() {
            return kDescriptor;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field findById(int id) {
            switch (id) {
                case 1: {
                    return NAME;
                }
                case 2: {
                    return DESCRIPTION;
                }
                case 3: {
                    return ARGS;
                }
                case 4: {
                    return LOCATIONS;
                }
            }
            return null;
        }

        public static _Field findByName(String name) {
            if (name == null) {
                return null;
            }
            switch (name) {
                case "name": {
                    return NAME;
                }
                case "description": {
                    return DESCRIPTION;
                }
                case "args": {
                    return ARGS;
                }
                case "locations": {
                    return LOCATIONS;
                }
            }
            return null;
        }

        public static _Field findByPojoName(String name) {
            if (name == null) {
                return null;
            }
            switch (name) {
                case "name": {
                    return NAME;
                }
                case "description": {
                    return DESCRIPTION;
                }
                case "args": {
                    return ARGS;
                }
                case "locations": {
                    return LOCATIONS;
                }
            }
            return null;
        }

        public static _Field fieldForId(int id) {
            _Field field = _Field.findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in gql_introspection.__Directive");
            }
            return field;
        }

        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = _Field.findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__Directive");
            }
            return field;
        }

        public static _Field fieldForPojoName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = _Field.findByPojoName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__Directive");
            }
            return field;
        }
    }
}

