/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.gql;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.graphql.gql.GQLFragmentDefinition;
import net.morimekta.providence.graphql.gql.GQLOperation;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableMap;

@Immutable
public class GQLQuery {
    private final Map<String, GQLOperation> operationMap;
    private final Map<String, GQLFragmentDefinition> fragmentMap;
    private final boolean defaultOperationAvailable;

    public GQLQuery(@Nonnull Map<String, GQLOperation> operationMap, @Nonnull Map<String, GQLFragmentDefinition> fragmentMap) {
        this.operationMap = UnmodifiableMap.copyOf(operationMap);
        this.fragmentMap = UnmodifiableMap.copyOf(fragmentMap);
        this.defaultOperationAvailable = operationMap.size() == 1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.operationMap.values().stream().map(Objects::toString).collect(Collectors.joining(" ")));
        for (GQLFragmentDefinition fragment : this.fragmentMap.values()) {
            builder.append(" ").append(fragment.toString());
        }
        return builder.toString();
    }

    public boolean isDefaultOperationAvailable() {
        return this.defaultOperationAvailable;
    }

    public Optional<GQLOperation> getOperation(String name) {
        if (!Strings.isNullOrEmpty((String)name)) {
            return Optional.ofNullable(this.operationMap.get(name));
        }
        if (this.operationMap.size() > 1) {
            throw new IllegalArgumentException("Multiple operations and no operation name given");
        }
        return Optional.ofNullable(this.operationMap.values().iterator().next());
    }
}

