package net.morimekta.providence.graphql.introspection;

@SuppressWarnings("unused")
@javax.annotation.Generated(
        value = "net.morimekta.providence:providence-generator-java",
        comments = "java")
@javax.annotation.concurrent.Immutable
public class Type
        implements Type_OrBuilder,
                   net.morimekta.providence.PMessage<Type>,
                   Comparable<Type>,
                   net.morimekta.providence.serializer.binary.BinaryWriter {
    private final transient net.morimekta.providence.graphql.introspection.TypeKind mKind;
    private final transient String mName;
    private final transient String mDescription;
    private final transient java.util.List<net.morimekta.providence.graphql.introspection.Field> mFields;
    private final transient java.util.List<net.morimekta.providence.graphql.introspection.Type> mInterfaces;
    private final transient java.util.List<net.morimekta.providence.graphql.introspection.Type> mPossibleTypes;
    private final transient java.util.List<net.morimekta.providence.graphql.introspection.EnumValue> mEnumValues;
    private final transient java.util.List<net.morimekta.providence.graphql.introspection.InputValue> mInputFields;
    private final transient net.morimekta.providence.graphql.introspection.Type mOfType;

    private volatile transient int tHashCode;

    private Type(_Builder builder) {
        mKind = builder.mKind;
        mName = builder.mName;
        mDescription = builder.mDescription;
        if (builder.isSetFields()) {
            mFields = net.morimekta.util.collect.UnmodifiableList.copyOf(builder.mFields);
        } else {
            mFields = null;
        }
        if (builder.isSetInterfaces()) {
            mInterfaces = net.morimekta.util.collect.UnmodifiableList.copyOf(builder.mInterfaces);
        } else {
            mInterfaces = null;
        }
        if (builder.isSetPossibleTypes()) {
            mPossibleTypes = net.morimekta.util.collect.UnmodifiableList.copyOf(builder.mPossibleTypes);
        } else {
            mPossibleTypes = null;
        }
        if (builder.isSetEnumValues()) {
            mEnumValues = net.morimekta.util.collect.UnmodifiableList.copyOf(builder.mEnumValues);
        } else {
            mEnumValues = null;
        }
        if (builder.isSetInputFields()) {
            mInputFields = net.morimekta.util.collect.UnmodifiableList.copyOf(builder.mInputFields);
        } else {
            mInputFields = null;
        }
        mOfType = builder.mOfType_builder != null ? builder.mOfType_builder.build() : builder.mOfType;
    }

    public boolean hasKind() {
        return mKind != null;
    }

    /**
     * @return The <code>kind</code> value
     */
    public net.morimekta.providence.graphql.introspection.TypeKind getKind() {
        return mKind;
    }

    /**
     * @return Optional of the <code>kind</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<net.morimekta.providence.graphql.introspection.TypeKind> optionalKind() {
        return java.util.Optional.ofNullable(mKind);
    }

    public boolean hasName() {
        return mName != null;
    }

    /**
     * @return The <code>name</code> value
     */
    public String getName() {
        return mName;
    }

    /**
     * @return Optional of the <code>name</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<String> optionalName() {
        return java.util.Optional.ofNullable(mName);
    }

    public boolean hasDescription() {
        return mDescription != null;
    }

    /**
     * @return The <code>description</code> value
     */
    public String getDescription() {
        return mDescription;
    }

    /**
     * @return Optional of the <code>description</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<String> optionalDescription() {
        return java.util.Optional.ofNullable(mDescription);
    }

    public int numFields() {
        return mFields != null ? mFields.size() : 0;
    }

    public boolean hasFields() {
        return mFields != null;
    }

    /**
     * OBJECT, and INTERFACE only
     *
     * @return The <code>fields</code> value
     */
    public java.util.List<net.morimekta.providence.graphql.introspection.Field> getFields() {
        return mFields;
    }

    /**
     * OBJECT, and INTERFACE only
     *
     * @return Optional of the <code>fields</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.Field>> optionalFields() {
        return java.util.Optional.ofNullable(mFields);
    }

    public int numInterfaces() {
        return mInterfaces != null ? mInterfaces.size() : 0;
    }

    public boolean hasInterfaces() {
        return mInterfaces != null;
    }

    /**
     * OBJECT only
     *
     * @return The <code>interfaces</code> value
     */
    public java.util.List<net.morimekta.providence.graphql.introspection.Type> getInterfaces() {
        return mInterfaces;
    }

    /**
     * OBJECT only
     *
     * @return Optional of the <code>interfaces</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.Type>> optionalInterfaces() {
        return java.util.Optional.ofNullable(mInterfaces);
    }

    public int numPossibleTypes() {
        return mPossibleTypes != null ? mPossibleTypes.size() : 0;
    }

    public boolean hasPossibleTypes() {
        return mPossibleTypes != null;
    }

    /**
     * INTERFACE and UNION only
     *
     * @return The <code>possibleTypes</code> value
     */
    public java.util.List<net.morimekta.providence.graphql.introspection.Type> getPossibleTypes() {
        return mPossibleTypes;
    }

    /**
     * INTERFACE and UNION only
     *
     * @return Optional of the <code>possibleTypes</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.Type>> optionalPossibleTypes() {
        return java.util.Optional.ofNullable(mPossibleTypes);
    }

    public int numEnumValues() {
        return mEnumValues != null ? mEnumValues.size() : 0;
    }

    public boolean hasEnumValues() {
        return mEnumValues != null;
    }

    /**
     * ENUM only
     *
     * @return The <code>enumValues</code> value
     */
    public java.util.List<net.morimekta.providence.graphql.introspection.EnumValue> getEnumValues() {
        return mEnumValues;
    }

    /**
     * ENUM only
     *
     * @return Optional of the <code>enumValues</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.EnumValue>> optionalEnumValues() {
        return java.util.Optional.ofNullable(mEnumValues);
    }

    public int numInputFields() {
        return mInputFields != null ? mInputFields.size() : 0;
    }

    public boolean hasInputFields() {
        return mInputFields != null;
    }

    /**
     * INPUT_OBJECT only
     *
     * @return The <code>inputFields</code> value
     */
    public java.util.List<net.morimekta.providence.graphql.introspection.InputValue> getInputFields() {
        return mInputFields;
    }

    /**
     * INPUT_OBJECT only
     *
     * @return Optional of the <code>inputFields</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.InputValue>> optionalInputFields() {
        return java.util.Optional.ofNullable(mInputFields);
    }

    public boolean hasOfType() {
        return mOfType != null;
    }

    /**
     * NON_NULL and LIST only
     *
     * @return The <code>ofType</code> value
     */
    public net.morimekta.providence.graphql.introspection.Type getOfType() {
        return mOfType;
    }

    /**
     * NON_NULL and LIST only
     *
     * @return Optional of the <code>ofType</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<net.morimekta.providence.graphql.introspection.Type> optionalOfType() {
        return java.util.Optional.ofNullable(mOfType);
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return mKind != null;
            case 2: return mName != null;
            case 3: return mDescription != null;
            case 4: return mFields != null;
            case 5: return mInterfaces != null;
            case 6: return mPossibleTypes != null;
            case 7: return mEnumValues != null;
            case 8: return mInputFields != null;
            case 9: return mOfType != null;
            default: return false;
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T> T get(int key) {
        switch(key) {
            case 1: return (T) mKind;
            case 2: return (T) mName;
            case 3: return (T) mDescription;
            case 4: return (T) mFields;
            case 5: return (T) mInterfaces;
            case 6: return (T) mPossibleTypes;
            case 7: return (T) mEnumValues;
            case 8: return (T) mInputFields;
            case 9: return (T) mOfType;
            default: return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) return true;
        if (o == null || !o.getClass().equals(getClass())) return false;
        Type other = (Type) o;
        return java.util.Objects.equals(mKind, other.mKind) &&
               java.util.Objects.equals(mName, other.mName) &&
               java.util.Objects.equals(mDescription, other.mDescription) &&
               java.util.Objects.equals(mFields, other.mFields) &&
               java.util.Objects.equals(mInterfaces, other.mInterfaces) &&
               java.util.Objects.equals(mPossibleTypes, other.mPossibleTypes) &&
               java.util.Objects.equals(mEnumValues, other.mEnumValues) &&
               java.util.Objects.equals(mInputFields, other.mInputFields) &&
               java.util.Objects.equals(mOfType, other.mOfType);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = java.util.Objects.hash(
                    Type.class,
                    _Field.KIND, mKind,
                    _Field.NAME, mName,
                    _Field.DESCRIPTION, mDescription,
                    _Field.FIELDS, mFields,
                    _Field.INTERFACES, mInterfaces,
                    _Field.POSSIBLE_TYPES, mPossibleTypes,
                    _Field.ENUM_VALUES, mEnumValues,
                    _Field.INPUT_FIELDS, mInputFields,
                    _Field.OF_TYPE, mOfType);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "gql_introspection.__Type" + asString();
    }

    @Override
    @javax.annotation.Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        boolean first = true;
        if (hasKind()) {
            first = false;
            out.append("kind:")
               .append(mKind.asString());
        }
        if (hasName()) {
            if (first) first = false;
            else out.append(',');
            out.append("name:")
               .append('\"')
               .append(net.morimekta.util.Strings.escape(mName))
               .append('\"');
        }
        if (hasDescription()) {
            if (first) first = false;
            else out.append(',');
            out.append("description:")
               .append('\"')
               .append(net.morimekta.util.Strings.escape(mDescription))
               .append('\"');
        }
        if (hasFields()) {
            if (first) first = false;
            else out.append(',');
            out.append("fields:")
               .append(net.morimekta.util.Strings.asString(mFields));
        }
        if (hasInterfaces()) {
            if (first) first = false;
            else out.append(',');
            out.append("interfaces:")
               .append(net.morimekta.util.Strings.asString(mInterfaces));
        }
        if (hasPossibleTypes()) {
            if (first) first = false;
            else out.append(',');
            out.append("possibleTypes:")
               .append(net.morimekta.util.Strings.asString(mPossibleTypes));
        }
        if (hasEnumValues()) {
            if (first) first = false;
            else out.append(',');
            out.append("enumValues:")
               .append(net.morimekta.util.Strings.asString(mEnumValues));
        }
        if (hasInputFields()) {
            if (first) first = false;
            else out.append(',');
            out.append("inputFields:")
               .append(net.morimekta.util.Strings.asString(mInputFields));
        }
        if (hasOfType()) {
            if (!first) out.append(',');
            out.append("ofType:")
               .append(mOfType.asString());
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Type other) {
        int c;

        c = Boolean.compare(mKind != null, other.mKind != null);
        if (c != 0) return c;
        if (mKind != null) {
            c = Integer.compare(mKind.ordinal(), mKind.ordinal());
            if (c != 0) return c;
        }

        c = Boolean.compare(mName != null, other.mName != null);
        if (c != 0) return c;
        if (mName != null) {
            c = mName.compareTo(other.mName);
            if (c != 0) return c;
        }

        c = Boolean.compare(mDescription != null, other.mDescription != null);
        if (c != 0) return c;
        if (mDescription != null) {
            c = mDescription.compareTo(other.mDescription);
            if (c != 0) return c;
        }

        c = Boolean.compare(mFields != null, other.mFields != null);
        if (c != 0) return c;
        if (mFields != null) {
            c = Integer.compare(mFields.hashCode(), other.mFields.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mInterfaces != null, other.mInterfaces != null);
        if (c != 0) return c;
        if (mInterfaces != null) {
            c = Integer.compare(mInterfaces.hashCode(), other.mInterfaces.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mPossibleTypes != null, other.mPossibleTypes != null);
        if (c != 0) return c;
        if (mPossibleTypes != null) {
            c = Integer.compare(mPossibleTypes.hashCode(), other.mPossibleTypes.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mEnumValues != null, other.mEnumValues != null);
        if (c != 0) return c;
        if (mEnumValues != null) {
            c = Integer.compare(mEnumValues.hashCode(), other.mEnumValues.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mInputFields != null, other.mInputFields != null);
        if (c != 0) return c;
        if (mInputFields != null) {
            c = Integer.compare(mInputFields.hashCode(), other.mInputFields.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mOfType != null, other.mOfType != null);
        if (c != 0) return c;
        if (mOfType != null) {
            c = mOfType.compareTo(other.mOfType);
            if (c != 0) return c;
        }

        return 0;
    }

    @Override
    public int writeBinary(net.morimekta.util.io.BigEndianBinaryWriter writer) throws java.io.IOException {
        int length = 0;

        if (hasKind()) {
            length += writer.writeByte((byte) 8);
            length += writer.writeShort((short) 1);
            length += writer.writeInt(mKind.asInteger());
        }

        if (hasName()) {
            length += writer.writeByte((byte) 11);
            length += writer.writeShort((short) 2);
            net.morimekta.util.Binary tmp_1 = net.morimekta.util.Binary.wrap(mName.getBytes(java.nio.charset.StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_1.length());
            length += writer.writeBinary(tmp_1);
        }

        if (hasDescription()) {
            length += writer.writeByte((byte) 11);
            length += writer.writeShort((short) 3);
            net.morimekta.util.Binary tmp_2 = net.morimekta.util.Binary.wrap(mDescription.getBytes(java.nio.charset.StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }

        if (hasFields()) {
            length += writer.writeByte((byte) 15);
            length += writer.writeShort((short) 4);
            length += writer.writeByte((byte) 12);
            length += writer.writeUInt32(mFields.size());
            for (net.morimekta.providence.graphql.introspection.Field entry_3 : mFields) {
                length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, entry_3);
            }
        }

        if (hasInterfaces()) {
            length += writer.writeByte((byte) 15);
            length += writer.writeShort((short) 5);
            length += writer.writeByte((byte) 12);
            length += writer.writeUInt32(mInterfaces.size());
            for (net.morimekta.providence.graphql.introspection.Type entry_4 : mInterfaces) {
                length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, entry_4);
            }
        }

        if (hasPossibleTypes()) {
            length += writer.writeByte((byte) 15);
            length += writer.writeShort((short) 6);
            length += writer.writeByte((byte) 12);
            length += writer.writeUInt32(mPossibleTypes.size());
            for (net.morimekta.providence.graphql.introspection.Type entry_5 : mPossibleTypes) {
                length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, entry_5);
            }
        }

        if (hasEnumValues()) {
            length += writer.writeByte((byte) 15);
            length += writer.writeShort((short) 7);
            length += writer.writeByte((byte) 12);
            length += writer.writeUInt32(mEnumValues.size());
            for (net.morimekta.providence.graphql.introspection.EnumValue entry_6 : mEnumValues) {
                length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, entry_6);
            }
        }

        if (hasInputFields()) {
            length += writer.writeByte((byte) 15);
            length += writer.writeShort((short) 8);
            length += writer.writeByte((byte) 12);
            length += writer.writeUInt32(mInputFields.size());
            for (net.morimekta.providence.graphql.introspection.InputValue entry_7 : mInputFields) {
                length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, entry_7);
            }
        }

        if (hasOfType()) {
            length += writer.writeByte((byte) 12);
            length += writer.writeShort((short) 9);
            length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, mOfType);
        }

        length += writer.writeByte((byte) 0);
        return length;
    }

    @javax.annotation.Nonnull
    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public enum _Field implements net.morimekta.providence.descriptor.PField<Type> {
        KIND(1, net.morimekta.providence.descriptor.PRequirement.REQUIRED, "kind", "kind", net.morimekta.providence.graphql.introspection.TypeKind.provider(), null, null),
        NAME(2, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "name", "name", net.morimekta.providence.descriptor.PPrimitive.STRING.provider(), null, null),
        DESCRIPTION(3, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "description", "description", net.morimekta.providence.descriptor.PPrimitive.STRING.provider(), null, null),
        FIELDS(4, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "fields", "fields", net.morimekta.providence.descriptor.PList.provider(net.morimekta.providence.graphql.introspection.Field.provider()), net.morimekta.providence.graphql.introspection.FieldsArguments.provider(), null),
        INTERFACES(5, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "interfaces", "interfaces", net.morimekta.providence.descriptor.PList.provider(net.morimekta.providence.graphql.introspection.Type.provider()), null, null),
        POSSIBLE_TYPES(6, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "possibleTypes", "possibleTypes", net.morimekta.providence.descriptor.PList.provider(net.morimekta.providence.graphql.introspection.Type.provider()), null, null),
        ENUM_VALUES(7, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "enumValues", "enumValues", net.morimekta.providence.descriptor.PList.provider(net.morimekta.providence.graphql.introspection.EnumValue.provider()), net.morimekta.providence.graphql.introspection.FieldsArguments.provider(), null),
        INPUT_FIELDS(8, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "inputFields", "inputFields", net.morimekta.providence.descriptor.PList.provider(net.morimekta.providence.graphql.introspection.InputValue.provider()), null, null),
        OF_TYPE(9, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "ofType", "ofType", net.morimekta.providence.graphql.introspection.Type.provider(), null, null),
        ;

        private final int mId;
        private final net.morimekta.providence.descriptor.PRequirement mRequired;
        private final String mName;
        private final String mPojoName;
        private final net.morimekta.providence.descriptor.PDescriptorProvider mTypeProvider;
        private final net.morimekta.providence.descriptor.PStructDescriptorProvider mArgumentsProvider;
        private final net.morimekta.providence.descriptor.PValueProvider<?> mDefaultValue;

        _Field(int id, net.morimekta.providence.descriptor.PRequirement required, String name, String pojoName, net.morimekta.providence.descriptor.PDescriptorProvider typeProvider, net.morimekta.providence.descriptor.PStructDescriptorProvider argumentsProvider, net.morimekta.providence.descriptor.PValueProvider<?> defaultValue) {
            mId = id;
            mRequired = required;
            mName = name;
            mPojoName = pojoName;
            mTypeProvider = typeProvider;
            mArgumentsProvider = argumentsProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public int getId() { return mId; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PRequirement getRequirement() { return mRequired; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PDescriptor getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        @javax.annotation.Nullable
        public net.morimekta.providence.descriptor.PStructDescriptor getArgumentsType() { return mArgumentsProvider == null ? null : mArgumentsProvider.descriptor(); }

        @javax.annotation.Nonnull
        @Override
        public String getName() { return mName; }

        @javax.annotation.Nonnull
        @Override
        public String getPojoName() { return mPojoName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        @javax.annotation.Nullable
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        @javax.annotation.Nonnull
        public net.morimekta.providence.descriptor.PMessageDescriptor<Type> onMessageType() {
            return kDescriptor;
        }

        @Override
        public String toString() {
            return net.morimekta.providence.descriptor.PField.asString(this);
        }

        /**
         * @param id Field ID
         * @return The identified field or null
         */
        public static _Field findById(int id) {
            switch (id) {
                case 1: return _Field.KIND;
                case 2: return _Field.NAME;
                case 3: return _Field.DESCRIPTION;
                case 4: return _Field.FIELDS;
                case 5: return _Field.INTERFACES;
                case 6: return _Field.POSSIBLE_TYPES;
                case 7: return _Field.ENUM_VALUES;
                case 8: return _Field.INPUT_FIELDS;
                case 9: return _Field.OF_TYPE;
            }
            return null;
        }

        /**
         * @param name Field name
         * @return The named field or null
         */
        public static _Field findByName(String name) {
            if (name == null) return null;
            switch (name) {
                case "kind": return _Field.KIND;
                case "name": return _Field.NAME;
                case "description": return _Field.DESCRIPTION;
                case "fields": return _Field.FIELDS;
                case "interfaces": return _Field.INTERFACES;
                case "possibleTypes": return _Field.POSSIBLE_TYPES;
                case "enumValues": return _Field.ENUM_VALUES;
                case "inputFields": return _Field.INPUT_FIELDS;
                case "ofType": return _Field.OF_TYPE;
            }
            return null;
        }

        /**
         * @param name Field POJO name
         * @return The named field or null
         */
        public static _Field findByPojoName(String name) {
            if (name == null) return null;
            switch (name) {
                case "kind": return _Field.KIND;
                case "name": return _Field.NAME;
                case "description": return _Field.DESCRIPTION;
                case "fields": return _Field.FIELDS;
                case "interfaces": return _Field.INTERFACES;
                case "possibleTypes": return _Field.POSSIBLE_TYPES;
                case "enumValues": return _Field.ENUM_VALUES;
                case "inputFields": return _Field.INPUT_FIELDS;
                case "ofType": return _Field.OF_TYPE;
            }
            return null;
        }

        /**
         * @param id Field ID
         * @return The identified field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForId(int id) {
            _Field field = findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in gql_introspection.__Type");
            }
            return field;
        }

        /**
         * @param name Field name
         * @return The named field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__Type");
            }
            return field;
        }

        /**
         * @param name Field POJO name
         * @return The named field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForPojoName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = findByPojoName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__Type");
            }
            return field;
        }
    }

    @javax.annotation.Nonnull
    public static net.morimekta.providence.descriptor.PStructDescriptorProvider<Type> provider() {
        return new _Provider();
    }

    @Override
    @javax.annotation.Nonnull
    public net.morimekta.providence.descriptor.PStructDescriptor<Type> descriptor() {
        return kDescriptor;
    }

    public static final net.morimekta.providence.descriptor.PStructDescriptor<Type> kDescriptor;

    private static final class _Descriptor
            extends net.morimekta.providence.descriptor.PStructDescriptor<Type> {
        public _Descriptor() {
            super("gql_introspection", "__Type", _Builder::new, false);
        }

        @Override
        @javax.annotation.Nonnull
        public boolean isInnerType() {
            return false;
        }

        @Override
        @javax.annotation.Nonnull
        public boolean isAutoType() {
            return false;
        }

        @Override
        @javax.annotation.Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldByPojoName(String name) {
            return _Field.findByPojoName(name);
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static final class _Provider extends net.morimekta.providence.descriptor.PStructDescriptorProvider<Type> {
        @Override
        public net.morimekta.providence.descriptor.PStructDescriptor<Type> descriptor() {
            return kDescriptor;
        }
    }

    /**
     * Make a <code>gql_introspection.__Type</code> builder.
     * @return The builder instance.
     */
    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends net.morimekta.providence.PMessageBuilder<Type>
            implements Type_OrBuilder,
                       net.morimekta.providence.serializer.binary.BinaryReader {
        private java.util.BitSet optionals;
        private java.util.BitSet modified;

        private net.morimekta.providence.graphql.introspection.TypeKind mKind;
        private String mName;
        private String mDescription;
        private java.util.List<net.morimekta.providence.graphql.introspection.Field> mFields;
        private java.util.List<net.morimekta.providence.graphql.introspection.Type> mInterfaces;
        private java.util.List<net.morimekta.providence.graphql.introspection.Type> mPossibleTypes;
        private java.util.List<net.morimekta.providence.graphql.introspection.EnumValue> mEnumValues;
        private java.util.List<net.morimekta.providence.graphql.introspection.InputValue> mInputFields;
        private net.morimekta.providence.graphql.introspection.Type mOfType;
        private net.morimekta.providence.graphql.introspection.Type._Builder mOfType_builder;

        /**
         * Make a gql_introspection.__Type builder instance.
         */
        public _Builder() {
            optionals = new java.util.BitSet(9);
            modified = new java.util.BitSet(9);
        }

        /**
         * Make a mutating builder off a base gql_introspection.__Type.
         *
         * @param base The base __Type
         */
        public _Builder(Type base) {
            this();

            if (base.hasKind()) {
                optionals.set(0);
                mKind = base.mKind;
            }
            if (base.hasName()) {
                optionals.set(1);
                mName = base.mName;
            }
            if (base.hasDescription()) {
                optionals.set(2);
                mDescription = base.mDescription;
            }
            if (base.hasFields()) {
                optionals.set(3);
                mFields = base.mFields;
            }
            if (base.hasInterfaces()) {
                optionals.set(4);
                mInterfaces = base.mInterfaces;
            }
            if (base.hasPossibleTypes()) {
                optionals.set(5);
                mPossibleTypes = base.mPossibleTypes;
            }
            if (base.hasEnumValues()) {
                optionals.set(6);
                mEnumValues = base.mEnumValues;
            }
            if (base.hasInputFields()) {
                optionals.set(7);
                mInputFields = base.mInputFields;
            }
            if (base.hasOfType()) {
                optionals.set(8);
                mOfType = base.mOfType;
            }
        }

        @javax.annotation.Nonnull
        @Override
        public Type._Builder merge(Type from) {
            if (from.hasKind()) {
                optionals.set(0);
                modified.set(0);
                mKind = from.getKind();
            }

            if (from.hasName()) {
                optionals.set(1);
                modified.set(1);
                mName = from.getName();
            }

            if (from.hasDescription()) {
                optionals.set(2);
                modified.set(2);
                mDescription = from.getDescription();
            }

            if (from.hasFields()) {
                optionals.set(3);
                modified.set(3);
                mFields = from.getFields();
            }

            if (from.hasInterfaces()) {
                optionals.set(4);
                modified.set(4);
                mInterfaces = from.getInterfaces();
            }

            if (from.hasPossibleTypes()) {
                optionals.set(5);
                modified.set(5);
                mPossibleTypes = from.getPossibleTypes();
            }

            if (from.hasEnumValues()) {
                optionals.set(6);
                modified.set(6);
                mEnumValues = from.getEnumValues();
            }

            if (from.hasInputFields()) {
                optionals.set(7);
                modified.set(7);
                mInputFields = from.getInputFields();
            }

            if (from.hasOfType()) {
                optionals.set(8);
                modified.set(8);
                if (mOfType_builder != null) {
                    mOfType_builder.merge(from.getOfType());
                } else if (mOfType != null) {
                    mOfType_builder = mOfType.mutate().merge(from.getOfType());
                    mOfType = null;
                } else {
                    mOfType = from.getOfType();
                }
            }
            return this;
        }

        /**
         * Set the <code>kind</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder setKind(net.morimekta.providence.graphql.introspection.TypeKind value) {
            if (value == null) {
                return clearKind();
            }

            optionals.set(0);
            modified.set(0);
            mKind = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>kind</code> field.
         *
         * @return True if kind has been set.
         */
        public boolean isSetKind() {
            return optionals.get(0);
        }

        /**
         * Checks for presence of the <code>kind</code> field.
         *
         * @return True if kind is present.
         */
        public boolean hasKind() {
            return optionals.get(0);
        }

        /**
         * Checks if the <code>kind</code> field has been modified since the
         * builder was created.
         *
         * @return True if kind has been modified.
         */
        public boolean isModifiedKind() {
            return modified.get(0);
        }

        /**
         * Clear the <code>kind</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder clearKind() {
            optionals.clear(0);
            modified.set(0);
            mKind = null;
            return this;
        }

        /**
         * @return The <code>kind</code> field value
         */
        public net.morimekta.providence.graphql.introspection.TypeKind getKind() {
            return mKind;
        }

        /**
         * @return Optional <code>kind</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<net.morimekta.providence.graphql.introspection.TypeKind> optionalKind() {
            return java.util.Optional.ofNullable(mKind);
        }

        /**
         * Set the <code>name</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder setName(String value) {
            if (value == null) {
                return clearName();
            }

            optionals.set(1);
            modified.set(1);
            mName = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>name</code> field.
         *
         * @return True if name has been set.
         */
        public boolean isSetName() {
            return optionals.get(1);
        }

        /**
         * Checks for presence of the <code>name</code> field.
         *
         * @return True if name is present.
         */
        public boolean hasName() {
            return optionals.get(1);
        }

        /**
         * Checks if the <code>name</code> field has been modified since the
         * builder was created.
         *
         * @return True if name has been modified.
         */
        public boolean isModifiedName() {
            return modified.get(1);
        }

        /**
         * Clear the <code>name</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder clearName() {
            optionals.clear(1);
            modified.set(1);
            mName = null;
            return this;
        }

        /**
         * @return The <code>name</code> field value
         */
        public String getName() {
            return mName;
        }

        /**
         * @return Optional <code>name</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<String> optionalName() {
            return java.util.Optional.ofNullable(mName);
        }

        /**
         * Set the <code>description</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder setDescription(String value) {
            if (value == null) {
                return clearDescription();
            }

            optionals.set(2);
            modified.set(2);
            mDescription = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>description</code> field.
         *
         * @return True if description has been set.
         */
        public boolean isSetDescription() {
            return optionals.get(2);
        }

        /**
         * Checks for presence of the <code>description</code> field.
         *
         * @return True if description is present.
         */
        public boolean hasDescription() {
            return optionals.get(2);
        }

        /**
         * Checks if the <code>description</code> field has been modified since the
         * builder was created.
         *
         * @return True if description has been modified.
         */
        public boolean isModifiedDescription() {
            return modified.get(2);
        }

        /**
         * Clear the <code>description</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder clearDescription() {
            optionals.clear(2);
            modified.set(2);
            mDescription = null;
            return this;
        }

        /**
         * @return The <code>description</code> field value
         */
        public String getDescription() {
            return mDescription;
        }

        /**
         * @return Optional <code>description</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<String> optionalDescription() {
            return java.util.Optional.ofNullable(mDescription);
        }

        /**
         * Set the <code>fields</code> field value.
         * <p>
         * OBJECT, and INTERFACE only
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder setFields(java.util.Collection<net.morimekta.providence.graphql.introspection.Field> value) {
            if (value == null) {
                return clearFields();
            }

            optionals.set(3);
            modified.set(3);
            mFields = net.morimekta.util.collect.UnmodifiableList.copyOf(value);
            return this;
        }

        /**
         * Adds entries to the <code>fields</code> list.
         * <p>
         * OBJECT, and INTERFACE only
         *
         * @param values The added value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder addToFields(net.morimekta.providence.graphql.introspection.Field... values) {
            optionals.set(3);
            modified.set(3);
            java.util.List<net.morimekta.providence.graphql.introspection.Field> _container = mutableFields();
            for (net.morimekta.providence.graphql.introspection.Field item : values) {
                _container.add(item);
            }
            return this;
        }

        /**
         * Checks for explicit presence of the <code>fields</code> field.
         *
         * @return True if fields has been set.
         */
        public boolean isSetFields() {
            return optionals.get(3);
        }

        /**
         * Checks for presence of the <code>fields</code> field.
         *
         * @return True if fields is present.
         */
        public boolean hasFields() {
            return optionals.get(3);
        }

        /**
         * Checks if the <code>fields</code> field has been modified since the
         * builder was created.
         *
         * @return True if fields has been modified.
         */
        public boolean isModifiedFields() {
            return modified.get(3);
        }

        /**
         * Clear the <code>fields</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder clearFields() {
            optionals.clear(3);
            modified.set(3);
            mFields = null;
            return this;
        }

        /**
         * OBJECT, and INTERFACE only
         *
         * @return The mutable <code>fields</code> container
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.Field> mutableFields() {
            optionals.set(3);
            modified.set(3);

            if (mFields == null) {
                mFields = new java.util.ArrayList<>();
            } else if (!(mFields instanceof java.util.ArrayList)) {
                mFields = new java.util.ArrayList<>(mFields);
            }
            return mFields;
        }

        /**
         * OBJECT, and INTERFACE only
         *
         * @return The <code>fields</code> field value
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.Field> getFields() {
            return mFields;
        }

        /**
         * OBJECT, and INTERFACE only
         *
         * @return Optional <code>fields</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.Field>> optionalFields() {
            return java.util.Optional.ofNullable(mFields);
        }

        /**
         * OBJECT, and INTERFACE only
         *
         * @return Number of entries in <code>fields</code>.
         */
        public int numFields() {
            return mFields != null ? mFields.size() : 0;
        }

        /**
         * Set the <code>interfaces</code> field value.
         * <p>
         * OBJECT only
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder setInterfaces(java.util.Collection<net.morimekta.providence.graphql.introspection.Type> value) {
            if (value == null) {
                return clearInterfaces();
            }

            optionals.set(4);
            modified.set(4);
            mInterfaces = net.morimekta.util.collect.UnmodifiableList.copyOf(value);
            return this;
        }

        /**
         * Adds entries to the <code>interfaces</code> list.
         * <p>
         * OBJECT only
         *
         * @param values The added value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder addToInterfaces(net.morimekta.providence.graphql.introspection.Type... values) {
            optionals.set(4);
            modified.set(4);
            java.util.List<net.morimekta.providence.graphql.introspection.Type> _container = mutableInterfaces();
            for (net.morimekta.providence.graphql.introspection.Type item : values) {
                _container.add(item);
            }
            return this;
        }

        /**
         * Checks for explicit presence of the <code>interfaces</code> field.
         *
         * @return True if interfaces has been set.
         */
        public boolean isSetInterfaces() {
            return optionals.get(4);
        }

        /**
         * Checks for presence of the <code>interfaces</code> field.
         *
         * @return True if interfaces is present.
         */
        public boolean hasInterfaces() {
            return optionals.get(4);
        }

        /**
         * Checks if the <code>interfaces</code> field has been modified since the
         * builder was created.
         *
         * @return True if interfaces has been modified.
         */
        public boolean isModifiedInterfaces() {
            return modified.get(4);
        }

        /**
         * Clear the <code>interfaces</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder clearInterfaces() {
            optionals.clear(4);
            modified.set(4);
            mInterfaces = null;
            return this;
        }

        /**
         * OBJECT only
         *
         * @return The mutable <code>interfaces</code> container
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.Type> mutableInterfaces() {
            optionals.set(4);
            modified.set(4);

            if (mInterfaces == null) {
                mInterfaces = new java.util.ArrayList<>();
            } else if (!(mInterfaces instanceof java.util.ArrayList)) {
                mInterfaces = new java.util.ArrayList<>(mInterfaces);
            }
            return mInterfaces;
        }

        /**
         * OBJECT only
         *
         * @return The <code>interfaces</code> field value
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.Type> getInterfaces() {
            return mInterfaces;
        }

        /**
         * OBJECT only
         *
         * @return Optional <code>interfaces</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.Type>> optionalInterfaces() {
            return java.util.Optional.ofNullable(mInterfaces);
        }

        /**
         * OBJECT only
         *
         * @return Number of entries in <code>interfaces</code>.
         */
        public int numInterfaces() {
            return mInterfaces != null ? mInterfaces.size() : 0;
        }

        /**
         * Set the <code>possibleTypes</code> field value.
         * <p>
         * INTERFACE and UNION only
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder setPossibleTypes(java.util.Collection<net.morimekta.providence.graphql.introspection.Type> value) {
            if (value == null) {
                return clearPossibleTypes();
            }

            optionals.set(5);
            modified.set(5);
            mPossibleTypes = net.morimekta.util.collect.UnmodifiableList.copyOf(value);
            return this;
        }

        /**
         * Adds entries to the <code>possibleTypes</code> list.
         * <p>
         * INTERFACE and UNION only
         *
         * @param values The added value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder addToPossibleTypes(net.morimekta.providence.graphql.introspection.Type... values) {
            optionals.set(5);
            modified.set(5);
            java.util.List<net.morimekta.providence.graphql.introspection.Type> _container = mutablePossibleTypes();
            for (net.morimekta.providence.graphql.introspection.Type item : values) {
                _container.add(item);
            }
            return this;
        }

        /**
         * Checks for explicit presence of the <code>possibleTypes</code> field.
         *
         * @return True if possibleTypes has been set.
         */
        public boolean isSetPossibleTypes() {
            return optionals.get(5);
        }

        /**
         * Checks for presence of the <code>possibleTypes</code> field.
         *
         * @return True if possibleTypes is present.
         */
        public boolean hasPossibleTypes() {
            return optionals.get(5);
        }

        /**
         * Checks if the <code>possibleTypes</code> field has been modified since the
         * builder was created.
         *
         * @return True if possibleTypes has been modified.
         */
        public boolean isModifiedPossibleTypes() {
            return modified.get(5);
        }

        /**
         * Clear the <code>possibleTypes</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder clearPossibleTypes() {
            optionals.clear(5);
            modified.set(5);
            mPossibleTypes = null;
            return this;
        }

        /**
         * INTERFACE and UNION only
         *
         * @return The mutable <code>possibleTypes</code> container
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.Type> mutablePossibleTypes() {
            optionals.set(5);
            modified.set(5);

            if (mPossibleTypes == null) {
                mPossibleTypes = new java.util.ArrayList<>();
            } else if (!(mPossibleTypes instanceof java.util.ArrayList)) {
                mPossibleTypes = new java.util.ArrayList<>(mPossibleTypes);
            }
            return mPossibleTypes;
        }

        /**
         * INTERFACE and UNION only
         *
         * @return The <code>possibleTypes</code> field value
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.Type> getPossibleTypes() {
            return mPossibleTypes;
        }

        /**
         * INTERFACE and UNION only
         *
         * @return Optional <code>possibleTypes</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.Type>> optionalPossibleTypes() {
            return java.util.Optional.ofNullable(mPossibleTypes);
        }

        /**
         * INTERFACE and UNION only
         *
         * @return Number of entries in <code>possibleTypes</code>.
         */
        public int numPossibleTypes() {
            return mPossibleTypes != null ? mPossibleTypes.size() : 0;
        }

        /**
         * Set the <code>enumValues</code> field value.
         * <p>
         * ENUM only
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder setEnumValues(java.util.Collection<net.morimekta.providence.graphql.introspection.EnumValue> value) {
            if (value == null) {
                return clearEnumValues();
            }

            optionals.set(6);
            modified.set(6);
            mEnumValues = net.morimekta.util.collect.UnmodifiableList.copyOf(value);
            return this;
        }

        /**
         * Adds entries to the <code>enumValues</code> list.
         * <p>
         * ENUM only
         *
         * @param values The added value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder addToEnumValues(net.morimekta.providence.graphql.introspection.EnumValue... values) {
            optionals.set(6);
            modified.set(6);
            java.util.List<net.morimekta.providence.graphql.introspection.EnumValue> _container = mutableEnumValues();
            for (net.morimekta.providence.graphql.introspection.EnumValue item : values) {
                _container.add(item);
            }
            return this;
        }

        /**
         * Checks for explicit presence of the <code>enumValues</code> field.
         *
         * @return True if enumValues has been set.
         */
        public boolean isSetEnumValues() {
            return optionals.get(6);
        }

        /**
         * Checks for presence of the <code>enumValues</code> field.
         *
         * @return True if enumValues is present.
         */
        public boolean hasEnumValues() {
            return optionals.get(6);
        }

        /**
         * Checks if the <code>enumValues</code> field has been modified since the
         * builder was created.
         *
         * @return True if enumValues has been modified.
         */
        public boolean isModifiedEnumValues() {
            return modified.get(6);
        }

        /**
         * Clear the <code>enumValues</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder clearEnumValues() {
            optionals.clear(6);
            modified.set(6);
            mEnumValues = null;
            return this;
        }

        /**
         * ENUM only
         *
         * @return The mutable <code>enumValues</code> container
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.EnumValue> mutableEnumValues() {
            optionals.set(6);
            modified.set(6);

            if (mEnumValues == null) {
                mEnumValues = new java.util.ArrayList<>();
            } else if (!(mEnumValues instanceof java.util.ArrayList)) {
                mEnumValues = new java.util.ArrayList<>(mEnumValues);
            }
            return mEnumValues;
        }

        /**
         * ENUM only
         *
         * @return The <code>enumValues</code> field value
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.EnumValue> getEnumValues() {
            return mEnumValues;
        }

        /**
         * ENUM only
         *
         * @return Optional <code>enumValues</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.EnumValue>> optionalEnumValues() {
            return java.util.Optional.ofNullable(mEnumValues);
        }

        /**
         * ENUM only
         *
         * @return Number of entries in <code>enumValues</code>.
         */
        public int numEnumValues() {
            return mEnumValues != null ? mEnumValues.size() : 0;
        }

        /**
         * Set the <code>inputFields</code> field value.
         * <p>
         * INPUT_OBJECT only
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder setInputFields(java.util.Collection<net.morimekta.providence.graphql.introspection.InputValue> value) {
            if (value == null) {
                return clearInputFields();
            }

            optionals.set(7);
            modified.set(7);
            mInputFields = net.morimekta.util.collect.UnmodifiableList.copyOf(value);
            return this;
        }

        /**
         * Adds entries to the <code>inputFields</code> list.
         * <p>
         * INPUT_OBJECT only
         *
         * @param values The added value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder addToInputFields(net.morimekta.providence.graphql.introspection.InputValue... values) {
            optionals.set(7);
            modified.set(7);
            java.util.List<net.morimekta.providence.graphql.introspection.InputValue> _container = mutableInputFields();
            for (net.morimekta.providence.graphql.introspection.InputValue item : values) {
                _container.add(item);
            }
            return this;
        }

        /**
         * Checks for explicit presence of the <code>inputFields</code> field.
         *
         * @return True if inputFields has been set.
         */
        public boolean isSetInputFields() {
            return optionals.get(7);
        }

        /**
         * Checks for presence of the <code>inputFields</code> field.
         *
         * @return True if inputFields is present.
         */
        public boolean hasInputFields() {
            return optionals.get(7);
        }

        /**
         * Checks if the <code>inputFields</code> field has been modified since the
         * builder was created.
         *
         * @return True if inputFields has been modified.
         */
        public boolean isModifiedInputFields() {
            return modified.get(7);
        }

        /**
         * Clear the <code>inputFields</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder clearInputFields() {
            optionals.clear(7);
            modified.set(7);
            mInputFields = null;
            return this;
        }

        /**
         * INPUT_OBJECT only
         *
         * @return The mutable <code>inputFields</code> container
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.InputValue> mutableInputFields() {
            optionals.set(7);
            modified.set(7);

            if (mInputFields == null) {
                mInputFields = new java.util.ArrayList<>();
            } else if (!(mInputFields instanceof java.util.ArrayList)) {
                mInputFields = new java.util.ArrayList<>(mInputFields);
            }
            return mInputFields;
        }

        /**
         * INPUT_OBJECT only
         *
         * @return The <code>inputFields</code> field value
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.InputValue> getInputFields() {
            return mInputFields;
        }

        /**
         * INPUT_OBJECT only
         *
         * @return Optional <code>inputFields</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.InputValue>> optionalInputFields() {
            return java.util.Optional.ofNullable(mInputFields);
        }

        /**
         * INPUT_OBJECT only
         *
         * @return Number of entries in <code>inputFields</code>.
         */
        public int numInputFields() {
            return mInputFields != null ? mInputFields.size() : 0;
        }

        /**
         * Set the <code>ofType</code> field value.
         * <p>
         * NON_NULL and LIST only
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder setOfType(net.morimekta.providence.graphql.introspection.Type_OrBuilder value) {
            if (value == null) {
                return clearOfType();
            }

            optionals.set(8);
            modified.set(8);
            if (value instanceof net.morimekta.providence.graphql.introspection.Type._Builder) {
                value = ((net.morimekta.providence.graphql.introspection.Type._Builder) value).build();
            } else if (!(value instanceof net.morimekta.providence.graphql.introspection.Type)) {
                throw new java.lang.IllegalArgumentException("Invalid type for gql_introspection.__Type: " + value.getClass().getName());
            }
            mOfType = (net.morimekta.providence.graphql.introspection.Type) value;
            mOfType_builder = null;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>ofType</code> field.
         *
         * @return True if ofType has been set.
         */
        public boolean isSetOfType() {
            return optionals.get(8);
        }

        /**
         * Checks for presence of the <code>ofType</code> field.
         *
         * @return True if ofType is present.
         */
        public boolean hasOfType() {
            return optionals.get(8);
        }

        /**
         * Checks if the <code>ofType</code> field has been modified since the
         * builder was created.
         *
         * @return True if ofType has been modified.
         */
        public boolean isModifiedOfType() {
            return modified.get(8);
        }

        /**
         * Clear the <code>ofType</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Type._Builder clearOfType() {
            optionals.clear(8);
            modified.set(8);
            mOfType = null;
            mOfType_builder = null;
            return this;
        }

        /**
         * Get the builder for the contained <code>ofType</code> message field.
         * <p>
         * NON_NULL and LIST only
         *
         * @return The field message builder
         */
        @javax.annotation.Nonnull
        public net.morimekta.providence.graphql.introspection.Type._Builder mutableOfType() {
            optionals.set(8);
            modified.set(8);

            if (mOfType != null) {
                mOfType_builder = mOfType.mutate();
                mOfType = null;
            } else if (mOfType_builder == null) {
                mOfType_builder = net.morimekta.providence.graphql.introspection.Type.builder();
            }
            return mOfType_builder;
        }

        /**
         * NON_NULL and LIST only
         *
         * @return The <code>ofType</code> field value
         */
        public net.morimekta.providence.graphql.introspection.Type getOfType() {
            return mOfType_builder != null ? mOfType_builder.build() : mOfType;
        }

        /**
         * NON_NULL and LIST only
         *
         * @return Optional <code>ofType</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<net.morimekta.providence.graphql.introspection.Type> optionalOfType() {
            return java.util.Optional.ofNullable(mOfType_builder != null ? mOfType_builder.build() : mOfType);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) return true;
            if (o == null || !o.getClass().equals(getClass())) return false;
            Type._Builder other = (Type._Builder) o;
            return java.util.Objects.equals(optionals, other.optionals) &&
                   java.util.Objects.equals(mKind, other.mKind) &&
                   java.util.Objects.equals(mName, other.mName) &&
                   java.util.Objects.equals(mDescription, other.mDescription) &&
                   java.util.Objects.equals(mFields, other.mFields) &&
                   java.util.Objects.equals(mInterfaces, other.mInterfaces) &&
                   java.util.Objects.equals(mPossibleTypes, other.mPossibleTypes) &&
                   java.util.Objects.equals(mEnumValues, other.mEnumValues) &&
                   java.util.Objects.equals(mInputFields, other.mInputFields) &&
                   java.util.Objects.equals(getOfType(), other.getOfType());
        }

        @Override
        public int hashCode() {
            return java.util.Objects.hash(
                    Type.class, optionals,
                    Type._Field.KIND, mKind,
                    Type._Field.NAME, mName,
                    Type._Field.DESCRIPTION, mDescription,
                    Type._Field.FIELDS, mFields,
                    Type._Field.INTERFACES, mInterfaces,
                    Type._Field.POSSIBLE_TYPES, mPossibleTypes,
                    Type._Field.ENUM_VALUES, mEnumValues,
                    Type._Field.INPUT_FIELDS, mInputFields,
                    Type._Field.OF_TYPE, getOfType());
        }

        @Override
        @SuppressWarnings("unchecked")
        public net.morimekta.providence.PMessageBuilder mutator(int key) {
            switch (key) {
                case 9: return mutableOfType();
                default: throw new IllegalArgumentException("Not a message field ID: " + key);
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public Type._Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setKind((net.morimekta.providence.graphql.introspection.TypeKind) value); break;
                case 2: setName((String) value); break;
                case 3: setDescription((String) value); break;
                case 4: setFields((java.util.List<net.morimekta.providence.graphql.introspection.Field>) value); break;
                case 5: setInterfaces((java.util.List<net.morimekta.providence.graphql.introspection.Type>) value); break;
                case 6: setPossibleTypes((java.util.List<net.morimekta.providence.graphql.introspection.Type>) value); break;
                case 7: setEnumValues((java.util.List<net.morimekta.providence.graphql.introspection.EnumValue>) value); break;
                case 8: setInputFields((java.util.List<net.morimekta.providence.graphql.introspection.InputValue>) value); break;
                case 9: setOfType((net.morimekta.providence.graphql.introspection.Type) value); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean isSet(int key) {
            switch (key) {
                case 1: return optionals.get(0);
                case 2: return optionals.get(1);
                case 3: return optionals.get(2);
                case 4: return optionals.get(3);
                case 5: return optionals.get(4);
                case 6: return optionals.get(5);
                case 7: return optionals.get(6);
                case 8: return optionals.get(7);
                case 9: return optionals.get(8);
                default: break;
            }
            return false;
        }

        @Override
        public boolean isModified(int key) {
            switch (key) {
                case 1: return modified.get(0);
                case 2: return modified.get(1);
                case 3: return modified.get(2);
                case 4: return modified.get(3);
                case 5: return modified.get(4);
                case 6: return modified.get(5);
                case 7: return modified.get(6);
                case 8: return modified.get(7);
                case 9: return modified.get(8);
                default: break;
            }
            return false;
        }

        @Override
        @SuppressWarnings("unchecked")
        public <T> T get(int key) {
            switch(key) {
                case 1: return (T) getKind();
                case 2: return (T) getName();
                case 3: return (T) getDescription();
                case 4: return (T) getFields();
                case 5: return (T) getInterfaces();
                case 6: return (T) getPossibleTypes();
                case 7: return (T) getEnumValues();
                case 8: return (T) getInputFields();
                case 9: return (T) getOfType();
                default: return null;
            }
        }

        @Override
        public boolean has(int key) {
            switch(key) {
                case 1: return mKind != null;
                case 2: return mName != null;
                case 3: return mDescription != null;
                case 4: return mFields != null;
                case 5: return mInterfaces != null;
                case 6: return mPossibleTypes != null;
                case 7: return mEnumValues != null;
                case 8: return mInputFields != null;
                case 9: return mOfType != null || mOfType_builder != null;
                default: return false;
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public Type._Builder addTo(int key, Object value) {
            switch (key) {
                case 4: addToFields((net.morimekta.providence.graphql.introspection.Field) value); break;
                case 5: addToInterfaces((net.morimekta.providence.graphql.introspection.Type) value); break;
                case 6: addToPossibleTypes((net.morimekta.providence.graphql.introspection.Type) value); break;
                case 7: addToEnumValues((net.morimekta.providence.graphql.introspection.EnumValue) value); break;
                case 8: addToInputFields((net.morimekta.providence.graphql.introspection.InputValue) value); break;
                default: break;
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public Type._Builder clear(int key) {
            switch (key) {
                case 1: clearKind(); break;
                case 2: clearName(); break;
                case 3: clearDescription(); break;
                case 4: clearFields(); break;
                case 5: clearInterfaces(); break;
                case 6: clearPossibleTypes(); break;
                case 7: clearEnumValues(); break;
                case 8: clearInputFields(); break;
                case 9: clearOfType(); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean valid() {
            return optionals.get(0);
        }

        @Override
        public Type._Builder validate() {
            if (!valid()) {
                java.util.ArrayList<String> missing = new java.util.ArrayList<>();

                if (!optionals.get(0)) {
                    missing.add("kind");
                }

                throw new java.lang.IllegalStateException(
                        "Missing required fields " +
                        String.join(",", missing) +
                        " in message gql_introspection.__Type");
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PStructDescriptor<Type> descriptor() {
            return Type.kDescriptor;
        }

        @Override
        public void readBinary(net.morimekta.util.io.BigEndianBinaryReader reader, boolean strict) throws java.io.IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                int field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 8) {
                            mKind = net.morimekta.providence.graphql.introspection.TypeKind.findById(reader.expectInt());
                            optionals.set(0);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Type.kind, should be struct(12)");
                        }
                        break;
                    }
                    case 2: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            mName = new String(reader.expectBytes(len_1), java.nio.charset.StandardCharsets.UTF_8);
                            optionals.set(1);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Type.name, should be struct(12)");
                        }
                        break;
                    }
                    case 3: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            mDescription = new String(reader.expectBytes(len_2), java.nio.charset.StandardCharsets.UTF_8);
                            optionals.set(2);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Type.description, should be struct(12)");
                        }
                        break;
                    }
                    case 4: {
                        if (type == 15) {
                            byte t_5 = reader.expectByte();
                            if (t_5 == 12) {
                                final int len_4 = reader.expectUInt32();
                                net.morimekta.util.collect.UnmodifiableList.Builder<net.morimekta.providence.graphql.introspection.Field> b_3 = net.morimekta.util.collect.UnmodifiableList.builder(len_4);
                                for (int i_6 = 0; i_6 < len_4; ++i_6) {
                                    net.morimekta.providence.graphql.introspection.Field key_7 = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.Field.kDescriptor, strict);
                                    b_3.add(key_7);
                                }
                                mFields = b_3.build();
                            } else {
                                throw new net.morimekta.providence.serializer.SerializerException("Wrong item type " + net.morimekta.providence.serializer.binary.BinaryType.asString(t_5) + " for gql_introspection.__Type.fields, should be struct(12)");
                            }
                            optionals.set(3);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Type.fields, should be struct(12)");
                        }
                        break;
                    }
                    case 5: {
                        if (type == 15) {
                            byte t_10 = reader.expectByte();
                            if (t_10 == 12) {
                                final int len_9 = reader.expectUInt32();
                                net.morimekta.util.collect.UnmodifiableList.Builder<net.morimekta.providence.graphql.introspection.Type> b_8 = net.morimekta.util.collect.UnmodifiableList.builder(len_9);
                                for (int i_11 = 0; i_11 < len_9; ++i_11) {
                                    net.morimekta.providence.graphql.introspection.Type key_12 = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.Type.kDescriptor, strict);
                                    b_8.add(key_12);
                                }
                                mInterfaces = b_8.build();
                            } else {
                                throw new net.morimekta.providence.serializer.SerializerException("Wrong item type " + net.morimekta.providence.serializer.binary.BinaryType.asString(t_10) + " for gql_introspection.__Type.interfaces, should be struct(12)");
                            }
                            optionals.set(4);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Type.interfaces, should be struct(12)");
                        }
                        break;
                    }
                    case 6: {
                        if (type == 15) {
                            byte t_15 = reader.expectByte();
                            if (t_15 == 12) {
                                final int len_14 = reader.expectUInt32();
                                net.morimekta.util.collect.UnmodifiableList.Builder<net.morimekta.providence.graphql.introspection.Type> b_13 = net.morimekta.util.collect.UnmodifiableList.builder(len_14);
                                for (int i_16 = 0; i_16 < len_14; ++i_16) {
                                    net.morimekta.providence.graphql.introspection.Type key_17 = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.Type.kDescriptor, strict);
                                    b_13.add(key_17);
                                }
                                mPossibleTypes = b_13.build();
                            } else {
                                throw new net.morimekta.providence.serializer.SerializerException("Wrong item type " + net.morimekta.providence.serializer.binary.BinaryType.asString(t_15) + " for gql_introspection.__Type.possibleTypes, should be struct(12)");
                            }
                            optionals.set(5);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Type.possibleTypes, should be struct(12)");
                        }
                        break;
                    }
                    case 7: {
                        if (type == 15) {
                            byte t_20 = reader.expectByte();
                            if (t_20 == 12) {
                                final int len_19 = reader.expectUInt32();
                                net.morimekta.util.collect.UnmodifiableList.Builder<net.morimekta.providence.graphql.introspection.EnumValue> b_18 = net.morimekta.util.collect.UnmodifiableList.builder(len_19);
                                for (int i_21 = 0; i_21 < len_19; ++i_21) {
                                    net.morimekta.providence.graphql.introspection.EnumValue key_22 = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.EnumValue.kDescriptor, strict);
                                    b_18.add(key_22);
                                }
                                mEnumValues = b_18.build();
                            } else {
                                throw new net.morimekta.providence.serializer.SerializerException("Wrong item type " + net.morimekta.providence.serializer.binary.BinaryType.asString(t_20) + " for gql_introspection.__Type.enumValues, should be struct(12)");
                            }
                            optionals.set(6);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Type.enumValues, should be struct(12)");
                        }
                        break;
                    }
                    case 8: {
                        if (type == 15) {
                            byte t_25 = reader.expectByte();
                            if (t_25 == 12) {
                                final int len_24 = reader.expectUInt32();
                                net.morimekta.util.collect.UnmodifiableList.Builder<net.morimekta.providence.graphql.introspection.InputValue> b_23 = net.morimekta.util.collect.UnmodifiableList.builder(len_24);
                                for (int i_26 = 0; i_26 < len_24; ++i_26) {
                                    net.morimekta.providence.graphql.introspection.InputValue key_27 = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.InputValue.kDescriptor, strict);
                                    b_23.add(key_27);
                                }
                                mInputFields = b_23.build();
                            } else {
                                throw new net.morimekta.providence.serializer.SerializerException("Wrong item type " + net.morimekta.providence.serializer.binary.BinaryType.asString(t_25) + " for gql_introspection.__Type.inputFields, should be struct(12)");
                            }
                            optionals.set(7);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Type.inputFields, should be struct(12)");
                        }
                        break;
                    }
                    case 9: {
                        if (type == 12) {
                            mOfType = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.Type.kDescriptor, strict);
                            optionals.set(8);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Type.ofType, should be struct(12)");
                        }
                        break;
                    }
                    default: {
                        net.morimekta.providence.serializer.binary.BinaryFormatUtils.readFieldValue(reader, new net.morimekta.providence.serializer.binary.BinaryFormatUtils.FieldInfo(field, type), null, false);
                        break;
                    }
                }
                type = reader.expectByte();
            }
        }

        @Override
        @javax.annotation.Nonnull
        public Type build() {
            return new Type(this);
        }
    }
}
