/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.introspection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.graphql.introspection.Directive;
import net.morimekta.providence.graphql.introspection.Schema_OrBuilder;
import net.morimekta.providence.graphql.introspection.Type;
import net.morimekta.providence.graphql.introspection.Type_OrBuilder;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

@Immutable
public class Schema
implements Schema_OrBuilder,
PMessage<Schema>,
Comparable<Schema>,
BinaryWriter {
    private final transient List<Type> mTypes;
    private final transient Type mQueryType;
    private final transient Type mMutationType;
    private final transient Type mSubscriptionType;
    private final transient List<Directive> mDirectives;
    private volatile transient int tHashCode;
    public static final PStructDescriptor<Schema> kDescriptor = new _Descriptor();

    private Schema(_Builder builder) {
        this.mTypes = builder.isSetTypes() ? UnmodifiableList.copyOf((Collection)builder.mTypes) : null;
        this.mQueryType = builder.mQueryType_builder != null ? builder.mQueryType_builder.build() : builder.mQueryType;
        this.mMutationType = builder.mMutationType_builder != null ? builder.mMutationType_builder.build() : builder.mMutationType;
        this.mSubscriptionType = builder.mSubscriptionType_builder != null ? builder.mSubscriptionType_builder.build() : builder.mSubscriptionType;
        this.mDirectives = builder.isSetDirectives() ? UnmodifiableList.copyOf((Collection)builder.mDirectives) : null;
    }

    @Override
    public int numTypes() {
        return this.mTypes != null ? this.mTypes.size() : 0;
    }

    @Override
    public boolean hasTypes() {
        return this.mTypes != null;
    }

    @Override
    public List<Type> getTypes() {
        return this.mTypes;
    }

    @Override
    @Nonnull
    public Optional<List<Type>> optionalTypes() {
        return Optional.ofNullable(this.mTypes);
    }

    @Override
    public boolean hasQueryType() {
        return this.mQueryType != null;
    }

    @Override
    public Type getQueryType() {
        return this.mQueryType;
    }

    @Override
    @Nonnull
    public Optional<Type> optionalQueryType() {
        return Optional.ofNullable(this.mQueryType);
    }

    @Override
    public boolean hasMutationType() {
        return this.mMutationType != null;
    }

    @Override
    public Type getMutationType() {
        return this.mMutationType;
    }

    @Override
    @Nonnull
    public Optional<Type> optionalMutationType() {
        return Optional.ofNullable(this.mMutationType);
    }

    @Override
    public boolean hasSubscriptionType() {
        return this.mSubscriptionType != null;
    }

    @Override
    public Type getSubscriptionType() {
        return this.mSubscriptionType;
    }

    @Override
    @Nonnull
    public Optional<Type> optionalSubscriptionType() {
        return Optional.ofNullable(this.mSubscriptionType);
    }

    @Override
    public int numDirectives() {
        return this.mDirectives != null ? this.mDirectives.size() : 0;
    }

    @Override
    public boolean hasDirectives() {
        return this.mDirectives != null;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.mDirectives;
    }

    @Override
    @Nonnull
    public Optional<List<Directive>> optionalDirectives() {
        return Optional.ofNullable(this.mDirectives);
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.mTypes != null;
            }
            case 2: {
                return this.mQueryType != null;
            }
            case 3: {
                return this.mMutationType != null;
            }
            case 4: {
                return this.mSubscriptionType != null;
            }
            case 5: {
                return this.mDirectives != null;
            }
        }
        return false;
    }

    public <T> T get(int key) {
        switch (key) {
            case 1: {
                return (T)this.mTypes;
            }
            case 2: {
                return (T)this.mQueryType;
            }
            case 3: {
                return (T)this.mMutationType;
            }
            case 4: {
                return (T)this.mSubscriptionType;
            }
            case 5: {
                return (T)this.mDirectives;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Schema other = (Schema)o;
        return Objects.equals(this.mTypes, other.mTypes) && Objects.equals(this.mQueryType, other.mQueryType) && Objects.equals(this.mMutationType, other.mMutationType) && Objects.equals(this.mSubscriptionType, other.mSubscriptionType) && Objects.equals(this.mDirectives, other.mDirectives);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{Schema.class, _Field.TYPES, this.mTypes, _Field.QUERY_TYPE, this.mQueryType, _Field.MUTATION_TYPE, this.mMutationType, _Field.SUBSCRIPTION_TYPE, this.mSubscriptionType, _Field.DIRECTIVES, this.mDirectives});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "gql_introspection.__Schema" + this.asString();
    }

    @Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasTypes()) {
            first = false;
            out.append("types:").append(Strings.asString(this.mTypes));
        }
        if (this.hasQueryType()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("queryType:").append(this.mQueryType.asString());
        }
        if (this.hasMutationType()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("mutationType:").append(this.mMutationType.asString());
        }
        if (this.hasSubscriptionType()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("subscriptionType:").append(this.mSubscriptionType.asString());
        }
        if (this.hasDirectives()) {
            if (!first) {
                out.append(',');
            }
            out.append("directives:").append(Strings.asString(this.mDirectives));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Schema other) {
        int c = Boolean.compare(this.mTypes != null, other.mTypes != null);
        if (c != 0) {
            return c;
        }
        if (this.mTypes != null && (c = Integer.compare(this.mTypes.hashCode(), other.mTypes.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mQueryType != null, other.mQueryType != null);
        if (c != 0) {
            return c;
        }
        if (this.mQueryType != null && (c = this.mQueryType.compareTo(other.mQueryType)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mMutationType != null, other.mMutationType != null);
        if (c != 0) {
            return c;
        }
        if (this.mMutationType != null && (c = this.mMutationType.compareTo(other.mMutationType)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mSubscriptionType != null, other.mSubscriptionType != null);
        if (c != 0) {
            return c;
        }
        if (this.mSubscriptionType != null && (c = this.mSubscriptionType.compareTo(other.mSubscriptionType)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mDirectives != null, other.mDirectives != null);
        if (c != 0) {
            return c;
        }
        if (this.mDirectives != null && (c = Integer.compare(this.mDirectives.hashCode(), other.mDirectives.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        if (this.hasTypes()) {
            length += writer.writeByte((byte)15);
            length += writer.writeShort((short)1);
            length += writer.writeByte((byte)12);
            length += writer.writeUInt32(this.mTypes.size());
            for (Type entry_1 : this.mTypes) {
                length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)entry_1);
            }
        }
        if (this.hasQueryType()) {
            length += writer.writeByte((byte)12);
            length += writer.writeShort((short)2);
            length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)this.mQueryType);
        }
        if (this.hasMutationType()) {
            length += writer.writeByte((byte)12);
            length += writer.writeShort((short)3);
            length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)this.mMutationType);
        }
        if (this.hasSubscriptionType()) {
            length += writer.writeByte((byte)12);
            length += writer.writeShort((short)4);
            length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)this.mSubscriptionType);
        }
        if (this.hasDirectives()) {
            length += writer.writeByte((byte)15);
            length += writer.writeShort((short)5);
            length += writer.writeByte((byte)12);
            length += writer.writeUInt32(this.mDirectives.size());
            for (Directive entry_2 : this.mDirectives) {
                length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)entry_2);
            }
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    @Nonnull
    public static PStructDescriptorProvider<Schema> provider() {
        return new _Provider();
    }

    @Nonnull
    public PStructDescriptor<Schema> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<Schema>
    implements Schema_OrBuilder,
    BinaryReader {
        private BitSet optionals = new BitSet(5);
        private BitSet modified = new BitSet(5);
        private List<Type> mTypes;
        private Type mQueryType;
        private Type._Builder mQueryType_builder;
        private Type mMutationType;
        private Type._Builder mMutationType_builder;
        private Type mSubscriptionType;
        private Type._Builder mSubscriptionType_builder;
        private List<Directive> mDirectives;

        public _Builder() {
        }

        public _Builder(Schema base) {
            this();
            if (base.hasTypes()) {
                this.optionals.set(0);
                this.mTypes = base.mTypes;
            }
            if (base.hasQueryType()) {
                this.optionals.set(1);
                this.mQueryType = base.mQueryType;
            }
            if (base.hasMutationType()) {
                this.optionals.set(2);
                this.mMutationType = base.mMutationType;
            }
            if (base.hasSubscriptionType()) {
                this.optionals.set(3);
                this.mSubscriptionType = base.mSubscriptionType;
            }
            if (base.hasDirectives()) {
                this.optionals.set(4);
                this.mDirectives = base.mDirectives;
            }
        }

        @Nonnull
        public _Builder merge(Schema from) {
            if (from.hasTypes()) {
                this.optionals.set(0);
                this.modified.set(0);
                this.mTypes = from.getTypes();
            }
            if (from.hasQueryType()) {
                this.optionals.set(1);
                this.modified.set(1);
                if (this.mQueryType_builder != null) {
                    this.mQueryType_builder.merge(from.getQueryType());
                } else if (this.mQueryType != null) {
                    this.mQueryType_builder = this.mQueryType.mutate().merge(from.getQueryType());
                    this.mQueryType = null;
                } else {
                    this.mQueryType = from.getQueryType();
                }
            }
            if (from.hasMutationType()) {
                this.optionals.set(2);
                this.modified.set(2);
                if (this.mMutationType_builder != null) {
                    this.mMutationType_builder.merge(from.getMutationType());
                } else if (this.mMutationType != null) {
                    this.mMutationType_builder = this.mMutationType.mutate().merge(from.getMutationType());
                    this.mMutationType = null;
                } else {
                    this.mMutationType = from.getMutationType();
                }
            }
            if (from.hasSubscriptionType()) {
                this.optionals.set(3);
                this.modified.set(3);
                if (this.mSubscriptionType_builder != null) {
                    this.mSubscriptionType_builder.merge(from.getSubscriptionType());
                } else if (this.mSubscriptionType != null) {
                    this.mSubscriptionType_builder = this.mSubscriptionType.mutate().merge(from.getSubscriptionType());
                    this.mSubscriptionType = null;
                } else {
                    this.mSubscriptionType = from.getSubscriptionType();
                }
            }
            if (from.hasDirectives()) {
                this.optionals.set(4);
                this.modified.set(4);
                this.mDirectives = from.getDirectives();
            }
            return this;
        }

        @Nonnull
        public _Builder setTypes(Collection<Type> value) {
            if (value == null) {
                return this.clearTypes();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mTypes = UnmodifiableList.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder addToTypes(Type ... values) {
            this.optionals.set(0);
            this.modified.set(0);
            List<Type> _container = this.mutableTypes();
            for (Type item : values) {
                _container.add(item);
            }
            return this;
        }

        public boolean isSetTypes() {
            return this.optionals.get(0);
        }

        @Override
        public boolean hasTypes() {
            return this.optionals.get(0);
        }

        public boolean isModifiedTypes() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearTypes() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mTypes = null;
            return this;
        }

        public List<Type> mutableTypes() {
            this.optionals.set(0);
            this.modified.set(0);
            if (this.mTypes == null) {
                this.mTypes = new ArrayList<Type>();
            } else if (!(this.mTypes instanceof ArrayList)) {
                this.mTypes = new ArrayList<Type>(this.mTypes);
            }
            return this.mTypes;
        }

        @Override
        public List<Type> getTypes() {
            return this.mTypes;
        }

        @Override
        @Nonnull
        public Optional<List<Type>> optionalTypes() {
            return Optional.ofNullable(this.mTypes);
        }

        @Override
        public int numTypes() {
            return this.mTypes != null ? this.mTypes.size() : 0;
        }

        @Nonnull
        public _Builder setQueryType(Type_OrBuilder value) {
            if (value == null) {
                return this.clearQueryType();
            }
            this.optionals.set(1);
            this.modified.set(1);
            if (value instanceof Type._Builder) {
                value = ((Type._Builder)value).build();
            } else if (!(value instanceof Type)) {
                throw new IllegalArgumentException("Invalid type for gql_introspection.__Type: " + value.getClass().getName());
            }
            this.mQueryType = (Type)value;
            this.mQueryType_builder = null;
            return this;
        }

        public boolean isSetQueryType() {
            return this.optionals.get(1);
        }

        @Override
        public boolean hasQueryType() {
            return this.optionals.get(1);
        }

        public boolean isModifiedQueryType() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearQueryType() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mQueryType = null;
            this.mQueryType_builder = null;
            return this;
        }

        @Nonnull
        public Type._Builder mutableQueryType() {
            this.optionals.set(1);
            this.modified.set(1);
            if (this.mQueryType != null) {
                this.mQueryType_builder = this.mQueryType.mutate();
                this.mQueryType = null;
            } else if (this.mQueryType_builder == null) {
                this.mQueryType_builder = Type.builder();
            }
            return this.mQueryType_builder;
        }

        @Override
        public Type getQueryType() {
            return this.mQueryType_builder != null ? this.mQueryType_builder.build() : this.mQueryType;
        }

        @Override
        @Nonnull
        public Optional<Type> optionalQueryType() {
            return Optional.ofNullable(this.mQueryType_builder != null ? this.mQueryType_builder.build() : this.mQueryType);
        }

        @Nonnull
        public _Builder setMutationType(Type_OrBuilder value) {
            if (value == null) {
                return this.clearMutationType();
            }
            this.optionals.set(2);
            this.modified.set(2);
            if (value instanceof Type._Builder) {
                value = ((Type._Builder)value).build();
            } else if (!(value instanceof Type)) {
                throw new IllegalArgumentException("Invalid type for gql_introspection.__Type: " + value.getClass().getName());
            }
            this.mMutationType = (Type)value;
            this.mMutationType_builder = null;
            return this;
        }

        public boolean isSetMutationType() {
            return this.optionals.get(2);
        }

        @Override
        public boolean hasMutationType() {
            return this.optionals.get(2);
        }

        public boolean isModifiedMutationType() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearMutationType() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mMutationType = null;
            this.mMutationType_builder = null;
            return this;
        }

        @Nonnull
        public Type._Builder mutableMutationType() {
            this.optionals.set(2);
            this.modified.set(2);
            if (this.mMutationType != null) {
                this.mMutationType_builder = this.mMutationType.mutate();
                this.mMutationType = null;
            } else if (this.mMutationType_builder == null) {
                this.mMutationType_builder = Type.builder();
            }
            return this.mMutationType_builder;
        }

        @Override
        public Type getMutationType() {
            return this.mMutationType_builder != null ? this.mMutationType_builder.build() : this.mMutationType;
        }

        @Override
        @Nonnull
        public Optional<Type> optionalMutationType() {
            return Optional.ofNullable(this.mMutationType_builder != null ? this.mMutationType_builder.build() : this.mMutationType);
        }

        @Nonnull
        public _Builder setSubscriptionType(Type_OrBuilder value) {
            if (value == null) {
                return this.clearSubscriptionType();
            }
            this.optionals.set(3);
            this.modified.set(3);
            if (value instanceof Type._Builder) {
                value = ((Type._Builder)value).build();
            } else if (!(value instanceof Type)) {
                throw new IllegalArgumentException("Invalid type for gql_introspection.__Type: " + value.getClass().getName());
            }
            this.mSubscriptionType = (Type)value;
            this.mSubscriptionType_builder = null;
            return this;
        }

        public boolean isSetSubscriptionType() {
            return this.optionals.get(3);
        }

        @Override
        public boolean hasSubscriptionType() {
            return this.optionals.get(3);
        }

        public boolean isModifiedSubscriptionType() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearSubscriptionType() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mSubscriptionType = null;
            this.mSubscriptionType_builder = null;
            return this;
        }

        @Nonnull
        public Type._Builder mutableSubscriptionType() {
            this.optionals.set(3);
            this.modified.set(3);
            if (this.mSubscriptionType != null) {
                this.mSubscriptionType_builder = this.mSubscriptionType.mutate();
                this.mSubscriptionType = null;
            } else if (this.mSubscriptionType_builder == null) {
                this.mSubscriptionType_builder = Type.builder();
            }
            return this.mSubscriptionType_builder;
        }

        @Override
        public Type getSubscriptionType() {
            return this.mSubscriptionType_builder != null ? this.mSubscriptionType_builder.build() : this.mSubscriptionType;
        }

        @Override
        @Nonnull
        public Optional<Type> optionalSubscriptionType() {
            return Optional.ofNullable(this.mSubscriptionType_builder != null ? this.mSubscriptionType_builder.build() : this.mSubscriptionType);
        }

        @Nonnull
        public _Builder setDirectives(Collection<Directive> value) {
            if (value == null) {
                return this.clearDirectives();
            }
            this.optionals.set(4);
            this.modified.set(4);
            this.mDirectives = UnmodifiableList.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder addToDirectives(Directive ... values) {
            this.optionals.set(4);
            this.modified.set(4);
            List<Directive> _container = this.mutableDirectives();
            for (Directive item : values) {
                _container.add(item);
            }
            return this;
        }

        public boolean isSetDirectives() {
            return this.optionals.get(4);
        }

        @Override
        public boolean hasDirectives() {
            return this.optionals.get(4);
        }

        public boolean isModifiedDirectives() {
            return this.modified.get(4);
        }

        @Nonnull
        public _Builder clearDirectives() {
            this.optionals.clear(4);
            this.modified.set(4);
            this.mDirectives = null;
            return this;
        }

        public List<Directive> mutableDirectives() {
            this.optionals.set(4);
            this.modified.set(4);
            if (this.mDirectives == null) {
                this.mDirectives = new ArrayList<Directive>();
            } else if (!(this.mDirectives instanceof ArrayList)) {
                this.mDirectives = new ArrayList<Directive>(this.mDirectives);
            }
            return this.mDirectives;
        }

        @Override
        public List<Directive> getDirectives() {
            return this.mDirectives;
        }

        @Override
        @Nonnull
        public Optional<List<Directive>> optionalDirectives() {
            return Optional.ofNullable(this.mDirectives);
        }

        @Override
        public int numDirectives() {
            return this.mDirectives != null ? this.mDirectives.size() : 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            _Builder other = (_Builder)o;
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mTypes, other.mTypes) && Objects.equals(this.getQueryType(), other.getQueryType()) && Objects.equals(this.getMutationType(), other.getMutationType()) && Objects.equals(this.getSubscriptionType(), other.getSubscriptionType()) && Objects.equals(this.mDirectives, other.mDirectives);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{Schema.class, this.optionals, _Field.TYPES, this.mTypes, _Field.QUERY_TYPE, this.getQueryType(), _Field.MUTATION_TYPE, this.getMutationType(), _Field.SUBSCRIPTION_TYPE, this.getSubscriptionType(), _Field.DIRECTIVES, this.mDirectives});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                case 2: {
                    return this.mutableQueryType();
                }
                case 3: {
                    return this.mutableMutationType();
                }
                case 4: {
                    return this.mutableSubscriptionType();
                }
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setTypes((List)value);
                    break;
                }
                case 2: {
                    this.setQueryType((Type)value);
                    break;
                }
                case 3: {
                    this.setMutationType((Type)value);
                    break;
                }
                case 4: {
                    this.setSubscriptionType((Type)value);
                    break;
                }
                case 5: {
                    this.setDirectives((List)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 3: {
                    return this.optionals.get(2);
                }
                case 4: {
                    return this.optionals.get(3);
                }
                case 5: {
                    return this.optionals.get(4);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 3: {
                    return this.modified.get(2);
                }
                case 4: {
                    return this.modified.get(3);
                }
                case 5: {
                    return this.modified.get(4);
                }
            }
            return false;
        }

        public <T> T get(int key) {
            switch (key) {
                case 1: {
                    return (T)this.getTypes();
                }
                case 2: {
                    return (T)this.getQueryType();
                }
                case 3: {
                    return (T)this.getMutationType();
                }
                case 4: {
                    return (T)this.getSubscriptionType();
                }
                case 5: {
                    return (T)this.getDirectives();
                }
            }
            return null;
        }

        public boolean has(int key) {
            switch (key) {
                case 1: {
                    return this.mTypes != null;
                }
                case 2: {
                    return this.mQueryType != null || this.mQueryType_builder != null;
                }
                case 3: {
                    return this.mMutationType != null || this.mMutationType_builder != null;
                }
                case 4: {
                    return this.mSubscriptionType != null || this.mSubscriptionType_builder != null;
                }
                case 5: {
                    return this.mDirectives != null;
                }
            }
            return false;
        }

        @Nonnull
        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 1: {
                    this.addToTypes((Type)value);
                    break;
                }
                case 5: {
                    this.addToDirectives((Directive)value);
                    break;
                }
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearTypes();
                    break;
                }
                case 2: {
                    this.clearQueryType();
                    break;
                }
                case 3: {
                    this.clearMutationType();
                    break;
                }
                case 4: {
                    this.clearSubscriptionType();
                    break;
                }
                case 5: {
                    this.clearDirectives();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return true;
        }

        public _Builder validate() {
            return this;
        }

        @Nonnull
        public PStructDescriptor<Schema> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 15) {
                            UnmodifiableList.Builder b_1;
                            byte t_3 = reader.expectByte();
                            if (t_3 == 12) {
                                int len_2 = reader.expectUInt32();
                                b_1 = UnmodifiableList.builder((int)len_2);
                                for (int i_4 = 0; i_4 < len_2; ++i_4) {
                                    Type key_5 = (Type)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, Type.kDescriptor, (boolean)strict);
                                    b_1.add((Object)key_5);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_3) + " for gql_introspection.__Schema.types, should be struct(12)", new Object[0]);
                            }
                            this.mTypes = b_1.build();
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Schema.types, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 12) {
                            this.mQueryType = (Type)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, Type.kDescriptor, (boolean)strict);
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Schema.queryType, should be struct(12)", new Object[0]);
                    }
                    case 3: {
                        if (type == 12) {
                            this.mMutationType = (Type)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, Type.kDescriptor, (boolean)strict);
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Schema.mutationType, should be struct(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 12) {
                            this.mSubscriptionType = (Type)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, Type.kDescriptor, (boolean)strict);
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Schema.subscriptionType, should be struct(12)", new Object[0]);
                    }
                    case 5: {
                        if (type == 15) {
                            UnmodifiableList.Builder b_6;
                            byte t_8 = reader.expectByte();
                            if (t_8 == 12) {
                                int len_7 = reader.expectUInt32();
                                b_6 = UnmodifiableList.builder((int)len_7);
                                for (int i_9 = 0; i_9 < len_7; ++i_9) {
                                    Directive key_10 = (Directive)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, Directive.kDescriptor, (boolean)strict);
                                    b_6.add((Object)key_10);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_8) + " for gql_introspection.__Schema.directives, should be struct(12)", new Object[0]);
                            }
                            this.mDirectives = b_6.build();
                            this.optionals.set(4);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Schema.directives, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        @Nonnull
        public Schema build() {
            return new Schema(this);
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<Schema> {
        private _Provider() {
        }

        public PStructDescriptor<Schema> descriptor() {
            return kDescriptor;
        }
    }

    private static final class _Descriptor
    extends PStructDescriptor<Schema> {
        public _Descriptor() {
            super("gql_introspection", "__Schema", _Builder::new, false);
        }

        @Nonnull
        public boolean isInnerType() {
            return false;
        }

        @Nonnull
        public boolean isAutoType() {
            return false;
        }

        @Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Nullable
        public _Field findFieldByPojoName(String name) {
            return _Field.findByPojoName(name);
        }

        @Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    public static enum _Field implements PField<Schema>
    {
        TYPES(1, PRequirement.OPTIONAL, "types", "types", (PDescriptorProvider)PList.provider(Type.provider()), null, null),
        QUERY_TYPE(2, PRequirement.OPTIONAL, "queryType", "queryType", (PDescriptorProvider)Type.provider(), null, null),
        MUTATION_TYPE(3, PRequirement.OPTIONAL, "mutationType", "mutationType", (PDescriptorProvider)Type.provider(), null, null),
        SUBSCRIPTION_TYPE(4, PRequirement.OPTIONAL, "subscriptionType", "subscriptionType", (PDescriptorProvider)Type.provider(), null, null),
        DIRECTIVES(5, PRequirement.OPTIONAL, "directives", "directives", (PDescriptorProvider)PList.provider(Directive.provider()), null, null);

        private final int mId;
        private final PRequirement mRequired;
        private final String mName;
        private final String mPojoName;
        private final PDescriptorProvider mTypeProvider;
        private final PStructDescriptorProvider mArgumentsProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int id, PRequirement required, String name, String pojoName, PDescriptorProvider typeProvider, PStructDescriptorProvider argumentsProvider, PValueProvider<?> defaultValue) {
            this.mId = id;
            this.mRequired = required;
            this.mName = name;
            this.mPojoName = pojoName;
            this.mTypeProvider = typeProvider;
            this.mArgumentsProvider = argumentsProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getId() {
            return this.mId;
        }

        @Nonnull
        public PRequirement getRequirement() {
            return this.mRequired;
        }

        @Nonnull
        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        @Nullable
        public PStructDescriptor getArgumentsType() {
            return this.mArgumentsProvider == null ? null : this.mArgumentsProvider.descriptor();
        }

        @Nonnull
        public String getName() {
            return this.mName;
        }

        @Nonnull
        public String getPojoName() {
            return this.mPojoName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        @Nullable
        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        @Nonnull
        public PMessageDescriptor<Schema> onMessageType() {
            return kDescriptor;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field findById(int id) {
            switch (id) {
                case 1: {
                    return TYPES;
                }
                case 2: {
                    return QUERY_TYPE;
                }
                case 3: {
                    return MUTATION_TYPE;
                }
                case 4: {
                    return SUBSCRIPTION_TYPE;
                }
                case 5: {
                    return DIRECTIVES;
                }
            }
            return null;
        }

        public static _Field findByName(String name) {
            if (name == null) {
                return null;
            }
            switch (name) {
                case "types": {
                    return TYPES;
                }
                case "queryType": {
                    return QUERY_TYPE;
                }
                case "mutationType": {
                    return MUTATION_TYPE;
                }
                case "subscriptionType": {
                    return SUBSCRIPTION_TYPE;
                }
                case "directives": {
                    return DIRECTIVES;
                }
            }
            return null;
        }

        public static _Field findByPojoName(String name) {
            if (name == null) {
                return null;
            }
            switch (name) {
                case "types": {
                    return TYPES;
                }
                case "queryType": {
                    return QUERY_TYPE;
                }
                case "mutationType": {
                    return MUTATION_TYPE;
                }
                case "subscriptionType": {
                    return SUBSCRIPTION_TYPE;
                }
                case "directives": {
                    return DIRECTIVES;
                }
            }
            return null;
        }

        public static _Field fieldForId(int id) {
            _Field field = _Field.findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in gql_introspection.__Schema");
            }
            return field;
        }

        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = _Field.findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__Schema");
            }
            return field;
        }

        public static _Field fieldForPojoName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = _Field.findByPojoName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__Schema");
            }
            return field;
        }
    }
}

