/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.introspection;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.graphql.introspection.EnumValue_OrBuilder;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

@Immutable
public class EnumValue
implements EnumValue_OrBuilder,
PMessage<EnumValue>,
Comparable<EnumValue>,
BinaryWriter {
    private static final String kDefaultName = "";
    private static final boolean kDefaultIsDeprecated = false;
    private final transient String mName;
    private final transient String mDescription;
    private final transient boolean mIsDeprecated;
    private final transient String mDeprecationReason;
    private volatile transient int tHashCode;
    public static final PStructDescriptor<EnumValue> kDescriptor = new _Descriptor();

    public EnumValue(String pName, String pDescription, boolean pIsDeprecated, String pDeprecationReason) {
        this.mName = pName != null ? pName : kDefaultName;
        this.mDescription = pDescription;
        this.mIsDeprecated = pIsDeprecated;
        this.mDeprecationReason = pDeprecationReason;
    }

    private EnumValue(_Builder builder) {
        this.mName = builder.isSetName() ? builder.mName : kDefaultName;
        this.mDescription = builder.mDescription;
        this.mIsDeprecated = builder.mIsDeprecated;
        this.mDeprecationReason = builder.mDeprecationReason;
    }

    @Override
    public boolean hasName() {
        return true;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean hasDescription() {
        return this.mDescription != null;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    @Nonnull
    public Optional<String> optionalDescription() {
        return Optional.ofNullable(this.mDescription);
    }

    @Override
    public boolean hasIsDeprecated() {
        return true;
    }

    @Override
    public boolean isIsDeprecated() {
        return this.mIsDeprecated;
    }

    @Override
    public boolean hasDeprecationReason() {
        return this.mDeprecationReason != null;
    }

    @Override
    public String getDeprecationReason() {
        return this.mDeprecationReason;
    }

    @Override
    @Nonnull
    public Optional<String> optionalDeprecationReason() {
        return Optional.ofNullable(this.mDeprecationReason);
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return true;
            }
            case 2: {
                return this.mDescription != null;
            }
            case 3: {
                return true;
            }
            case 4: {
                return this.mDeprecationReason != null;
            }
        }
        return false;
    }

    public <T> T get(int key) {
        switch (key) {
            case 1: {
                return (T)this.mName;
            }
            case 2: {
                return (T)this.mDescription;
            }
            case 3: {
                return (T)Boolean.valueOf(this.mIsDeprecated);
            }
            case 4: {
                return (T)this.mDeprecationReason;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        EnumValue other = (EnumValue)o;
        return Objects.equals(this.mName, other.mName) && Objects.equals(this.mDescription, other.mDescription) && Objects.equals(this.mIsDeprecated, other.mIsDeprecated) && Objects.equals(this.mDeprecationReason, other.mDeprecationReason);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{EnumValue.class, _Field.NAME, this.mName, _Field.DESCRIPTION, this.mDescription, _Field.IS_DEPRECATED, this.mIsDeprecated, _Field.DEPRECATION_REASON, this.mDeprecationReason});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "gql_introspection.__EnumValue" + this.asString();
    }

    @Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        out.append("name:").append('\"').append(Strings.escape((CharSequence)this.mName)).append('\"');
        if (this.hasDescription()) {
            out.append(',');
            out.append("description:").append('\"').append(Strings.escape((CharSequence)this.mDescription)).append('\"');
        }
        out.append(',');
        out.append("isDeprecated:").append(this.mIsDeprecated);
        if (this.hasDeprecationReason()) {
            out.append(',');
            out.append("deprecationReason:").append('\"').append(Strings.escape((CharSequence)this.mDeprecationReason)).append('\"');
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(EnumValue other) {
        int c = this.mName.compareTo(other.mName);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mDescription != null, other.mDescription != null);
        if (c != 0) {
            return c;
        }
        if (this.mDescription != null && (c = this.mDescription.compareTo(other.mDescription)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mIsDeprecated, other.mIsDeprecated);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mDeprecationReason != null, other.mDeprecationReason != null);
        if (c != 0) {
            return c;
        }
        if (this.mDeprecationReason != null && (c = this.mDeprecationReason.compareTo(other.mDeprecationReason)) != 0) {
            return c;
        }
        return 0;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        length += writer.writeByte((byte)11);
        length += writer.writeShort((short)1);
        Binary tmp_1 = Binary.wrap((byte[])this.mName.getBytes(StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_1.length());
        length += writer.writeBinary(tmp_1);
        if (this.hasDescription()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)2);
            Binary tmp_2 = Binary.wrap((byte[])this.mDescription.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }
        length += writer.writeByte((byte)2);
        length += writer.writeShort((short)3);
        length += writer.writeUInt8(this.mIsDeprecated ? 1 : 0);
        if (this.hasDeprecationReason()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)4);
            Binary tmp_3 = Binary.wrap((byte[])this.mDeprecationReason.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_3.length());
            length += writer.writeBinary(tmp_3);
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    @Nonnull
    public static PStructDescriptorProvider<EnumValue> provider() {
        return new _Provider();
    }

    @Nonnull
    public PStructDescriptor<EnumValue> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<EnumValue>
    implements EnumValue_OrBuilder,
    BinaryReader {
        private BitSet optionals = new BitSet(4);
        private BitSet modified = new BitSet(4);
        private String mName = "";
        private String mDescription;
        private boolean mIsDeprecated = false;
        private String mDeprecationReason;

        public _Builder() {
        }

        public _Builder(EnumValue base) {
            this();
            this.optionals.set(0);
            this.mName = base.mName;
            if (base.hasDescription()) {
                this.optionals.set(1);
                this.mDescription = base.mDescription;
            }
            this.optionals.set(2);
            this.mIsDeprecated = base.mIsDeprecated;
            if (base.hasDeprecationReason()) {
                this.optionals.set(3);
                this.mDeprecationReason = base.mDeprecationReason;
            }
        }

        @Nonnull
        public _Builder merge(EnumValue from) {
            this.optionals.set(0);
            this.modified.set(0);
            this.mName = from.getName();
            if (from.hasDescription()) {
                this.optionals.set(1);
                this.modified.set(1);
                this.mDescription = from.getDescription();
            }
            this.optionals.set(2);
            this.modified.set(2);
            this.mIsDeprecated = from.isIsDeprecated();
            if (from.hasDeprecationReason()) {
                this.optionals.set(3);
                this.modified.set(3);
                this.mDeprecationReason = from.getDeprecationReason();
            }
            return this;
        }

        @Nonnull
        public _Builder setName(String value) {
            if (value == null) {
                return this.clearName();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(0);
        }

        @Override
        public boolean hasName() {
            return true;
        }

        public boolean isModifiedName() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearName() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mName = EnumValue.kDefaultName;
            return this;
        }

        @Override
        public String getName() {
            return this.isSetName() ? this.mName : EnumValue.kDefaultName;
        }

        @Nonnull
        public _Builder setDescription(String value) {
            if (value == null) {
                return this.clearDescription();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mDescription = value;
            return this;
        }

        public boolean isSetDescription() {
            return this.optionals.get(1);
        }

        @Override
        public boolean hasDescription() {
            return this.optionals.get(1);
        }

        public boolean isModifiedDescription() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearDescription() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mDescription = null;
            return this;
        }

        @Override
        public String getDescription() {
            return this.mDescription;
        }

        @Override
        @Nonnull
        public Optional<String> optionalDescription() {
            return Optional.ofNullable(this.mDescription);
        }

        @Nonnull
        public _Builder setIsDeprecated(Boolean value) {
            if (value == null) {
                return this.clearIsDeprecated();
            }
            this.optionals.set(2);
            this.modified.set(2);
            this.mIsDeprecated = value;
            return this;
        }

        @Nonnull
        public _Builder setIsDeprecated(boolean value) {
            this.optionals.set(2);
            this.modified.set(2);
            this.mIsDeprecated = value;
            return this;
        }

        public boolean isSetIsDeprecated() {
            return this.optionals.get(2);
        }

        @Override
        public boolean hasIsDeprecated() {
            return true;
        }

        public boolean isModifiedIsDeprecated() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearIsDeprecated() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mIsDeprecated = false;
            return this;
        }

        @Override
        public boolean isIsDeprecated() {
            return this.isSetIsDeprecated() ? this.mIsDeprecated : false;
        }

        @Nonnull
        public _Builder setDeprecationReason(String value) {
            if (value == null) {
                return this.clearDeprecationReason();
            }
            this.optionals.set(3);
            this.modified.set(3);
            this.mDeprecationReason = value;
            return this;
        }

        public boolean isSetDeprecationReason() {
            return this.optionals.get(3);
        }

        @Override
        public boolean hasDeprecationReason() {
            return this.optionals.get(3);
        }

        public boolean isModifiedDeprecationReason() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearDeprecationReason() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mDeprecationReason = null;
            return this;
        }

        @Override
        public String getDeprecationReason() {
            return this.mDeprecationReason;
        }

        @Override
        @Nonnull
        public Optional<String> optionalDeprecationReason() {
            return Optional.ofNullable(this.mDeprecationReason);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            _Builder other = (_Builder)o;
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mDescription, other.mDescription) && Objects.equals(this.mIsDeprecated, other.mIsDeprecated) && Objects.equals(this.mDeprecationReason, other.mDeprecationReason);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{EnumValue.class, this.optionals, _Field.NAME, this.mName, _Field.DESCRIPTION, this.mDescription, _Field.IS_DEPRECATED, this.mIsDeprecated, _Field.DEPRECATION_REASON, this.mDeprecationReason});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                default: 
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setName((String)value);
                    break;
                }
                case 2: {
                    this.setDescription((String)value);
                    break;
                }
                case 3: {
                    this.setIsDeprecated((boolean)((Boolean)value));
                    break;
                }
                case 4: {
                    this.setDeprecationReason((String)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 3: {
                    return this.optionals.get(2);
                }
                case 4: {
                    return this.optionals.get(3);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 3: {
                    return this.modified.get(2);
                }
                case 4: {
                    return this.modified.get(3);
                }
            }
            return false;
        }

        public <T> T get(int key) {
            switch (key) {
                case 1: {
                    return (T)this.getName();
                }
                case 2: {
                    return (T)this.getDescription();
                }
                case 3: {
                    return (T)Boolean.valueOf(this.isIsDeprecated());
                }
                case 4: {
                    return (T)this.getDeprecationReason();
                }
            }
            return null;
        }

        public boolean has(int key) {
            switch (key) {
                case 1: {
                    return true;
                }
                case 2: {
                    return this.mDescription != null;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return this.mDeprecationReason != null;
                }
            }
            return false;
        }

        @Nonnull
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearName();
                    break;
                }
                case 2: {
                    this.clearDescription();
                    break;
                }
                case 3: {
                    this.clearIsDeprecated();
                    break;
                }
                case 4: {
                    this.clearDeprecationReason();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return this.optionals.get(0) && this.optionals.get(2);
        }

        public _Builder validate() {
            if (!this.valid()) {
                ArrayList<String> missing = new ArrayList<String>();
                if (!this.optionals.get(0)) {
                    missing.add("name");
                }
                if (!this.optionals.get(2)) {
                    missing.add("isDeprecated");
                }
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message gql_introspection.__EnumValue");
            }
            return this;
        }

        @Nonnull
        public PStructDescriptor<EnumValue> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mName = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__EnumValue.name, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            this.mDescription = new String(reader.expectBytes(len_2), StandardCharsets.UTF_8);
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__EnumValue.description, should be struct(12)", new Object[0]);
                    }
                    case 3: {
                        if (type == 2) {
                            this.mIsDeprecated = reader.expectUInt8() == 1;
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__EnumValue.isDeprecated, should be struct(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 11) {
                            int len_3 = reader.expectUInt32();
                            this.mDeprecationReason = new String(reader.expectBytes(len_3), StandardCharsets.UTF_8);
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__EnumValue.deprecationReason, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        @Nonnull
        public EnumValue build() {
            return new EnumValue(this);
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<EnumValue> {
        private _Provider() {
        }

        public PStructDescriptor<EnumValue> descriptor() {
            return kDescriptor;
        }
    }

    private static final class _Descriptor
    extends PStructDescriptor<EnumValue> {
        public _Descriptor() {
            super("gql_introspection", "__EnumValue", _Builder::new, true);
        }

        @Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    public static enum _Field implements PField<EnumValue>
    {
        NAME(1, PRequirement.REQUIRED, "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null, null),
        DESCRIPTION(2, PRequirement.OPTIONAL, "description", (PDescriptorProvider)PPrimitive.STRING.provider(), null, null),
        IS_DEPRECATED(3, PRequirement.REQUIRED, "isDeprecated", (PDescriptorProvider)PPrimitive.BOOL.provider(), null, null),
        DEPRECATION_REASON(4, PRequirement.OPTIONAL, "deprecationReason", (PDescriptorProvider)PPrimitive.STRING.provider(), null, null);

        private final int mId;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PStructDescriptorProvider mArgumentsProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int id, PRequirement required, String name, PDescriptorProvider typeProvider, PStructDescriptorProvider argumentsProvider, PValueProvider<?> defaultValue) {
            this.mId = id;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mArgumentsProvider = argumentsProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getId() {
            return this.mId;
        }

        @Nonnull
        public PRequirement getRequirement() {
            return this.mRequired;
        }

        @Nonnull
        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        @Nullable
        public PStructDescriptor getArgumentsType() {
            return this.mArgumentsProvider == null ? null : this.mArgumentsProvider.descriptor();
        }

        @Nonnull
        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        @Nullable
        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field findById(int id) {
            switch (id) {
                case 1: {
                    return NAME;
                }
                case 2: {
                    return DESCRIPTION;
                }
                case 3: {
                    return IS_DEPRECATED;
                }
                case 4: {
                    return DEPRECATION_REASON;
                }
            }
            return null;
        }

        public static _Field findByName(String name) {
            if (name == null) {
                return null;
            }
            switch (name) {
                case "name": {
                    return NAME;
                }
                case "description": {
                    return DESCRIPTION;
                }
                case "isDeprecated": {
                    return IS_DEPRECATED;
                }
                case "deprecationReason": {
                    return DEPRECATION_REASON;
                }
            }
            return null;
        }

        public static _Field fieldForId(int id) {
            _Field field = _Field.findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in gql_introspection.__EnumValue");
            }
            return field;
        }

        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = _Field.findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__EnumValue");
            }
            return field;
        }
    }
}

