/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.gql;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.graphql.gql.GQLFragment;
import net.morimekta.providence.graphql.gql.GQLFragmentDefinition;
import net.morimekta.providence.graphql.gql.GQLSelection;

@Immutable
public class GQLFragmentReference
implements GQLFragment {
    private final String name;
    private final PMessageDescriptor<?> parentDescriptor;
    private final Map<String, GQLFragmentDefinition> fragmentMap;

    public GQLFragmentReference(@Nonnull String name, @Nonnull PMessageDescriptor<?> parentDescriptor, @Nonnull Map<String, GQLFragmentDefinition> fragmentMap) {
        this.name = name;
        this.parentDescriptor = parentDescriptor;
        this.fragmentMap = fragmentMap;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public GQLFragmentDefinition getDefinition() {
        return this.fragmentMap.get(this.name);
    }

    @Nonnull
    public PMessageDescriptor<?> getParentDescriptor() {
        return this.parentDescriptor;
    }

    @Override
    @Nonnull
    public PMessageDescriptor<?> getTypeCondition() {
        if (!this.fragmentMap.containsKey(this.name)) {
            throw new IllegalStateException("No named fragment " + this.name + " to reference");
        }
        return this.fragmentMap.get(this.name).getTypeCondition();
    }

    @Override
    @Nonnull
    public List<GQLSelection> getSelectionSet() {
        if (!this.fragmentMap.containsKey(this.name)) {
            throw new IllegalStateException("No named fragment " + this.name + " to reference");
        }
        return this.fragmentMap.get(this.name).getSelectionSet();
    }

    public String toString() {
        return "..." + this.name;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GQLFragmentReference)) {
            return false;
        }
        GQLFragmentReference other = (GQLFragmentReference)o;
        return Objects.equals(this.name, other.name);
    }
}

