package net.morimekta.providence.graphql.introspection;

@SuppressWarnings("unused")
@javax.annotation.Generated(
        value = "net.morimekta.providence:providence-generator-java",
        comments = "java")
@javax.annotation.concurrent.Immutable
public class Directive
        implements Directive_OrBuilder,
                   net.morimekta.providence.PMessage<Directive>,
                   Comparable<Directive>,
                   net.morimekta.providence.serializer.binary.BinaryWriter {
    private final static String kDefaultName = "";
    private final static java.util.List<net.morimekta.providence.graphql.introspection.InputValue> kDefaultArgs = new net.morimekta.providence.descriptor.PList.DefaultBuilder<net.morimekta.providence.graphql.introspection.InputValue>()
                .build();
    private final static java.util.List<net.morimekta.providence.graphql.introspection.DirectiveLocation> kDefaultLocations = new net.morimekta.providence.descriptor.PList.DefaultBuilder<net.morimekta.providence.graphql.introspection.DirectiveLocation>()
                .build();

    private final transient String mName;
    private final transient String mDescription;
    private final transient java.util.List<net.morimekta.providence.graphql.introspection.InputValue> mArgs;
    private final transient java.util.List<net.morimekta.providence.graphql.introspection.DirectiveLocation> mLocations;

    private volatile transient int tHashCode;

    private Directive(_Builder builder) {
        if (builder.isSetName()) {
            mName = builder.mName;
        } else {
            mName = kDefaultName;
        }
        mDescription = builder.mDescription;
        if (builder.isSetArgs()) {
            mArgs = net.morimekta.util.collect.UnmodifiableList.copyOf(builder.mArgs);
        } else {
            mArgs = kDefaultArgs;
        }
        if (builder.isSetLocations()) {
            mLocations = net.morimekta.util.collect.UnmodifiableList.copyOf(builder.mLocations);
        } else {
            mLocations = kDefaultLocations;
        }
    }

    public boolean hasName() {
        return true;
    }

    /**
     * @return The <code>name</code> value
     */
    @javax.annotation.Nonnull
    public String getName() {
        return mName;
    }

    public boolean hasDescription() {
        return mDescription != null;
    }

    /**
     * @return The <code>description</code> value
     */
    public String getDescription() {
        return mDescription;
    }

    /**
     * @return Optional of the <code>description</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<String> optionalDescription() {
        return java.util.Optional.ofNullable(mDescription);
    }

    public int numArgs() {
        return mArgs != null ? mArgs.size() : 0;
    }

    public boolean hasArgs() {
        return true;
    }

    /**
     * @return The <code>args</code> value
     */
    @javax.annotation.Nonnull
    public java.util.List<net.morimekta.providence.graphql.introspection.InputValue> getArgs() {
        return mArgs;
    }

    public int numLocations() {
        return mLocations != null ? mLocations.size() : 0;
    }

    public boolean hasLocations() {
        return true;
    }

    /**
     * @return The <code>locations</code> value
     */
    @javax.annotation.Nonnull
    public java.util.List<net.morimekta.providence.graphql.introspection.DirectiveLocation> getLocations() {
        return mLocations;
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return true;
            case 2: return mDescription != null;
            case 3: return true;
            case 4: return true;
            default: return false;
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T> T get(int key) {
        switch(key) {
            case 1: return (T) mName;
            case 2: return (T) mDescription;
            case 3: return (T) mArgs;
            case 4: return (T) mLocations;
            default: return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) return true;
        if (o == null || !o.getClass().equals(getClass())) return false;
        Directive other = (Directive) o;
        return java.util.Objects.equals(mName, other.mName) &&
               java.util.Objects.equals(mDescription, other.mDescription) &&
               java.util.Objects.equals(mArgs, other.mArgs) &&
               java.util.Objects.equals(mLocations, other.mLocations);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = java.util.Objects.hash(
                    Directive.class,
                    _Field.NAME, mName,
                    _Field.DESCRIPTION, mDescription,
                    _Field.ARGS, mArgs,
                    _Field.LOCATIONS, mLocations);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "gql_introspection.__Directive" + asString();
    }

    @Override
    @javax.annotation.Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        out.append("name:")
           .append('\"')
           .append(net.morimekta.util.Strings.escape(mName))
           .append('\"');
        if (hasDescription()) {
            out.append(',');
            out.append("description:")
               .append('\"')
               .append(net.morimekta.util.Strings.escape(mDescription))
               .append('\"');
        }
        out.append(',');
        out.append("args:")
           .append(net.morimekta.util.Strings.asString(mArgs));
        out.append(',');
        out.append("locations:")
           .append(net.morimekta.util.Strings.asString(mLocations));
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Directive other) {
        int c;

        c = mName.compareTo(other.mName);
        if (c != 0) return c;

        c = Boolean.compare(mDescription != null, other.mDescription != null);
        if (c != 0) return c;
        if (mDescription != null) {
            c = mDescription.compareTo(other.mDescription);
            if (c != 0) return c;
        }

        c = Integer.compare(mArgs.hashCode(), other.mArgs.hashCode());
        if (c != 0) return c;

        c = Integer.compare(mLocations.hashCode(), other.mLocations.hashCode());
        if (c != 0) return c;

        return 0;
    }

    @Override
    public int writeBinary(net.morimekta.util.io.BigEndianBinaryWriter writer) throws java.io.IOException {
        int length = 0;

        length += writer.writeByte((byte) 11);
        length += writer.writeShort((short) 1);
        net.morimekta.util.Binary tmp_1 = net.morimekta.util.Binary.wrap(mName.getBytes(java.nio.charset.StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_1.length());
        length += writer.writeBinary(tmp_1);

        if (hasDescription()) {
            length += writer.writeByte((byte) 11);
            length += writer.writeShort((short) 2);
            net.morimekta.util.Binary tmp_2 = net.morimekta.util.Binary.wrap(mDescription.getBytes(java.nio.charset.StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }

        length += writer.writeByte((byte) 15);
        length += writer.writeShort((short) 3);
        length += writer.writeByte((byte) 12);
        length += writer.writeUInt32(mArgs.size());
        for (net.morimekta.providence.graphql.introspection.InputValue entry_3 : mArgs) {
            length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, entry_3);
        }

        length += writer.writeByte((byte) 15);
        length += writer.writeShort((short) 4);
        length += writer.writeByte((byte) 8);
        length += writer.writeUInt32(mLocations.size());
        for (net.morimekta.providence.graphql.introspection.DirectiveLocation entry_4 : mLocations) {
            length += writer.writeInt(entry_4.asInteger());
        }

        length += writer.writeByte((byte) 0);
        return length;
    }

    @javax.annotation.Nonnull
    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public enum _Field implements net.morimekta.providence.descriptor.PField<Directive> {
        NAME(1, net.morimekta.providence.descriptor.PRequirement.REQUIRED, "name", net.morimekta.providence.descriptor.PPrimitive.STRING.provider(), null, null),
        DESCRIPTION(2, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "description", net.morimekta.providence.descriptor.PPrimitive.STRING.provider(), null, null),
        ARGS(3, net.morimekta.providence.descriptor.PRequirement.REQUIRED, "args", net.morimekta.providence.descriptor.PList.provider(net.morimekta.providence.graphql.introspection.InputValue.provider()), null, new net.morimekta.providence.descriptor.PDefaultValueProvider<>(kDefaultArgs)),
        LOCATIONS(4, net.morimekta.providence.descriptor.PRequirement.REQUIRED, "locations", net.morimekta.providence.descriptor.PList.provider(net.morimekta.providence.graphql.introspection.DirectiveLocation.provider()), null, null),
        ;

        private final int mId;
        private final net.morimekta.providence.descriptor.PRequirement mRequired;
        private final String mName;
        private final net.morimekta.providence.descriptor.PDescriptorProvider mTypeProvider;
        private final net.morimekta.providence.descriptor.PStructDescriptorProvider mArgumentsProvider;
        private final net.morimekta.providence.descriptor.PValueProvider<?> mDefaultValue;

        _Field(int id, net.morimekta.providence.descriptor.PRequirement required, String name, net.morimekta.providence.descriptor.PDescriptorProvider typeProvider, net.morimekta.providence.descriptor.PStructDescriptorProvider argumentsProvider, net.morimekta.providence.descriptor.PValueProvider<?> defaultValue) {
            mId = id;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mArgumentsProvider = argumentsProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public int getId() { return mId; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PRequirement getRequirement() { return mRequired; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PDescriptor getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        @javax.annotation.Nullable
        public net.morimekta.providence.descriptor.PStructDescriptor getArgumentsType() { return mArgumentsProvider == null ? null : mArgumentsProvider.descriptor(); }

        @javax.annotation.Nonnull
        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        @javax.annotation.Nullable
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            return net.morimekta.providence.descriptor.PField.asString(this);
        }

        /**
         * @param id Field name
         * @return The identified field or null
         */
        public static _Field findById(int id) {
            switch (id) {
                case 1: return _Field.NAME;
                case 2: return _Field.DESCRIPTION;
                case 3: return _Field.ARGS;
                case 4: return _Field.LOCATIONS;
            }
            return null;
        }

        /**
         * @param name Field name
         * @return The named field or null
         */
        public static _Field findByName(String name) {
            if (name == null) return null;
            switch (name) {
                case "name": return _Field.NAME;
                case "description": return _Field.DESCRIPTION;
                case "args": return _Field.ARGS;
                case "locations": return _Field.LOCATIONS;
            }
            return null;
        }

        /**
         * @param id Field name
         * @return The identified field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForId(int id) {
            _Field field = findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in gql_introspection.__Directive");
            }
            return field;
        }

        /**
         * @param name Field name
         * @return The named field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__Directive");
            }
            return field;
        }

    }

    @javax.annotation.Nonnull
    public static net.morimekta.providence.descriptor.PStructDescriptorProvider<Directive> provider() {
        return new _Provider();
    }

    @Override
    @javax.annotation.Nonnull
    public net.morimekta.providence.descriptor.PStructDescriptor<Directive> descriptor() {
        return kDescriptor;
    }

    public static final net.morimekta.providence.descriptor.PStructDescriptor<Directive> kDescriptor;

    private static final class _Descriptor
            extends net.morimekta.providence.descriptor.PStructDescriptor<Directive> {
        public _Descriptor() {
            super("gql_introspection", "__Directive", _Builder::new, false);
        }

        @Override
        @javax.annotation.Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static final class _Provider extends net.morimekta.providence.descriptor.PStructDescriptorProvider<Directive> {
        @Override
        public net.morimekta.providence.descriptor.PStructDescriptor<Directive> descriptor() {
            return kDescriptor;
        }
    }

    /**
     * Make a <code>gql_introspection.__Directive</code> builder.
     * @return The builder instance.
     */
    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends net.morimekta.providence.PMessageBuilder<Directive>
            implements Directive_OrBuilder,
                       net.morimekta.providence.serializer.binary.BinaryReader {
        private java.util.BitSet optionals;
        private java.util.BitSet modified;

        private String mName;
        private String mDescription;
        private java.util.List<net.morimekta.providence.graphql.introspection.InputValue> mArgs;
        private java.util.List<net.morimekta.providence.graphql.introspection.DirectiveLocation> mLocations;

        /**
         * Make a gql_introspection.__Directive builder instance.
         */
        public _Builder() {
            optionals = new java.util.BitSet(4);
            modified = new java.util.BitSet(4);
            mName = kDefaultName;
            mArgs = kDefaultArgs;
            mLocations = kDefaultLocations;
        }

        /**
         * Make a mutating builder off a base gql_introspection.__Directive.
         *
         * @param base The base __Directive
         */
        public _Builder(Directive base) {
            this();

            optionals.set(0);
            mName = base.mName;
            if (base.hasDescription()) {
                optionals.set(1);
                mDescription = base.mDescription;
            }
            optionals.set(2);
            mArgs = base.mArgs;
            optionals.set(3);
            mLocations = base.mLocations;
        }

        @javax.annotation.Nonnull
        @Override
        public Directive._Builder merge(Directive from) {
            optionals.set(0);
            modified.set(0);
            mName = from.getName();

            if (from.hasDescription()) {
                optionals.set(1);
                modified.set(1);
                mDescription = from.getDescription();
            }

            optionals.set(2);
            modified.set(2);
            mArgs = from.getArgs();

            optionals.set(3);
            modified.set(3);
            mLocations = from.getLocations();
            return this;
        }

        /**
         * Set the <code>name</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Directive._Builder setName(String value) {
            if (value == null) {
                return clearName();
            }

            optionals.set(0);
            modified.set(0);
            mName = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>name</code> field.
         *
         * @return True if name has been set.
         */
        public boolean isSetName() {
            return optionals.get(0);
        }

        /**
         * Checks for presence of the <code>name</code> field.
         *
         * @return True if name is present.
         */
        public boolean hasName() {
            return true;
        }

        /**
         * Checks if the <code>name</code> field has been modified since the
         * builder was created.
         *
         * @return True if name has been modified.
         */
        public boolean isModifiedName() {
            return modified.get(0);
        }

        /**
         * Clear the <code>name</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Directive._Builder clearName() {
            optionals.clear(0);
            modified.set(0);
            mName = kDefaultName;
            return this;
        }

        /**
         * @return The <code>name</code> field value
         */
        public String getName() {
            return isSetName() ? mName : kDefaultName;
        }

        /**
         * Set the <code>description</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Directive._Builder setDescription(String value) {
            if (value == null) {
                return clearDescription();
            }

            optionals.set(1);
            modified.set(1);
            mDescription = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>description</code> field.
         *
         * @return True if description has been set.
         */
        public boolean isSetDescription() {
            return optionals.get(1);
        }

        /**
         * Checks for presence of the <code>description</code> field.
         *
         * @return True if description is present.
         */
        public boolean hasDescription() {
            return optionals.get(1);
        }

        /**
         * Checks if the <code>description</code> field has been modified since the
         * builder was created.
         *
         * @return True if description has been modified.
         */
        public boolean isModifiedDescription() {
            return modified.get(1);
        }

        /**
         * Clear the <code>description</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Directive._Builder clearDescription() {
            optionals.clear(1);
            modified.set(1);
            mDescription = null;
            return this;
        }

        /**
         * @return The <code>description</code> field value
         */
        public String getDescription() {
            return mDescription;
        }

        /**
         * @return Optional <code>description</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<String> optionalDescription() {
            return java.util.Optional.ofNullable(mDescription);
        }

        /**
         * Set the <code>args</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Directive._Builder setArgs(java.util.Collection<net.morimekta.providence.graphql.introspection.InputValue> value) {
            if (value == null) {
                return clearArgs();
            }

            optionals.set(2);
            modified.set(2);
            mArgs = net.morimekta.util.collect.UnmodifiableList.copyOf(value);
            return this;
        }

        /**
         * Adds entries to the <code>args</code> list.
         *
         * @param values The added value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Directive._Builder addToArgs(net.morimekta.providence.graphql.introspection.InputValue... values) {
            optionals.set(2);
            modified.set(2);
            java.util.List<net.morimekta.providence.graphql.introspection.InputValue> _container = mutableArgs();
            for (net.morimekta.providence.graphql.introspection.InputValue item : values) {
                _container.add(item);
            }
            return this;
        }

        /**
         * Checks for explicit presence of the <code>args</code> field.
         *
         * @return True if args has been set.
         */
        public boolean isSetArgs() {
            return optionals.get(2);
        }

        /**
         * Checks for presence of the <code>args</code> field.
         *
         * @return True if args is present.
         */
        public boolean hasArgs() {
            return true;
        }

        /**
         * Checks if the <code>args</code> field has been modified since the
         * builder was created.
         *
         * @return True if args has been modified.
         */
        public boolean isModifiedArgs() {
            return modified.get(2);
        }

        /**
         * Clear the <code>args</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Directive._Builder clearArgs() {
            optionals.clear(2);
            modified.set(2);
            mArgs = kDefaultArgs;
            return this;
        }

        /**
         * @return The mutable <code>args</code> container
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.InputValue> mutableArgs() {
            optionals.set(2);
            modified.set(2);

            if (mArgs == null) {
                mArgs = new java.util.ArrayList<>();
            } else if (!(mArgs instanceof java.util.ArrayList)) {
                mArgs = new java.util.ArrayList<>(mArgs);
            }
            return mArgs;
        }

        /**
         * @return The <code>args</code> field value
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.InputValue> getArgs() {
            return isSetArgs() ? mArgs : kDefaultArgs;
        }

        /**
         * @return Number of entries in <code>args</code>.
         */
        public int numArgs() {
            return mArgs != null ? mArgs.size() : 0;
        }

        /**
         * Set the <code>locations</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Directive._Builder setLocations(java.util.Collection<net.morimekta.providence.graphql.introspection.DirectiveLocation> value) {
            if (value == null) {
                return clearLocations();
            }

            optionals.set(3);
            modified.set(3);
            mLocations = net.morimekta.util.collect.UnmodifiableList.copyOf(value);
            return this;
        }

        /**
         * Adds entries to the <code>locations</code> list.
         *
         * @param values The added value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Directive._Builder addToLocations(net.morimekta.providence.graphql.introspection.DirectiveLocation... values) {
            optionals.set(3);
            modified.set(3);
            java.util.List<net.morimekta.providence.graphql.introspection.DirectiveLocation> _container = mutableLocations();
            for (net.morimekta.providence.graphql.introspection.DirectiveLocation item : values) {
                _container.add(item);
            }
            return this;
        }

        /**
         * Checks for explicit presence of the <code>locations</code> field.
         *
         * @return True if locations has been set.
         */
        public boolean isSetLocations() {
            return optionals.get(3);
        }

        /**
         * Checks for presence of the <code>locations</code> field.
         *
         * @return True if locations is present.
         */
        public boolean hasLocations() {
            return true;
        }

        /**
         * Checks if the <code>locations</code> field has been modified since the
         * builder was created.
         *
         * @return True if locations has been modified.
         */
        public boolean isModifiedLocations() {
            return modified.get(3);
        }

        /**
         * Clear the <code>locations</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Directive._Builder clearLocations() {
            optionals.clear(3);
            modified.set(3);
            mLocations = kDefaultLocations;
            return this;
        }

        /**
         * @return The mutable <code>locations</code> container
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.DirectiveLocation> mutableLocations() {
            optionals.set(3);
            modified.set(3);

            if (mLocations == null) {
                mLocations = new java.util.ArrayList<>();
            } else if (!(mLocations instanceof java.util.ArrayList)) {
                mLocations = new java.util.ArrayList<>(mLocations);
            }
            return mLocations;
        }

        /**
         * @return The <code>locations</code> field value
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.DirectiveLocation> getLocations() {
            return isSetLocations() ? mLocations : kDefaultLocations;
        }

        /**
         * @return Number of entries in <code>locations</code>.
         */
        public int numLocations() {
            return mLocations != null ? mLocations.size() : 0;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) return true;
            if (o == null || !o.getClass().equals(getClass())) return false;
            Directive._Builder other = (Directive._Builder) o;
            return java.util.Objects.equals(optionals, other.optionals) &&
                   java.util.Objects.equals(mName, other.mName) &&
                   java.util.Objects.equals(mDescription, other.mDescription) &&
                   java.util.Objects.equals(mArgs, other.mArgs) &&
                   java.util.Objects.equals(mLocations, other.mLocations);
        }

        @Override
        public int hashCode() {
            return java.util.Objects.hash(
                    Directive.class, optionals,
                    Directive._Field.NAME, mName,
                    Directive._Field.DESCRIPTION, mDescription,
                    Directive._Field.ARGS, mArgs,
                    Directive._Field.LOCATIONS, mLocations);
        }

        @Override
        @SuppressWarnings("unchecked")
        public net.morimekta.providence.PMessageBuilder mutator(int key) {
            switch (key) {
                default: throw new IllegalArgumentException("Not a message field ID: " + key);
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public Directive._Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setName((String) value); break;
                case 2: setDescription((String) value); break;
                case 3: setArgs((java.util.List<net.morimekta.providence.graphql.introspection.InputValue>) value); break;
                case 4: setLocations((java.util.List<net.morimekta.providence.graphql.introspection.DirectiveLocation>) value); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean isSet(int key) {
            switch (key) {
                case 1: return optionals.get(0);
                case 2: return optionals.get(1);
                case 3: return optionals.get(2);
                case 4: return optionals.get(3);
                default: break;
            }
            return false;
        }

        @Override
        public boolean isModified(int key) {
            switch (key) {
                case 1: return modified.get(0);
                case 2: return modified.get(1);
                case 3: return modified.get(2);
                case 4: return modified.get(3);
                default: break;
            }
            return false;
        }

        @Override
        @SuppressWarnings("unchecked")
        public <T> T get(int key) {
            switch(key) {
                case 1: return (T) getName();
                case 2: return (T) getDescription();
                case 3: return (T) getArgs();
                case 4: return (T) getLocations();
                default: return null;
            }
        }

        @Override
        public boolean has(int key) {
            switch(key) {
                case 1: return true;
                case 2: return mDescription != null;
                case 3: return true;
                case 4: return true;
                default: return false;
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public Directive._Builder addTo(int key, Object value) {
            switch (key) {
                case 3: addToArgs((net.morimekta.providence.graphql.introspection.InputValue) value); break;
                case 4: addToLocations((net.morimekta.providence.graphql.introspection.DirectiveLocation) value); break;
                default: break;
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public Directive._Builder clear(int key) {
            switch (key) {
                case 1: clearName(); break;
                case 2: clearDescription(); break;
                case 3: clearArgs(); break;
                case 4: clearLocations(); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean valid() {
            return optionals.get(0) &&
                   optionals.get(2) &&
                   optionals.get(3);
        }

        @Override
        public Directive._Builder validate() {
            if (!valid()) {
                java.util.ArrayList<String> missing = new java.util.ArrayList<>();

                if (!optionals.get(0)) {
                    missing.add("name");
                }

                if (!optionals.get(2)) {
                    missing.add("args");
                }

                if (!optionals.get(3)) {
                    missing.add("locations");
                }

                throw new java.lang.IllegalStateException(
                        "Missing required fields " +
                        String.join(",", missing) +
                        " in message gql_introspection.__Directive");
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PStructDescriptor<Directive> descriptor() {
            return Directive.kDescriptor;
        }

        @Override
        public void readBinary(net.morimekta.util.io.BigEndianBinaryReader reader, boolean strict) throws java.io.IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                int field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            mName = new String(reader.expectBytes(len_1), java.nio.charset.StandardCharsets.UTF_8);
                            optionals.set(0);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Directive.name, should be struct(12)");
                        }
                        break;
                    }
                    case 2: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            mDescription = new String(reader.expectBytes(len_2), java.nio.charset.StandardCharsets.UTF_8);
                            optionals.set(1);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Directive.description, should be struct(12)");
                        }
                        break;
                    }
                    case 3: {
                        if (type == 15) {
                            byte t_5 = reader.expectByte();
                            if (t_5 == 12) {
                                final int len_4 = reader.expectUInt32();
                                net.morimekta.util.collect.UnmodifiableList.Builder<net.morimekta.providence.graphql.introspection.InputValue> b_3 = net.morimekta.util.collect.UnmodifiableList.builder(len_4);
                                for (int i_6 = 0; i_6 < len_4; ++i_6) {
                                    net.morimekta.providence.graphql.introspection.InputValue key_7 = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.InputValue.kDescriptor, strict);
                                    b_3.add(key_7);
                                }
                                mArgs = b_3.build();
                            } else {
                                throw new net.morimekta.providence.serializer.SerializerException("Wrong item type " + net.morimekta.providence.serializer.binary.BinaryType.asString(t_5) + " for gql_introspection.__Directive.args, should be struct(12)");
                            }
                            optionals.set(2);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Directive.args, should be struct(12)");
                        }
                        break;
                    }
                    case 4: {
                        if (type == 15) {
                            byte t_10 = reader.expectByte();
                            if (t_10 == 8) {
                                final int len_9 = reader.expectUInt32();
                                net.morimekta.util.collect.UnmodifiableList.Builder<net.morimekta.providence.graphql.introspection.DirectiveLocation> b_8 = net.morimekta.util.collect.UnmodifiableList.builder(len_9);
                                for (int i_11 = 0; i_11 < len_9; ++i_11) {
                                    net.morimekta.providence.graphql.introspection.DirectiveLocation key_12 = net.morimekta.providence.graphql.introspection.DirectiveLocation.findById(reader.expectInt());
                                    b_8.add(key_12);
                                }
                                mLocations = b_8.build();
                            } else {
                                throw new net.morimekta.providence.serializer.SerializerException("Wrong item type " + net.morimekta.providence.serializer.binary.BinaryType.asString(t_10) + " for gql_introspection.__Directive.locations, should be i32(8)");
                            }
                            optionals.set(3);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Directive.locations, should be struct(12)");
                        }
                        break;
                    }
                    default: {
                        net.morimekta.providence.serializer.binary.BinaryFormatUtils.readFieldValue(reader, new net.morimekta.providence.serializer.binary.BinaryFormatUtils.FieldInfo(field, type), null, false);
                        break;
                    }
                }
                type = reader.expectByte();
            }
        }

        @Override
        @javax.annotation.Nonnull
        public Directive build() {
            return new Directive(this);
        }
    }
}
