/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.introspection;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.graphql.introspection.InputValue_OrBuilder;
import net.morimekta.providence.graphql.introspection.Type;
import net.morimekta.providence.graphql.introspection.Type_OrBuilder;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

@Immutable
public class InputValue
implements InputValue_OrBuilder,
PMessage<InputValue>,
Comparable<InputValue>,
BinaryWriter {
    private static final String kDefaultName = "";
    private final transient String mName;
    private final transient String mDescription;
    private final transient Type mType;
    private final transient String mDefaultValue;
    private volatile transient int tHashCode;
    public static final PStructDescriptor<InputValue> kDescriptor = new _Descriptor();

    private InputValue(_Builder builder) {
        this.mName = builder.isSetName() ? builder.mName : kDefaultName;
        this.mDescription = builder.mDescription;
        this.mType = builder.mType_builder != null ? builder.mType_builder.build() : builder.mType;
        this.mDefaultValue = builder.mDefaultValue;
    }

    @Override
    public boolean hasName() {
        return true;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean hasDescription() {
        return this.mDescription != null;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    @Nonnull
    public Optional<String> optionalDescription() {
        return Optional.ofNullable(this.mDescription);
    }

    @Override
    public boolean hasType() {
        return this.mType != null;
    }

    @Override
    public Type getType() {
        return this.mType;
    }

    @Override
    @Nonnull
    public Optional<Type> optionalType() {
        return Optional.ofNullable(this.mType);
    }

    @Override
    public boolean hasDefaultValue() {
        return this.mDefaultValue != null;
    }

    @Override
    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    @Override
    @Nonnull
    public Optional<String> optionalDefaultValue() {
        return Optional.ofNullable(this.mDefaultValue);
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return true;
            }
            case 2: {
                return this.mDescription != null;
            }
            case 3: {
                return this.mType != null;
            }
            case 4: {
                return this.mDefaultValue != null;
            }
        }
        return false;
    }

    public <T> T get(int key) {
        switch (key) {
            case 1: {
                return (T)this.mName;
            }
            case 2: {
                return (T)this.mDescription;
            }
            case 3: {
                return (T)this.mType;
            }
            case 4: {
                return (T)this.mDefaultValue;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        InputValue other = (InputValue)o;
        return Objects.equals(this.mName, other.mName) && Objects.equals(this.mDescription, other.mDescription) && Objects.equals(this.mType, other.mType) && Objects.equals(this.mDefaultValue, other.mDefaultValue);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{InputValue.class, _Field.NAME, this.mName, _Field.DESCRIPTION, this.mDescription, _Field.TYPE, this.mType, _Field.DEFAULT_VALUE, this.mDefaultValue});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "gql_introspection.__InputValue" + this.asString();
    }

    @Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        out.append("name:").append('\"').append(Strings.escape((CharSequence)this.mName)).append('\"');
        if (this.hasDescription()) {
            out.append(',');
            out.append("description:").append('\"').append(Strings.escape((CharSequence)this.mDescription)).append('\"');
        }
        if (this.hasType()) {
            out.append(',');
            out.append("type:").append(this.mType.asString());
        }
        if (this.hasDefaultValue()) {
            out.append(',');
            out.append("defaultValue:").append('\"').append(Strings.escape((CharSequence)this.mDefaultValue)).append('\"');
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(InputValue other) {
        int c = this.mName.compareTo(other.mName);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mDescription != null, other.mDescription != null);
        if (c != 0) {
            return c;
        }
        if (this.mDescription != null && (c = this.mDescription.compareTo(other.mDescription)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mType != null, other.mType != null);
        if (c != 0) {
            return c;
        }
        if (this.mType != null && (c = this.mType.compareTo(other.mType)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mDefaultValue != null, other.mDefaultValue != null);
        if (c != 0) {
            return c;
        }
        if (this.mDefaultValue != null && (c = this.mDefaultValue.compareTo(other.mDefaultValue)) != 0) {
            return c;
        }
        return 0;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        length += writer.writeByte((byte)11);
        length += writer.writeShort((short)1);
        Binary tmp_1 = Binary.wrap((byte[])this.mName.getBytes(StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_1.length());
        length += writer.writeBinary(tmp_1);
        if (this.hasDescription()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)2);
            Binary tmp_2 = Binary.wrap((byte[])this.mDescription.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }
        if (this.hasType()) {
            length += writer.writeByte((byte)12);
            length += writer.writeShort((short)3);
            length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)this.mType);
        }
        if (this.hasDefaultValue()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)4);
            Binary tmp_3 = Binary.wrap((byte[])this.mDefaultValue.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_3.length());
            length += writer.writeBinary(tmp_3);
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    @Nonnull
    public static PStructDescriptorProvider<InputValue> provider() {
        return new _Provider();
    }

    @Nonnull
    public PStructDescriptor<InputValue> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<InputValue>
    implements InputValue_OrBuilder,
    BinaryReader {
        private BitSet optionals = new BitSet(4);
        private BitSet modified = new BitSet(4);
        private String mName = "";
        private String mDescription;
        private Type mType;
        private Type._Builder mType_builder;
        private String mDefaultValue;

        public _Builder() {
        }

        public _Builder(InputValue base) {
            this();
            this.optionals.set(0);
            this.mName = base.mName;
            if (base.hasDescription()) {
                this.optionals.set(1);
                this.mDescription = base.mDescription;
            }
            if (base.hasType()) {
                this.optionals.set(2);
                this.mType = base.mType;
            }
            if (base.hasDefaultValue()) {
                this.optionals.set(3);
                this.mDefaultValue = base.mDefaultValue;
            }
        }

        @Nonnull
        public _Builder merge(InputValue from) {
            this.optionals.set(0);
            this.modified.set(0);
            this.mName = from.getName();
            if (from.hasDescription()) {
                this.optionals.set(1);
                this.modified.set(1);
                this.mDescription = from.getDescription();
            }
            if (from.hasType()) {
                this.optionals.set(2);
                this.modified.set(2);
                if (this.mType_builder != null) {
                    this.mType_builder.merge(from.getType());
                } else if (this.mType != null) {
                    this.mType_builder = this.mType.mutate().merge(from.getType());
                    this.mType = null;
                } else {
                    this.mType = from.getType();
                }
            }
            if (from.hasDefaultValue()) {
                this.optionals.set(3);
                this.modified.set(3);
                this.mDefaultValue = from.getDefaultValue();
            }
            return this;
        }

        @Nonnull
        public _Builder setName(String value) {
            if (value == null) {
                return this.clearName();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(0);
        }

        @Override
        public boolean hasName() {
            return true;
        }

        public boolean isModifiedName() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearName() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mName = InputValue.kDefaultName;
            return this;
        }

        @Override
        public String getName() {
            return this.isSetName() ? this.mName : InputValue.kDefaultName;
        }

        @Nonnull
        public _Builder setDescription(String value) {
            if (value == null) {
                return this.clearDescription();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mDescription = value;
            return this;
        }

        public boolean isSetDescription() {
            return this.optionals.get(1);
        }

        @Override
        public boolean hasDescription() {
            return this.optionals.get(1);
        }

        public boolean isModifiedDescription() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearDescription() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mDescription = null;
            return this;
        }

        @Override
        public String getDescription() {
            return this.mDescription;
        }

        @Override
        @Nonnull
        public Optional<String> optionalDescription() {
            return Optional.ofNullable(this.mDescription);
        }

        @Nonnull
        public _Builder setType(Type_OrBuilder value) {
            if (value == null) {
                return this.clearType();
            }
            this.optionals.set(2);
            this.modified.set(2);
            if (value instanceof Type._Builder) {
                value = ((Type._Builder)value).build();
            } else if (!(value instanceof Type)) {
                throw new IllegalArgumentException("Invalid type for gql_introspection.__Type: " + value.getClass().getName());
            }
            this.mType = (Type)value;
            this.mType_builder = null;
            return this;
        }

        public boolean isSetType() {
            return this.optionals.get(2);
        }

        @Override
        public boolean hasType() {
            return this.optionals.get(2);
        }

        public boolean isModifiedType() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearType() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mType = null;
            this.mType_builder = null;
            return this;
        }

        @Nonnull
        public Type._Builder mutableType() {
            this.optionals.set(2);
            this.modified.set(2);
            if (this.mType != null) {
                this.mType_builder = this.mType.mutate();
                this.mType = null;
            } else if (this.mType_builder == null) {
                this.mType_builder = Type.builder();
            }
            return this.mType_builder;
        }

        @Override
        public Type getType() {
            return this.mType_builder != null ? this.mType_builder.build() : this.mType;
        }

        @Override
        @Nonnull
        public Optional<Type> optionalType() {
            return Optional.ofNullable(this.mType_builder != null ? this.mType_builder.build() : this.mType);
        }

        @Nonnull
        public _Builder setDefaultValue(String value) {
            if (value == null) {
                return this.clearDefaultValue();
            }
            this.optionals.set(3);
            this.modified.set(3);
            this.mDefaultValue = value;
            return this;
        }

        public boolean isSetDefaultValue() {
            return this.optionals.get(3);
        }

        @Override
        public boolean hasDefaultValue() {
            return this.optionals.get(3);
        }

        public boolean isModifiedDefaultValue() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearDefaultValue() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mDefaultValue = null;
            return this;
        }

        @Override
        public String getDefaultValue() {
            return this.mDefaultValue;
        }

        @Override
        @Nonnull
        public Optional<String> optionalDefaultValue() {
            return Optional.ofNullable(this.mDefaultValue);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            _Builder other = (_Builder)o;
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mDescription, other.mDescription) && Objects.equals(this.getType(), other.getType()) && Objects.equals(this.mDefaultValue, other.mDefaultValue);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{InputValue.class, this.optionals, _Field.NAME, this.mName, _Field.DESCRIPTION, this.mDescription, _Field.TYPE, this.getType(), _Field.DEFAULT_VALUE, this.mDefaultValue});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                case 3: {
                    return this.mutableType();
                }
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setName((String)value);
                    break;
                }
                case 2: {
                    this.setDescription((String)value);
                    break;
                }
                case 3: {
                    this.setType((Type)value);
                    break;
                }
                case 4: {
                    this.setDefaultValue((String)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 3: {
                    return this.optionals.get(2);
                }
                case 4: {
                    return this.optionals.get(3);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 3: {
                    return this.modified.get(2);
                }
                case 4: {
                    return this.modified.get(3);
                }
            }
            return false;
        }

        public <T> T get(int key) {
            switch (key) {
                case 1: {
                    return (T)this.getName();
                }
                case 2: {
                    return (T)this.getDescription();
                }
                case 3: {
                    return (T)this.getType();
                }
                case 4: {
                    return (T)this.getDefaultValue();
                }
            }
            return null;
        }

        public boolean has(int key) {
            switch (key) {
                case 1: {
                    return true;
                }
                case 2: {
                    return this.mDescription != null;
                }
                case 3: {
                    return this.mType != null || this.mType_builder != null;
                }
                case 4: {
                    return this.mDefaultValue != null;
                }
            }
            return false;
        }

        @Nonnull
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearName();
                    break;
                }
                case 2: {
                    this.clearDescription();
                    break;
                }
                case 3: {
                    this.clearType();
                    break;
                }
                case 4: {
                    this.clearDefaultValue();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return this.optionals.get(0) && this.optionals.get(2);
        }

        public _Builder validate() {
            if (!this.valid()) {
                ArrayList<String> missing = new ArrayList<String>();
                if (!this.optionals.get(0)) {
                    missing.add("name");
                }
                if (!this.optionals.get(2)) {
                    missing.add("type");
                }
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message gql_introspection.__InputValue");
            }
            return this;
        }

        @Nonnull
        public PStructDescriptor<InputValue> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mName = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__InputValue.name, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            this.mDescription = new String(reader.expectBytes(len_2), StandardCharsets.UTF_8);
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__InputValue.description, should be struct(12)", new Object[0]);
                    }
                    case 3: {
                        if (type == 12) {
                            this.mType = (Type)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, Type.kDescriptor, (boolean)strict);
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__InputValue.type, should be struct(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 11) {
                            int len_3 = reader.expectUInt32();
                            this.mDefaultValue = new String(reader.expectBytes(len_3), StandardCharsets.UTF_8);
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__InputValue.defaultValue, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        @Nonnull
        public InputValue build() {
            return new InputValue(this);
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<InputValue> {
        private _Provider() {
        }

        public PStructDescriptor<InputValue> descriptor() {
            return kDescriptor;
        }
    }

    private static final class _Descriptor
    extends PStructDescriptor<InputValue> {
        public _Descriptor() {
            super("gql_introspection", "__InputValue", _Builder::new, false);
        }

        @Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    public static enum _Field implements PField<InputValue>
    {
        NAME(1, PRequirement.REQUIRED, "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null, null),
        DESCRIPTION(2, PRequirement.OPTIONAL, "description", (PDescriptorProvider)PPrimitive.STRING.provider(), null, null),
        TYPE(3, PRequirement.REQUIRED, "type", (PDescriptorProvider)Type.provider(), null, null),
        DEFAULT_VALUE(4, PRequirement.OPTIONAL, "defaultValue", (PDescriptorProvider)PPrimitive.STRING.provider(), null, null);

        private final int mId;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PStructDescriptorProvider mArgumentsProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int id, PRequirement required, String name, PDescriptorProvider typeProvider, PStructDescriptorProvider argumentsProvider, PValueProvider<?> defaultValue) {
            this.mId = id;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mArgumentsProvider = argumentsProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getId() {
            return this.mId;
        }

        @Nonnull
        public PRequirement getRequirement() {
            return this.mRequired;
        }

        @Nonnull
        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        @Nullable
        public PStructDescriptor getArgumentsType() {
            return this.mArgumentsProvider == null ? null : this.mArgumentsProvider.descriptor();
        }

        @Nonnull
        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        @Nullable
        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field findById(int id) {
            switch (id) {
                case 1: {
                    return NAME;
                }
                case 2: {
                    return DESCRIPTION;
                }
                case 3: {
                    return TYPE;
                }
                case 4: {
                    return DEFAULT_VALUE;
                }
            }
            return null;
        }

        public static _Field findByName(String name) {
            if (name == null) {
                return null;
            }
            switch (name) {
                case "name": {
                    return NAME;
                }
                case "description": {
                    return DESCRIPTION;
                }
                case "type": {
                    return TYPE;
                }
                case "defaultValue": {
                    return DEFAULT_VALUE;
                }
            }
            return null;
        }

        public static _Field fieldForId(int id) {
            _Field field = _Field.findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in gql_introspection.__InputValue");
            }
            return field;
        }

        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = _Field.findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__InputValue");
            }
            return field;
        }
    }
}

