/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PProcessor;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.graphql.GQLContext;
import net.morimekta.providence.graphql.GQLContextFactory;
import net.morimekta.providence.graphql.GQLDefinition;
import net.morimekta.providence.graphql.GQLFieldProvider;
import net.morimekta.providence.graphql.GQLProcessorProvider;
import net.morimekta.providence.graphql.errors.GQLError;
import net.morimekta.providence.graphql.errors.GQLErrorLocation;
import net.morimekta.providence.graphql.errors.GQLErrorResponse;
import net.morimekta.providence.graphql.gql.GQLField;
import net.morimekta.providence.graphql.gql.GQLFragment;
import net.morimekta.providence.graphql.gql.GQLIntrospection;
import net.morimekta.providence.graphql.gql.GQLMethodCall;
import net.morimekta.providence.graphql.gql.GQLOperation;
import net.morimekta.providence.graphql.gql.GQLQuery;
import net.morimekta.providence.graphql.gql.GQLSelection;
import net.morimekta.providence.graphql.introspection.Type;
import net.morimekta.providence.graphql.introspection.TypeArguments;
import net.morimekta.providence.graphql.parser.GQLException;
import net.morimekta.providence.graphql.parser.GQLParser;
import net.morimekta.providence.graphql.utils.FieldFieldProvider;
import net.morimekta.providence.graphql.utils.InputValueFieldProvider;
import net.morimekta.providence.graphql.utils.TypeFieldProvider;
import net.morimekta.util.Binary;
import net.morimekta.util.Pair;
import net.morimekta.util.Tuple;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableMap;
import net.morimekta.util.io.IOUtils;
import net.morimekta.util.io.IndentedPrintWriter;
import net.morimekta.util.json.JsonWriter;
import net.morimekta.util.json.PrettyJsonWriter;
import net.morimekta.util.lexer.LexerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GQLServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(GQLServlet.class);
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String MEDIA_TYPE = "application/graphql";
    private static final String PRETTY_PARAM = "pretty";
    private static final String TRUE = "true";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final JavaType VARIABLES = MAPPER.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class);
    private final GQLContextFactory contextFactory;
    private final GQLDefinition definition;
    private final GQLProcessorProvider queryProvider;
    private final GQLProcessorProvider mutationProvider;
    private final GQLParser parser;
    private final ExecutorService executorService;
    private final Map<PField, GQLFieldProvider> fieldProviderMap;

    public GQLServlet(@Nonnull GQLDefinition definition, @Nonnull GQLProcessorProvider queryProvider, @Nullable GQLProcessorProvider mutationProvider, @Nonnull Collection<GQLFieldProvider> fieldProviders, @Nullable GQLContextFactory contextFactory, @Nonnull ExecutorService executorService) {
        if (definition.getMutation() == null != (mutationProvider == null)) {
            throw new IllegalArgumentException("Definition " + (definition.getMutation() == null ? "does not have" : "has") + " mutation, while provider is " + (mutationProvider == null ? "not " : "") + "present");
        }
        HashMap<PField, GQLFieldProvider> providerMap = new HashMap<PField, GQLFieldProvider>();
        GQLServlet.buildMutatorMap(providerMap, new FieldFieldProvider(definition));
        GQLServlet.buildMutatorMap(providerMap, new InputValueFieldProvider(definition));
        GQLServlet.buildMutatorMap(providerMap, new TypeFieldProvider(definition));
        for (GQLFieldProvider provider : fieldProviders) {
            GQLServlet.buildMutatorMap(providerMap, provider);
        }
        this.contextFactory = Optional.ofNullable(contextFactory).orElse(GQLContextFactory.DEFAULT_INSTANCE);
        this.definition = definition;
        this.queryProvider = queryProvider;
        this.mutationProvider = mutationProvider;
        this.fieldProviderMap = UnmodifiableMap.copyOf(providerMap);
        this.parser = new GQLParser(definition);
        this.executorService = executorService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        GQLOperation operation;
        GQLQuery query;
        String operationName;
        try {
            Map rawVariables = Collections.emptyMap();
            String variables = req.getParameter("variables");
            if (variables != null) {
                rawVariables = (Map)MAPPER.readValue(variables, VARIABLES);
            }
            operationName = req.getParameter("operationName");
            String q = req.getParameter("query");
            if (q == null) {
                resp.setHeader(CONTENT_TYPE, "application/json");
                resp.setStatus(400);
                this.writeError(this.makeWriter(resp, true), new GQLError("No query param in request", null));
                return;
            }
            query = this.parser.parseQuery(q, rawVariables);
        }
        catch (LexerException e) {
            LOGGER.debug("Error parsing query:\n{}", (Object)e.displayString(), (Object)e);
            resp.setHeader(CONTENT_TYPE, "application/json");
            resp.setStatus(400);
            this.writeError(this.makeWriter(resp, true), new GQLError(e.getMessage(), (List<GQLErrorLocation>)UnmodifiableList.listOf((Object)new GQLErrorLocation(e.getLineNo(), e.getLinePos()))));
            return;
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.debug("Exception in parsing query: {}", (Object)e.getMessage(), (Object)e);
            resp.setHeader(CONTENT_TYPE, "application/json");
            resp.setStatus(400);
            this.writeError(this.makeWriter(resp, true), new GQLError(e.getMessage(), null));
            return;
        }
        if (operationName == null && !query.isDefaultOperationAvailable()) {
            resp.setHeader(CONTENT_TYPE, "application/json");
            resp.setStatus(400);
            this.writeError(this.makeWriter(resp, true), new GQLError("No default query defined", null));
            return;
        }
        try {
            operation = query.getOperation(operationName).orElse(null);
        }
        catch (IllegalArgumentException e) {
            resp.setHeader(CONTENT_TYPE, "application/json");
            resp.setStatus(400);
            this.writeError(this.makeWriter(resp, true), new GQLError(e.getMessage(), null));
            return;
        }
        if (operation == null) {
            resp.setHeader(CONTENT_TYPE, "application/json");
            resp.setStatus(400);
            this.writeError(this.makeWriter(resp, true), new GQLError("No such operation " + operationName + " in query", null));
            return;
        }
        if (operation.isMutation()) {
            resp.setHeader(CONTENT_TYPE, "application/json");
            resp.setStatus(400);
            this.writeError(this.makeWriter(resp, true), new GQLError("mutation not allowed in GET request", null));
            return;
        }
        this.handleOperation(req, resp, operation, false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        GQLOperation operation;
        String contentType = req.getContentType();
        contentType = contentType == null ? MEDIA_TYPE : contentType.split(";")[0].trim().toLowerCase(Locale.US);
        try {
            GQLQuery query = null;
            switch (contentType) {
                case "application/graphql": {
                    String q = IOUtils.readString((Reader)req.getReader());
                    query = this.parser.parseQuery(q, new HashMap<String, Object>());
                    operation = query.getOperation(null).orElseThrow(() -> new IllegalArgumentException("No default operation defined in query"));
                    break;
                }
                case "application/json": {
                    JsonRequest content;
                    try {
                        content = (JsonRequest)MAPPER.readValue((Reader)req.getReader(), JsonRequest.class);
                    }
                    catch (JsonParseException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e.getMessage(), e);
                    }
                    if (content.query != null) {
                        query = this.parser.parseQuery(content.query, content.variables);
                    }
                    if (query == null) {
                        String q = req.getParameter("query");
                        if (q == null) {
                            throw new IllegalArgumentException("No query in request");
                        }
                        query = this.parser.parseQuery(q, Optional.ofNullable(content.variables).orElse(new HashMap()));
                    }
                    operation = query.getOperation(null).orElseThrow(() -> new IllegalArgumentException("No default operation defined in query"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown content-type: " + contentType);
                }
            }
        }
        catch (JsonParseException e) {
            LOGGER.debug("Error parsing JSON: {}", (Object)e.getMessage(), (Object)e);
            resp.setHeader(CONTENT_TYPE, "application/json");
            resp.setStatus(400);
            this.writeError(this.makeWriter(resp, true), new GQLError(e.getMessage(), (List<GQLErrorLocation>)UnmodifiableList.listOf((Object)new GQLErrorLocation(e.getLocation().getLineNr(), e.getLocation().getColumnNr()))));
            return;
        }
        catch (LexerException e) {
            LOGGER.debug("Error parsing query:\n{}", (Object)e.displayString(), (Object)e);
            resp.setHeader(CONTENT_TYPE, "application/json");
            resp.setStatus(400);
            this.writeError(this.makeWriter(resp, true), new GQLError(e.getMessage(), (List<GQLErrorLocation>)UnmodifiableList.listOf((Object)new GQLErrorLocation(e.getLineNo(), e.getLinePos()))));
            return;
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.debug("Exception in parsing query: {}", (Object)e.getMessage(), (Object)e);
            resp.setHeader(CONTENT_TYPE, "application/json");
            resp.setStatus(400);
            this.writeError(this.makeWriter(resp, true), new GQLError(e.getMessage(), null));
            return;
        }
        this.handleOperation(req, resp, operation, operation.isMutation());
    }

    @OverridingMethodsMustInvokeSuper
    protected void handleOperation(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp, @Nonnull GQLOperation operation, boolean handleSerially) throws IOException {
        try {
            if (handleSerially) {
                this.handleSerially(req, resp, operation);
            } else {
                this.handleParallel(req, resp, operation);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error handling {}: {}", new Object[]{operation.isMutation() ? "mutation" : "query", e.getMessage(), e});
            throw e;
        }
    }

    private JsonWriter makeWriter(HttpServletResponse resp, boolean pretty) throws IOException {
        return pretty ? new PrettyJsonWriter(new IndentedPrintWriter((Writer)resp.getWriter(), "  ", "\n")) : new JsonWriter(resp.getWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSerially(HttpServletRequest req, HttpServletResponse resp, GQLOperation operation) throws IOException {
        boolean pretty = TRUE.equalsIgnoreCase(req.getParameter(PRETTY_PARAM));
        resp.setStatus(200);
        resp.setHeader(CONTENT_TYPE, "application/json");
        JsonWriter writer = this.makeWriter(resp, pretty);
        writer.object().key((CharSequence)"data").object();
        int i = 0;
        PServiceCall request = null;
        try (Object context = this.contextFactory.createContext(req, operation);){
            try {
                for (GQLSelection entry : operation.getSelectionSet()) {
                    if (entry instanceof GQLMethodCall) {
                        GQLMethodCall methodEntry = (GQLMethodCall)entry;
                        request = new PServiceCall(Objects.requireNonNull(methodEntry.getMethod()).getName(), PServiceCallType.CALL, ++i, methodEntry.getArguments());
                        PProcessor processor = this.mutationProvider.processorFor(context, methodEntry);
                        PServiceCall response = processor.handleCall(request);
                        if (response.getType() == PServiceCallType.EXCEPTION) {
                            throw (PApplicationException)response.getMessage();
                        }
                        PUnion union = (PUnion)response.getMessage();
                        if (union.unionField().getId() == 0) {
                            Object out = union.get(0);
                            if (methodEntry.getAlias() != null) {
                                writer.key((CharSequence)methodEntry.getAlias());
                            } else {
                                writer.key((CharSequence)methodEntry.getMethod().getName());
                            }
                            this.writeAndHandleResponse(writer, out, methodEntry);
                            continue;
                        }
                        throw (Exception)union.get(union.unionField().getId());
                    }
                    if (entry instanceof GQLIntrospection) {
                        GQLIntrospection intro = (GQLIntrospection)entry;
                        switch (intro.getField()) {
                            case __schema: {
                                if (intro.getAlias() != null) {
                                    writer.key((CharSequence)intro.getAlias());
                                } else {
                                    writer.key((CharSequence)intro.getField().name());
                                }
                                this.writeAndHandleResponse(writer, this.definition.getIntrospectionSchema(), new GQLField(Type._Field.NAME, intro.getSelectionSet()));
                                break;
                            }
                            case __type: {
                                TypeArguments ta = (TypeArguments)intro.getArguments();
                                if (ta == null || ta.getName() == null) {
                                    throw new PApplicationException("No name for type lookup", PApplicationExceptionType.PROTOCOL_ERROR);
                                }
                                Type type = this.definition.getIntrospectionType(ta.getName());
                                if (type == null) {
                                    throw new PApplicationException("Unknown type named '" + ta.getName() + "'", PApplicationExceptionType.PROTOCOL_ERROR);
                                }
                                if (intro.getAlias() != null) {
                                    writer.key((CharSequence)intro.getAlias());
                                } else {
                                    writer.key((CharSequence)intro.getField().name());
                                }
                                this.writeAndHandleResponse(writer, type, new GQLField(Type._Field.NAME, intro.getSelectionSet()));
                                break;
                            }
                            case __typename: {
                                throw new PApplicationException("Introspection __typename not allowed at root", PApplicationExceptionType.PROTOCOL_ERROR);
                            }
                        }
                        continue;
                    }
                    throw new GQLException("Unhandled root selection: " + entry.toString());
                }
                ((GQLContext)context).commit();
                writer.endObject().endObject();
            }
            catch (Exception e) {
                LOGGER.debug("Call exception: {}", (Object)e.getMessage(), (Object)e);
                ((GQLContext)context).abort(e);
                writer.endObject();
                this.writeErrors(writer, (List<Pair<PServiceCall, Exception>>)UnmodifiableList.listOf((Object)Pair.create(request, (Object)e)));
                writer.endObject();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Unhandled exception in abort: {}", (Object)e.getMessage(), (Object)e);
            writer.endObject();
            this.writeErrors(writer, (List<Pair<PServiceCall, Exception>>)UnmodifiableList.listOf((Object)Pair.create(request, (Object)e)));
            writer.endObject();
        }
        finally {
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleParallel(HttpServletRequest req, HttpServletResponse resp, GQLOperation operation) throws IOException {
        boolean pretty = TRUE.equalsIgnoreCase(req.getParameter(PRETTY_PARAM));
        ArrayList<Tuple.Tuple3> futures = new ArrayList<Tuple.Tuple3>();
        int i = 0;
        for (GQLSelection entry : operation.getSelectionSet()) {
            if (entry instanceof GQLIntrospection) {
                GQLIntrospection intro = (GQLIntrospection)entry;
                futures.add(Tuple.tuple((Object)intro, null, null));
                continue;
            }
            if (entry instanceof GQLMethodCall) {
                GQLMethodCall methodEntry = (GQLMethodCall)entry;
                Object arguments = methodEntry.getArguments();
                if (arguments == null) {
                    arguments = (PMessage)methodEntry.getMethod().getRequestType().builder().build();
                }
                PServiceCall psc = new PServiceCall(methodEntry.getMethod().getName(), PServiceCallType.CALL, ++i, arguments);
                futures.add(Tuple.tuple((Object)methodEntry, (Object)psc, this.executorService.submit(() -> {
                    Object context = this.contextFactory.createContext(req, operation);
                    try {
                        PProcessor processor = this.queryProvider.processorFor(context, methodEntry);
                        PServiceCall response = processor.handleCall(psc);
                        ((GQLContext)context).commit();
                        PServiceCall pServiceCall = response;
                        return pServiceCall;
                    }
                    catch (Exception e) {
                        ((GQLContext)context).abort(e);
                        throw e;
                    }
                    finally {
                        if (context != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2;
                                throwable2.addSuppressed(throwable);
                            }
                        }
                    }
                })));
                continue;
            }
            throw new GQLException("Unhandled root selection: " + entry.toString());
        }
        resp.setStatus(200);
        resp.setHeader(CONTENT_TYPE, "application/json");
        JsonWriter writer = this.makeWriter(resp, pretty);
        try {
            writer.object().key((CharSequence)"data").object();
            ArrayList<Pair<PServiceCall, Exception>> errors = new ArrayList<Pair<PServiceCall, Exception>>();
            for (Tuple.Tuple3 future : futures) {
                if (future.first() instanceof GQLIntrospection) {
                    GQLIntrospection intro = (GQLIntrospection)future.first();
                    switch (intro.getField()) {
                        case __schema: {
                            if (intro.getAlias() != null) {
                                writer.key((CharSequence)intro.getAlias());
                            } else {
                                writer.key((CharSequence)intro.getField().name());
                            }
                            this.writeAndHandleResponse(writer, this.definition.getIntrospectionSchema(), new GQLField(Type._Field.NAME, intro.getSelectionSet()));
                            break;
                        }
                        case __type: {
                            TypeArguments ta = (TypeArguments)intro.getArguments();
                            if (ta == null || ta.getName() == null) {
                                errors.add((Pair<PServiceCall, Exception>)Pair.create((Object)new PServiceCall("__type", PServiceCallType.CALL, 0, (PMessage)Type.builder().build()), (Object)new IllegalArgumentException("No name for type lookup")));
                                break;
                            }
                            Type type = this.definition.getIntrospectionType(ta.getName());
                            if (type == null) {
                                errors.add((Pair<PServiceCall, Exception>)Pair.create((Object)new PServiceCall("__type", PServiceCallType.CALL, 0, (PMessage)Type.builder().build()), (Object)new IllegalArgumentException("Unknown type named '" + ta.getName() + "'")));
                                break;
                            }
                            if (intro.getAlias() != null) {
                                writer.key((CharSequence)intro.getAlias());
                            } else {
                                writer.key((CharSequence)intro.getField().name());
                            }
                            this.writeAndHandleResponse(writer, type, new GQLField(Type._Field.NAME, intro.getSelectionSet()));
                            break;
                        }
                        case __typename: {
                            errors.add((Pair<PServiceCall, Exception>)Pair.create((Object)new PServiceCall("__typename", PServiceCallType.CALL, 0, (PMessage)Type.builder().build()), (Object)new IllegalArgumentException("Introspection __typename not allowed at root")));
                        }
                    }
                    continue;
                }
                GQLMethodCall field = (GQLMethodCall)future.first();
                PServiceCall call = (PServiceCall)future.second();
                try {
                    PServiceCall reply = (PServiceCall)((Future)future.third()).get(3L, TimeUnit.MINUTES);
                    if (reply.getType() == PServiceCallType.EXCEPTION) {
                        errors.add((Pair<PServiceCall, Exception>)Pair.create((Object)call, (Object)((PApplicationException)reply.getMessage())));
                        continue;
                    }
                    PUnion response = (PUnion)reply.getMessage();
                    if (response.unionField().getId() == 0) {
                        Object out = response.get(0);
                        if (field.getAlias() != null) {
                            writer.key((CharSequence)field.getAlias());
                        } else {
                            writer.key((CharSequence)field.getMethod().getName());
                        }
                        this.writeAndHandleResponse(writer, out, field);
                        continue;
                    }
                    errors.add((Pair<PServiceCall, Exception>)Pair.create((Object)call, (Object)((Exception)response.get(response.unionField().getId()))));
                }
                catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException e) {
                    LOGGER.warn("Exception calling {}: {}", new Object[]{call.getMethod(), e.getMessage(), e});
                    errors.add((Pair<PServiceCall, Exception>)Pair.create((Object)call, (Object)e));
                }
            }
            writer.endObject();
            this.writeErrors(writer, errors);
            writer.endObject();
        }
        finally {
            writer.flush();
        }
    }

    private void writeErrors(JsonWriter writer, List<Pair<PServiceCall, Exception>> errors) throws IOException {
        if (errors.size() > 0) {
            writer.key((CharSequence)"errors").array();
            for (Pair<PServiceCall, Exception> error : errors) {
                if (error.second instanceof GQLError) {
                    this.writeAndHandleResponse(writer, error.second, new GQLField(GQLErrorResponse._Field.ERRORS));
                    continue;
                }
                if (error.first != null) {
                    writer.object().key((CharSequence)"message").value((CharSequence)("Exception in call to " + ((PServiceCall)error.first).getMethod() + ": " + ((Exception)error.second).getMessage())).endObject();
                    continue;
                }
                writer.object().key((CharSequence)"message").value((CharSequence)("Exception in handling: " + ((Exception)error.second).getMessage())).endObject();
            }
            writer.endArray();
        }
    }

    private void writeError(JsonWriter writer, GQLError error) throws IOException {
        this.writeAndHandleResponse(writer, new GQLErrorResponse((List<GQLError>)UnmodifiableList.listOf((Object)error)), new GQLField(GQLErrorResponse._Field.ERRORS));
    }

    private void writeAndHandleMessageResponse(JsonWriter writer, PMessage<?> message, GQLSelection msgField) throws IOException {
        PMessageDescriptor descriptor = message.descriptor();
        if (descriptor.getVariant() == PMessageVariant.UNION && descriptor.getImplementing() != null) {
            PUnion union = (PUnion)message;
            this.writeAndHandleResponse(writer, union.get(union.unionField().getId()), msgField);
            return;
        }
        writer.object();
        if (msgField.getSelectionSet() == null) {
            for (PField field : descriptor.getFields()) {
                if (!message.has(field.getId()) || field.getName().startsWith("__")) continue;
                this.writeAndHandleField(writer, message, new GQLField(field));
            }
        } else {
            this.writeAndHandleSelection(writer, message, msgField.getSelectionSet());
        }
        writer.endObject();
    }

    private void writeAndHandleSelection(@Nonnull JsonWriter writer, @Nonnull PMessage<?> message, @Nonnull List<GQLSelection> selection) throws IOException {
        PMessageDescriptor descriptor = message.descriptor();
        for (GQLSelection entry : selection) {
            if (entry instanceof GQLIntrospection) {
                GQLIntrospection intro = (GQLIntrospection)entry;
                switch (intro.getField()) {
                    case __type: {
                        Type type = this.definition.getIntrospectionType((PDescriptor)descriptor, false);
                        writer.key((CharSequence)GQLIntrospection.Field.__type.name());
                        this.writeAndHandleMessageResponse(writer, type, intro);
                        break;
                    }
                    case __typename: {
                        Type type = this.definition.getIntrospectionType((PDescriptor)descriptor, false);
                        writer.key((CharSequence)GQLIntrospection.Field.__typename.name());
                        writer.value((CharSequence)type.getName());
                        break;
                    }
                }
                continue;
            }
            if (entry instanceof GQLFragment) {
                GQLFragment fragment = (GQLFragment)entry;
                if (!fragment.isApplicableFor(descriptor)) continue;
                this.writeAndHandleSelection(writer, message, fragment.getSelectionSet());
                continue;
            }
            if (entry instanceof GQLField) {
                this.writeAndHandleField(writer, message, (GQLField)entry);
                continue;
            }
            throw new IOException("Unknown GQL entry " + entry.getClass().getSimpleName() + ": " + entry.toString());
        }
    }

    private void writeAndHandleField(JsonWriter writer, PMessage<?> message, GQLField gqlField) throws IOException {
        PField actualField = Objects.requireNonNull(gqlField.getField());
        actualField = message.descriptor().fieldForName(actualField.getName());
        GQLFieldProvider mutator = this.fieldProviderMap.get(actualField);
        Object value = mutator != null ? mutator.provide(message, actualField, gqlField) : (message.has(actualField.getId()) ? message.get(actualField.getId()) : null);
        if (gqlField.getAlias() != null) {
            writer.key((CharSequence)gqlField.getAlias());
        } else {
            writer.key((CharSequence)actualField.getName());
        }
        this.writeAndHandleResponse(writer, value, gqlField);
    }

    private void writeAndHandleResponse(JsonWriter writer, Object out, GQLSelection field) throws IOException {
        if (out == null) {
            writer.value((CharSequence)null);
            return;
        }
        if (out instanceof PMessage) {
            this.writeAndHandleMessageResponse(writer, (PMessage)out, field);
        } else if (out instanceof Integer || out instanceof Long || out instanceof Short || out instanceof Byte) {
            writer.value(((Number)out).longValue());
        } else if (out instanceof Double || out instanceof Float) {
            writer.value(((Number)out).doubleValue());
        } else if (out instanceof CharSequence) {
            writer.value((CharSequence)out);
        } else if (out instanceof Binary) {
            writer.value((Binary)out);
        } else if (out instanceof Boolean) {
            writer.value(((Boolean)out).booleanValue());
        } else if (out instanceof Collection) {
            writer.array();
            for (Object o : (Collection)out) {
                this.writeAndHandleResponse(writer, o, field);
            }
            writer.endArray();
        } else {
            writer.value((CharSequence)out.toString());
        }
    }

    private static void buildMutatorMap(Map<PField, GQLFieldProvider> providerMap, GQLFieldProvider<?> provider) {
        for (PField<?> field : provider.getFields()) {
            if (providerMap.containsKey(field)) {
                throw new IllegalArgumentException("Two field providers claim to handle " + provider.getDescriptor().getQualifiedName() + "." + field.getName() + " at the same time.");
            }
            providerMap.put(field, provider);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class JsonRequest {
        @JsonProperty(value="query")
        String query;
        @JsonProperty(value="operationName")
        String operationName;
        @JsonProperty(value="variables")
        Map<String, Object> variables;

        private JsonRequest() {
        }
    }
}

