/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PInterfaceDescriptor;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.graphql.gql.GQLScalar;
import net.morimekta.providence.graphql.gql.GQLUtil;
import net.morimekta.providence.graphql.introspection.EnumValue;
import net.morimekta.providence.graphql.introspection.Field;
import net.morimekta.providence.graphql.introspection.InputValue;
import net.morimekta.providence.graphql.introspection.Schema;
import net.morimekta.providence.graphql.introspection.Type;
import net.morimekta.providence.graphql.introspection.TypeKind;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableSet;
import net.morimekta.util.collect.UnmodifiableSortedMap;
import net.morimekta.util.io.IndentedPrintWriter;

@Immutable
public class GQLDefinition {
    private final PService query;
    private final PService mutation;
    private final Map<String, PDescriptor> allTypes;
    private final Map<String, PDescriptor> inputTypes;
    private final Map<String, PDescriptor> outputTypes;
    private final Map<String, Type> introspectionMap;
    private final Set<PField> idFields;
    private final AtomicReference<String> schema;
    private final Schema introspectionSchema;
    private static final String INPUT_TYPE = "InputType";

    public GQLDefinition(@Nonnull PService query, @Nullable PService mutation, @Nonnull Collection<PField> idFields) {
        this.idFields = UnmodifiableSet.copyOf(idFields);
        LinkedHashMap<String, PDescriptor> typeMap = new LinkedHashMap<String, PDescriptor>();
        LinkedHashMap<String, PDescriptor> inputTypeMap = new LinkedHashMap<String, PDescriptor>();
        for (PServiceMethod method : query.getMethods()) {
            GQLDefinition.registerInputTypes((PMessageDescriptor)method.getRequestType(), typeMap, inputTypeMap, false);
            GQLDefinition.registerTypes((PMessageDescriptor)method.getResponseType(), typeMap, inputTypeMap, false);
        }
        if (mutation != null) {
            for (PServiceMethod method : mutation.getMethods()) {
                GQLDefinition.registerInputTypes((PMessageDescriptor)method.getRequestType(), typeMap, inputTypeMap, false);
                GQLDefinition.registerTypes((PMessageDescriptor)method.getResponseType(), typeMap, inputTypeMap, false);
            }
        }
        this.inputTypes = UnmodifiableSortedMap.copyOf(inputTypeMap);
        this.outputTypes = UnmodifiableSortedMap.copyOf(typeMap);
        GQLDefinition.registerTypes(Schema.kDescriptor, typeMap, inputTypeMap, true);
        TreeMap<String, PDescriptor> allTypes = new TreeMap<String, PDescriptor>(typeMap);
        TreeMap<String, Type> introspection = new TreeMap<String, Type>();
        ArrayList<PDescriptor> types = new ArrayList<PDescriptor>(typeMap.values());
        Collections.reverse(types);
        types.forEach(descriptor -> this.buildTypeDefinition((Map<String, Type>)introspection, (PDescriptor)descriptor, false, false));
        types = new ArrayList<PDescriptor>(inputTypeMap.values());
        Collections.reverse(types);
        types.forEach(descriptor -> {
            Type tmp = this.buildTypeDefinition((Map<String, Type>)introspection, (PDescriptor)descriptor, true, false);
            allTypes.put(tmp.getName(), (PDescriptor)descriptor);
        });
        Type queryType = this.buildServiceDefinition(introspection, query);
        Type mutationType = this.buildServiceDefinition(introspection, mutation);
        this.allTypes = UnmodifiableSortedMap.copyOf(allTypes);
        this.introspectionMap = UnmodifiableSortedMap.copyOf(introspection);
        this.introspectionSchema = Schema.builder().setTypes(introspection.values().stream().filter(type -> !type.getName().startsWith("__")).collect(Collectors.toList())).setQueryType(queryType).setMutationType(mutationType).build();
        this.query = query;
        this.mutation = mutation;
        this.schema = new AtomicReference();
    }

    @Nonnull
    public PService getQuery() {
        return this.query;
    }

    @Nullable
    public PService getMutation() {
        return this.mutation;
    }

    public PDescriptor getType(@Nonnull String name) {
        return this.allTypes.get(name);
    }

    @Nullable
    public Type getIntrospectionType(@Nonnull String name) {
        return this.introspectionMap.get(name);
    }

    @Nonnull
    public Type getIntrospectionType(@Nonnull PDescriptor descriptor, boolean isInput) {
        String name = descriptor.getName();
        if (descriptor instanceof PMessageDescriptor && isInput) {
            name = name + INPUT_TYPE;
        }
        return Optional.ofNullable(this.getIntrospectionType(name)).orElseGet(() -> this.buildTypeDefinition(new HashMap<String, Type>(this.introspectionMap), descriptor, isInput, false));
    }

    public String getSchema() {
        return this.schema.updateAndGet(schema -> {
            if (schema == null) {
                return this.buildSchema();
            }
            return schema;
        });
    }

    @Nonnull
    public Schema getIntrospectionSchema() {
        return this.introspectionSchema;
    }

    private boolean isIdField(PField field) {
        return this.idFields.contains(field);
    }

    private Type buildServiceDefinition(Map<String, Type> introspection, PService service) {
        if (service == null) {
            return null;
        }
        Type._Builder builder = Type.builder();
        builder.setName(service.getName());
        builder.setKind(TypeKind.OBJECT);
        builder.setInterfaces((Collection<Type>)UnmodifiableList.listOf());
        for (PServiceMethod method : service.getMethods()) {
            if (method.getName().startsWith("__")) continue;
            Field._Builder field = Field.builder();
            field.setName(method.getName());
            PUnionDescriptor response = method.getResponseType();
            PStructDescriptor request = method.getRequestType();
            if (response != null) {
                PDescriptor desc = response.fieldForId(0).getDescriptor();
                field.setType(Type.builder().setKind(TypeKind.NON_NULL).setOfType(this.makeTypeReference(this.buildTypeDefinition(introspection, desc, false, false))));
            } else {
                field.setType(GQLScalar.Boolean.introspection);
            }
            field.setArgs(this.buildInputValues(introspection, (PMessageDescriptor)request));
            builder.addToFields(field.build());
        }
        Type type = builder.build();
        introspection.put(type.getName(), type);
        return type;
    }

    private String defaultValueString(Object value) {
        if (value == null) {
            return null;
        }
        return GQLUtil.toArgumentString(value);
    }

    private List<InputValue> buildInputValues(Map<String, Type> introspection, PMessageDescriptor arguments) {
        ArrayList<InputValue> out = new ArrayList<InputValue>();
        for (PField field : arguments.getFields()) {
            if (field.getName().startsWith("__")) continue;
            out.add(InputValue.builder().setName(field.getName()).setType(this.makeTypeReference(this.buildTypeDefinition(introspection, field.getDescriptor(), true, this.isIdField(field)))).setDefaultValue(this.defaultValueString(field.getDefaultValue())).build());
        }
        return UnmodifiableList.copyOf(out);
    }

    private Field buildFieldSpec(Map<String, Type> introspection, PField field) {
        Field._Builder builder = Field.builder();
        builder.setName(field.getName());
        if (field.getArgumentsType() != null) {
            builder.setArgs(this.buildInputValues(introspection, (PMessageDescriptor)field.getArgumentsType()));
        }
        Type type = this.makeTypeReference(this.buildTypeDefinition(introspection, field.getDescriptor(), false, this.isIdField(field)));
        if (field.getRequirement() == PRequirement.REQUIRED) {
            type = Type.builder().setKind(TypeKind.NON_NULL).setOfType(type).build();
        }
        return builder.setType(type).build();
    }

    private Type makeTypeReference(Type type) {
        switch (type.getKind()) {
            case UNION: 
            case INTERFACE: 
            case OBJECT: 
            case INPUT_OBJECT: {
                return type.mutate().clearInterfaces().clearInputFields().clearPossibleTypes().clearFields().build();
            }
            case LIST: 
            case NON_NULL: {
                return type.mutate().setOfType(this.makeTypeReference(type.getOfType())).build();
            }
        }
        return type;
    }

    private Type buildTypeDefinition(Map<String, Type> introspection, PDescriptor descriptor, boolean isInput, boolean isIdField) {
        switch (descriptor.getType()) {
            case MESSAGE: {
                Type._Builder builder = Type.builder();
                String name = descriptor.getName();
                if (isInput) {
                    name = name + INPUT_TYPE;
                }
                if (introspection.containsKey(name)) {
                    return introspection.get(name);
                }
                builder.setName(name);
                PMessageDescriptor md = (PMessageDescriptor)descriptor;
                boolean isUnion = false;
                if (md.getVariant() == PMessageVariant.INTERFACE) {
                    builder.setKind(TypeKind.INTERFACE);
                    builder.setPossibleTypes((Collection<Type>)UnmodifiableList.listOf());
                    builder.setFields((Collection<Field>)UnmodifiableList.listOf());
                } else if (isInput) {
                    builder.setKind(TypeKind.INPUT_OBJECT);
                } else if (md.getVariant() == PMessageVariant.UNION && md.getImplementing() != null) {
                    builder.setKind(TypeKind.UNION);
                    builder.setPossibleTypes((Collection<Type>)UnmodifiableList.listOf());
                    isUnion = true;
                } else {
                    builder.setKind(TypeKind.OBJECT);
                    builder.setFields((Collection<Field>)UnmodifiableList.listOf());
                    builder.setInterfaces((Collection<Type>)UnmodifiableList.listOf());
                }
                if (md.getImplementing() != null) {
                    builder.addToInterfaces(this.buildTypeDefinition(introspection, (PDescriptor)md.getImplementing(), false, false));
                    if (introspection.containsKey(name)) {
                        return introspection.get(name);
                    }
                }
                introspection.put(name, builder.build());
                if (isUnion) {
                    for (PField field : md.getFields()) {
                        builder.addToPossibleTypes(this.buildTypeDefinition(introspection, field.getDescriptor(), false, false));
                    }
                } else if (isInput) {
                    builder.setInputFields(this.buildInputValues(introspection, md));
                } else {
                    for (PField field : md.getFields()) {
                        if (field.getName().startsWith("__")) continue;
                        builder.addToFields(this.buildFieldSpec(introspection, field));
                    }
                }
                introspection.put(name, builder.build());
                if (md instanceof PInterfaceDescriptor) {
                    PInterfaceDescriptor id = (PInterfaceDescriptor)descriptor;
                    for (PMessageDescriptor pt : id.getPossibleTypes()) {
                        if (pt.getVariant() == PMessageVariant.UNION) continue;
                        builder.addToPossibleTypes(this.buildTypeDefinition(introspection, (PDescriptor)pt, false, false));
                    }
                }
                introspection.put(name, builder.build());
                return builder.build();
            }
            case ENUM: {
                Type._Builder builder = Type.builder();
                if (introspection.containsKey(descriptor.getName())) {
                    return introspection.get(descriptor.getName());
                }
                builder.setName(descriptor.getName());
                builder.setKind(TypeKind.ENUM);
                builder.mutableEnumValues();
                for (PEnumValue value : ((PEnumDescriptor)descriptor).getValues()) {
                    builder.addToEnumValues(EnumValue.builder().setName(value.asString()).build());
                }
                introspection.put(descriptor.getName(), builder.build());
                return builder.build();
            }
            case SET: 
            case LIST: {
                Type._Builder builder = Type.builder();
                PContainer pc = (PContainer)descriptor;
                builder.setKind(TypeKind.LIST);
                builder.setOfType(this.buildTypeDefinition(introspection, pc.itemDescriptor(), isInput, isIdField));
                return builder.build();
            }
            case STRING: 
            case BINARY: {
                if (isIdField) {
                    return GQLScalar.ID.introspection;
                }
                return GQLScalar.String.introspection;
            }
            case VOID: 
            case BOOL: {
                return GQLScalar.Boolean.introspection;
            }
            case I64: 
            case I32: 
            case I16: 
            case BYTE: {
                return GQLScalar.Int.introspection;
            }
            case DOUBLE: {
                return GQLScalar.Float.introspection;
            }
        }
        throw new IllegalStateException("Unsupported type: " + descriptor.getType());
    }

    private String buildSchema() {
        PMessageDescriptor md;
        StringWriter out = new StringWriter();
        IndentedPrintWriter writer = new IndentedPrintWriter((Writer)out, "  ", "\n");
        writer.append((CharSequence)"# Generated for providence graphql").newline();
        ArrayList<PDescriptor> types = new ArrayList<PDescriptor>(this.outputTypes.values());
        for (PDescriptor descriptor : types) {
            if (descriptor.getName().startsWith("__")) continue;
            if (descriptor.getType() == PType.ENUM) {
                PEnumDescriptor ed = (PEnumDescriptor)descriptor;
                writer.formatln("enum %s {", new Object[]{descriptor.getName()}).begin();
                for (PEnumValue pEnumValue : ed.getValues()) {
                    writer.appendln((CharSequence)pEnumValue.asString());
                }
                writer.end().appendln((CharSequence)"}").newline();
                continue;
            }
            if (descriptor.getType() != PType.MESSAGE) continue;
            md = (PMessageDescriptor)descriptor;
            if (md.getVariant() == PMessageVariant.UNION && md.getImplementing() != null) {
                writer.formatln("union %s = ", new Object[]{md.getName()});
                boolean first = true;
                PField[] pFieldArray = md.getFields();
                int n = pFieldArray.length;
                for (int i = 0; i < n; ++i) {
                    PField field = pFieldArray[i];
                    if (field.getName().startsWith("__") || field.getDescriptor().getName().startsWith("__")) continue;
                    if (first) {
                        first = false;
                    } else {
                        writer.append((CharSequence)" | ");
                    }
                    writer.append((CharSequence)field.getDescriptor().getName());
                }
                writer.newline();
                continue;
            }
            if (md.getVariant() == PMessageVariant.INTERFACE) {
                writer.formatln("interface %s {", new Object[]{md.getName()}).begin();
                for (PEnumValue pEnumValue : md.getFields()) {
                    if (pEnumValue.getName().startsWith("__") || pEnumValue.getDescriptor().getName().startsWith("__")) continue;
                    writer.formatln("%s: %s", new Object[]{pEnumValue.getName(), this.typeName((PField)pEnumValue)});
                }
                writer.end().appendln((CharSequence)"}").newline();
                continue;
            }
            writer.formatln("type %s%s {", new Object[]{md.getName(), md.getImplementing() != null ? " implements " + this.typeName((PDescriptor)md.getImplementing(), false) : ""}).begin();
            for (PEnumValue pEnumValue : md.getFields()) {
                if (pEnumValue.getName().startsWith("__")) continue;
                writer.formatln("%s", new Object[]{pEnumValue.getName()});
                if (pEnumValue.getArgumentsType() != null) {
                    writer.append((CharSequence)"(");
                    boolean first = true;
                    for (PField arg : pEnumValue.getArgumentsType().getFields()) {
                        if (pEnumValue.getName().startsWith("__")) continue;
                        if (first) {
                            first = false;
                        } else {
                            writer.append((CharSequence)", ");
                        }
                        writer.format("%s: %s", new Object[]{arg.getName(), this.inputTypeName(arg.getDescriptor(), this.isIdField(arg))});
                        if (!arg.hasDefaultValue()) continue;
                        writer.format(" = %s", new Object[]{GQLUtil.toArgumentString(arg.getDefaultValue())});
                    }
                    writer.append((CharSequence)")");
                }
                writer.format(": %s", new Object[]{this.typeName((PField)pEnumValue)});
            }
            writer.end().appendln((CharSequence)"}").newline();
        }
        types = new ArrayList<PDescriptor>(this.inputTypes.values());
        for (PDescriptor descriptor : types) {
            md = (PMessageDescriptor)descriptor;
            writer.formatln("input %s%s%s {", new Object[]{md.getName(), INPUT_TYPE, md.getImplementing() != null ? " implements " + this.typeName((PDescriptor)md.getImplementing(), false) : ""}).begin();
            for (PEnumValue pEnumValue : md.getFields()) {
                if (pEnumValue.getName().startsWith("__")) continue;
                writer.formatln("%s: %s", new Object[]{pEnumValue.getName(), this.inputTypeName((PField)pEnumValue)});
            }
            writer.end().appendln((CharSequence)"}").newline();
        }
        this.appendService(writer, this.query);
        if (this.mutation != null) {
            this.appendService(writer, this.mutation);
        }
        writer.appendln((CharSequence)"schema {").begin().formatln("query: %s", new Object[]{this.query.getName()});
        if (this.mutation != null) {
            writer.formatln("mutation: %s", new Object[]{this.mutation.getName()});
        }
        writer.end().appendln((CharSequence)"}").newline();
        writer.flush();
        return out.toString();
    }

    private void appendService(IndentedPrintWriter writer, PService service) {
        writer.formatln("type %s {", new Object[]{service.getName()}).begin();
        boolean firstMethod = true;
        for (PServiceMethod method : service.getMethods()) {
            if (firstMethod) {
                firstMethod = false;
            } else {
                writer.newline();
            }
            writer.appendln((CharSequence)method.getName());
            PStructDescriptor args = method.getRequestType();
            writer.append((CharSequence)"(");
            boolean first = true;
            for (PField arg : args.getFields()) {
                if (arg.getName().startsWith("__")) continue;
                if (first) {
                    first = false;
                } else {
                    writer.append((CharSequence)", ");
                }
                writer.format("%s: %s", new Object[]{arg.getName(), this.inputTypeName(arg.getDescriptor(), this.isIdField(arg))});
                if (!arg.hasDefaultValue()) continue;
                writer.format(" = %s", new Object[]{GQLUtil.toArgumentString(arg.getDefaultValue())});
            }
            writer.append((CharSequence)"): ");
            PUnionDescriptor response = method.getResponseType();
            if (response == null) continue;
            PField success = response.fieldForId(0);
            if (success.getType() == PType.VOID) {
                writer.format("Boolean", new Object[0]);
                continue;
            }
            writer.format("%s!", new Object[]{this.typeName(success)});
        }
        writer.end().appendln((CharSequence)"}").newline();
    }

    private String typeName(PField field) {
        return this.typeName(field.getDescriptor(), this.isIdField(field)) + (field.getRequirement() == PRequirement.REQUIRED ? "!" : "");
    }

    private String typeName(PDescriptor descriptor, boolean idType) {
        switch (descriptor.getType()) {
            case MESSAGE: 
            case ENUM: {
                return descriptor.getName();
            }
            case SET: 
            case LIST: {
                PContainer cd = (PContainer)descriptor;
                return "[" + this.typeName(cd.itemDescriptor(), idType) + "!]";
            }
            case VOID: 
            case BOOL: {
                return GQLScalar.Boolean.name();
            }
            case I64: 
            case I32: 
            case I16: 
            case BYTE: {
                return GQLScalar.Int.name();
            }
            case DOUBLE: {
                return GQLScalar.Float.name();
            }
            case STRING: 
            case BINARY: {
                if (idType) {
                    return GQLScalar.ID.name();
                }
                return GQLScalar.String.name();
            }
        }
        throw new UnsupportedOperationException("Not supported type " + descriptor.getQualifiedName());
    }

    private String inputTypeName(PField field) {
        return this.inputTypeName(field.getDescriptor(), this.isIdField(field)) + (field.getRequirement() == PRequirement.REQUIRED ? "!" : "");
    }

    private String inputTypeName(PDescriptor descriptor, boolean idType) {
        if (descriptor.getType() == PType.MESSAGE) {
            return descriptor.getName() + INPUT_TYPE;
        }
        if (descriptor.getType() == PType.SET || descriptor.getType() == PType.LIST) {
            PContainer cd = (PContainer)descriptor;
            return "[" + this.inputTypeName(cd.itemDescriptor(), idType) + "!]";
        }
        return this.typeName(descriptor, idType);
    }

    private static void registerInputTypes(PMessageDescriptor descriptor, Map<String, PDescriptor> types, Map<String, PDescriptor> inputTypes, boolean registerSelf) {
        if (descriptor != null) {
            if (descriptor.getVariant() == PMessageVariant.EXCEPTION || inputTypes.containsKey(descriptor.getName())) {
                return;
            }
            if (registerSelf) {
                inputTypes.put(descriptor.getName(), (PDescriptor)descriptor);
            }
            GQLDefinition.registerTypes((PMessageDescriptor)descriptor.getImplementing(), types, inputTypes, true);
            for (PField field : descriptor.getFields()) {
                if (field.getName().startsWith("__")) continue;
                if (field.getType() == PType.ENUM) {
                    types.put(field.getDescriptor().getName(), field.getDescriptor());
                    continue;
                }
                if (field.getType() == PType.MESSAGE) {
                    GQLDefinition.registerInputTypes((PMessageDescriptor)field.getDescriptor(), types, inputTypes, true);
                    continue;
                }
                if (field.getType() != PType.SET && field.getType() != PType.LIST && field.getType() != PType.MAP) continue;
                PDescriptor itemType = ((PContainer)field.getDescriptor()).itemDescriptor();
                if (itemType.getType() == PType.MESSAGE) {
                    GQLDefinition.registerInputTypes((PMessageDescriptor)itemType, types, inputTypes, true);
                    continue;
                }
                if (itemType.getType() != PType.ENUM) continue;
                types.put(itemType.getName(), itemType);
            }
        }
    }

    private static void registerTypes(PMessageDescriptor descriptor, Map<String, PDescriptor> types, Map<String, PDescriptor> inputTypes, boolean registerSelf) {
        if (descriptor != null) {
            if (descriptor.getVariant() == PMessageVariant.EXCEPTION || types.containsKey(descriptor.getName())) {
                return;
            }
            if (registerSelf) {
                types.put(descriptor.getName(), (PDescriptor)descriptor);
            }
            GQLDefinition.registerTypes((PMessageDescriptor)descriptor.getImplementing(), types, inputTypes, true);
            for (PField field : descriptor.getFields()) {
                if (field.getName().startsWith("__")) continue;
                GQLDefinition.registerInputTypes((PMessageDescriptor)field.getArgumentsType(), types, inputTypes, false);
                if (field.getType() == PType.ENUM) {
                    types.put(field.getDescriptor().getName(), field.getDescriptor());
                    continue;
                }
                if (field.getType() == PType.MESSAGE) {
                    GQLDefinition.registerTypes((PMessageDescriptor)field.getDescriptor(), types, inputTypes, true);
                    continue;
                }
                if (field.getType() != PType.SET && field.getType() != PType.LIST && field.getType() != PType.MAP) continue;
                PDescriptor itemType = ((PContainer)field.getDescriptor()).itemDescriptor();
                if (itemType.getType() == PType.MESSAGE) {
                    GQLDefinition.registerTypes((PMessageDescriptor)itemType, types, inputTypes, true);
                    continue;
                }
                if (itemType.getType() != PType.ENUM) continue;
                types.put(itemType.getName(), itemType);
            }
        }
    }
}

