package net.morimekta.providence.graphql.introspection;

@SuppressWarnings("unused")
@javax.annotation.Generated(
        value = "net.morimekta.providence:providence-generator-java",
        comments = "java")
@javax.annotation.concurrent.Immutable
public class Schema
        implements Schema_OrBuilder,
                   net.morimekta.providence.PMessage<Schema>,
                   Comparable<Schema>,
                   net.morimekta.providence.serializer.binary.BinaryWriter {
    private final transient java.util.List<net.morimekta.providence.graphql.introspection.Type> mTypes;
    private final transient net.morimekta.providence.graphql.introspection.Type mQueryType;
    private final transient net.morimekta.providence.graphql.introspection.Type mMutationType;
    private final transient net.morimekta.providence.graphql.introspection.Type mSubscriptionType;
    private final transient java.util.List<net.morimekta.providence.graphql.introspection.Directive> mDirectives;

    private volatile transient int tHashCode;

    private Schema(_Builder builder) {
        if (builder.isSetTypes()) {
            mTypes = net.morimekta.util.collect.UnmodifiableList.copyOf(builder.mTypes);
        } else {
            mTypes = null;
        }
        mQueryType = builder.mQueryType_builder != null ? builder.mQueryType_builder.build() : builder.mQueryType;
        mMutationType = builder.mMutationType_builder != null ? builder.mMutationType_builder.build() : builder.mMutationType;
        mSubscriptionType = builder.mSubscriptionType_builder != null ? builder.mSubscriptionType_builder.build() : builder.mSubscriptionType;
        if (builder.isSetDirectives()) {
            mDirectives = net.morimekta.util.collect.UnmodifiableList.copyOf(builder.mDirectives);
        } else {
            mDirectives = null;
        }
    }

    public int numTypes() {
        return mTypes != null ? mTypes.size() : 0;
    }

    public boolean hasTypes() {
        return mTypes != null;
    }

    /**
     * @return The <code>types</code> value
     */
    public java.util.List<net.morimekta.providence.graphql.introspection.Type> getTypes() {
        return mTypes;
    }

    /**
     * @return Optional of the <code>types</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.Type>> optionalTypes() {
        return java.util.Optional.ofNullable(mTypes);
    }

    public boolean hasQueryType() {
        return mQueryType != null;
    }

    /**
     * @return The <code>queryType</code> value
     */
    public net.morimekta.providence.graphql.introspection.Type getQueryType() {
        return mQueryType;
    }

    /**
     * @return Optional of the <code>queryType</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<net.morimekta.providence.graphql.introspection.Type> optionalQueryType() {
        return java.util.Optional.ofNullable(mQueryType);
    }

    public boolean hasMutationType() {
        return mMutationType != null;
    }

    /**
     * @return The <code>mutationType</code> value
     */
    public net.morimekta.providence.graphql.introspection.Type getMutationType() {
        return mMutationType;
    }

    /**
     * @return Optional of the <code>mutationType</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<net.morimekta.providence.graphql.introspection.Type> optionalMutationType() {
        return java.util.Optional.ofNullable(mMutationType);
    }

    public boolean hasSubscriptionType() {
        return mSubscriptionType != null;
    }

    /**
     * @return The <code>subscriptionType</code> value
     */
    public net.morimekta.providence.graphql.introspection.Type getSubscriptionType() {
        return mSubscriptionType;
    }

    /**
     * @return Optional of the <code>subscriptionType</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<net.morimekta.providence.graphql.introspection.Type> optionalSubscriptionType() {
        return java.util.Optional.ofNullable(mSubscriptionType);
    }

    public int numDirectives() {
        return mDirectives != null ? mDirectives.size() : 0;
    }

    public boolean hasDirectives() {
        return mDirectives != null;
    }

    /**
     * @return The <code>directives</code> value
     */
    public java.util.List<net.morimekta.providence.graphql.introspection.Directive> getDirectives() {
        return mDirectives;
    }

    /**
     * @return Optional of the <code>directives</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.Directive>> optionalDirectives() {
        return java.util.Optional.ofNullable(mDirectives);
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return mTypes != null;
            case 2: return mQueryType != null;
            case 3: return mMutationType != null;
            case 4: return mSubscriptionType != null;
            case 5: return mDirectives != null;
            default: return false;
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T> T get(int key) {
        switch(key) {
            case 1: return (T) mTypes;
            case 2: return (T) mQueryType;
            case 3: return (T) mMutationType;
            case 4: return (T) mSubscriptionType;
            case 5: return (T) mDirectives;
            default: return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) return true;
        if (o == null || !o.getClass().equals(getClass())) return false;
        Schema other = (Schema) o;
        return java.util.Objects.equals(mTypes, other.mTypes) &&
               java.util.Objects.equals(mQueryType, other.mQueryType) &&
               java.util.Objects.equals(mMutationType, other.mMutationType) &&
               java.util.Objects.equals(mSubscriptionType, other.mSubscriptionType) &&
               java.util.Objects.equals(mDirectives, other.mDirectives);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = java.util.Objects.hash(
                    Schema.class,
                    _Field.TYPES, mTypes,
                    _Field.QUERY_TYPE, mQueryType,
                    _Field.MUTATION_TYPE, mMutationType,
                    _Field.SUBSCRIPTION_TYPE, mSubscriptionType,
                    _Field.DIRECTIVES, mDirectives);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "gql_introspection.__Schema" + asString();
    }

    @Override
    @javax.annotation.Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        boolean first = true;
        if (hasTypes()) {
            first = false;
            out.append("types:")
               .append(net.morimekta.util.Strings.asString(mTypes));
        }
        if (hasQueryType()) {
            if (first) first = false;
            else out.append(',');
            out.append("queryType:")
               .append(mQueryType.asString());
        }
        if (hasMutationType()) {
            if (first) first = false;
            else out.append(',');
            out.append("mutationType:")
               .append(mMutationType.asString());
        }
        if (hasSubscriptionType()) {
            if (first) first = false;
            else out.append(',');
            out.append("subscriptionType:")
               .append(mSubscriptionType.asString());
        }
        if (hasDirectives()) {
            if (!first) out.append(',');
            out.append("directives:")
               .append(net.morimekta.util.Strings.asString(mDirectives));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Schema other) {
        int c;

        c = Boolean.compare(mTypes != null, other.mTypes != null);
        if (c != 0) return c;
        if (mTypes != null) {
            c = Integer.compare(mTypes.hashCode(), other.mTypes.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mQueryType != null, other.mQueryType != null);
        if (c != 0) return c;
        if (mQueryType != null) {
            c = mQueryType.compareTo(other.mQueryType);
            if (c != 0) return c;
        }

        c = Boolean.compare(mMutationType != null, other.mMutationType != null);
        if (c != 0) return c;
        if (mMutationType != null) {
            c = mMutationType.compareTo(other.mMutationType);
            if (c != 0) return c;
        }

        c = Boolean.compare(mSubscriptionType != null, other.mSubscriptionType != null);
        if (c != 0) return c;
        if (mSubscriptionType != null) {
            c = mSubscriptionType.compareTo(other.mSubscriptionType);
            if (c != 0) return c;
        }

        c = Boolean.compare(mDirectives != null, other.mDirectives != null);
        if (c != 0) return c;
        if (mDirectives != null) {
            c = Integer.compare(mDirectives.hashCode(), other.mDirectives.hashCode());
            if (c != 0) return c;
        }

        return 0;
    }

    @Override
    public int writeBinary(net.morimekta.util.io.BigEndianBinaryWriter writer) throws java.io.IOException {
        int length = 0;

        if (hasTypes()) {
            length += writer.writeByte((byte) 15);
            length += writer.writeShort((short) 1);
            length += writer.writeByte((byte) 12);
            length += writer.writeUInt32(mTypes.size());
            for (net.morimekta.providence.graphql.introspection.Type entry_1 : mTypes) {
                length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, entry_1);
            }
        }

        if (hasQueryType()) {
            length += writer.writeByte((byte) 12);
            length += writer.writeShort((short) 2);
            length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, mQueryType);
        }

        if (hasMutationType()) {
            length += writer.writeByte((byte) 12);
            length += writer.writeShort((short) 3);
            length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, mMutationType);
        }

        if (hasSubscriptionType()) {
            length += writer.writeByte((byte) 12);
            length += writer.writeShort((short) 4);
            length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, mSubscriptionType);
        }

        if (hasDirectives()) {
            length += writer.writeByte((byte) 15);
            length += writer.writeShort((short) 5);
            length += writer.writeByte((byte) 12);
            length += writer.writeUInt32(mDirectives.size());
            for (net.morimekta.providence.graphql.introspection.Directive entry_2 : mDirectives) {
                length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, entry_2);
            }
        }

        length += writer.writeByte((byte) 0);
        return length;
    }

    @javax.annotation.Nonnull
    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public enum _Field implements net.morimekta.providence.descriptor.PField<Schema> {
        TYPES(1, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "types", net.morimekta.providence.descriptor.PList.provider(net.morimekta.providence.graphql.introspection.Type.provider()), null, null),
        QUERY_TYPE(2, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "queryType", net.morimekta.providence.graphql.introspection.Type.provider(), null, null),
        MUTATION_TYPE(3, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "mutationType", net.morimekta.providence.graphql.introspection.Type.provider(), null, null),
        SUBSCRIPTION_TYPE(4, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "subscriptionType", net.morimekta.providence.graphql.introspection.Type.provider(), null, null),
        DIRECTIVES(5, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "directives", net.morimekta.providence.descriptor.PList.provider(net.morimekta.providence.graphql.introspection.Directive.provider()), null, null),
        ;

        private final int mId;
        private final net.morimekta.providence.descriptor.PRequirement mRequired;
        private final String mName;
        private final net.morimekta.providence.descriptor.PDescriptorProvider mTypeProvider;
        private final net.morimekta.providence.descriptor.PStructDescriptorProvider mArgumentsProvider;
        private final net.morimekta.providence.descriptor.PValueProvider<?> mDefaultValue;

        _Field(int id, net.morimekta.providence.descriptor.PRequirement required, String name, net.morimekta.providence.descriptor.PDescriptorProvider typeProvider, net.morimekta.providence.descriptor.PStructDescriptorProvider argumentsProvider, net.morimekta.providence.descriptor.PValueProvider<?> defaultValue) {
            mId = id;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mArgumentsProvider = argumentsProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public int getId() { return mId; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PRequirement getRequirement() { return mRequired; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PDescriptor getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        @javax.annotation.Nullable
        public net.morimekta.providence.descriptor.PStructDescriptor getArgumentsType() { return mArgumentsProvider == null ? null : mArgumentsProvider.descriptor(); }

        @javax.annotation.Nonnull
        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        @javax.annotation.Nullable
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            return net.morimekta.providence.descriptor.PField.asString(this);
        }

        /**
         * @param id Field name
         * @return The identified field or null
         */
        public static _Field findById(int id) {
            switch (id) {
                case 1: return _Field.TYPES;
                case 2: return _Field.QUERY_TYPE;
                case 3: return _Field.MUTATION_TYPE;
                case 4: return _Field.SUBSCRIPTION_TYPE;
                case 5: return _Field.DIRECTIVES;
            }
            return null;
        }

        /**
         * @param name Field name
         * @return The named field or null
         */
        public static _Field findByName(String name) {
            if (name == null) return null;
            switch (name) {
                case "types": return _Field.TYPES;
                case "queryType": return _Field.QUERY_TYPE;
                case "mutationType": return _Field.MUTATION_TYPE;
                case "subscriptionType": return _Field.SUBSCRIPTION_TYPE;
                case "directives": return _Field.DIRECTIVES;
            }
            return null;
        }

        /**
         * @param id Field name
         * @return The identified field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForId(int id) {
            _Field field = findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in gql_introspection.__Schema");
            }
            return field;
        }

        /**
         * @param name Field name
         * @return The named field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__Schema");
            }
            return field;
        }

    }

    @javax.annotation.Nonnull
    public static net.morimekta.providence.descriptor.PStructDescriptorProvider<Schema> provider() {
        return new _Provider();
    }

    @Override
    @javax.annotation.Nonnull
    public net.morimekta.providence.descriptor.PStructDescriptor<Schema> descriptor() {
        return kDescriptor;
    }

    public static final net.morimekta.providence.descriptor.PStructDescriptor<Schema> kDescriptor;

    private static final class _Descriptor
            extends net.morimekta.providence.descriptor.PStructDescriptor<Schema> {
        public _Descriptor() {
            super("gql_introspection", "__Schema", _Builder::new, false);
        }

        @Override
        @javax.annotation.Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static final class _Provider extends net.morimekta.providence.descriptor.PStructDescriptorProvider<Schema> {
        @Override
        public net.morimekta.providence.descriptor.PStructDescriptor<Schema> descriptor() {
            return kDescriptor;
        }
    }

    /**
     * Make a <code>gql_introspection.__Schema</code> builder.
     * @return The builder instance.
     */
    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends net.morimekta.providence.PMessageBuilder<Schema>
            implements Schema_OrBuilder,
                       net.morimekta.providence.serializer.binary.BinaryReader {
        private java.util.BitSet optionals;
        private java.util.BitSet modified;

        private java.util.List<net.morimekta.providence.graphql.introspection.Type> mTypes;
        private net.morimekta.providence.graphql.introspection.Type mQueryType;
        private net.morimekta.providence.graphql.introspection.Type._Builder mQueryType_builder;
        private net.morimekta.providence.graphql.introspection.Type mMutationType;
        private net.morimekta.providence.graphql.introspection.Type._Builder mMutationType_builder;
        private net.morimekta.providence.graphql.introspection.Type mSubscriptionType;
        private net.morimekta.providence.graphql.introspection.Type._Builder mSubscriptionType_builder;
        private java.util.List<net.morimekta.providence.graphql.introspection.Directive> mDirectives;

        /**
         * Make a gql_introspection.__Schema builder instance.
         */
        public _Builder() {
            optionals = new java.util.BitSet(5);
            modified = new java.util.BitSet(5);
        }

        /**
         * Make a mutating builder off a base gql_introspection.__Schema.
         *
         * @param base The base __Schema
         */
        public _Builder(Schema base) {
            this();

            if (base.hasTypes()) {
                optionals.set(0);
                mTypes = base.mTypes;
            }
            if (base.hasQueryType()) {
                optionals.set(1);
                mQueryType = base.mQueryType;
            }
            if (base.hasMutationType()) {
                optionals.set(2);
                mMutationType = base.mMutationType;
            }
            if (base.hasSubscriptionType()) {
                optionals.set(3);
                mSubscriptionType = base.mSubscriptionType;
            }
            if (base.hasDirectives()) {
                optionals.set(4);
                mDirectives = base.mDirectives;
            }
        }

        @javax.annotation.Nonnull
        @Override
        public Schema._Builder merge(Schema from) {
            if (from.hasTypes()) {
                optionals.set(0);
                modified.set(0);
                mTypes = from.getTypes();
            }

            if (from.hasQueryType()) {
                optionals.set(1);
                modified.set(1);
                if (mQueryType_builder != null) {
                    mQueryType_builder.merge(from.getQueryType());
                } else if (mQueryType != null) {
                    mQueryType_builder = mQueryType.mutate().merge(from.getQueryType());
                    mQueryType = null;
                } else {
                    mQueryType = from.getQueryType();
                }
            }

            if (from.hasMutationType()) {
                optionals.set(2);
                modified.set(2);
                if (mMutationType_builder != null) {
                    mMutationType_builder.merge(from.getMutationType());
                } else if (mMutationType != null) {
                    mMutationType_builder = mMutationType.mutate().merge(from.getMutationType());
                    mMutationType = null;
                } else {
                    mMutationType = from.getMutationType();
                }
            }

            if (from.hasSubscriptionType()) {
                optionals.set(3);
                modified.set(3);
                if (mSubscriptionType_builder != null) {
                    mSubscriptionType_builder.merge(from.getSubscriptionType());
                } else if (mSubscriptionType != null) {
                    mSubscriptionType_builder = mSubscriptionType.mutate().merge(from.getSubscriptionType());
                    mSubscriptionType = null;
                } else {
                    mSubscriptionType = from.getSubscriptionType();
                }
            }

            if (from.hasDirectives()) {
                optionals.set(4);
                modified.set(4);
                mDirectives = from.getDirectives();
            }
            return this;
        }

        /**
         * Set the <code>types</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Schema._Builder setTypes(java.util.Collection<net.morimekta.providence.graphql.introspection.Type> value) {
            if (value == null) {
                return clearTypes();
            }

            optionals.set(0);
            modified.set(0);
            mTypes = net.morimekta.util.collect.UnmodifiableList.copyOf(value);
            return this;
        }

        /**
         * Adds entries to the <code>types</code> list.
         *
         * @param values The added value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Schema._Builder addToTypes(net.morimekta.providence.graphql.introspection.Type... values) {
            optionals.set(0);
            modified.set(0);
            java.util.List<net.morimekta.providence.graphql.introspection.Type> _container = mutableTypes();
            for (net.morimekta.providence.graphql.introspection.Type item : values) {
                _container.add(item);
            }
            return this;
        }

        /**
         * Checks for explicit presence of the <code>types</code> field.
         *
         * @return True if types has been set.
         */
        public boolean isSetTypes() {
            return optionals.get(0);
        }

        /**
         * Checks for presence of the <code>types</code> field.
         *
         * @return True if types is present.
         */
        public boolean hasTypes() {
            return optionals.get(0);
        }

        /**
         * Checks if the <code>types</code> field has been modified since the
         * builder was created.
         *
         * @return True if types has been modified.
         */
        public boolean isModifiedTypes() {
            return modified.get(0);
        }

        /**
         * Clear the <code>types</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Schema._Builder clearTypes() {
            optionals.clear(0);
            modified.set(0);
            mTypes = null;
            return this;
        }

        /**
         * @return The mutable <code>types</code> container
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.Type> mutableTypes() {
            optionals.set(0);
            modified.set(0);

            if (mTypes == null) {
                mTypes = new java.util.ArrayList<>();
            } else if (!(mTypes instanceof java.util.ArrayList)) {
                mTypes = new java.util.ArrayList<>(mTypes);
            }
            return mTypes;
        }

        /**
         * @return The <code>types</code> field value
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.Type> getTypes() {
            return mTypes;
        }

        /**
         * @return Optional <code>types</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.Type>> optionalTypes() {
            return java.util.Optional.ofNullable(mTypes);
        }

        /**
         * @return Number of entries in <code>types</code>.
         */
        public int numTypes() {
            return mTypes != null ? mTypes.size() : 0;
        }

        /**
         * Set the <code>queryType</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Schema._Builder setQueryType(net.morimekta.providence.graphql.introspection.Type_OrBuilder value) {
            if (value == null) {
                return clearQueryType();
            }

            optionals.set(1);
            modified.set(1);
            if (value instanceof net.morimekta.providence.graphql.introspection.Type._Builder) {
                value = ((net.morimekta.providence.graphql.introspection.Type._Builder) value).build();
            } else if (!(value instanceof net.morimekta.providence.graphql.introspection.Type)) {
                throw new java.lang.IllegalArgumentException("Invalid type for gql_introspection.__Type: " + value.getClass().getName());
            }
            mQueryType = (net.morimekta.providence.graphql.introspection.Type) value;
            mQueryType_builder = null;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>queryType</code> field.
         *
         * @return True if queryType has been set.
         */
        public boolean isSetQueryType() {
            return optionals.get(1);
        }

        /**
         * Checks for presence of the <code>queryType</code> field.
         *
         * @return True if queryType is present.
         */
        public boolean hasQueryType() {
            return optionals.get(1);
        }

        /**
         * Checks if the <code>queryType</code> field has been modified since the
         * builder was created.
         *
         * @return True if queryType has been modified.
         */
        public boolean isModifiedQueryType() {
            return modified.get(1);
        }

        /**
         * Clear the <code>queryType</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Schema._Builder clearQueryType() {
            optionals.clear(1);
            modified.set(1);
            mQueryType = null;
            mQueryType_builder = null;
            return this;
        }

        /**
         * Get the builder for the contained <code>queryType</code> message field.
         *
         * @return The field message builder
         */
        @javax.annotation.Nonnull
        public net.morimekta.providence.graphql.introspection.Type._Builder mutableQueryType() {
            optionals.set(1);
            modified.set(1);

            if (mQueryType != null) {
                mQueryType_builder = mQueryType.mutate();
                mQueryType = null;
            } else if (mQueryType_builder == null) {
                mQueryType_builder = net.morimekta.providence.graphql.introspection.Type.builder();
            }
            return mQueryType_builder;
        }

        /**
         * @return The <code>queryType</code> field value
         */
        public net.morimekta.providence.graphql.introspection.Type getQueryType() {
            return mQueryType_builder != null ? mQueryType_builder.build() : mQueryType;
        }

        /**
         * @return Optional <code>queryType</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<net.morimekta.providence.graphql.introspection.Type> optionalQueryType() {
            return java.util.Optional.ofNullable(mQueryType_builder != null ? mQueryType_builder.build() : mQueryType);
        }

        /**
         * Set the <code>mutationType</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Schema._Builder setMutationType(net.morimekta.providence.graphql.introspection.Type_OrBuilder value) {
            if (value == null) {
                return clearMutationType();
            }

            optionals.set(2);
            modified.set(2);
            if (value instanceof net.morimekta.providence.graphql.introspection.Type._Builder) {
                value = ((net.morimekta.providence.graphql.introspection.Type._Builder) value).build();
            } else if (!(value instanceof net.morimekta.providence.graphql.introspection.Type)) {
                throw new java.lang.IllegalArgumentException("Invalid type for gql_introspection.__Type: " + value.getClass().getName());
            }
            mMutationType = (net.morimekta.providence.graphql.introspection.Type) value;
            mMutationType_builder = null;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>mutationType</code> field.
         *
         * @return True if mutationType has been set.
         */
        public boolean isSetMutationType() {
            return optionals.get(2);
        }

        /**
         * Checks for presence of the <code>mutationType</code> field.
         *
         * @return True if mutationType is present.
         */
        public boolean hasMutationType() {
            return optionals.get(2);
        }

        /**
         * Checks if the <code>mutationType</code> field has been modified since the
         * builder was created.
         *
         * @return True if mutationType has been modified.
         */
        public boolean isModifiedMutationType() {
            return modified.get(2);
        }

        /**
         * Clear the <code>mutationType</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Schema._Builder clearMutationType() {
            optionals.clear(2);
            modified.set(2);
            mMutationType = null;
            mMutationType_builder = null;
            return this;
        }

        /**
         * Get the builder for the contained <code>mutationType</code> message field.
         *
         * @return The field message builder
         */
        @javax.annotation.Nonnull
        public net.morimekta.providence.graphql.introspection.Type._Builder mutableMutationType() {
            optionals.set(2);
            modified.set(2);

            if (mMutationType != null) {
                mMutationType_builder = mMutationType.mutate();
                mMutationType = null;
            } else if (mMutationType_builder == null) {
                mMutationType_builder = net.morimekta.providence.graphql.introspection.Type.builder();
            }
            return mMutationType_builder;
        }

        /**
         * @return The <code>mutationType</code> field value
         */
        public net.morimekta.providence.graphql.introspection.Type getMutationType() {
            return mMutationType_builder != null ? mMutationType_builder.build() : mMutationType;
        }

        /**
         * @return Optional <code>mutationType</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<net.morimekta.providence.graphql.introspection.Type> optionalMutationType() {
            return java.util.Optional.ofNullable(mMutationType_builder != null ? mMutationType_builder.build() : mMutationType);
        }

        /**
         * Set the <code>subscriptionType</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Schema._Builder setSubscriptionType(net.morimekta.providence.graphql.introspection.Type_OrBuilder value) {
            if (value == null) {
                return clearSubscriptionType();
            }

            optionals.set(3);
            modified.set(3);
            if (value instanceof net.morimekta.providence.graphql.introspection.Type._Builder) {
                value = ((net.morimekta.providence.graphql.introspection.Type._Builder) value).build();
            } else if (!(value instanceof net.morimekta.providence.graphql.introspection.Type)) {
                throw new java.lang.IllegalArgumentException("Invalid type for gql_introspection.__Type: " + value.getClass().getName());
            }
            mSubscriptionType = (net.morimekta.providence.graphql.introspection.Type) value;
            mSubscriptionType_builder = null;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>subscriptionType</code> field.
         *
         * @return True if subscriptionType has been set.
         */
        public boolean isSetSubscriptionType() {
            return optionals.get(3);
        }

        /**
         * Checks for presence of the <code>subscriptionType</code> field.
         *
         * @return True if subscriptionType is present.
         */
        public boolean hasSubscriptionType() {
            return optionals.get(3);
        }

        /**
         * Checks if the <code>subscriptionType</code> field has been modified since the
         * builder was created.
         *
         * @return True if subscriptionType has been modified.
         */
        public boolean isModifiedSubscriptionType() {
            return modified.get(3);
        }

        /**
         * Clear the <code>subscriptionType</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Schema._Builder clearSubscriptionType() {
            optionals.clear(3);
            modified.set(3);
            mSubscriptionType = null;
            mSubscriptionType_builder = null;
            return this;
        }

        /**
         * Get the builder for the contained <code>subscriptionType</code> message field.
         *
         * @return The field message builder
         */
        @javax.annotation.Nonnull
        public net.morimekta.providence.graphql.introspection.Type._Builder mutableSubscriptionType() {
            optionals.set(3);
            modified.set(3);

            if (mSubscriptionType != null) {
                mSubscriptionType_builder = mSubscriptionType.mutate();
                mSubscriptionType = null;
            } else if (mSubscriptionType_builder == null) {
                mSubscriptionType_builder = net.morimekta.providence.graphql.introspection.Type.builder();
            }
            return mSubscriptionType_builder;
        }

        /**
         * @return The <code>subscriptionType</code> field value
         */
        public net.morimekta.providence.graphql.introspection.Type getSubscriptionType() {
            return mSubscriptionType_builder != null ? mSubscriptionType_builder.build() : mSubscriptionType;
        }

        /**
         * @return Optional <code>subscriptionType</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<net.morimekta.providence.graphql.introspection.Type> optionalSubscriptionType() {
            return java.util.Optional.ofNullable(mSubscriptionType_builder != null ? mSubscriptionType_builder.build() : mSubscriptionType);
        }

        /**
         * Set the <code>directives</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Schema._Builder setDirectives(java.util.Collection<net.morimekta.providence.graphql.introspection.Directive> value) {
            if (value == null) {
                return clearDirectives();
            }

            optionals.set(4);
            modified.set(4);
            mDirectives = net.morimekta.util.collect.UnmodifiableList.copyOf(value);
            return this;
        }

        /**
         * Adds entries to the <code>directives</code> list.
         *
         * @param values The added value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Schema._Builder addToDirectives(net.morimekta.providence.graphql.introspection.Directive... values) {
            optionals.set(4);
            modified.set(4);
            java.util.List<net.morimekta.providence.graphql.introspection.Directive> _container = mutableDirectives();
            for (net.morimekta.providence.graphql.introspection.Directive item : values) {
                _container.add(item);
            }
            return this;
        }

        /**
         * Checks for explicit presence of the <code>directives</code> field.
         *
         * @return True if directives has been set.
         */
        public boolean isSetDirectives() {
            return optionals.get(4);
        }

        /**
         * Checks for presence of the <code>directives</code> field.
         *
         * @return True if directives is present.
         */
        public boolean hasDirectives() {
            return optionals.get(4);
        }

        /**
         * Checks if the <code>directives</code> field has been modified since the
         * builder was created.
         *
         * @return True if directives has been modified.
         */
        public boolean isModifiedDirectives() {
            return modified.get(4);
        }

        /**
         * Clear the <code>directives</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Schema._Builder clearDirectives() {
            optionals.clear(4);
            modified.set(4);
            mDirectives = null;
            return this;
        }

        /**
         * @return The mutable <code>directives</code> container
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.Directive> mutableDirectives() {
            optionals.set(4);
            modified.set(4);

            if (mDirectives == null) {
                mDirectives = new java.util.ArrayList<>();
            } else if (!(mDirectives instanceof java.util.ArrayList)) {
                mDirectives = new java.util.ArrayList<>(mDirectives);
            }
            return mDirectives;
        }

        /**
         * @return The <code>directives</code> field value
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.Directive> getDirectives() {
            return mDirectives;
        }

        /**
         * @return Optional <code>directives</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<java.util.List<net.morimekta.providence.graphql.introspection.Directive>> optionalDirectives() {
            return java.util.Optional.ofNullable(mDirectives);
        }

        /**
         * @return Number of entries in <code>directives</code>.
         */
        public int numDirectives() {
            return mDirectives != null ? mDirectives.size() : 0;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) return true;
            if (o == null || !o.getClass().equals(getClass())) return false;
            Schema._Builder other = (Schema._Builder) o;
            return java.util.Objects.equals(optionals, other.optionals) &&
                   java.util.Objects.equals(mTypes, other.mTypes) &&
                   java.util.Objects.equals(getQueryType(), other.getQueryType()) &&
                   java.util.Objects.equals(getMutationType(), other.getMutationType()) &&
                   java.util.Objects.equals(getSubscriptionType(), other.getSubscriptionType()) &&
                   java.util.Objects.equals(mDirectives, other.mDirectives);
        }

        @Override
        public int hashCode() {
            return java.util.Objects.hash(
                    Schema.class, optionals,
                    Schema._Field.TYPES, mTypes,
                    Schema._Field.QUERY_TYPE, getQueryType(),
                    Schema._Field.MUTATION_TYPE, getMutationType(),
                    Schema._Field.SUBSCRIPTION_TYPE, getSubscriptionType(),
                    Schema._Field.DIRECTIVES, mDirectives);
        }

        @Override
        @SuppressWarnings("unchecked")
        public net.morimekta.providence.PMessageBuilder mutator(int key) {
            switch (key) {
                case 2: return mutableQueryType();
                case 3: return mutableMutationType();
                case 4: return mutableSubscriptionType();
                default: throw new IllegalArgumentException("Not a message field ID: " + key);
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public Schema._Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setTypes((java.util.List<net.morimekta.providence.graphql.introspection.Type>) value); break;
                case 2: setQueryType((net.morimekta.providence.graphql.introspection.Type) value); break;
                case 3: setMutationType((net.morimekta.providence.graphql.introspection.Type) value); break;
                case 4: setSubscriptionType((net.morimekta.providence.graphql.introspection.Type) value); break;
                case 5: setDirectives((java.util.List<net.morimekta.providence.graphql.introspection.Directive>) value); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean isSet(int key) {
            switch (key) {
                case 1: return optionals.get(0);
                case 2: return optionals.get(1);
                case 3: return optionals.get(2);
                case 4: return optionals.get(3);
                case 5: return optionals.get(4);
                default: break;
            }
            return false;
        }

        @Override
        public boolean isModified(int key) {
            switch (key) {
                case 1: return modified.get(0);
                case 2: return modified.get(1);
                case 3: return modified.get(2);
                case 4: return modified.get(3);
                case 5: return modified.get(4);
                default: break;
            }
            return false;
        }

        @Override
        @SuppressWarnings("unchecked")
        public <T> T get(int key) {
            switch(key) {
                case 1: return (T) getTypes();
                case 2: return (T) getQueryType();
                case 3: return (T) getMutationType();
                case 4: return (T) getSubscriptionType();
                case 5: return (T) getDirectives();
                default: return null;
            }
        }

        @Override
        public boolean has(int key) {
            switch(key) {
                case 1: return mTypes != null;
                case 2: return mQueryType != null || mQueryType_builder != null;
                case 3: return mMutationType != null || mMutationType_builder != null;
                case 4: return mSubscriptionType != null || mSubscriptionType_builder != null;
                case 5: return mDirectives != null;
                default: return false;
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public Schema._Builder addTo(int key, Object value) {
            switch (key) {
                case 1: addToTypes((net.morimekta.providence.graphql.introspection.Type) value); break;
                case 5: addToDirectives((net.morimekta.providence.graphql.introspection.Directive) value); break;
                default: break;
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public Schema._Builder clear(int key) {
            switch (key) {
                case 1: clearTypes(); break;
                case 2: clearQueryType(); break;
                case 3: clearMutationType(); break;
                case 4: clearSubscriptionType(); break;
                case 5: clearDirectives(); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean valid() {
            return true;
        }

        @Override
        public Schema._Builder validate() {
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PStructDescriptor<Schema> descriptor() {
            return Schema.kDescriptor;
        }

        @Override
        public void readBinary(net.morimekta.util.io.BigEndianBinaryReader reader, boolean strict) throws java.io.IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                int field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 15) {
                            byte t_3 = reader.expectByte();
                            if (t_3 == 12) {
                                final int len_2 = reader.expectUInt32();
                                net.morimekta.util.collect.UnmodifiableList.Builder<net.morimekta.providence.graphql.introspection.Type> b_1 = net.morimekta.util.collect.UnmodifiableList.builder(len_2);
                                for (int i_4 = 0; i_4 < len_2; ++i_4) {
                                    net.morimekta.providence.graphql.introspection.Type key_5 = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.Type.kDescriptor, strict);
                                    b_1.add(key_5);
                                }
                                mTypes = b_1.build();
                            } else {
                                throw new net.morimekta.providence.serializer.SerializerException("Wrong item type " + net.morimekta.providence.serializer.binary.BinaryType.asString(t_3) + " for gql_introspection.__Schema.types, should be struct(12)");
                            }
                            optionals.set(0);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Schema.types, should be struct(12)");
                        }
                        break;
                    }
                    case 2: {
                        if (type == 12) {
                            mQueryType = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.Type.kDescriptor, strict);
                            optionals.set(1);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Schema.queryType, should be struct(12)");
                        }
                        break;
                    }
                    case 3: {
                        if (type == 12) {
                            mMutationType = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.Type.kDescriptor, strict);
                            optionals.set(2);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Schema.mutationType, should be struct(12)");
                        }
                        break;
                    }
                    case 4: {
                        if (type == 12) {
                            mSubscriptionType = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.Type.kDescriptor, strict);
                            optionals.set(3);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Schema.subscriptionType, should be struct(12)");
                        }
                        break;
                    }
                    case 5: {
                        if (type == 15) {
                            byte t_8 = reader.expectByte();
                            if (t_8 == 12) {
                                final int len_7 = reader.expectUInt32();
                                net.morimekta.util.collect.UnmodifiableList.Builder<net.morimekta.providence.graphql.introspection.Directive> b_6 = net.morimekta.util.collect.UnmodifiableList.builder(len_7);
                                for (int i_9 = 0; i_9 < len_7; ++i_9) {
                                    net.morimekta.providence.graphql.introspection.Directive key_10 = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.Directive.kDescriptor, strict);
                                    b_6.add(key_10);
                                }
                                mDirectives = b_6.build();
                            } else {
                                throw new net.morimekta.providence.serializer.SerializerException("Wrong item type " + net.morimekta.providence.serializer.binary.BinaryType.asString(t_8) + " for gql_introspection.__Schema.directives, should be struct(12)");
                            }
                            optionals.set(4);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Schema.directives, should be struct(12)");
                        }
                        break;
                    }
                    default: {
                        net.morimekta.providence.serializer.binary.BinaryFormatUtils.readFieldValue(reader, new net.morimekta.providence.serializer.binary.BinaryFormatUtils.FieldInfo(field, type), null, false);
                        break;
                    }
                }
                type = reader.expectByte();
            }
        }

        @Override
        @javax.annotation.Nonnull
        public Schema build() {
            return new Schema(this);
        }
    }
}
