package net.morimekta.providence.graphql.introspection;

@javax.annotation.Generated(
        value = "net.morimekta.providence:providence-generator-java",
        comments = "java")
public enum TypeKind
        implements net.morimekta.providence.PEnumValue<TypeKind> {
    SCALAR(1, "SCALAR"),
    OBJECT(2, "OBJECT"),
    INTERFACE(3, "INTERFACE"),
    UNION(4, "UNION"),
    ENUM(5, "ENUM"),
    INPUT_OBJECT(6, "INPUT_OBJECT"),
    LIST(7, "LIST"),
    NON_NULL(8, "NON_NULL"),
    ;

    private final int    mId;
    private final String mName;

    TypeKind(int id, String name) {
        mId = id;
        mName = name;
    }

    @Override
    public int asInteger() {
        return mId;
    }

    @Override
    @javax.annotation.Nonnull
    public String asString() {
        return mName;
    }

    /**
     * Find a value based in its ID
     *
     * @param id Id of value
     * @return Value found or null
     */
    @javax.annotation.Nullable
    public static TypeKind findById(Integer id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case 1: return TypeKind.SCALAR;
            case 2: return TypeKind.OBJECT;
            case 3: return TypeKind.INTERFACE;
            case 4: return TypeKind.UNION;
            case 5: return TypeKind.ENUM;
            case 6: return TypeKind.INPUT_OBJECT;
            case 7: return TypeKind.LIST;
            case 8: return TypeKind.NON_NULL;
            default: return null;
        }
    }

    /**
     * Find a value based in its name
     *
     * @param name Name of value
     * @return Value found or null
     */
    @javax.annotation.Nullable
    public static TypeKind findByName(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "SCALAR": return TypeKind.SCALAR;
            case "OBJECT": return TypeKind.OBJECT;
            case "INTERFACE": return TypeKind.INTERFACE;
            case "UNION": return TypeKind.UNION;
            case "ENUM": return TypeKind.ENUM;
            case "INPUT_OBJECT": return TypeKind.INPUT_OBJECT;
            case "LIST": return TypeKind.LIST;
            case "NON_NULL": return TypeKind.NON_NULL;
            default: return null;
        }
    }

    /**
     * Get a value based in its ID
     *
     * @param id Id of value
     * @return Value found
     * @throws IllegalArgumentException If no value for id is found
     */
    @javax.annotation.Nonnull
    public static TypeKind valueForId(int id) {
        TypeKind value = findById(id);
        if (value == null) {
            throw new IllegalArgumentException("No gql_introspection.__TypeKind for id " + id);
        }
        return value;
    }

    /**
     * Get a value based in its name
     *
     * @param name Name of value
     * @return Value found
     * @throws IllegalArgumentException If no value for name is found, or null name
     */
    @javax.annotation.Nonnull
    public static TypeKind valueForName(@javax.annotation.Nonnull String name) {
        TypeKind value = findByName(name);
        if (value == null) {
            throw new IllegalArgumentException("No gql_introspection.__TypeKind for name \"" + name + "\"");
        }
        return value;
    }

    public static final class _Builder extends net.morimekta.providence.PEnumBuilder<TypeKind> {
        private TypeKind mValue;

        @Override
        @javax.annotation.Nonnull
        public _Builder setById(int value) {
            mValue = TypeKind.findById(value);
            return this;
        }

        @Override
        @javax.annotation.Nonnull
        public _Builder setByName(String name) {
            mValue = TypeKind.findByName(name);
            return this;
        }

        @Override
        public boolean valid() {
            return mValue != null;
        }

        @Override
        public TypeKind build() {
            return mValue;
        }
    }

    public static final net.morimekta.providence.descriptor.PEnumDescriptor<TypeKind> kDescriptor;

    @Override
    public net.morimekta.providence.descriptor.PEnumDescriptor<TypeKind> descriptor() {
        return kDescriptor;
    }

    public static net.morimekta.providence.descriptor.PEnumDescriptorProvider<TypeKind> provider() {
        return new net.morimekta.providence.descriptor.PEnumDescriptorProvider<TypeKind>(kDescriptor);
    }

    private static final class _Descriptor
            extends net.morimekta.providence.descriptor.PEnumDescriptor<TypeKind> {
        public _Descriptor() {
            super("gql_introspection", "__TypeKind", _Builder::new);
        }

        @Override
        @javax.annotation.Nonnull
        public TypeKind[] getValues() {
            return TypeKind.values();
        }

        @Override
        @javax.annotation.Nullable
        public TypeKind findById(int id) {
            return TypeKind.findById(id);
        }

        @Override
        @javax.annotation.Nullable
        public TypeKind findByName(String name) {
            return TypeKind.findByName(name);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }
}
