package net.morimekta.providence.graphql.introspection;

@SuppressWarnings("unused")
@javax.annotation.Generated(
        value = "net.morimekta.providence:providence-generator-java",
        comments = "java")
@javax.annotation.concurrent.Immutable
public class InputValue
        implements InputValue_OrBuilder,
                   net.morimekta.providence.PMessage<InputValue>,
                   Comparable<InputValue>,
                   net.morimekta.providence.serializer.binary.BinaryWriter {
    private final static String kDefaultName = "";

    private final transient String mName;
    private final transient String mDescription;
    private final transient net.morimekta.providence.graphql.introspection.Type mType;
    private final transient String mDefaultValue;

    private volatile transient int tHashCode;

    private InputValue(_Builder builder) {
        if (builder.isSetName()) {
            mName = builder.mName;
        } else {
            mName = kDefaultName;
        }
        mDescription = builder.mDescription;
        mType = builder.mType_builder != null ? builder.mType_builder.build() : builder.mType;
        mDefaultValue = builder.mDefaultValue;
    }

    public boolean hasName() {
        return true;
    }

    /**
     * @return The <code>name</code> value
     */
    @javax.annotation.Nonnull
    public String getName() {
        return mName;
    }

    public boolean hasDescription() {
        return mDescription != null;
    }

    /**
     * @return The <code>description</code> value
     */
    public String getDescription() {
        return mDescription;
    }

    /**
     * @return Optional of the <code>description</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<String> optionalDescription() {
        return java.util.Optional.ofNullable(mDescription);
    }

    public boolean hasType() {
        return mType != null;
    }

    /**
     * @return The <code>type</code> value
     */
    public net.morimekta.providence.graphql.introspection.Type getType() {
        return mType;
    }

    /**
     * @return Optional of the <code>type</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<net.morimekta.providence.graphql.introspection.Type> optionalType() {
        return java.util.Optional.ofNullable(mType);
    }

    public boolean hasDefaultValue() {
        return mDefaultValue != null;
    }

    /**
     * @return The <code>defaultValue</code> value
     */
    public String getDefaultValue() {
        return mDefaultValue;
    }

    /**
     * @return Optional of the <code>defaultValue</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<String> optionalDefaultValue() {
        return java.util.Optional.ofNullable(mDefaultValue);
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return true;
            case 2: return mDescription != null;
            case 3: return mType != null;
            case 4: return mDefaultValue != null;
            default: return false;
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T> T get(int key) {
        switch(key) {
            case 1: return (T) mName;
            case 2: return (T) mDescription;
            case 3: return (T) mType;
            case 4: return (T) mDefaultValue;
            default: return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) return true;
        if (o == null || !o.getClass().equals(getClass())) return false;
        InputValue other = (InputValue) o;
        return java.util.Objects.equals(mName, other.mName) &&
               java.util.Objects.equals(mDescription, other.mDescription) &&
               java.util.Objects.equals(mType, other.mType) &&
               java.util.Objects.equals(mDefaultValue, other.mDefaultValue);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = java.util.Objects.hash(
                    InputValue.class,
                    _Field.NAME, mName,
                    _Field.DESCRIPTION, mDescription,
                    _Field.TYPE, mType,
                    _Field.DEFAULT_VALUE, mDefaultValue);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "gql_introspection.__InputValue" + asString();
    }

    @Override
    @javax.annotation.Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        out.append("name:")
           .append('\"')
           .append(net.morimekta.util.Strings.escape(mName))
           .append('\"');
        if (hasDescription()) {
            out.append(',');
            out.append("description:")
               .append('\"')
               .append(net.morimekta.util.Strings.escape(mDescription))
               .append('\"');
        }
        if (hasType()) {
            out.append(',');
            out.append("type:")
               .append(mType.asString());
        }
        if (hasDefaultValue()) {
            out.append(',');
            out.append("defaultValue:")
               .append('\"')
               .append(net.morimekta.util.Strings.escape(mDefaultValue))
               .append('\"');
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(InputValue other) {
        int c;

        c = mName.compareTo(other.mName);
        if (c != 0) return c;

        c = Boolean.compare(mDescription != null, other.mDescription != null);
        if (c != 0) return c;
        if (mDescription != null) {
            c = mDescription.compareTo(other.mDescription);
            if (c != 0) return c;
        }

        c = Boolean.compare(mType != null, other.mType != null);
        if (c != 0) return c;
        if (mType != null) {
            c = mType.compareTo(other.mType);
            if (c != 0) return c;
        }

        c = Boolean.compare(mDefaultValue != null, other.mDefaultValue != null);
        if (c != 0) return c;
        if (mDefaultValue != null) {
            c = mDefaultValue.compareTo(other.mDefaultValue);
            if (c != 0) return c;
        }

        return 0;
    }

    @Override
    public int writeBinary(net.morimekta.util.io.BigEndianBinaryWriter writer) throws java.io.IOException {
        int length = 0;

        length += writer.writeByte((byte) 11);
        length += writer.writeShort((short) 1);
        net.morimekta.util.Binary tmp_1 = net.morimekta.util.Binary.wrap(mName.getBytes(java.nio.charset.StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_1.length());
        length += writer.writeBinary(tmp_1);

        if (hasDescription()) {
            length += writer.writeByte((byte) 11);
            length += writer.writeShort((short) 2);
            net.morimekta.util.Binary tmp_2 = net.morimekta.util.Binary.wrap(mDescription.getBytes(java.nio.charset.StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }

        if (hasType()) {
            length += writer.writeByte((byte) 12);
            length += writer.writeShort((short) 3);
            length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, mType);
        }

        if (hasDefaultValue()) {
            length += writer.writeByte((byte) 11);
            length += writer.writeShort((short) 4);
            net.morimekta.util.Binary tmp_3 = net.morimekta.util.Binary.wrap(mDefaultValue.getBytes(java.nio.charset.StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_3.length());
            length += writer.writeBinary(tmp_3);
        }

        length += writer.writeByte((byte) 0);
        return length;
    }

    @javax.annotation.Nonnull
    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public enum _Field implements net.morimekta.providence.descriptor.PField<InputValue> {
        NAME(1, net.morimekta.providence.descriptor.PRequirement.REQUIRED, "name", net.morimekta.providence.descriptor.PPrimitive.STRING.provider(), null, null),
        DESCRIPTION(2, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "description", net.morimekta.providence.descriptor.PPrimitive.STRING.provider(), null, null),
        TYPE(3, net.morimekta.providence.descriptor.PRequirement.REQUIRED, "type", net.morimekta.providence.graphql.introspection.Type.provider(), null, null),
        DEFAULT_VALUE(4, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "defaultValue", net.morimekta.providence.descriptor.PPrimitive.STRING.provider(), null, null),
        ;

        private final int mId;
        private final net.morimekta.providence.descriptor.PRequirement mRequired;
        private final String mName;
        private final net.morimekta.providence.descriptor.PDescriptorProvider mTypeProvider;
        private final net.morimekta.providence.descriptor.PStructDescriptorProvider mArgumentsProvider;
        private final net.morimekta.providence.descriptor.PValueProvider<?> mDefaultValue;

        _Field(int id, net.morimekta.providence.descriptor.PRequirement required, String name, net.morimekta.providence.descriptor.PDescriptorProvider typeProvider, net.morimekta.providence.descriptor.PStructDescriptorProvider argumentsProvider, net.morimekta.providence.descriptor.PValueProvider<?> defaultValue) {
            mId = id;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mArgumentsProvider = argumentsProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public int getId() { return mId; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PRequirement getRequirement() { return mRequired; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PDescriptor getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        @javax.annotation.Nullable
        public net.morimekta.providence.descriptor.PStructDescriptor getArgumentsType() { return mArgumentsProvider == null ? null : mArgumentsProvider.descriptor(); }

        @javax.annotation.Nonnull
        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        @javax.annotation.Nullable
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            return net.morimekta.providence.descriptor.PField.asString(this);
        }

        /**
         * @param id Field name
         * @return The identified field or null
         */
        public static _Field findById(int id) {
            switch (id) {
                case 1: return _Field.NAME;
                case 2: return _Field.DESCRIPTION;
                case 3: return _Field.TYPE;
                case 4: return _Field.DEFAULT_VALUE;
            }
            return null;
        }

        /**
         * @param name Field name
         * @return The named field or null
         */
        public static _Field findByName(String name) {
            if (name == null) return null;
            switch (name) {
                case "name": return _Field.NAME;
                case "description": return _Field.DESCRIPTION;
                case "type": return _Field.TYPE;
                case "defaultValue": return _Field.DEFAULT_VALUE;
            }
            return null;
        }

        /**
         * @param id Field name
         * @return The identified field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForId(int id) {
            _Field field = findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in gql_introspection.__InputValue");
            }
            return field;
        }

        /**
         * @param name Field name
         * @return The named field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__InputValue");
            }
            return field;
        }

    }

    @javax.annotation.Nonnull
    public static net.morimekta.providence.descriptor.PStructDescriptorProvider<InputValue> provider() {
        return new _Provider();
    }

    @Override
    @javax.annotation.Nonnull
    public net.morimekta.providence.descriptor.PStructDescriptor<InputValue> descriptor() {
        return kDescriptor;
    }

    public static final net.morimekta.providence.descriptor.PStructDescriptor<InputValue> kDescriptor;

    private static final class _Descriptor
            extends net.morimekta.providence.descriptor.PStructDescriptor<InputValue> {
        public _Descriptor() {
            super("gql_introspection", "__InputValue", _Builder::new, false);
        }

        @Override
        @javax.annotation.Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static final class _Provider extends net.morimekta.providence.descriptor.PStructDescriptorProvider<InputValue> {
        @Override
        public net.morimekta.providence.descriptor.PStructDescriptor<InputValue> descriptor() {
            return kDescriptor;
        }
    }

    /**
     * Make a <code>gql_introspection.__InputValue</code> builder.
     * @return The builder instance.
     */
    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends net.morimekta.providence.PMessageBuilder<InputValue>
            implements InputValue_OrBuilder,
                       net.morimekta.providence.serializer.binary.BinaryReader {
        private java.util.BitSet optionals;
        private java.util.BitSet modified;

        private String mName;
        private String mDescription;
        private net.morimekta.providence.graphql.introspection.Type mType;
        private net.morimekta.providence.graphql.introspection.Type._Builder mType_builder;
        private String mDefaultValue;

        /**
         * Make a gql_introspection.__InputValue builder instance.
         */
        public _Builder() {
            optionals = new java.util.BitSet(4);
            modified = new java.util.BitSet(4);
            mName = kDefaultName;
        }

        /**
         * Make a mutating builder off a base gql_introspection.__InputValue.
         *
         * @param base The base __InputValue
         */
        public _Builder(InputValue base) {
            this();

            optionals.set(0);
            mName = base.mName;
            if (base.hasDescription()) {
                optionals.set(1);
                mDescription = base.mDescription;
            }
            if (base.hasType()) {
                optionals.set(2);
                mType = base.mType;
            }
            if (base.hasDefaultValue()) {
                optionals.set(3);
                mDefaultValue = base.mDefaultValue;
            }
        }

        @javax.annotation.Nonnull
        @Override
        public InputValue._Builder merge(InputValue from) {
            optionals.set(0);
            modified.set(0);
            mName = from.getName();

            if (from.hasDescription()) {
                optionals.set(1);
                modified.set(1);
                mDescription = from.getDescription();
            }

            if (from.hasType()) {
                optionals.set(2);
                modified.set(2);
                if (mType_builder != null) {
                    mType_builder.merge(from.getType());
                } else if (mType != null) {
                    mType_builder = mType.mutate().merge(from.getType());
                    mType = null;
                } else {
                    mType = from.getType();
                }
            }

            if (from.hasDefaultValue()) {
                optionals.set(3);
                modified.set(3);
                mDefaultValue = from.getDefaultValue();
            }
            return this;
        }

        /**
         * Set the <code>name</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public InputValue._Builder setName(String value) {
            if (value == null) {
                return clearName();
            }

            optionals.set(0);
            modified.set(0);
            mName = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>name</code> field.
         *
         * @return True if name has been set.
         */
        public boolean isSetName() {
            return optionals.get(0);
        }

        /**
         * Checks for presence of the <code>name</code> field.
         *
         * @return True if name is present.
         */
        public boolean hasName() {
            return true;
        }

        /**
         * Checks if the <code>name</code> field has been modified since the
         * builder was created.
         *
         * @return True if name has been modified.
         */
        public boolean isModifiedName() {
            return modified.get(0);
        }

        /**
         * Clear the <code>name</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public InputValue._Builder clearName() {
            optionals.clear(0);
            modified.set(0);
            mName = kDefaultName;
            return this;
        }

        /**
         * @return The <code>name</code> field value
         */
        public String getName() {
            return isSetName() ? mName : kDefaultName;
        }

        /**
         * Set the <code>description</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public InputValue._Builder setDescription(String value) {
            if (value == null) {
                return clearDescription();
            }

            optionals.set(1);
            modified.set(1);
            mDescription = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>description</code> field.
         *
         * @return True if description has been set.
         */
        public boolean isSetDescription() {
            return optionals.get(1);
        }

        /**
         * Checks for presence of the <code>description</code> field.
         *
         * @return True if description is present.
         */
        public boolean hasDescription() {
            return optionals.get(1);
        }

        /**
         * Checks if the <code>description</code> field has been modified since the
         * builder was created.
         *
         * @return True if description has been modified.
         */
        public boolean isModifiedDescription() {
            return modified.get(1);
        }

        /**
         * Clear the <code>description</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public InputValue._Builder clearDescription() {
            optionals.clear(1);
            modified.set(1);
            mDescription = null;
            return this;
        }

        /**
         * @return The <code>description</code> field value
         */
        public String getDescription() {
            return mDescription;
        }

        /**
         * @return Optional <code>description</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<String> optionalDescription() {
            return java.util.Optional.ofNullable(mDescription);
        }

        /**
         * Set the <code>type</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public InputValue._Builder setType(net.morimekta.providence.graphql.introspection.Type_OrBuilder value) {
            if (value == null) {
                return clearType();
            }

            optionals.set(2);
            modified.set(2);
            if (value instanceof net.morimekta.providence.graphql.introspection.Type._Builder) {
                value = ((net.morimekta.providence.graphql.introspection.Type._Builder) value).build();
            } else if (!(value instanceof net.morimekta.providence.graphql.introspection.Type)) {
                throw new java.lang.IllegalArgumentException("Invalid type for gql_introspection.__Type: " + value.getClass().getName());
            }
            mType = (net.morimekta.providence.graphql.introspection.Type) value;
            mType_builder = null;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>type</code> field.
         *
         * @return True if type has been set.
         */
        public boolean isSetType() {
            return optionals.get(2);
        }

        /**
         * Checks for presence of the <code>type</code> field.
         *
         * @return True if type is present.
         */
        public boolean hasType() {
            return optionals.get(2);
        }

        /**
         * Checks if the <code>type</code> field has been modified since the
         * builder was created.
         *
         * @return True if type has been modified.
         */
        public boolean isModifiedType() {
            return modified.get(2);
        }

        /**
         * Clear the <code>type</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public InputValue._Builder clearType() {
            optionals.clear(2);
            modified.set(2);
            mType = null;
            mType_builder = null;
            return this;
        }

        /**
         * Get the builder for the contained <code>type</code> message field.
         *
         * @return The field message builder
         */
        @javax.annotation.Nonnull
        public net.morimekta.providence.graphql.introspection.Type._Builder mutableType() {
            optionals.set(2);
            modified.set(2);

            if (mType != null) {
                mType_builder = mType.mutate();
                mType = null;
            } else if (mType_builder == null) {
                mType_builder = net.morimekta.providence.graphql.introspection.Type.builder();
            }
            return mType_builder;
        }

        /**
         * @return The <code>type</code> field value
         */
        public net.morimekta.providence.graphql.introspection.Type getType() {
            return mType_builder != null ? mType_builder.build() : mType;
        }

        /**
         * @return Optional <code>type</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<net.morimekta.providence.graphql.introspection.Type> optionalType() {
            return java.util.Optional.ofNullable(mType_builder != null ? mType_builder.build() : mType);
        }

        /**
         * Set the <code>defaultValue</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public InputValue._Builder setDefaultValue(String value) {
            if (value == null) {
                return clearDefaultValue();
            }

            optionals.set(3);
            modified.set(3);
            mDefaultValue = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>defaultValue</code> field.
         *
         * @return True if defaultValue has been set.
         */
        public boolean isSetDefaultValue() {
            return optionals.get(3);
        }

        /**
         * Checks for presence of the <code>defaultValue</code> field.
         *
         * @return True if defaultValue is present.
         */
        public boolean hasDefaultValue() {
            return optionals.get(3);
        }

        /**
         * Checks if the <code>defaultValue</code> field has been modified since the
         * builder was created.
         *
         * @return True if defaultValue has been modified.
         */
        public boolean isModifiedDefaultValue() {
            return modified.get(3);
        }

        /**
         * Clear the <code>defaultValue</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public InputValue._Builder clearDefaultValue() {
            optionals.clear(3);
            modified.set(3);
            mDefaultValue = null;
            return this;
        }

        /**
         * @return The <code>defaultValue</code> field value
         */
        public String getDefaultValue() {
            return mDefaultValue;
        }

        /**
         * @return Optional <code>defaultValue</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<String> optionalDefaultValue() {
            return java.util.Optional.ofNullable(mDefaultValue);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) return true;
            if (o == null || !o.getClass().equals(getClass())) return false;
            InputValue._Builder other = (InputValue._Builder) o;
            return java.util.Objects.equals(optionals, other.optionals) &&
                   java.util.Objects.equals(mName, other.mName) &&
                   java.util.Objects.equals(mDescription, other.mDescription) &&
                   java.util.Objects.equals(getType(), other.getType()) &&
                   java.util.Objects.equals(mDefaultValue, other.mDefaultValue);
        }

        @Override
        public int hashCode() {
            return java.util.Objects.hash(
                    InputValue.class, optionals,
                    InputValue._Field.NAME, mName,
                    InputValue._Field.DESCRIPTION, mDescription,
                    InputValue._Field.TYPE, getType(),
                    InputValue._Field.DEFAULT_VALUE, mDefaultValue);
        }

        @Override
        @SuppressWarnings("unchecked")
        public net.morimekta.providence.PMessageBuilder mutator(int key) {
            switch (key) {
                case 3: return mutableType();
                default: throw new IllegalArgumentException("Not a message field ID: " + key);
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public InputValue._Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setName((String) value); break;
                case 2: setDescription((String) value); break;
                case 3: setType((net.morimekta.providence.graphql.introspection.Type) value); break;
                case 4: setDefaultValue((String) value); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean isSet(int key) {
            switch (key) {
                case 1: return optionals.get(0);
                case 2: return optionals.get(1);
                case 3: return optionals.get(2);
                case 4: return optionals.get(3);
                default: break;
            }
            return false;
        }

        @Override
        public boolean isModified(int key) {
            switch (key) {
                case 1: return modified.get(0);
                case 2: return modified.get(1);
                case 3: return modified.get(2);
                case 4: return modified.get(3);
                default: break;
            }
            return false;
        }

        @Override
        @SuppressWarnings("unchecked")
        public <T> T get(int key) {
            switch(key) {
                case 1: return (T) getName();
                case 2: return (T) getDescription();
                case 3: return (T) getType();
                case 4: return (T) getDefaultValue();
                default: return null;
            }
        }

        @Override
        public boolean has(int key) {
            switch(key) {
                case 1: return true;
                case 2: return mDescription != null;
                case 3: return mType != null || mType_builder != null;
                case 4: return mDefaultValue != null;
                default: return false;
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public InputValue._Builder addTo(int key, Object value) {
            switch (key) {
                default: break;
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public InputValue._Builder clear(int key) {
            switch (key) {
                case 1: clearName(); break;
                case 2: clearDescription(); break;
                case 3: clearType(); break;
                case 4: clearDefaultValue(); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean valid() {
            return optionals.get(0) &&
                   optionals.get(2);
        }

        @Override
        public InputValue._Builder validate() {
            if (!valid()) {
                java.util.ArrayList<String> missing = new java.util.ArrayList<>();

                if (!optionals.get(0)) {
                    missing.add("name");
                }

                if (!optionals.get(2)) {
                    missing.add("type");
                }

                throw new java.lang.IllegalStateException(
                        "Missing required fields " +
                        String.join(",", missing) +
                        " in message gql_introspection.__InputValue");
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PStructDescriptor<InputValue> descriptor() {
            return InputValue.kDescriptor;
        }

        @Override
        public void readBinary(net.morimekta.util.io.BigEndianBinaryReader reader, boolean strict) throws java.io.IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                int field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            mName = new String(reader.expectBytes(len_1), java.nio.charset.StandardCharsets.UTF_8);
                            optionals.set(0);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__InputValue.name, should be struct(12)");
                        }
                        break;
                    }
                    case 2: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            mDescription = new String(reader.expectBytes(len_2), java.nio.charset.StandardCharsets.UTF_8);
                            optionals.set(1);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__InputValue.description, should be struct(12)");
                        }
                        break;
                    }
                    case 3: {
                        if (type == 12) {
                            mType = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.Type.kDescriptor, strict);
                            optionals.set(2);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__InputValue.type, should be struct(12)");
                        }
                        break;
                    }
                    case 4: {
                        if (type == 11) {
                            int len_3 = reader.expectUInt32();
                            mDefaultValue = new String(reader.expectBytes(len_3), java.nio.charset.StandardCharsets.UTF_8);
                            optionals.set(3);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__InputValue.defaultValue, should be struct(12)");
                        }
                        break;
                    }
                    default: {
                        net.morimekta.providence.serializer.binary.BinaryFormatUtils.readFieldValue(reader, new net.morimekta.providence.serializer.binary.BinaryFormatUtils.FieldInfo(field, type), null, false);
                        break;
                    }
                }
                type = reader.expectByte();
            }
        }

        @Override
        @javax.annotation.Nonnull
        public InputValue build() {
            return new InputValue(this);
        }
    }
}
