/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.utils;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.morimekta.providence.graphql.GQLDefinition;
import net.morimekta.providence.graphql.introspection.Type;

abstract class BaseTypeProvider {
    private final GQLDefinition definition;

    BaseTypeProvider(@Nonnull GQLDefinition definition) {
        this.definition = definition;
    }

    Type resolveType(Type type) {
        if (type == null) {
            return null;
        }
        switch (type.getKind()) {
            case NON_NULL: 
            case LIST: {
                return type.mutate().setOfType(this.resolveType(type.getOfType())).build();
            }
            case UNION: 
            case INTERFACE: 
            case OBJECT: 
            case INPUT_OBJECT: {
                return Optional.ofNullable(this.definition.getIntrospectionType(type.getName())).orElse(type);
            }
        }
        return type;
    }
}

