/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.parser;

import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnull;
import net.morimekta.providence.graphql.parser.GQLToken;
import net.morimekta.providence.graphql.parser.GQLTokenType;
import net.morimekta.util.lexer.TokenizerBase;

public class GQLTokenizer
extends TokenizerBase<GQLTokenType, GQLToken> {
    public GQLTokenizer(Reader in) {
        super(in, 2048, true);
    }

    protected GQLToken genericToken(char[] buffer, int offset, int len, @Nonnull GQLTokenType type, int lineNo, int linePos) {
        return new GQLToken(buffer, offset, len, type, lineNo, linePos);
    }

    protected GQLToken identifierToken(char[] buffer, int offset, int len, int lineNo, int linePos) {
        GQLTokenType type = GQLTokenType.IDENTIFIER;
        if (buffer[offset] == '@') {
            type = GQLTokenType.DIRECTIVE;
        } else if (buffer[offset] == '$') {
            type = GQLTokenType.VARIABLE;
        }
        return new GQLToken(buffer, offset, len, type, lineNo, linePos);
    }

    protected GQLToken stringToken(char[] buffer, int offset, int len, int lineNo, int linePos) {
        return new GQLToken(buffer, offset, len, GQLTokenType.STRING, lineNo, linePos);
    }

    protected GQLToken numberToken(char[] buffer, int offset, int len, int lineNo, int linePos) {
        GQLTokenType type = GQLTokenType.INTEGER;
        for (int i = offset; i < offset + len; ++i) {
            if (buffer[i] != '.' && buffer[i] != 'e' && buffer[i] != 'E') continue;
            type = GQLTokenType.FLOAT;
            break;
        }
        return new GQLToken(buffer, offset, len, type, lineNo, linePos);
    }

    protected GQLToken symbolToken(char[] buffer, int offset, int len, int lineNo, int linePos) {
        return new GQLToken(buffer, offset, len, GQLTokenType.SYMBOL, lineNo, linePos);
    }

    protected boolean startNumber() {
        return this.lastChar != 46 && super.startNumber();
    }

    protected boolean startIdentifier() {
        return this.lastChar == 36 || this.lastChar == 64 || super.startIdentifier();
    }

    protected boolean allowIdentifier(int last) {
        return last != 46 && super.allowIdentifier(last);
    }

    protected boolean identifierSeparator(int last) {
        return last == 36 || last == 64;
    }

    @Nonnull
    protected GQLToken nextSymbol() throws IOException {
        if (this.lastChar == 46) {
            GQLToken fail;
            int startOffset = this.bufferOffset;
            int startLinePos = this.linePos;
            int startLineNo = this.lineNo;
            this.readNextChar();
            if (this.lastChar == 46) {
                this.readNextChar();
                if (this.lastChar == 46) {
                    this.lastChar = 0;
                    return this.genericToken(this.buffer, startOffset, 3, GQLTokenType.SYMBOL, startLineNo, startLinePos);
                }
                fail = this.genericToken(this.buffer, startOffset, 3, GQLTokenType.SYMBOL, startLineNo, startLinePos);
            } else {
                fail = this.genericToken(this.buffer, startOffset, 2, GQLTokenType.SYMBOL, startLineNo, startLinePos);
            }
            throw this.failure(fail, "Invalid spread specialization: '%s'", new Object[]{fail.toString()});
        }
        return (GQLToken)super.nextSymbol();
    }
}

