/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.introspection;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptorProvider;

public enum TypeKind implements PEnumValue<TypeKind>
{
    SCALAR(1, "SCALAR"),
    OBJECT(2, "OBJECT"),
    INTERFACE(3, "INTERFACE"),
    UNION(4, "UNION"),
    ENUM(5, "ENUM"),
    INPUT_OBJECT(6, "INPUT_OBJECT"),
    LIST(7, "LIST"),
    NON_NULL(8, "NON_NULL");

    private final int mId;
    private final String mName;
    public static final PEnumDescriptor<TypeKind> kDescriptor;

    private TypeKind(int id, String name) {
        this.mId = id;
        this.mName = name;
    }

    public int asInteger() {
        return this.mId;
    }

    @Nonnull
    public String asString() {
        return this.mName;
    }

    @Nullable
    public static TypeKind findById(Integer id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case 1: {
                return SCALAR;
            }
            case 2: {
                return OBJECT;
            }
            case 3: {
                return INTERFACE;
            }
            case 4: {
                return UNION;
            }
            case 5: {
                return ENUM;
            }
            case 6: {
                return INPUT_OBJECT;
            }
            case 7: {
                return LIST;
            }
            case 8: {
                return NON_NULL;
            }
        }
        return null;
    }

    @Nullable
    public static TypeKind findByName(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "SCALAR": {
                return SCALAR;
            }
            case "OBJECT": {
                return OBJECT;
            }
            case "INTERFACE": {
                return INTERFACE;
            }
            case "UNION": {
                return UNION;
            }
            case "ENUM": {
                return ENUM;
            }
            case "INPUT_OBJECT": {
                return INPUT_OBJECT;
            }
            case "LIST": {
                return LIST;
            }
            case "NON_NULL": {
                return NON_NULL;
            }
        }
        return null;
    }

    @Nonnull
    public static TypeKind valueForId(int id) {
        TypeKind value = TypeKind.findById(id);
        if (value == null) {
            throw new IllegalArgumentException("No gql_introspection.__TypeKind for id " + id);
        }
        return value;
    }

    @Nonnull
    public static TypeKind valueForName(@Nonnull String name) {
        TypeKind value = TypeKind.findByName(name);
        if (value == null) {
            throw new IllegalArgumentException("No gql_introspection.__TypeKind for name \"" + name + "\"");
        }
        return value;
    }

    public PEnumDescriptor<TypeKind> descriptor() {
        return kDescriptor;
    }

    public static PEnumDescriptorProvider<TypeKind> provider() {
        return new PEnumDescriptorProvider(kDescriptor);
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static final class _Descriptor
    extends PEnumDescriptor<TypeKind> {
        public _Descriptor() {
            super("gql_introspection", "__TypeKind", _Builder::new);
        }

        @Nonnull
        public TypeKind[] getValues() {
            return TypeKind.values();
        }

        @Nullable
        public TypeKind findById(int id) {
            return TypeKind.findById(id);
        }

        @Nullable
        public TypeKind findByName(String name) {
            return TypeKind.findByName(name);
        }
    }

    public static final class _Builder
    extends PEnumBuilder<TypeKind> {
        private TypeKind mValue;

        @Nonnull
        public _Builder setById(int value) {
            this.mValue = TypeKind.findById(value);
            return this;
        }

        @Nonnull
        public _Builder setByName(String name) {
            this.mValue = TypeKind.findByName(name);
            return this;
        }

        public boolean valid() {
            return this.mValue != null;
        }

        public TypeKind build() {
            return this.mValue;
        }
    }
}

