/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.introspection;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.graphql.introspection.TypeArguments_OrBuilder;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

@Immutable
public class TypeArguments
implements TypeArguments_OrBuilder,
PMessage<TypeArguments>,
Comparable<TypeArguments>,
BinaryWriter {
    private final transient String mName;
    private volatile transient int tHashCode;
    public static final PStructDescriptor<TypeArguments> kDescriptor = new _Descriptor();

    private TypeArguments(_Builder builder) {
        this.mName = builder.mName;
    }

    @Override
    public boolean hasName() {
        return this.mName != null;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    @Nonnull
    public Optional<String> optionalName() {
        return Optional.ofNullable(this.mName);
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.mName != null;
            }
        }
        return false;
    }

    public <T> T get(int key) {
        switch (key) {
            case 1: {
                return (T)this.mName;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        TypeArguments other = (TypeArguments)o;
        return Objects.equals(this.mName, other.mName);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{TypeArguments.class, _Field.NAME, this.mName});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "gql_introspection.__TypeArguments" + this.asString();
    }

    @Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        if (this.hasName()) {
            out.append("name:").append('\"').append(Strings.escape((CharSequence)this.mName)).append('\"');
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(TypeArguments other) {
        int c = Boolean.compare(this.mName != null, other.mName != null);
        if (c != 0) {
            return c;
        }
        if (this.mName != null && (c = this.mName.compareTo(other.mName)) != 0) {
            return c;
        }
        return 0;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        if (this.hasName()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)1);
            Binary tmp_1 = Binary.wrap((byte[])this.mName.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_1.length());
            length += writer.writeBinary(tmp_1);
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    @Nonnull
    public static PStructDescriptorProvider<TypeArguments> provider() {
        return new _Provider();
    }

    @Nonnull
    public PStructDescriptor<TypeArguments> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<TypeArguments>
    implements TypeArguments_OrBuilder,
    BinaryReader {
        private BitSet optionals = new BitSet(1);
        private BitSet modified = new BitSet(1);
        private String mName;

        public _Builder() {
        }

        public _Builder(TypeArguments base) {
            this();
            if (base.hasName()) {
                this.optionals.set(0);
                this.mName = base.mName;
            }
        }

        @Nonnull
        public _Builder merge(TypeArguments from) {
            if (from.hasName()) {
                this.optionals.set(0);
                this.modified.set(0);
                this.mName = from.getName();
            }
            return this;
        }

        @Nonnull
        public _Builder setName(String value) {
            if (value == null) {
                return this.clearName();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(0);
        }

        @Override
        public boolean hasName() {
            return this.optionals.get(0);
        }

        public boolean isModifiedName() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearName() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mName = null;
            return this;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        @Nonnull
        public Optional<String> optionalName() {
            return Optional.ofNullable(this.mName);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            _Builder other = (_Builder)o;
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mName, other.mName);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{TypeArguments.class, this.optionals, _Field.NAME, this.mName});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                default: 
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setName((String)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
            }
            return false;
        }

        public <T> T get(int key) {
            switch (key) {
                case 1: {
                    return (T)this.getName();
                }
            }
            return null;
        }

        public boolean has(int key) {
            switch (key) {
                case 1: {
                    return this.mName != null;
                }
            }
            return false;
        }

        @Nonnull
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearName();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return true;
        }

        public _Builder validate() {
            return this;
        }

        @Nonnull
        public PStructDescriptor<TypeArguments> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mName = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__TypeArguments.name, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        @Nonnull
        public TypeArguments build() {
            return new TypeArguments(this);
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<TypeArguments> {
        private _Provider() {
        }

        public PStructDescriptor<TypeArguments> descriptor() {
            return kDescriptor;
        }
    }

    private static final class _Descriptor
    extends PStructDescriptor<TypeArguments> {
        public _Descriptor() {
            super("gql_introspection", "__TypeArguments", _Builder::new, true);
        }

        @Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    public static enum _Field implements PField<TypeArguments>
    {
        NAME(1, PRequirement.OPTIONAL, "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null, null);

        private final int mId;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PStructDescriptorProvider mArgumentsProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int id, PRequirement required, String name, PDescriptorProvider typeProvider, PStructDescriptorProvider argumentsProvider, PValueProvider<?> defaultValue) {
            this.mId = id;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mArgumentsProvider = argumentsProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getId() {
            return this.mId;
        }

        @Nonnull
        public PRequirement getRequirement() {
            return this.mRequired;
        }

        @Nonnull
        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        @Nullable
        public PStructDescriptor getArgumentsType() {
            return this.mArgumentsProvider == null ? null : this.mArgumentsProvider.descriptor();
        }

        @Nonnull
        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        @Nullable
        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field findById(int id) {
            switch (id) {
                case 1: {
                    return NAME;
                }
            }
            return null;
        }

        public static _Field findByName(String name) {
            if (name == null) {
                return null;
            }
            switch (name) {
                case "name": {
                    return NAME;
                }
            }
            return null;
        }

        public static _Field fieldForId(int id) {
            _Field field = _Field.findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in gql_introspection.__TypeArguments");
            }
            return field;
        }

        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = _Field.findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__TypeArguments");
            }
            return field;
        }
    }
}

