/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.introspection;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptorProvider;

public enum DirectiveLocation implements PEnumValue<DirectiveLocation>
{
    QUERY(0, "QUERY"),
    MUTATION(1, "MUTATION"),
    SUBSCRIPTION(2, "SUBSCRIPTION"),
    FIELD(3, "FIELD"),
    FRAGMENT_DEFINITION(4, "FRAGMENT_DEFINITION"),
    FRAGMENT_SPREAD(5, "FRAGMENT_SPREAD"),
    INLINE_FRAGMENT(6, "INLINE_FRAGMENT"),
    SCHEMA(7, "SCHEMA"),
    SCALAR(8, "SCALAR"),
    OBJECT(9, "OBJECT"),
    FIELD_DEFINITION(10, "FIELD_DEFINITION"),
    ARGUMENT_DEFINITION(11, "ARGUMENT_DEFINITION"),
    INTERFACE(12, "INTERFACE"),
    UNION(13, "UNION"),
    ENUM(14, "ENUM"),
    ENUM_VALUE(15, "ENUM_VALUE"),
    INPUT_OBJECT(16, "INPUT_OBJECT"),
    INPUT_FIELD_DEFINITION(17, "INPUT_FIELD_DEFINITION");

    private final int mId;
    private final String mName;
    public static final PEnumDescriptor<DirectiveLocation> kDescriptor;

    private DirectiveLocation(int id, String name) {
        this.mId = id;
        this.mName = name;
    }

    public int asInteger() {
        return this.mId;
    }

    @Nonnull
    public String asString() {
        return this.mName;
    }

    @Nullable
    public static DirectiveLocation findById(Integer id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case 0: {
                return QUERY;
            }
            case 1: {
                return MUTATION;
            }
            case 2: {
                return SUBSCRIPTION;
            }
            case 3: {
                return FIELD;
            }
            case 4: {
                return FRAGMENT_DEFINITION;
            }
            case 5: {
                return FRAGMENT_SPREAD;
            }
            case 6: {
                return INLINE_FRAGMENT;
            }
            case 7: {
                return SCHEMA;
            }
            case 8: {
                return SCALAR;
            }
            case 9: {
                return OBJECT;
            }
            case 10: {
                return FIELD_DEFINITION;
            }
            case 11: {
                return ARGUMENT_DEFINITION;
            }
            case 12: {
                return INTERFACE;
            }
            case 13: {
                return UNION;
            }
            case 14: {
                return ENUM;
            }
            case 15: {
                return ENUM_VALUE;
            }
            case 16: {
                return INPUT_OBJECT;
            }
            case 17: {
                return INPUT_FIELD_DEFINITION;
            }
        }
        return null;
    }

    @Nullable
    public static DirectiveLocation findByName(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "QUERY": {
                return QUERY;
            }
            case "MUTATION": {
                return MUTATION;
            }
            case "SUBSCRIPTION": {
                return SUBSCRIPTION;
            }
            case "FIELD": {
                return FIELD;
            }
            case "FRAGMENT_DEFINITION": {
                return FRAGMENT_DEFINITION;
            }
            case "FRAGMENT_SPREAD": {
                return FRAGMENT_SPREAD;
            }
            case "INLINE_FRAGMENT": {
                return INLINE_FRAGMENT;
            }
            case "SCHEMA": {
                return SCHEMA;
            }
            case "SCALAR": {
                return SCALAR;
            }
            case "OBJECT": {
                return OBJECT;
            }
            case "FIELD_DEFINITION": {
                return FIELD_DEFINITION;
            }
            case "ARGUMENT_DEFINITION": {
                return ARGUMENT_DEFINITION;
            }
            case "INTERFACE": {
                return INTERFACE;
            }
            case "UNION": {
                return UNION;
            }
            case "ENUM": {
                return ENUM;
            }
            case "ENUM_VALUE": {
                return ENUM_VALUE;
            }
            case "INPUT_OBJECT": {
                return INPUT_OBJECT;
            }
            case "INPUT_FIELD_DEFINITION": {
                return INPUT_FIELD_DEFINITION;
            }
        }
        return null;
    }

    @Nonnull
    public static DirectiveLocation valueForId(int id) {
        DirectiveLocation value = DirectiveLocation.findById(id);
        if (value == null) {
            throw new IllegalArgumentException("No gql_introspection.__DirectiveLocation for id " + id);
        }
        return value;
    }

    @Nonnull
    public static DirectiveLocation valueForName(@Nonnull String name) {
        DirectiveLocation value = DirectiveLocation.findByName(name);
        if (value == null) {
            throw new IllegalArgumentException("No gql_introspection.__DirectiveLocation for name \"" + name + "\"");
        }
        return value;
    }

    public PEnumDescriptor<DirectiveLocation> descriptor() {
        return kDescriptor;
    }

    public static PEnumDescriptorProvider<DirectiveLocation> provider() {
        return new PEnumDescriptorProvider(kDescriptor);
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static final class _Descriptor
    extends PEnumDescriptor<DirectiveLocation> {
        public _Descriptor() {
            super("gql_introspection", "__DirectiveLocation", _Builder::new);
        }

        @Nonnull
        public DirectiveLocation[] getValues() {
            return DirectiveLocation.values();
        }

        @Nullable
        public DirectiveLocation findById(int id) {
            return DirectiveLocation.findById(id);
        }

        @Nullable
        public DirectiveLocation findByName(String name) {
            return DirectiveLocation.findByName(name);
        }
    }

    public static final class _Builder
    extends PEnumBuilder<DirectiveLocation> {
        private DirectiveLocation mValue;

        @Nonnull
        public _Builder setById(int value) {
            this.mValue = DirectiveLocation.findById(value);
            return this;
        }

        @Nonnull
        public _Builder setByName(String name) {
            this.mValue = DirectiveLocation.findByName(name);
            return this;
        }

        public boolean valid() {
            return this.mValue != null;
        }

        public DirectiveLocation build() {
            return this.mValue;
        }
    }
}

