/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.gql;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.graphql.gql.GQLField;
import net.morimekta.providence.graphql.gql.GQLFragment;
import net.morimekta.util.collect.UnmodifiableList;

public interface GQLSelection {
    @Nullable
    public List<GQLSelection> getSelectionSet();

    default public boolean hasSelection(PField ... fields) {
        if (this.getSelectionSet() == null) {
            return true;
        }
        if (fields.length == 0) {
            return false;
        }
        for (GQLSelection sel : this.getSelectionSet()) {
            GQLFragment fragment;
            if (sel instanceof GQLField) {
                GQLField sf = (GQLField)sel;
                for (PField field : fields) {
                    if (sf.getField() != field) continue;
                    return true;
                }
                continue;
            }
            if (!(sel instanceof GQLFragment) || !(fragment = (GQLFragment)sel).hasSelection(fields)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    default public List<GQLSelection> getSelection(@Nonnull PField field) {
        if (this.getSelectionSet() == null) {
            return UnmodifiableList.listOf();
        }
        ArrayList<GQLSelection> selection = new ArrayList<GQLSelection>();
        for (GQLSelection sel : this.getSelectionSet()) {
            if (sel instanceof GQLField) {
                GQLField sf = (GQLField)sel;
                if (!field.equals(sf.getField())) continue;
                selection.add(sf);
                continue;
            }
            if (!(sel instanceof GQLFragment)) continue;
            GQLFragment fragment = (GQLFragment)sel;
            selection.addAll(fragment.getSelection(field));
        }
        return UnmodifiableList.copyOf(selection);
    }
}

