/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.gql;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.graphql.gql.GQLMethodCall;
import net.morimekta.providence.graphql.gql.GQLSelection;
import net.morimekta.util.collect.UnmodifiableList;

@Immutable
public class GQLOperation
implements GQLSelection {
    private final PService service;
    private final List<GQLSelection> selectionSet;
    private final boolean mutation;
    private final String name;

    public GQLOperation(@Nonnull PService service, boolean mutation, @Nullable String name, @Nonnull List<GQLSelection> selectionSet) {
        this.service = service;
        this.mutation = mutation;
        this.name = name;
        this.selectionSet = selectionSet;
    }

    public boolean isMutation() {
        return this.mutation;
    }

    public boolean hasMethodCall(PServiceMethod method) {
        for (GQLSelection selection : this.selectionSet) {
            GQLMethodCall call;
            if (!(selection instanceof GQLMethodCall) || !(call = (GQLMethodCall)selection).getMethod().equals(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSelection(PField ... fields) {
        return false;
    }

    @Override
    @Nonnull
    public List<GQLSelection> getSelection(@Nonnull PField field) {
        return UnmodifiableList.listOf();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nonnull
    public PService getService() {
        return this.service;
    }

    @Override
    @Nonnull
    public List<GQLSelection> getSelectionSet() {
        return this.selectionSet;
    }

    public int hashCode() {
        return Objects.hash(GQLOperation.class, this.name, this.service, this.selectionSet);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.name != null) {
            if (this.mutation) {
                builder.append("mutation ");
            } else {
                builder.append("query ");
            }
            builder.append(this.name);
            builder.append(" ");
        }
        builder.append("{");
        boolean first = true;
        for (GQLSelection selection : this.selectionSet) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(selection.toString());
        }
        builder.append("}");
        return builder.toString();
    }
}

