/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.gql;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.graphql.gql.GQLFragment;
import net.morimekta.providence.graphql.gql.GQLSelection;
import net.morimekta.util.collect.UnmodifiableList;

@Immutable
public class GQLInlineFragment
implements GQLFragment {
    private final PMessageDescriptor<?> descriptor;
    private final List<GQLSelection> selectionSet;

    public GQLInlineFragment(@Nonnull PMessageDescriptor<?> descriptor, @Nonnull List<GQLSelection> selectionSet) {
        this.descriptor = descriptor;
        this.selectionSet = UnmodifiableList.copyOf(selectionSet);
    }

    @Override
    @Nonnull
    public PMessageDescriptor<?> getTypeCondition() {
        return this.descriptor;
    }

    @Override
    @Nonnull
    public List<GQLSelection> getSelectionSet() {
        return this.selectionSet;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("... on ").append(this.descriptor.getName()).append(" {");
        boolean first = true;
        for (GQLSelection entry : this.selectionSet) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(entry.toString());
        }
        builder.append("}");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.descriptor, this.selectionSet);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GQLInlineFragment)) {
            return false;
        }
        GQLInlineFragment other = (GQLInlineFragment)o;
        return Objects.equals(this.descriptor, other.descriptor) && Objects.equals(this.selectionSet, other.selectionSet);
    }
}

