/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.gql;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.graphql.gql.GQLSelection;
import net.morimekta.providence.graphql.gql.GQLUtil;
import net.morimekta.util.collect.UnmodifiableList;

@Immutable
public class GQLField
implements GQLSelection {
    private final String alias;
    private final PField field;
    private final PMessage<?> arguments;
    private final List<GQLSelection> selectionSet;

    public GQLField(@Nonnull PField field) {
        this(field, null, null, null);
    }

    public GQLField(@Nonnull PField field, @Nullable List<GQLSelection> selectionSet) {
        this(field, null, null, selectionSet);
    }

    public GQLField(@Nonnull PField field, @Nullable String alias, @Nullable PMessage<?> arguments, @Nullable List<GQLSelection> selectionSet) {
        this.alias = alias;
        this.field = field;
        this.arguments = arguments;
        this.selectionSet = selectionSet != null && selectionSet.size() > 0 ? UnmodifiableList.copyOf(selectionSet) : null;
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @Nullable
    public PField getField() {
        return this.field;
    }

    @Nullable
    public <M extends PMessage<M>> M getArguments() {
        return (M)this.arguments;
    }

    @Override
    @Nullable
    public List<GQLSelection> getSelectionSet() {
        return this.selectionSet;
    }

    public String toString() {
        boolean first;
        StringBuilder builder = new StringBuilder();
        if (this.alias != null) {
            builder.append(this.alias).append(": ");
        }
        builder.append(this.field.getName());
        if (this.arguments != null) {
            builder.append("(");
            first = true;
            for (PField pf : this.arguments.descriptor().getFields()) {
                if (!this.arguments.has(pf.getId())) continue;
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append(pf.getName()).append(": ").append(GQLUtil.toArgumentString(this.arguments.get(pf.getId())));
            }
            builder.append(")");
        }
        if (this.selectionSet != null && this.selectionSet.size() > 0) {
            if (this.arguments != null) {
                builder.append(" ");
            }
            builder.append("{");
            first = true;
            for (GQLSelection field : this.selectionSet) {
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append(field.toString());
            }
            builder.append("}");
        }
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(GQLField.class, this.alias, this.field, this.arguments, this.selectionSet);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GQLField)) {
            return false;
        }
        GQLField other = (GQLField)o;
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.field, other.field) && Objects.equals(this.arguments, other.arguments) && Objects.equals(this.selectionSet, other.selectionSet);
    }
}

