package net.morimekta.providence.graphql.introspection;

@SuppressWarnings("unused")
@javax.annotation.Generated(
        value = "net.morimekta.providence:providence-generator-java",
        comments = "java")
@javax.annotation.concurrent.Immutable
public class Field
        implements Field_OrBuilder,
                   net.morimekta.providence.PMessage<Field>,
                   Comparable<Field>,
                   net.morimekta.providence.serializer.binary.BinaryWriter {
    private final static String kDefaultName = "";
    private final static java.util.List<net.morimekta.providence.graphql.introspection.InputValue> kDefaultArgs = new net.morimekta.providence.descriptor.PList.DefaultBuilder<net.morimekta.providence.graphql.introspection.InputValue>()
                .build();
    private final static boolean kDefaultIsDeprecated = false;

    private final transient String mName;
    private final transient String mDescription;
    private final transient java.util.List<net.morimekta.providence.graphql.introspection.InputValue> mArgs;
    private final transient net.morimekta.providence.graphql.introspection.Type mType;
    private final transient boolean mIsDeprecated;
    private final transient String mDeprecationReason;

    private volatile transient int tHashCode;

    private Field(_Builder builder) {
        if (builder.isSetName()) {
            mName = builder.mName;
        } else {
            mName = kDefaultName;
        }
        mDescription = builder.mDescription;
        if (builder.isSetArgs()) {
            mArgs = net.morimekta.util.collect.UnmodifiableList.copyOf(builder.mArgs);
        } else {
            mArgs = kDefaultArgs;
        }
        mType = builder.mType_builder != null ? builder.mType_builder.build() : builder.mType;
        mIsDeprecated = builder.mIsDeprecated;
        mDeprecationReason = builder.mDeprecationReason;
    }

    public boolean hasName() {
        return true;
    }

    /**
     * @return The <code>name</code> value
     */
    @javax.annotation.Nonnull
    public String getName() {
        return mName;
    }

    public boolean hasDescription() {
        return mDescription != null;
    }

    /**
     * @return The <code>description</code> value
     */
    public String getDescription() {
        return mDescription;
    }

    /**
     * @return Optional of the <code>description</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<String> optionalDescription() {
        return java.util.Optional.ofNullable(mDescription);
    }

    public int numArgs() {
        return mArgs != null ? mArgs.size() : 0;
    }

    public boolean hasArgs() {
        return true;
    }

    /**
     * @return The <code>args</code> value
     */
    @javax.annotation.Nonnull
    public java.util.List<net.morimekta.providence.graphql.introspection.InputValue> getArgs() {
        return mArgs;
    }

    public boolean hasType() {
        return mType != null;
    }

    /**
     * @return The <code>type</code> value
     */
    public net.morimekta.providence.graphql.introspection.Type getType() {
        return mType;
    }

    /**
     * @return Optional of the <code>type</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<net.morimekta.providence.graphql.introspection.Type> optionalType() {
        return java.util.Optional.ofNullable(mType);
    }

    public boolean hasIsDeprecated() {
        return true;
    }

    /**
     * @return The <code>isDeprecated</code> value
     */
    public boolean isIsDeprecated() {
        return mIsDeprecated;
    }

    public boolean hasDeprecationReason() {
        return mDeprecationReason != null;
    }

    /**
     * @return The <code>deprecationReason</code> value
     */
    public String getDeprecationReason() {
        return mDeprecationReason;
    }

    /**
     * @return Optional of the <code>deprecationReason</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<String> optionalDeprecationReason() {
        return java.util.Optional.ofNullable(mDeprecationReason);
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return true;
            case 2: return mDescription != null;
            case 3: return true;
            case 4: return mType != null;
            case 5: return true;
            case 6: return mDeprecationReason != null;
            default: return false;
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T> T get(int key) {
        switch(key) {
            case 1: return (T) mName;
            case 2: return (T) mDescription;
            case 3: return (T) mArgs;
            case 4: return (T) mType;
            case 5: return (T) (Boolean) mIsDeprecated;
            case 6: return (T) mDeprecationReason;
            default: return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) return true;
        if (o == null || !o.getClass().equals(getClass())) return false;
        Field other = (Field) o;
        return java.util.Objects.equals(mName, other.mName) &&
               java.util.Objects.equals(mDescription, other.mDescription) &&
               java.util.Objects.equals(mArgs, other.mArgs) &&
               java.util.Objects.equals(mType, other.mType) &&
               java.util.Objects.equals(mIsDeprecated, other.mIsDeprecated) &&
               java.util.Objects.equals(mDeprecationReason, other.mDeprecationReason);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = java.util.Objects.hash(
                    Field.class,
                    _Field.NAME, mName,
                    _Field.DESCRIPTION, mDescription,
                    _Field.ARGS, mArgs,
                    _Field.TYPE, mType,
                    _Field.IS_DEPRECATED, mIsDeprecated,
                    _Field.DEPRECATION_REASON, mDeprecationReason);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "gql_introspection.__Field" + asString();
    }

    @Override
    @javax.annotation.Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        out.append("name:")
           .append('\"')
           .append(net.morimekta.util.Strings.escape(mName))
           .append('\"');
        if (hasDescription()) {
            out.append(',');
            out.append("description:")
               .append('\"')
               .append(net.morimekta.util.Strings.escape(mDescription))
               .append('\"');
        }
        out.append(',');
        out.append("args:")
           .append(net.morimekta.util.Strings.asString(mArgs));
        if (hasType()) {
            out.append(',');
            out.append("type:")
               .append(mType.asString());
        }
        out.append(',');
        out.append("isDeprecated:")
           .append(mIsDeprecated);
        if (hasDeprecationReason()) {
            out.append(',');
            out.append("deprecationReason:")
               .append('\"')
               .append(net.morimekta.util.Strings.escape(mDeprecationReason))
               .append('\"');
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Field other) {
        int c;

        c = mName.compareTo(other.mName);
        if (c != 0) return c;

        c = Boolean.compare(mDescription != null, other.mDescription != null);
        if (c != 0) return c;
        if (mDescription != null) {
            c = mDescription.compareTo(other.mDescription);
            if (c != 0) return c;
        }

        c = Integer.compare(mArgs.hashCode(), other.mArgs.hashCode());
        if (c != 0) return c;

        c = Boolean.compare(mType != null, other.mType != null);
        if (c != 0) return c;
        if (mType != null) {
            c = mType.compareTo(other.mType);
            if (c != 0) return c;
        }

        c = Boolean.compare(mIsDeprecated, other.mIsDeprecated);
        if (c != 0) return c;

        c = Boolean.compare(mDeprecationReason != null, other.mDeprecationReason != null);
        if (c != 0) return c;
        if (mDeprecationReason != null) {
            c = mDeprecationReason.compareTo(other.mDeprecationReason);
            if (c != 0) return c;
        }

        return 0;
    }

    @Override
    public int writeBinary(net.morimekta.util.io.BigEndianBinaryWriter writer) throws java.io.IOException {
        int length = 0;

        length += writer.writeByte((byte) 11);
        length += writer.writeShort((short) 1);
        net.morimekta.util.Binary tmp_1 = net.morimekta.util.Binary.wrap(mName.getBytes(java.nio.charset.StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_1.length());
        length += writer.writeBinary(tmp_1);

        if (hasDescription()) {
            length += writer.writeByte((byte) 11);
            length += writer.writeShort((short) 2);
            net.morimekta.util.Binary tmp_2 = net.morimekta.util.Binary.wrap(mDescription.getBytes(java.nio.charset.StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }

        length += writer.writeByte((byte) 15);
        length += writer.writeShort((short) 3);
        length += writer.writeByte((byte) 12);
        length += writer.writeUInt32(mArgs.size());
        for (net.morimekta.providence.graphql.introspection.InputValue entry_3 : mArgs) {
            length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, entry_3);
        }

        if (hasType()) {
            length += writer.writeByte((byte) 12);
            length += writer.writeShort((short) 4);
            length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, mType);
        }

        length += writer.writeByte((byte) 2);
        length += writer.writeShort((short) 5);
        length += writer.writeUInt8(mIsDeprecated ? (byte) 1 : (byte) 0);

        if (hasDeprecationReason()) {
            length += writer.writeByte((byte) 11);
            length += writer.writeShort((short) 6);
            net.morimekta.util.Binary tmp_4 = net.morimekta.util.Binary.wrap(mDeprecationReason.getBytes(java.nio.charset.StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_4.length());
            length += writer.writeBinary(tmp_4);
        }

        length += writer.writeByte((byte) 0);
        return length;
    }

    @javax.annotation.Nonnull
    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public enum _Field implements net.morimekta.providence.descriptor.PField<Field> {
        NAME(1, net.morimekta.providence.descriptor.PRequirement.REQUIRED, "name", net.morimekta.providence.descriptor.PPrimitive.STRING.provider(), null, null),
        DESCRIPTION(2, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "description", net.morimekta.providence.descriptor.PPrimitive.STRING.provider(), null, null),
        ARGS(3, net.morimekta.providence.descriptor.PRequirement.REQUIRED, "args", net.morimekta.providence.descriptor.PList.provider(net.morimekta.providence.graphql.introspection.InputValue.provider()), null, new net.morimekta.providence.descriptor.PDefaultValueProvider<>(kDefaultArgs)),
        TYPE(4, net.morimekta.providence.descriptor.PRequirement.REQUIRED, "type", net.morimekta.providence.graphql.introspection.Type.provider(), null, null),
        IS_DEPRECATED(5, net.morimekta.providence.descriptor.PRequirement.REQUIRED, "isDeprecated", net.morimekta.providence.descriptor.PPrimitive.BOOL.provider(), null, null),
        DEPRECATION_REASON(6, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "deprecationReason", net.morimekta.providence.descriptor.PPrimitive.STRING.provider(), null, null),
        ;

        private final int mId;
        private final net.morimekta.providence.descriptor.PRequirement mRequired;
        private final String mName;
        private final net.morimekta.providence.descriptor.PDescriptorProvider mTypeProvider;
        private final net.morimekta.providence.descriptor.PStructDescriptorProvider mArgumentsProvider;
        private final net.morimekta.providence.descriptor.PValueProvider<?> mDefaultValue;

        _Field(int id, net.morimekta.providence.descriptor.PRequirement required, String name, net.morimekta.providence.descriptor.PDescriptorProvider typeProvider, net.morimekta.providence.descriptor.PStructDescriptorProvider argumentsProvider, net.morimekta.providence.descriptor.PValueProvider<?> defaultValue) {
            mId = id;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mArgumentsProvider = argumentsProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public int getId() { return mId; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PRequirement getRequirement() { return mRequired; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PDescriptor getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        @javax.annotation.Nullable
        public net.morimekta.providence.descriptor.PStructDescriptor getArgumentsType() { return mArgumentsProvider == null ? null : mArgumentsProvider.descriptor(); }

        @javax.annotation.Nonnull
        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        @javax.annotation.Nullable
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            return net.morimekta.providence.descriptor.PField.asString(this);
        }

        /**
         * @param id Field name
         * @return The identified field or null
         */
        public static _Field findById(int id) {
            switch (id) {
                case 1: return _Field.NAME;
                case 2: return _Field.DESCRIPTION;
                case 3: return _Field.ARGS;
                case 4: return _Field.TYPE;
                case 5: return _Field.IS_DEPRECATED;
                case 6: return _Field.DEPRECATION_REASON;
            }
            return null;
        }

        /**
         * @param name Field name
         * @return The named field or null
         */
        public static _Field findByName(String name) {
            if (name == null) return null;
            switch (name) {
                case "name": return _Field.NAME;
                case "description": return _Field.DESCRIPTION;
                case "args": return _Field.ARGS;
                case "type": return _Field.TYPE;
                case "isDeprecated": return _Field.IS_DEPRECATED;
                case "deprecationReason": return _Field.DEPRECATION_REASON;
            }
            return null;
        }

        /**
         * @param id Field name
         * @return The identified field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForId(int id) {
            _Field field = findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in gql_introspection.__Field");
            }
            return field;
        }

        /**
         * @param name Field name
         * @return The named field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__Field");
            }
            return field;
        }

    }

    @javax.annotation.Nonnull
    public static net.morimekta.providence.descriptor.PStructDescriptorProvider<Field> provider() {
        return new _Provider();
    }

    @Override
    @javax.annotation.Nonnull
    public net.morimekta.providence.descriptor.PStructDescriptor<Field> descriptor() {
        return kDescriptor;
    }

    public static final net.morimekta.providence.descriptor.PStructDescriptor<Field> kDescriptor;

    private static final class _Descriptor
            extends net.morimekta.providence.descriptor.PStructDescriptor<Field> {
        public _Descriptor() {
            super("gql_introspection", "__Field", _Builder::new, false);
        }

        @Override
        @javax.annotation.Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static final class _Provider extends net.morimekta.providence.descriptor.PStructDescriptorProvider<Field> {
        @Override
        public net.morimekta.providence.descriptor.PStructDescriptor<Field> descriptor() {
            return kDescriptor;
        }
    }

    /**
     * Make a <code>gql_introspection.__Field</code> builder.
     * @return The builder instance.
     */
    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends net.morimekta.providence.PMessageBuilder<Field>
            implements Field_OrBuilder,
                       net.morimekta.providence.serializer.binary.BinaryReader {
        private java.util.BitSet optionals;
        private java.util.BitSet modified;

        private String mName;
        private String mDescription;
        private java.util.List<net.morimekta.providence.graphql.introspection.InputValue> mArgs;
        private net.morimekta.providence.graphql.introspection.Type mType;
        private net.morimekta.providence.graphql.introspection.Type._Builder mType_builder;
        private boolean mIsDeprecated;
        private String mDeprecationReason;

        /**
         * Make a gql_introspection.__Field builder instance.
         */
        public _Builder() {
            optionals = new java.util.BitSet(6);
            modified = new java.util.BitSet(6);
            mName = kDefaultName;
            mArgs = kDefaultArgs;
            mIsDeprecated = kDefaultIsDeprecated;
        }

        /**
         * Make a mutating builder off a base gql_introspection.__Field.
         *
         * @param base The base __Field
         */
        public _Builder(Field base) {
            this();

            optionals.set(0);
            mName = base.mName;
            if (base.hasDescription()) {
                optionals.set(1);
                mDescription = base.mDescription;
            }
            optionals.set(2);
            mArgs = base.mArgs;
            if (base.hasType()) {
                optionals.set(3);
                mType = base.mType;
            }
            optionals.set(4);
            mIsDeprecated = base.mIsDeprecated;
            if (base.hasDeprecationReason()) {
                optionals.set(5);
                mDeprecationReason = base.mDeprecationReason;
            }
        }

        @javax.annotation.Nonnull
        @Override
        public Field._Builder merge(Field from) {
            optionals.set(0);
            modified.set(0);
            mName = from.getName();

            if (from.hasDescription()) {
                optionals.set(1);
                modified.set(1);
                mDescription = from.getDescription();
            }

            optionals.set(2);
            modified.set(2);
            mArgs = from.getArgs();

            if (from.hasType()) {
                optionals.set(3);
                modified.set(3);
                if (mType_builder != null) {
                    mType_builder.merge(from.getType());
                } else if (mType != null) {
                    mType_builder = mType.mutate().merge(from.getType());
                    mType = null;
                } else {
                    mType = from.getType();
                }
            }

            optionals.set(4);
            modified.set(4);
            mIsDeprecated = from.isIsDeprecated();

            if (from.hasDeprecationReason()) {
                optionals.set(5);
                modified.set(5);
                mDeprecationReason = from.getDeprecationReason();
            }
            return this;
        }

        /**
         * Set the <code>name</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder setName(String value) {
            if (value == null) {
                return clearName();
            }

            optionals.set(0);
            modified.set(0);
            mName = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>name</code> field.
         *
         * @return True if name has been set.
         */
        public boolean isSetName() {
            return optionals.get(0);
        }

        /**
         * Checks for presence of the <code>name</code> field.
         *
         * @return True if name is present.
         */
        public boolean hasName() {
            return true;
        }

        /**
         * Checks if the <code>name</code> field has been modified since the
         * builder was created.
         *
         * @return True if name has been modified.
         */
        public boolean isModifiedName() {
            return modified.get(0);
        }

        /**
         * Clear the <code>name</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder clearName() {
            optionals.clear(0);
            modified.set(0);
            mName = kDefaultName;
            return this;
        }

        /**
         * @return The <code>name</code> field value
         */
        public String getName() {
            return isSetName() ? mName : kDefaultName;
        }

        /**
         * Set the <code>description</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder setDescription(String value) {
            if (value == null) {
                return clearDescription();
            }

            optionals.set(1);
            modified.set(1);
            mDescription = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>description</code> field.
         *
         * @return True if description has been set.
         */
        public boolean isSetDescription() {
            return optionals.get(1);
        }

        /**
         * Checks for presence of the <code>description</code> field.
         *
         * @return True if description is present.
         */
        public boolean hasDescription() {
            return optionals.get(1);
        }

        /**
         * Checks if the <code>description</code> field has been modified since the
         * builder was created.
         *
         * @return True if description has been modified.
         */
        public boolean isModifiedDescription() {
            return modified.get(1);
        }

        /**
         * Clear the <code>description</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder clearDescription() {
            optionals.clear(1);
            modified.set(1);
            mDescription = null;
            return this;
        }

        /**
         * @return The <code>description</code> field value
         */
        public String getDescription() {
            return mDescription;
        }

        /**
         * @return Optional <code>description</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<String> optionalDescription() {
            return java.util.Optional.ofNullable(mDescription);
        }

        /**
         * Set the <code>args</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder setArgs(java.util.Collection<net.morimekta.providence.graphql.introspection.InputValue> value) {
            if (value == null) {
                return clearArgs();
            }

            optionals.set(2);
            modified.set(2);
            mArgs = net.morimekta.util.collect.UnmodifiableList.copyOf(value);
            return this;
        }

        /**
         * Adds entries to the <code>args</code> list.
         *
         * @param values The added value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder addToArgs(net.morimekta.providence.graphql.introspection.InputValue... values) {
            optionals.set(2);
            modified.set(2);
            java.util.List<net.morimekta.providence.graphql.introspection.InputValue> _container = mutableArgs();
            for (net.morimekta.providence.graphql.introspection.InputValue item : values) {
                _container.add(item);
            }
            return this;
        }

        /**
         * Checks for explicit presence of the <code>args</code> field.
         *
         * @return True if args has been set.
         */
        public boolean isSetArgs() {
            return optionals.get(2);
        }

        /**
         * Checks for presence of the <code>args</code> field.
         *
         * @return True if args is present.
         */
        public boolean hasArgs() {
            return true;
        }

        /**
         * Checks if the <code>args</code> field has been modified since the
         * builder was created.
         *
         * @return True if args has been modified.
         */
        public boolean isModifiedArgs() {
            return modified.get(2);
        }

        /**
         * Clear the <code>args</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder clearArgs() {
            optionals.clear(2);
            modified.set(2);
            mArgs = kDefaultArgs;
            return this;
        }

        /**
         * @return The mutable <code>args</code> container
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.InputValue> mutableArgs() {
            optionals.set(2);
            modified.set(2);

            if (mArgs == null) {
                mArgs = new java.util.ArrayList<>();
            } else if (!(mArgs instanceof java.util.ArrayList)) {
                mArgs = new java.util.ArrayList<>(mArgs);
            }
            return mArgs;
        }

        /**
         * @return The <code>args</code> field value
         */
        public java.util.List<net.morimekta.providence.graphql.introspection.InputValue> getArgs() {
            return isSetArgs() ? mArgs : kDefaultArgs;
        }

        /**
         * @return Number of entries in <code>args</code>.
         */
        public int numArgs() {
            return mArgs != null ? mArgs.size() : 0;
        }

        /**
         * Set the <code>type</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder setType(net.morimekta.providence.graphql.introspection.Type_OrBuilder value) {
            if (value == null) {
                return clearType();
            }

            optionals.set(3);
            modified.set(3);
            if (value instanceof net.morimekta.providence.graphql.introspection.Type._Builder) {
                value = ((net.morimekta.providence.graphql.introspection.Type._Builder) value).build();
            } else if (!(value instanceof net.morimekta.providence.graphql.introspection.Type)) {
                throw new java.lang.IllegalArgumentException("Invalid type for gql_introspection.__Type: " + value.getClass().getName());
            }
            mType = (net.morimekta.providence.graphql.introspection.Type) value;
            mType_builder = null;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>type</code> field.
         *
         * @return True if type has been set.
         */
        public boolean isSetType() {
            return optionals.get(3);
        }

        /**
         * Checks for presence of the <code>type</code> field.
         *
         * @return True if type is present.
         */
        public boolean hasType() {
            return optionals.get(3);
        }

        /**
         * Checks if the <code>type</code> field has been modified since the
         * builder was created.
         *
         * @return True if type has been modified.
         */
        public boolean isModifiedType() {
            return modified.get(3);
        }

        /**
         * Clear the <code>type</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder clearType() {
            optionals.clear(3);
            modified.set(3);
            mType = null;
            mType_builder = null;
            return this;
        }

        /**
         * Get the builder for the contained <code>type</code> message field.
         *
         * @return The field message builder
         */
        @javax.annotation.Nonnull
        public net.morimekta.providence.graphql.introspection.Type._Builder mutableType() {
            optionals.set(3);
            modified.set(3);

            if (mType != null) {
                mType_builder = mType.mutate();
                mType = null;
            } else if (mType_builder == null) {
                mType_builder = net.morimekta.providence.graphql.introspection.Type.builder();
            }
            return mType_builder;
        }

        /**
         * @return The <code>type</code> field value
         */
        public net.morimekta.providence.graphql.introspection.Type getType() {
            return mType_builder != null ? mType_builder.build() : mType;
        }

        /**
         * @return Optional <code>type</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<net.morimekta.providence.graphql.introspection.Type> optionalType() {
            return java.util.Optional.ofNullable(mType_builder != null ? mType_builder.build() : mType);
        }

        /**
         * Set the <code>isDeprecated</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder setIsDeprecated(Boolean value) {
            if (value == null) {
                return clearIsDeprecated();
            }

            optionals.set(4);
            modified.set(4);
            mIsDeprecated = value;
            return this;
        }

        /**
         * Set the <code>isDeprecated</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder setIsDeprecated(boolean value) {
            optionals.set(4);
            modified.set(4);
            mIsDeprecated = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>isDeprecated</code> field.
         *
         * @return True if isDeprecated has been set.
         */
        public boolean isSetIsDeprecated() {
            return optionals.get(4);
        }

        /**
         * Checks for presence of the <code>isDeprecated</code> field.
         *
         * @return True if isDeprecated is present.
         */
        public boolean hasIsDeprecated() {
            return true;
        }

        /**
         * Checks if the <code>isDeprecated</code> field has been modified since the
         * builder was created.
         *
         * @return True if isDeprecated has been modified.
         */
        public boolean isModifiedIsDeprecated() {
            return modified.get(4);
        }

        /**
         * Clear the <code>isDeprecated</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder clearIsDeprecated() {
            optionals.clear(4);
            modified.set(4);
            mIsDeprecated = kDefaultIsDeprecated;
            return this;
        }

        /**
         * @return The <code>isDeprecated</code> field value
         */
        public boolean isIsDeprecated() {
            return isSetIsDeprecated() ? mIsDeprecated : kDefaultIsDeprecated;
        }

        /**
         * Set the <code>deprecationReason</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder setDeprecationReason(String value) {
            if (value == null) {
                return clearDeprecationReason();
            }

            optionals.set(5);
            modified.set(5);
            mDeprecationReason = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>deprecationReason</code> field.
         *
         * @return True if deprecationReason has been set.
         */
        public boolean isSetDeprecationReason() {
            return optionals.get(5);
        }

        /**
         * Checks for presence of the <code>deprecationReason</code> field.
         *
         * @return True if deprecationReason is present.
         */
        public boolean hasDeprecationReason() {
            return optionals.get(5);
        }

        /**
         * Checks if the <code>deprecationReason</code> field has been modified since the
         * builder was created.
         *
         * @return True if deprecationReason has been modified.
         */
        public boolean isModifiedDeprecationReason() {
            return modified.get(5);
        }

        /**
         * Clear the <code>deprecationReason</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Field._Builder clearDeprecationReason() {
            optionals.clear(5);
            modified.set(5);
            mDeprecationReason = null;
            return this;
        }

        /**
         * @return The <code>deprecationReason</code> field value
         */
        public String getDeprecationReason() {
            return mDeprecationReason;
        }

        /**
         * @return Optional <code>deprecationReason</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<String> optionalDeprecationReason() {
            return java.util.Optional.ofNullable(mDeprecationReason);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) return true;
            if (o == null || !o.getClass().equals(getClass())) return false;
            Field._Builder other = (Field._Builder) o;
            return java.util.Objects.equals(optionals, other.optionals) &&
                   java.util.Objects.equals(mName, other.mName) &&
                   java.util.Objects.equals(mDescription, other.mDescription) &&
                   java.util.Objects.equals(mArgs, other.mArgs) &&
                   java.util.Objects.equals(getType(), other.getType()) &&
                   java.util.Objects.equals(mIsDeprecated, other.mIsDeprecated) &&
                   java.util.Objects.equals(mDeprecationReason, other.mDeprecationReason);
        }

        @Override
        public int hashCode() {
            return java.util.Objects.hash(
                    Field.class, optionals,
                    Field._Field.NAME, mName,
                    Field._Field.DESCRIPTION, mDescription,
                    Field._Field.ARGS, mArgs,
                    Field._Field.TYPE, getType(),
                    Field._Field.IS_DEPRECATED, mIsDeprecated,
                    Field._Field.DEPRECATION_REASON, mDeprecationReason);
        }

        @Override
        @SuppressWarnings("unchecked")
        public net.morimekta.providence.PMessageBuilder mutator(int key) {
            switch (key) {
                case 4: return mutableType();
                default: throw new IllegalArgumentException("Not a message field ID: " + key);
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public Field._Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setName((String) value); break;
                case 2: setDescription((String) value); break;
                case 3: setArgs((java.util.List<net.morimekta.providence.graphql.introspection.InputValue>) value); break;
                case 4: setType((net.morimekta.providence.graphql.introspection.Type) value); break;
                case 5: setIsDeprecated((boolean) value); break;
                case 6: setDeprecationReason((String) value); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean isSet(int key) {
            switch (key) {
                case 1: return optionals.get(0);
                case 2: return optionals.get(1);
                case 3: return optionals.get(2);
                case 4: return optionals.get(3);
                case 5: return optionals.get(4);
                case 6: return optionals.get(5);
                default: break;
            }
            return false;
        }

        @Override
        public boolean isModified(int key) {
            switch (key) {
                case 1: return modified.get(0);
                case 2: return modified.get(1);
                case 3: return modified.get(2);
                case 4: return modified.get(3);
                case 5: return modified.get(4);
                case 6: return modified.get(5);
                default: break;
            }
            return false;
        }

        @Override
        @SuppressWarnings("unchecked")
        public <T> T get(int key) {
            switch(key) {
                case 1: return (T) getName();
                case 2: return (T) getDescription();
                case 3: return (T) getArgs();
                case 4: return (T) getType();
                case 5: return (T) (Object) isIsDeprecated();
                case 6: return (T) getDeprecationReason();
                default: return null;
            }
        }

        @Override
        public boolean has(int key) {
            switch(key) {
                case 1: return true;
                case 2: return mDescription != null;
                case 3: return true;
                case 4: return mType != null || mType_builder != null;
                case 5: return true;
                case 6: return mDeprecationReason != null;
                default: return false;
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public Field._Builder addTo(int key, Object value) {
            switch (key) {
                case 3: addToArgs((net.morimekta.providence.graphql.introspection.InputValue) value); break;
                default: break;
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public Field._Builder clear(int key) {
            switch (key) {
                case 1: clearName(); break;
                case 2: clearDescription(); break;
                case 3: clearArgs(); break;
                case 4: clearType(); break;
                case 5: clearIsDeprecated(); break;
                case 6: clearDeprecationReason(); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean valid() {
            return optionals.get(0) &&
                   optionals.get(2) &&
                   optionals.get(3) &&
                   optionals.get(4);
        }

        @Override
        public Field._Builder validate() {
            if (!valid()) {
                java.util.ArrayList<String> missing = new java.util.ArrayList<>();

                if (!optionals.get(0)) {
                    missing.add("name");
                }

                if (!optionals.get(2)) {
                    missing.add("args");
                }

                if (!optionals.get(3)) {
                    missing.add("type");
                }

                if (!optionals.get(4)) {
                    missing.add("isDeprecated");
                }

                throw new java.lang.IllegalStateException(
                        "Missing required fields " +
                        String.join(",", missing) +
                        " in message gql_introspection.__Field");
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PStructDescriptor<Field> descriptor() {
            return Field.kDescriptor;
        }

        @Override
        public void readBinary(net.morimekta.util.io.BigEndianBinaryReader reader, boolean strict) throws java.io.IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                int field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            mName = new String(reader.expectBytes(len_1), java.nio.charset.StandardCharsets.UTF_8);
                            optionals.set(0);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Field.name, should be struct(12)");
                        }
                        break;
                    }
                    case 2: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            mDescription = new String(reader.expectBytes(len_2), java.nio.charset.StandardCharsets.UTF_8);
                            optionals.set(1);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Field.description, should be struct(12)");
                        }
                        break;
                    }
                    case 3: {
                        if (type == 15) {
                            byte t_5 = reader.expectByte();
                            if (t_5 == 12) {
                                final int len_4 = reader.expectUInt32();
                                net.morimekta.util.collect.UnmodifiableList.Builder<net.morimekta.providence.graphql.introspection.InputValue> b_3 = net.morimekta.util.collect.UnmodifiableList.builder(len_4);
                                for (int i_6 = 0; i_6 < len_4; ++i_6) {
                                    net.morimekta.providence.graphql.introspection.InputValue key_7 = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.InputValue.kDescriptor, strict);
                                    b_3.add(key_7);
                                }
                                mArgs = b_3.build();
                            } else {
                                throw new net.morimekta.providence.serializer.SerializerException("Wrong item type " + net.morimekta.providence.serializer.binary.BinaryType.asString(t_5) + " for gql_introspection.__Field.args, should be struct(12)");
                            }
                            optionals.set(2);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Field.args, should be struct(12)");
                        }
                        break;
                    }
                    case 4: {
                        if (type == 12) {
                            mType = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.introspection.Type.kDescriptor, strict);
                            optionals.set(3);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Field.type, should be struct(12)");
                        }
                        break;
                    }
                    case 5: {
                        if (type == 2) {
                            mIsDeprecated = reader.expectUInt8() == 1;
                            optionals.set(4);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Field.isDeprecated, should be struct(12)");
                        }
                        break;
                    }
                    case 6: {
                        if (type == 11) {
                            int len_8 = reader.expectUInt32();
                            mDeprecationReason = new String(reader.expectBytes(len_8), java.nio.charset.StandardCharsets.UTF_8);
                            optionals.set(5);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_introspection.__Field.deprecationReason, should be struct(12)");
                        }
                        break;
                    }
                    default: {
                        net.morimekta.providence.serializer.binary.BinaryFormatUtils.readFieldValue(reader, new net.morimekta.providence.serializer.binary.BinaryFormatUtils.FieldInfo(field, type), null, false);
                        break;
                    }
                }
                type = reader.expectByte();
            }
        }

        @Override
        @javax.annotation.Nonnull
        public Field build() {
            return new Field(this);
        }
    }
}
