package net.morimekta.providence.graphql.errors;

@SuppressWarnings("unused")
@javax.annotation.Generated(
        value = "net.morimekta.providence:providence-generator-java",
        comments = "java")
@javax.annotation.concurrent.Immutable
public class GQLError
        extends Exception
        implements GQLError_OrBuilder,
                   net.morimekta.providence.PMessage<GQLError>,
                   net.morimekta.providence.PException,
                   Comparable<GQLError>,
                   net.morimekta.providence.serializer.binary.BinaryWriter {
    private final static String kDefaultMessage = "";

    private final static long serialVersionUID = -2885365998749274602L;

    private final transient String mMessage;
    private final transient java.util.List<net.morimekta.providence.graphql.errors.GQLErrorLocation> mLocations;

    private volatile transient int tHashCode;

    // Transient object used during java deserialization.
    private transient GQLError tSerializeInstance;

    public GQLError(String pMessage,
                    java.util.List<net.morimekta.providence.graphql.errors.GQLErrorLocation> pLocations) {
        super(pMessage);

        if (pMessage != null) {
            mMessage = pMessage;
        } else {
            mMessage = kDefaultMessage;
        }
        if (pLocations != null) {
            mLocations = net.morimekta.util.collect.UnmodifiableList.copyOf(pLocations);
        } else {
            mLocations = null;
        }
    }

    private GQLError(_Builder builder) {
        super(builder.mMessage);

        if (builder.isSetMessage()) {
            mMessage = builder.mMessage;
        } else {
            mMessage = kDefaultMessage;
        }
        if (builder.isSetLocations()) {
            mLocations = net.morimekta.util.collect.UnmodifiableList.copyOf(builder.mLocations);
        } else {
            mLocations = null;
        }
    }

    public boolean hasMessage() {
        return true;
    }

    /**
     * @return The <code>message</code> value
     */
    @javax.annotation.Nonnull
    public String getMessage() {
        return mMessage;
    }

    public int numLocations() {
        return mLocations != null ? mLocations.size() : 0;
    }

    public boolean hasLocations() {
        return mLocations != null;
    }

    /**
     * @return The <code>locations</code> value
     */
    public java.util.List<net.morimekta.providence.graphql.errors.GQLErrorLocation> getLocations() {
        return mLocations;
    }

    /**
     * @return Optional of the <code>locations</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<java.util.List<net.morimekta.providence.graphql.errors.GQLErrorLocation>> optionalLocations() {
        return java.util.Optional.ofNullable(mLocations);
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return true;
            case 2: return mLocations != null;
            default: return false;
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T> T get(int key) {
        switch(key) {
            case 1: return (T) mMessage;
            case 2: return (T) mLocations;
            default: return null;
        }
    }

    @Override
    public String origGetMessage() {
        return super.getMessage();
    }

    @Override
    public String origGetLocalizedMessage() {
        return super.getLocalizedMessage();
    }

    @Override
    public GQLError initCause(Throwable cause) {
        return (GQLError) super.initCause(cause);
    }

    @Override
    public GQLError fillInStackTrace() {
        return (GQLError) super.fillInStackTrace();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) return true;
        if (o == null || !o.getClass().equals(getClass())) return false;
        GQLError other = (GQLError) o;
        return java.util.Objects.equals(mMessage, other.mMessage) &&
               java.util.Objects.equals(mLocations, other.mLocations);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = java.util.Objects.hash(
                    GQLError.class,
                    _Field.MESSAGE, mMessage,
                    _Field.LOCATIONS, mLocations);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "gql_errors.GQLError" + asString();
    }

    @Override
    @javax.annotation.Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        out.append("message:")
           .append('\"')
           .append(net.morimekta.util.Strings.escape(mMessage))
           .append('\"');
        if (hasLocations()) {
            out.append(',');
            out.append("locations:")
               .append(net.morimekta.util.Strings.asString(mLocations));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(GQLError other) {
        int c;

        c = mMessage.compareTo(other.mMessage);
        if (c != 0) return c;

        c = Boolean.compare(mLocations != null, other.mLocations != null);
        if (c != 0) return c;
        if (mLocations != null) {
            c = Integer.compare(mLocations.hashCode(), other.mLocations.hashCode());
            if (c != 0) return c;
        }

        return 0;
    }

    private void writeObject(java.io.ObjectOutputStream oos) throws java.io.IOException {
        oos.defaultWriteObject();
        net.morimekta.providence.serializer.BinarySerializer.INSTANCE.serialize(oos, this);
    }

    private void readObject(java.io.ObjectInputStream ois)
            throws java.io.IOException, ClassNotFoundException {
        ois.defaultReadObject();
        tSerializeInstance = net.morimekta.providence.serializer.BinarySerializer.INSTANCE.deserialize(ois, kDescriptor);
        if (getCause() != null) {
            tSerializeInstance.initCause(getCause());
        }
        tSerializeInstance.setStackTrace(getStackTrace());
    }

    private Object readResolve() throws java.io.ObjectStreamException {
        return tSerializeInstance;
    }

    @Override
    public int writeBinary(net.morimekta.util.io.BigEndianBinaryWriter writer) throws java.io.IOException {
        int length = 0;

        length += writer.writeByte((byte) 11);
        length += writer.writeShort((short) 1);
        net.morimekta.util.Binary tmp_1 = net.morimekta.util.Binary.wrap(mMessage.getBytes(java.nio.charset.StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_1.length());
        length += writer.writeBinary(tmp_1);

        if (hasLocations()) {
            length += writer.writeByte((byte) 15);
            length += writer.writeShort((short) 2);
            length += writer.writeByte((byte) 12);
            length += writer.writeUInt32(mLocations.size());
            for (net.morimekta.providence.graphql.errors.GQLErrorLocation entry_2 : mLocations) {
                length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, entry_2);
            }
        }

        length += writer.writeByte((byte) 0);
        return length;
    }

    @javax.annotation.Nonnull
    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public enum _Field implements net.morimekta.providence.descriptor.PField<GQLError> {
        MESSAGE(1, net.morimekta.providence.descriptor.PRequirement.REQUIRED, "message", net.morimekta.providence.descriptor.PPrimitive.STRING.provider(), null, null),
        LOCATIONS(2, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "locations", net.morimekta.providence.descriptor.PList.provider(net.morimekta.providence.graphql.errors.GQLErrorLocation.provider()), null, null),
        ;

        private final int mId;
        private final net.morimekta.providence.descriptor.PRequirement mRequired;
        private final String mName;
        private final net.morimekta.providence.descriptor.PDescriptorProvider mTypeProvider;
        private final net.morimekta.providence.descriptor.PStructDescriptorProvider mArgumentsProvider;
        private final net.morimekta.providence.descriptor.PValueProvider<?> mDefaultValue;

        _Field(int id, net.morimekta.providence.descriptor.PRequirement required, String name, net.morimekta.providence.descriptor.PDescriptorProvider typeProvider, net.morimekta.providence.descriptor.PStructDescriptorProvider argumentsProvider, net.morimekta.providence.descriptor.PValueProvider<?> defaultValue) {
            mId = id;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mArgumentsProvider = argumentsProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public int getId() { return mId; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PRequirement getRequirement() { return mRequired; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PDescriptor getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        @javax.annotation.Nullable
        public net.morimekta.providence.descriptor.PStructDescriptor getArgumentsType() { return mArgumentsProvider == null ? null : mArgumentsProvider.descriptor(); }

        @javax.annotation.Nonnull
        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        @javax.annotation.Nullable
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            return net.morimekta.providence.descriptor.PField.asString(this);
        }

        /**
         * @param id Field name
         * @return The identified field or null
         */
        public static _Field findById(int id) {
            switch (id) {
                case 1: return _Field.MESSAGE;
                case 2: return _Field.LOCATIONS;
            }
            return null;
        }

        /**
         * @param name Field name
         * @return The named field or null
         */
        public static _Field findByName(String name) {
            if (name == null) return null;
            switch (name) {
                case "message": return _Field.MESSAGE;
                case "locations": return _Field.LOCATIONS;
            }
            return null;
        }

        /**
         * @param id Field name
         * @return The identified field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForId(int id) {
            _Field field = findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in gql_errors.GQLError");
            }
            return field;
        }

        /**
         * @param name Field name
         * @return The named field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_errors.GQLError");
            }
            return field;
        }

    }

    @javax.annotation.Nonnull
    public static net.morimekta.providence.descriptor.PExceptionDescriptorProvider<GQLError> provider() {
        return new _Provider();
    }

    @Override
    @javax.annotation.Nonnull
    public net.morimekta.providence.descriptor.PExceptionDescriptor<GQLError> descriptor() {
        return kDescriptor;
    }

    public static final net.morimekta.providence.descriptor.PExceptionDescriptor<GQLError> kDescriptor;

    private static final class _Descriptor
            extends net.morimekta.providence.descriptor.PExceptionDescriptor<GQLError> {
        public _Descriptor() {
            super("gql_errors", "GQLError", _Builder::new, false);
        }

        @Override
        @javax.annotation.Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static final class _Provider extends net.morimekta.providence.descriptor.PExceptionDescriptorProvider<GQLError> {
        @Override
        public net.morimekta.providence.descriptor.PExceptionDescriptor<GQLError> descriptor() {
            return kDescriptor;
        }
    }

    /**
     * Make a <code>gql_errors.GQLError</code> builder.
     * @return The builder instance.
     */
    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends net.morimekta.providence.PMessageBuilder<GQLError>
            implements GQLError_OrBuilder,
                       net.morimekta.providence.serializer.binary.BinaryReader {
        private Throwable cause;
        private java.util.BitSet optionals;
        private java.util.BitSet modified;

        private String mMessage;
        private java.util.List<net.morimekta.providence.graphql.errors.GQLErrorLocation> mLocations;

        /**
         * Make a gql_errors.GQLError builder instance.
         */
        public _Builder() {
            optionals = new java.util.BitSet(2);
            modified = new java.util.BitSet(2);
            mMessage = kDefaultMessage;
        }

        /**
         * Make a mutating builder off a base gql_errors.GQLError.
         *
         * @param base The base GQLError
         */
        public _Builder(GQLError base) {
            this();

            optionals.set(0);
            mMessage = base.mMessage;
            if (base.hasLocations()) {
                optionals.set(1);
                mLocations = base.mLocations;
            }
        }

        @javax.annotation.Nonnull
        @Override
        public GQLError._Builder merge(GQLError from) {
            optionals.set(0);
            modified.set(0);
            mMessage = from.getMessage();

            if (from.hasLocations()) {
                optionals.set(1);
                modified.set(1);
                mLocations = from.getLocations();
            }
            return this;
        }

        /**
         * Set the <code>message</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public GQLError._Builder setMessage(String value) {
            if (value == null) {
                return clearMessage();
            }

            optionals.set(0);
            modified.set(0);
            mMessage = value;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>message</code> field.
         *
         * @return True if message has been set.
         */
        public boolean isSetMessage() {
            return optionals.get(0);
        }

        /**
         * Checks for presence of the <code>message</code> field.
         *
         * @return True if message is present.
         */
        public boolean hasMessage() {
            return true;
        }

        /**
         * Checks if the <code>message</code> field has been modified since the
         * builder was created.
         *
         * @return True if message has been modified.
         */
        public boolean isModifiedMessage() {
            return modified.get(0);
        }

        /**
         * Clear the <code>message</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public GQLError._Builder clearMessage() {
            optionals.clear(0);
            modified.set(0);
            mMessage = kDefaultMessage;
            return this;
        }

        /**
         * @return The <code>message</code> field value
         */
        public String getMessage() {
            return isSetMessage() ? mMessage : kDefaultMessage;
        }

        /**
         * Set the <code>locations</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public GQLError._Builder setLocations(java.util.Collection<net.morimekta.providence.graphql.errors.GQLErrorLocation> value) {
            if (value == null) {
                return clearLocations();
            }

            optionals.set(1);
            modified.set(1);
            mLocations = net.morimekta.util.collect.UnmodifiableList.copyOf(value);
            return this;
        }

        /**
         * Adds entries to the <code>locations</code> list.
         *
         * @param values The added value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public GQLError._Builder addToLocations(net.morimekta.providence.graphql.errors.GQLErrorLocation... values) {
            optionals.set(1);
            modified.set(1);
            java.util.List<net.morimekta.providence.graphql.errors.GQLErrorLocation> _container = mutableLocations();
            for (net.morimekta.providence.graphql.errors.GQLErrorLocation item : values) {
                _container.add(item);
            }
            return this;
        }

        /**
         * Checks for explicit presence of the <code>locations</code> field.
         *
         * @return True if locations has been set.
         */
        public boolean isSetLocations() {
            return optionals.get(1);
        }

        /**
         * Checks for presence of the <code>locations</code> field.
         *
         * @return True if locations is present.
         */
        public boolean hasLocations() {
            return optionals.get(1);
        }

        /**
         * Checks if the <code>locations</code> field has been modified since the
         * builder was created.
         *
         * @return True if locations has been modified.
         */
        public boolean isModifiedLocations() {
            return modified.get(1);
        }

        /**
         * Clear the <code>locations</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public GQLError._Builder clearLocations() {
            optionals.clear(1);
            modified.set(1);
            mLocations = null;
            return this;
        }

        /**
         * @return The mutable <code>locations</code> container
         */
        public java.util.List<net.morimekta.providence.graphql.errors.GQLErrorLocation> mutableLocations() {
            optionals.set(1);
            modified.set(1);

            if (mLocations == null) {
                mLocations = new java.util.ArrayList<>();
            } else if (!(mLocations instanceof java.util.ArrayList)) {
                mLocations = new java.util.ArrayList<>(mLocations);
            }
            return mLocations;
        }

        /**
         * @return The <code>locations</code> field value
         */
        public java.util.List<net.morimekta.providence.graphql.errors.GQLErrorLocation> getLocations() {
            return mLocations;
        }

        /**
         * @return Optional <code>locations</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<java.util.List<net.morimekta.providence.graphql.errors.GQLErrorLocation>> optionalLocations() {
            return java.util.Optional.ofNullable(mLocations);
        }

        /**
         * @return Number of entries in <code>locations</code>.
         */
        public int numLocations() {
            return mLocations != null ? mLocations.size() : 0;
        }

        /**
         * Initializes the cause of the gql_errors.GQLError
         *
         * @param cause The cause
         * @return Builder instance
         */
        @javax.annotation.Nonnull
        public GQLError._Builder initCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) return true;
            if (o == null || !o.getClass().equals(getClass())) return false;
            GQLError._Builder other = (GQLError._Builder) o;
            return java.util.Objects.equals(optionals, other.optionals) &&
                   java.util.Objects.equals(mMessage, other.mMessage) &&
                   java.util.Objects.equals(mLocations, other.mLocations);
        }

        @Override
        public int hashCode() {
            return java.util.Objects.hash(
                    GQLError.class, optionals,
                    GQLError._Field.MESSAGE, mMessage,
                    GQLError._Field.LOCATIONS, mLocations);
        }

        @Override
        @SuppressWarnings("unchecked")
        public net.morimekta.providence.PMessageBuilder mutator(int key) {
            switch (key) {
                default: throw new IllegalArgumentException("Not a message field ID: " + key);
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public GQLError._Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setMessage((String) value); break;
                case 2: setLocations((java.util.List<net.morimekta.providence.graphql.errors.GQLErrorLocation>) value); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean isSet(int key) {
            switch (key) {
                case 1: return optionals.get(0);
                case 2: return optionals.get(1);
                default: break;
            }
            return false;
        }

        @Override
        public boolean isModified(int key) {
            switch (key) {
                case 1: return modified.get(0);
                case 2: return modified.get(1);
                default: break;
            }
            return false;
        }

        @Override
        @SuppressWarnings("unchecked")
        public <T> T get(int key) {
            switch(key) {
                case 1: return (T) getMessage();
                case 2: return (T) getLocations();
                default: return null;
            }
        }

        @Override
        public boolean has(int key) {
            switch(key) {
                case 1: return true;
                case 2: return mLocations != null;
                default: return false;
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public GQLError._Builder addTo(int key, Object value) {
            switch (key) {
                case 2: addToLocations((net.morimekta.providence.graphql.errors.GQLErrorLocation) value); break;
                default: break;
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public GQLError._Builder clear(int key) {
            switch (key) {
                case 1: clearMessage(); break;
                case 2: clearLocations(); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean valid() {
            return optionals.get(0);
        }

        @Override
        public GQLError._Builder validate() {
            if (!valid()) {
                java.util.ArrayList<String> missing = new java.util.ArrayList<>();

                if (!optionals.get(0)) {
                    missing.add("message");
                }

                throw new java.lang.IllegalStateException(
                        "Missing required fields " +
                        String.join(",", missing) +
                        " in message gql_errors.GQLError");
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PExceptionDescriptor<GQLError> descriptor() {
            return GQLError.kDescriptor;
        }

        @Override
        public void readBinary(net.morimekta.util.io.BigEndianBinaryReader reader, boolean strict) throws java.io.IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                int field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            mMessage = new String(reader.expectBytes(len_1), java.nio.charset.StandardCharsets.UTF_8);
                            optionals.set(0);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_errors.GQLError.message, should be struct(12)");
                        }
                        break;
                    }
                    case 2: {
                        if (type == 15) {
                            byte t_4 = reader.expectByte();
                            if (t_4 == 12) {
                                final int len_3 = reader.expectUInt32();
                                net.morimekta.util.collect.UnmodifiableList.Builder<net.morimekta.providence.graphql.errors.GQLErrorLocation> b_2 = net.morimekta.util.collect.UnmodifiableList.builder(len_3);
                                for (int i_5 = 0; i_5 < len_3; ++i_5) {
                                    net.morimekta.providence.graphql.errors.GQLErrorLocation key_6 = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.graphql.errors.GQLErrorLocation.kDescriptor, strict);
                                    b_2.add(key_6);
                                }
                                mLocations = b_2.build();
                            } else {
                                throw new net.morimekta.providence.serializer.SerializerException("Wrong item type " + net.morimekta.providence.serializer.binary.BinaryType.asString(t_4) + " for gql_errors.GQLError.locations, should be struct(12)");
                            }
                            optionals.set(1);
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for gql_errors.GQLError.locations, should be struct(12)");
                        }
                        break;
                    }
                    default: {
                        net.morimekta.providence.serializer.binary.BinaryFormatUtils.readFieldValue(reader, new net.morimekta.providence.serializer.binary.BinaryFormatUtils.FieldInfo(field, type), null, false);
                        break;
                    }
                }
                type = reader.expectByte();
            }
        }

        @Override
        @javax.annotation.Nonnull
        public GQLError build() {
            GQLError e = new GQLError(this);

            try {
                StackTraceElement[] stackTrace = e.getStackTrace();
                StackTraceElement[] subTrace = new StackTraceElement[stackTrace.length - 1];
                System.arraycopy(stackTrace, 1, subTrace, 0, subTrace.length);
                e.setStackTrace(subTrace);
            } catch (Throwable ignored) {
            }

            if (cause != null) {
                e.initCause(cause);
            }

            return e;
        }
    }
}
