/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptorProvider;

public enum MessageVariant implements PEnumValue<MessageVariant>
{
    STRUCT(1, "STRUCT"),
    UNION(2, "UNION"),
    EXCEPTION(3, "EXCEPTION"),
    INTERFACE(4, "INTERFACE");

    private final int mId;
    private final String mName;
    public static final PEnumDescriptor<MessageVariant> kDescriptor;

    private MessageVariant(int id, String name) {
        this.mId = id;
        this.mName = name;
    }

    public int asInteger() {
        return this.mId;
    }

    @Nonnull
    public String asString() {
        return this.mName;
    }

    @Nullable
    public static MessageVariant findById(Integer id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case 1: {
                return STRUCT;
            }
            case 2: {
                return UNION;
            }
            case 3: {
                return EXCEPTION;
            }
            case 4: {
                return INTERFACE;
            }
        }
        return null;
    }

    @Nullable
    public static MessageVariant findByName(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "STRUCT": {
                return STRUCT;
            }
            case "UNION": {
                return UNION;
            }
            case "EXCEPTION": {
                return EXCEPTION;
            }
            case "INTERFACE": {
                return INTERFACE;
            }
        }
        return null;
    }

    @Nonnull
    public static MessageVariant valueForId(int id) {
        MessageVariant value = MessageVariant.findById(id);
        if (value == null) {
            throw new IllegalArgumentException("No p_model.MessageVariant for id " + id);
        }
        return value;
    }

    @Nonnull
    public static MessageVariant valueForName(@Nonnull String name) {
        MessageVariant value = MessageVariant.findByName(name);
        if (value == null) {
            throw new IllegalArgumentException("No p_model.MessageVariant for name \"" + name + "\"");
        }
        return value;
    }

    @Nonnull
    public PEnumDescriptor<MessageVariant> descriptor() {
        return kDescriptor;
    }

    public static PEnumDescriptorProvider<MessageVariant> provider() {
        return new PEnumDescriptorProvider(kDescriptor);
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static final class _Descriptor
    extends PEnumDescriptor<MessageVariant> {
        public _Descriptor() {
            super("p_model", "MessageVariant", _Builder::new);
        }

        @Nonnull
        public boolean isInnerType() {
            return false;
        }

        @Nonnull
        public boolean isAutoType() {
            return false;
        }

        @Nonnull
        public MessageVariant[] getValues() {
            return MessageVariant.values();
        }

        @Nullable
        public MessageVariant findById(int id) {
            return MessageVariant.findById(id);
        }

        @Nullable
        public MessageVariant findByName(String name) {
            return MessageVariant.findByName(name);
        }
    }

    public static final class _Builder
    extends PEnumBuilder<MessageVariant> {
        private MessageVariant mValue;

        @Nonnull
        public _Builder setById(int value) {
            this.mValue = MessageVariant.findById(value);
            return this;
        }

        @Nonnull
        public _Builder setByName(String name) {
            this.mValue = MessageVariant.findByName(name);
            return this;
        }

        public boolean valid() {
            return this.mValue != null;
        }

        public MessageVariant build() {
            return this.mValue;
        }
    }
}

