/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.morimekta.util.FileUtil;

public class FileManager {
    private final Path root;
    private final Set<Path> generatedFiles;
    private final Map<Path, Long> modificationTimeMap;

    public FileManager(Path root) {
        this.root = root;
        this.generatedFiles = new HashSet<Path>();
        this.modificationTimeMap = new HashMap<Path, Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIfMissingOrOutdated(Path programFile, String subPath, String fileName, CreateHandler create) throws IOException {
        long outputModified;
        long programModified;
        Path outputFile = this.absolutePath(subPath, fileName);
        if (Files.exists(outputFile, new LinkOption[0]) && (programModified = this.getLastModifiedTime(programFile)) < (outputModified = this.getLastModifiedTime(outputFile))) {
            return;
        }
        try (OutputStream out = this.createInternal(outputFile);
             BufferedOutputStream buf = new BufferedOutputStream(out);){
            try {
                create.create(buf);
            }
            finally {
                buf.flush();
            }
        }
    }

    private long getLastModifiedTime(Path path) throws IOException {
        try {
            return this.modificationTimeMap.computeIfAbsent(path, p -> {
                try {
                    return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private Path relativePath(Path path) {
        return path.relativize(this.root);
    }

    private Path absolutePath(String path, String name) throws IOException {
        Path tmp = this.root;
        if (path != null) {
            tmp = tmp.resolve(path);
        }
        tmp = tmp.resolve(name);
        return FileUtil.readCanonicalPath((Path)tmp);
    }

    private OutputStream createInternal(Path file) throws IOException {
        if (this.generatedFiles.contains(file)) {
            throw new IOException("File " + this.relativePath(file) + " already created.");
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        this.generatedFiles.add(file);
        return Files.newOutputStream(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @FunctionalInterface
    public static interface CreateHandler {
        public void create(OutputStream var1) throws IOException;
    }
}

