package net.morimekta.providence.model;

/**
 * ( &lt;enum&gt; | &lt;typedef&gt; | &lt;struct&gt; | &lt;service&gt; | &lt;const&gt; )
 */
@SuppressWarnings("unused")
@javax.annotation.Generated(
        value = "net.morimekta.providence:providence-generator-java",
        comments = "java:serializable")
@javax.annotation.concurrent.Immutable
public class Declaration
        implements net.morimekta.providence.model.Decl,
                   Declaration_OrBuilder,
                   net.morimekta.providence.PUnion<Declaration>,
                   Comparable<Declaration>,
                   java.io.Serializable,
                   net.morimekta.providence.serializer.binary.BinaryWriter {
    private final static long serialVersionUID = -3189658256244889228L;

    private final transient net.morimekta.providence.model.EnumType mDeclEnum;
    private final transient net.morimekta.providence.model.TypedefType mDeclTypedef;
    private final transient net.morimekta.providence.model.MessageType mDeclMessage;
    private final transient net.morimekta.providence.model.ServiceType mDeclService;
    private final transient net.morimekta.providence.model.ConstType mDeclConst;

    private transient final _Field tUnionField;

    private volatile transient int tHashCode;

    // Transient object used during java deserialization.
    private transient Declaration tSerializeInstance;

    /**
     * @param value The union value
     * @return The created union.
     */
    @javax.annotation.Nonnull
    public static Declaration withDeclEnum(@javax.annotation.Nonnull net.morimekta.providence.model.EnumType_OrBuilder value) {
        return new _Builder().setDeclEnum(value).build();
    }

    /**
     * @param value The union value
     * @return The created union.
     */
    @javax.annotation.Nonnull
    public static Declaration withDeclTypedef(@javax.annotation.Nonnull net.morimekta.providence.model.TypedefType_OrBuilder value) {
        return new _Builder().setDeclTypedef(value).build();
    }

    /**
     * @param value The union value
     * @return The created union.
     */
    @javax.annotation.Nonnull
    public static Declaration withDeclMessage(@javax.annotation.Nonnull net.morimekta.providence.model.MessageType_OrBuilder value) {
        return new _Builder().setDeclMessage(value).build();
    }

    /**
     * @param value The union value
     * @return The created union.
     */
    @javax.annotation.Nonnull
    public static Declaration withDeclService(@javax.annotation.Nonnull net.morimekta.providence.model.ServiceType_OrBuilder value) {
        return new _Builder().setDeclService(value).build();
    }

    /**
     * @param value The union value
     * @return The created union.
     */
    @javax.annotation.Nonnull
    public static Declaration withDeclConst(@javax.annotation.Nonnull net.morimekta.providence.model.ConstType_OrBuilder value) {
        return new _Builder().setDeclConst(value).build();
    }

    private Declaration(_Builder builder) {
        tUnionField = builder.tUnionField;

        mDeclEnum = tUnionField != _Field.DECL_ENUM
                ? null
                : builder.mDeclEnum_builder != null ? builder.mDeclEnum_builder.build() : builder.mDeclEnum;
        mDeclTypedef = tUnionField != _Field.DECL_TYPEDEF
                ? null
                : builder.mDeclTypedef_builder != null ? builder.mDeclTypedef_builder.build() : builder.mDeclTypedef;
        mDeclMessage = tUnionField != _Field.DECL_MESSAGE
                ? null
                : builder.mDeclMessage_builder != null ? builder.mDeclMessage_builder.build() : builder.mDeclMessage;
        mDeclService = tUnionField != _Field.DECL_SERVICE
                ? null
                : builder.mDeclService_builder != null ? builder.mDeclService_builder.build() : builder.mDeclService;
        mDeclConst = tUnionField != _Field.DECL_CONST
                ? null
                : builder.mDeclConst_builder != null ? builder.mDeclConst_builder.build() : builder.mDeclConst;
    }

    public boolean hasDeclEnum() {
        return tUnionField == _Field.DECL_ENUM && mDeclEnum != null;
    }

    /**
     * @return The <code>decl_enum</code> value
     */
    public net.morimekta.providence.model.EnumType getDeclEnum() {
        return mDeclEnum;
    }

    /**
     * @return Optional of the <code>decl_enum</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<net.morimekta.providence.model.EnumType> optionalDeclEnum() {
        return java.util.Optional.ofNullable(mDeclEnum);
    }

    public boolean hasDeclTypedef() {
        return tUnionField == _Field.DECL_TYPEDEF && mDeclTypedef != null;
    }

    /**
     * @return The <code>decl_typedef</code> value
     */
    public net.morimekta.providence.model.TypedefType getDeclTypedef() {
        return mDeclTypedef;
    }

    /**
     * @return Optional of the <code>decl_typedef</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<net.morimekta.providence.model.TypedefType> optionalDeclTypedef() {
        return java.util.Optional.ofNullable(mDeclTypedef);
    }

    public boolean hasDeclMessage() {
        return tUnionField == _Field.DECL_MESSAGE && mDeclMessage != null;
    }

    /**
     * @return The <code>decl_message</code> value
     */
    public net.morimekta.providence.model.MessageType getDeclMessage() {
        return mDeclMessage;
    }

    /**
     * @return Optional of the <code>decl_message</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<net.morimekta.providence.model.MessageType> optionalDeclMessage() {
        return java.util.Optional.ofNullable(mDeclMessage);
    }

    public boolean hasDeclService() {
        return tUnionField == _Field.DECL_SERVICE && mDeclService != null;
    }

    /**
     * @return The <code>decl_service</code> value
     */
    public net.morimekta.providence.model.ServiceType getDeclService() {
        return mDeclService;
    }

    /**
     * @return Optional of the <code>decl_service</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<net.morimekta.providence.model.ServiceType> optionalDeclService() {
        return java.util.Optional.ofNullable(mDeclService);
    }

    public boolean hasDeclConst() {
        return tUnionField == _Field.DECL_CONST && mDeclConst != null;
    }

    /**
     * @return The <code>decl_const</code> value
     */
    public net.morimekta.providence.model.ConstType getDeclConst() {
        return mDeclConst;
    }

    /**
     * @return Optional of the <code>decl_const</code> field value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<net.morimekta.providence.model.ConstType> optionalDeclConst() {
        return java.util.Optional.ofNullable(mDeclConst);
    }

    /**
     * @return The union field as implemented type.
     */
    public net.morimekta.providence.model.Decl asDecl() {
        switch (unionField()) {
            case DECL_ENUM: return getDeclEnum();
            case DECL_TYPEDEF: return getDeclTypedef();
            case DECL_MESSAGE: return getDeclMessage();
            case DECL_SERVICE: return getDeclService();
            case DECL_CONST: return getDeclConst();
            default: throw new IllegalStateException("Impossible");
        }
    }

    /**
     * Documentation for the specific declaration.
     *
     * @return The documentation value.
     */
    public String getDocumentation() {
        return asDecl().getDocumentation();
    }

    /**
     * Documentation for the specific declaration.
     *
     * @return Optional documentation value.
     */
    @javax.annotation.Nonnull
    public java.util.Optional<String> optionalDocumentation() {
        return asDecl().optionalDocumentation();
    }

    /**
     * @return If documentation is present.
     */
    public boolean hasDocumentation() {
        return asDecl().hasDocumentation();
    }

    /**
     * Name of the type, constant or service.
     *
     * @return The name value.
     */
    @javax.annotation.Nonnull
    public String getName() {
        return asDecl().getName();
    }

    /**
     * @return If name is present.
     */
    public boolean hasName() {
        return asDecl().hasName();
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return tUnionField == _Field.DECL_ENUM;
            case 2: return tUnionField == _Field.DECL_TYPEDEF;
            case 3: return tUnionField == _Field.DECL_MESSAGE;
            case 4: return tUnionField == _Field.DECL_SERVICE;
            case 5: return tUnionField == _Field.DECL_CONST;
            default: return false;
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T> T get(int key) {
        switch(key) {
            case 1: return (T) mDeclEnum;
            case 2: return (T) mDeclTypedef;
            case 3: return (T) mDeclMessage;
            case 4: return (T) mDeclService;
            case 5: return (T) mDeclConst;
            default: return null;
        }
    }

    @Override
    public boolean unionFieldIsSet() {
        return tUnionField != null;
    }

    @Override
    @javax.annotation.Nonnull
    public _Field unionField() {
        if (tUnionField == null) throw new IllegalStateException("No union field set in p_model.Declaration");
        return tUnionField;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) return true;
        if (o == null || !o.getClass().equals(getClass())) return false;
        Declaration other = (Declaration) o;
        return java.util.Objects.equals(tUnionField, other.tUnionField) &&
               java.util.Objects.equals(mDeclEnum, other.mDeclEnum) &&
               java.util.Objects.equals(mDeclTypedef, other.mDeclTypedef) &&
               java.util.Objects.equals(mDeclMessage, other.mDeclMessage) &&
               java.util.Objects.equals(mDeclService, other.mDeclService) &&
               java.util.Objects.equals(mDeclConst, other.mDeclConst);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = java.util.Objects.hash(
                    Declaration.class,
                    _Field.DECL_ENUM, mDeclEnum,
                    _Field.DECL_TYPEDEF, mDeclTypedef,
                    _Field.DECL_MESSAGE, mDeclMessage,
                    _Field.DECL_SERVICE, mDeclService,
                    _Field.DECL_CONST, mDeclConst);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "p_model.Declaration" + asString();
    }

    @Override
    @javax.annotation.Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        switch (tUnionField) {
            case DECL_ENUM: {
                out.append("decl_enum:")
                   .append(mDeclEnum.asString());
                break;
            }
            case DECL_TYPEDEF: {
                out.append("decl_typedef:")
                   .append(mDeclTypedef.asString());
                break;
            }
            case DECL_MESSAGE: {
                out.append("decl_message:")
                   .append(mDeclMessage.asString());
                break;
            }
            case DECL_SERVICE: {
                out.append("decl_service:")
                   .append(mDeclService.asString());
                break;
            }
            case DECL_CONST: {
                out.append("decl_const:")
                   .append(mDeclConst.asString());
                break;
            }
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Declaration other) {
        if (tUnionField == null || other.tUnionField == null) return Boolean.compare(tUnionField != null, other.tUnionField != null);
        int c = tUnionField.compareTo(other.tUnionField);
        if (c != 0) return c;

        switch (tUnionField) {
            case DECL_ENUM:
                return mDeclEnum.compareTo(other.mDeclEnum);
            case DECL_TYPEDEF:
                return mDeclTypedef.compareTo(other.mDeclTypedef);
            case DECL_MESSAGE:
                return mDeclMessage.compareTo(other.mDeclMessage);
            case DECL_SERVICE:
                return mDeclService.compareTo(other.mDeclService);
            case DECL_CONST:
                return mDeclConst.compareTo(other.mDeclConst);
            default: return 0;
        }
    }

    private void writeObject(java.io.ObjectOutputStream oos) throws java.io.IOException {
        oos.defaultWriteObject();
        net.morimekta.providence.serializer.BinarySerializer.INSTANCE.serialize(oos, this);
    }

    private void readObject(java.io.ObjectInputStream ois)
            throws java.io.IOException, ClassNotFoundException {
        ois.defaultReadObject();
        tSerializeInstance = net.morimekta.providence.serializer.BinarySerializer.INSTANCE.deserialize(ois, kDescriptor);
    }

    private Object readResolve() throws java.io.ObjectStreamException {
        return tSerializeInstance;
    }

    @Override
    public int writeBinary(net.morimekta.util.io.BigEndianBinaryWriter writer) throws java.io.IOException {
        int length = 0;

        if (tUnionField != null) {
            switch (tUnionField) {
                case DECL_ENUM: {
                    length += writer.writeByte((byte) 12);
                    length += writer.writeShort((short) 1);
                    length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, mDeclEnum);
                    break;
                }
                case DECL_TYPEDEF: {
                    length += writer.writeByte((byte) 12);
                    length += writer.writeShort((short) 2);
                    length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, mDeclTypedef);
                    break;
                }
                case DECL_MESSAGE: {
                    length += writer.writeByte((byte) 12);
                    length += writer.writeShort((short) 3);
                    length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, mDeclMessage);
                    break;
                }
                case DECL_SERVICE: {
                    length += writer.writeByte((byte) 12);
                    length += writer.writeShort((short) 4);
                    length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, mDeclService);
                    break;
                }
                case DECL_CONST: {
                    length += writer.writeByte((byte) 12);
                    length += writer.writeShort((short) 5);
                    length += net.morimekta.providence.serializer.binary.BinaryFormatUtils.writeMessage(writer, mDeclConst);
                    break;
                }
                default: break;
            }
        }
        length += writer.writeByte((byte) 0);
        return length;
    }

    @javax.annotation.Nonnull
    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public enum _Field implements net.morimekta.providence.descriptor.PField<Declaration> {
        DECL_ENUM(1, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "decl_enum", "declEnum", net.morimekta.providence.model.EnumType.provider(), null, null),
        DECL_TYPEDEF(2, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "decl_typedef", "declTypedef", net.morimekta.providence.model.TypedefType.provider(), null, null),
        DECL_MESSAGE(3, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "decl_message", "declMessage", net.morimekta.providence.model.MessageType.provider(), null, null),
        DECL_SERVICE(4, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "decl_service", "declService", net.morimekta.providence.model.ServiceType.provider(), null, null),
        DECL_CONST(5, net.morimekta.providence.descriptor.PRequirement.OPTIONAL, "decl_const", "declConst", net.morimekta.providence.model.ConstType.provider(), null, null),
        ;

        private final int mId;
        private final net.morimekta.providence.descriptor.PRequirement mRequired;
        private final String mName;
        private final String mPojoName;
        private final net.morimekta.providence.descriptor.PDescriptorProvider mTypeProvider;
        private final net.morimekta.providence.descriptor.PStructDescriptorProvider mArgumentsProvider;
        private final net.morimekta.providence.descriptor.PValueProvider<?> mDefaultValue;

        _Field(int id, net.morimekta.providence.descriptor.PRequirement required, String name, String pojoName, net.morimekta.providence.descriptor.PDescriptorProvider typeProvider, net.morimekta.providence.descriptor.PStructDescriptorProvider argumentsProvider, net.morimekta.providence.descriptor.PValueProvider<?> defaultValue) {
            mId = id;
            mRequired = required;
            mName = name;
            mPojoName = pojoName;
            mTypeProvider = typeProvider;
            mArgumentsProvider = argumentsProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public int getId() { return mId; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PRequirement getRequirement() { return mRequired; }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PDescriptor getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        @javax.annotation.Nullable
        public net.morimekta.providence.descriptor.PStructDescriptor getArgumentsType() { return mArgumentsProvider == null ? null : mArgumentsProvider.descriptor(); }

        @javax.annotation.Nonnull
        @Override
        public String getName() { return mName; }

        @javax.annotation.Nonnull
        @Override
        public String getPojoName() { return mPojoName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        @javax.annotation.Nullable
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        @javax.annotation.Nonnull
        public net.morimekta.providence.descriptor.PMessageDescriptor<Declaration> onMessageType() {
            return kDescriptor;
        }

        @Override
        public String toString() {
            return net.morimekta.providence.descriptor.PField.asString(this);
        }

        /**
         * @param id Field ID
         * @return The identified field or null
         */
        public static _Field findById(int id) {
            switch (id) {
                case 1: return _Field.DECL_ENUM;
                case 2: return _Field.DECL_TYPEDEF;
                case 3: return _Field.DECL_MESSAGE;
                case 4: return _Field.DECL_SERVICE;
                case 5: return _Field.DECL_CONST;
            }
            return null;
        }

        /**
         * @param name Field name
         * @return The named field or null
         */
        public static _Field findByName(String name) {
            if (name == null) return null;
            switch (name) {
                case "decl_enum": return _Field.DECL_ENUM;
                case "decl_typedef": return _Field.DECL_TYPEDEF;
                case "decl_message": return _Field.DECL_MESSAGE;
                case "decl_service": return _Field.DECL_SERVICE;
                case "decl_const": return _Field.DECL_CONST;
            }
            return null;
        }

        /**
         * @param name Field POJO name
         * @return The named field or null
         */
        public static _Field findByPojoName(String name) {
            if (name == null) return null;
            switch (name) {
                case "declEnum": return _Field.DECL_ENUM;
                case "declTypedef": return _Field.DECL_TYPEDEF;
                case "declMessage": return _Field.DECL_MESSAGE;
                case "declService": return _Field.DECL_SERVICE;
                case "declConst": return _Field.DECL_CONST;
            }
            return null;
        }

        /**
         * @param id Field ID
         * @return The identified field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForId(int id) {
            _Field field = findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in p_model.Declaration");
            }
            return field;
        }

        /**
         * @param name Field name
         * @return The named field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in p_model.Declaration");
            }
            return field;
        }

        /**
         * @param name Field POJO name
         * @return The named field
         * @throws IllegalArgumentException If no such field
         */
        public static _Field fieldForPojoName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = findByPojoName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in p_model.Declaration");
            }
            return field;
        }
    }

    @javax.annotation.Nonnull
    public static net.morimekta.providence.descriptor.PUnionDescriptorProvider<Declaration> provider() {
        return new _Provider();
    }

    @Override
    @javax.annotation.Nonnull
    public net.morimekta.providence.descriptor.PUnionDescriptor<Declaration> descriptor() {
        return kDescriptor;
    }

    public static final net.morimekta.providence.descriptor.PUnionDescriptor<Declaration> kDescriptor;

    private static final class _Descriptor
            extends net.morimekta.providence.descriptor.PUnionDescriptor<Declaration> {
        public _Descriptor() {
            super("p_model", "Declaration", _Builder::new, false);
        }

        @Override
        @javax.annotation.Nonnull
        public boolean isInnerType() {
            return false;
        }

        @Override
        @javax.annotation.Nonnull
        public boolean isAutoType() {
            return false;
        }

        @Override
        @javax.annotation.Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldByPojoName(String name) {
            return _Field.findByPojoName(name);
        }

        @Override
        @javax.annotation.Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }

        @Override
        public net.morimekta.providence.descriptor.PInterfaceDescriptor getImplementing() {
            return net.morimekta.providence.model.Decl.kDescriptor;
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static final class _Provider extends net.morimekta.providence.descriptor.PUnionDescriptorProvider<Declaration> {
        @Override
        @javax.annotation.Nonnull
        public net.morimekta.providence.descriptor.PUnionDescriptor<Declaration> descriptor() {
            return kDescriptor;
        }
    }

    /**
     * Make a <code>p_model.Declaration</code> builder.
     * @return The builder instance.
     */
    public static _Builder builder() {
        return new _Builder();
    }

    /**
     * ( &lt;enum&gt; | &lt;typedef&gt; | &lt;struct&gt; | &lt;service&gt; | &lt;const&gt; )
     */
    public static class _Builder
            extends net.morimekta.providence.PMessageBuilder<Declaration>
            implements Declaration_OrBuilder,
                       net.morimekta.providence.serializer.binary.BinaryReader {
        private Declaration._Field tUnionField;

        private boolean modified;

        private net.morimekta.providence.model.EnumType mDeclEnum;
        private net.morimekta.providence.model.EnumType._Builder mDeclEnum_builder;
        private net.morimekta.providence.model.TypedefType mDeclTypedef;
        private net.morimekta.providence.model.TypedefType._Builder mDeclTypedef_builder;
        private net.morimekta.providence.model.MessageType mDeclMessage;
        private net.morimekta.providence.model.MessageType._Builder mDeclMessage_builder;
        private net.morimekta.providence.model.ServiceType mDeclService;
        private net.morimekta.providence.model.ServiceType._Builder mDeclService_builder;
        private net.morimekta.providence.model.ConstType mDeclConst;
        private net.morimekta.providence.model.ConstType._Builder mDeclConst_builder;

        /**
         * Make a p_model.Declaration builder instance.
         */
        public _Builder() {
            modified = false;
        }

        /**
         * Make a mutating builder off a base p_model.Declaration.
         *
         * @param base The base Declaration
         */
        public _Builder(Declaration base) {
            this();

            tUnionField = base.tUnionField;

            mDeclEnum = base.mDeclEnum;
            mDeclTypedef = base.mDeclTypedef;
            mDeclMessage = base.mDeclMessage;
            mDeclService = base.mDeclService;
            mDeclConst = base.mDeclConst;
        }

        @javax.annotation.Nonnull
        @Override
        public Declaration._Builder merge(Declaration from) {
            if (!from.unionFieldIsSet()) {
                return this;
            }

            switch (from.unionField()) {
                case DECL_ENUM: {
                    if (tUnionField == Declaration._Field.DECL_ENUM && mDeclEnum != null) {
                        mDeclEnum = mDeclEnum.mutate().merge(from.getDeclEnum()).build();
                    } else {
                        setDeclEnum(from.getDeclEnum());
                    }
                    break;
                }
                case DECL_TYPEDEF: {
                    if (tUnionField == Declaration._Field.DECL_TYPEDEF && mDeclTypedef != null) {
                        mDeclTypedef = mDeclTypedef.mutate().merge(from.getDeclTypedef()).build();
                    } else {
                        setDeclTypedef(from.getDeclTypedef());
                    }
                    break;
                }
                case DECL_MESSAGE: {
                    if (tUnionField == Declaration._Field.DECL_MESSAGE && mDeclMessage != null) {
                        mDeclMessage = mDeclMessage.mutate().merge(from.getDeclMessage()).build();
                    } else {
                        setDeclMessage(from.getDeclMessage());
                    }
                    break;
                }
                case DECL_SERVICE: {
                    if (tUnionField == Declaration._Field.DECL_SERVICE && mDeclService != null) {
                        mDeclService = mDeclService.mutate().merge(from.getDeclService()).build();
                    } else {
                        setDeclService(from.getDeclService());
                    }
                    break;
                }
                case DECL_CONST: {
                    if (tUnionField == Declaration._Field.DECL_CONST && mDeclConst != null) {
                        mDeclConst = mDeclConst.mutate().merge(from.getDeclConst()).build();
                    } else {
                        setDeclConst(from.getDeclConst());
                    }
                    break;
                }
            }
            return this;
        }

        /**
         * Set the <code>decl_enum</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Declaration._Builder setDeclEnum(net.morimekta.providence.model.EnumType_OrBuilder value) {
            if (value == null) {
                return clearDeclEnum();
            }

            tUnionField = Declaration._Field.DECL_ENUM;
            modified = true;
            if (value instanceof net.morimekta.providence.model.EnumType._Builder) {
                value = ((net.morimekta.providence.model.EnumType._Builder) value).build();
            } else if (!(value instanceof net.morimekta.providence.model.EnumType)) {
                throw new java.lang.IllegalArgumentException("Invalid type for p_model.EnumType: " + value.getClass().getName());
            }
            mDeclEnum = (net.morimekta.providence.model.EnumType) value;
            mDeclEnum_builder = null;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>decl_enum</code> field.
         *
         * @return True if decl_enum has been set.
         */
        public boolean isSetDeclEnum() {
            return tUnionField == Declaration._Field.DECL_ENUM;
        }

        /**
         * Checks for presence of the <code>decl_enum</code> field.
         *
         * @return True if decl_enum is present.
         */
        public boolean hasDeclEnum() {
            return tUnionField == Declaration._Field.DECL_ENUM;
        }

        /**
         * Clear the <code>decl_enum</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Declaration._Builder clearDeclEnum() {
            if (tUnionField == Declaration._Field.DECL_ENUM) tUnionField = null;
            modified = true;
            mDeclEnum = null;
            mDeclEnum_builder = null;
            return this;
        }

        /**
         * Get the builder for the contained <code>decl_enum</code> message field.
         *
         * @return The field message builder
         */
        @javax.annotation.Nonnull
        public net.morimekta.providence.model.EnumType._Builder mutableDeclEnum() {
            if (tUnionField != Declaration._Field.DECL_ENUM) {
                clearDeclEnum();
            }
            tUnionField = Declaration._Field.DECL_ENUM;
            modified = true;

            if (mDeclEnum != null) {
                mDeclEnum_builder = mDeclEnum.mutate();
                mDeclEnum = null;
            } else if (mDeclEnum_builder == null) {
                mDeclEnum_builder = net.morimekta.providence.model.EnumType.builder();
            }
            return mDeclEnum_builder;
        }

        /**
         * @return The <code>decl_enum</code> field value
         */
        public net.morimekta.providence.model.EnumType getDeclEnum() {
            return mDeclEnum_builder != null ? mDeclEnum_builder.build() : mDeclEnum;
        }

        /**
         * @return Optional <code>decl_enum</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<net.morimekta.providence.model.EnumType> optionalDeclEnum() {
            return java.util.Optional.ofNullable(mDeclEnum_builder != null ? mDeclEnum_builder.build() : mDeclEnum);
        }

        /**
         * Set the <code>decl_typedef</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Declaration._Builder setDeclTypedef(net.morimekta.providence.model.TypedefType_OrBuilder value) {
            if (value == null) {
                return clearDeclTypedef();
            }

            tUnionField = Declaration._Field.DECL_TYPEDEF;
            modified = true;
            if (value instanceof net.morimekta.providence.model.TypedefType._Builder) {
                value = ((net.morimekta.providence.model.TypedefType._Builder) value).build();
            } else if (!(value instanceof net.morimekta.providence.model.TypedefType)) {
                throw new java.lang.IllegalArgumentException("Invalid type for p_model.TypedefType: " + value.getClass().getName());
            }
            mDeclTypedef = (net.morimekta.providence.model.TypedefType) value;
            mDeclTypedef_builder = null;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>decl_typedef</code> field.
         *
         * @return True if decl_typedef has been set.
         */
        public boolean isSetDeclTypedef() {
            return tUnionField == Declaration._Field.DECL_TYPEDEF;
        }

        /**
         * Checks for presence of the <code>decl_typedef</code> field.
         *
         * @return True if decl_typedef is present.
         */
        public boolean hasDeclTypedef() {
            return tUnionField == Declaration._Field.DECL_TYPEDEF;
        }

        /**
         * Clear the <code>decl_typedef</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Declaration._Builder clearDeclTypedef() {
            if (tUnionField == Declaration._Field.DECL_TYPEDEF) tUnionField = null;
            modified = true;
            mDeclTypedef = null;
            mDeclTypedef_builder = null;
            return this;
        }

        /**
         * Get the builder for the contained <code>decl_typedef</code> message field.
         *
         * @return The field message builder
         */
        @javax.annotation.Nonnull
        public net.morimekta.providence.model.TypedefType._Builder mutableDeclTypedef() {
            if (tUnionField != Declaration._Field.DECL_TYPEDEF) {
                clearDeclTypedef();
            }
            tUnionField = Declaration._Field.DECL_TYPEDEF;
            modified = true;

            if (mDeclTypedef != null) {
                mDeclTypedef_builder = mDeclTypedef.mutate();
                mDeclTypedef = null;
            } else if (mDeclTypedef_builder == null) {
                mDeclTypedef_builder = net.morimekta.providence.model.TypedefType.builder();
            }
            return mDeclTypedef_builder;
        }

        /**
         * @return The <code>decl_typedef</code> field value
         */
        public net.morimekta.providence.model.TypedefType getDeclTypedef() {
            return mDeclTypedef_builder != null ? mDeclTypedef_builder.build() : mDeclTypedef;
        }

        /**
         * @return Optional <code>decl_typedef</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<net.morimekta.providence.model.TypedefType> optionalDeclTypedef() {
            return java.util.Optional.ofNullable(mDeclTypedef_builder != null ? mDeclTypedef_builder.build() : mDeclTypedef);
        }

        /**
         * Set the <code>decl_message</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Declaration._Builder setDeclMessage(net.morimekta.providence.model.MessageType_OrBuilder value) {
            if (value == null) {
                return clearDeclMessage();
            }

            tUnionField = Declaration._Field.DECL_MESSAGE;
            modified = true;
            if (value instanceof net.morimekta.providence.model.MessageType._Builder) {
                value = ((net.morimekta.providence.model.MessageType._Builder) value).build();
            } else if (!(value instanceof net.morimekta.providence.model.MessageType)) {
                throw new java.lang.IllegalArgumentException("Invalid type for p_model.MessageType: " + value.getClass().getName());
            }
            mDeclMessage = (net.morimekta.providence.model.MessageType) value;
            mDeclMessage_builder = null;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>decl_message</code> field.
         *
         * @return True if decl_message has been set.
         */
        public boolean isSetDeclMessage() {
            return tUnionField == Declaration._Field.DECL_MESSAGE;
        }

        /**
         * Checks for presence of the <code>decl_message</code> field.
         *
         * @return True if decl_message is present.
         */
        public boolean hasDeclMessage() {
            return tUnionField == Declaration._Field.DECL_MESSAGE;
        }

        /**
         * Clear the <code>decl_message</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Declaration._Builder clearDeclMessage() {
            if (tUnionField == Declaration._Field.DECL_MESSAGE) tUnionField = null;
            modified = true;
            mDeclMessage = null;
            mDeclMessage_builder = null;
            return this;
        }

        /**
         * Get the builder for the contained <code>decl_message</code> message field.
         *
         * @return The field message builder
         */
        @javax.annotation.Nonnull
        public net.morimekta.providence.model.MessageType._Builder mutableDeclMessage() {
            if (tUnionField != Declaration._Field.DECL_MESSAGE) {
                clearDeclMessage();
            }
            tUnionField = Declaration._Field.DECL_MESSAGE;
            modified = true;

            if (mDeclMessage != null) {
                mDeclMessage_builder = mDeclMessage.mutate();
                mDeclMessage = null;
            } else if (mDeclMessage_builder == null) {
                mDeclMessage_builder = net.morimekta.providence.model.MessageType.builder();
            }
            return mDeclMessage_builder;
        }

        /**
         * @return The <code>decl_message</code> field value
         */
        public net.morimekta.providence.model.MessageType getDeclMessage() {
            return mDeclMessage_builder != null ? mDeclMessage_builder.build() : mDeclMessage;
        }

        /**
         * @return Optional <code>decl_message</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<net.morimekta.providence.model.MessageType> optionalDeclMessage() {
            return java.util.Optional.ofNullable(mDeclMessage_builder != null ? mDeclMessage_builder.build() : mDeclMessage);
        }

        /**
         * Set the <code>decl_service</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Declaration._Builder setDeclService(net.morimekta.providence.model.ServiceType_OrBuilder value) {
            if (value == null) {
                return clearDeclService();
            }

            tUnionField = Declaration._Field.DECL_SERVICE;
            modified = true;
            if (value instanceof net.morimekta.providence.model.ServiceType._Builder) {
                value = ((net.morimekta.providence.model.ServiceType._Builder) value).build();
            } else if (!(value instanceof net.morimekta.providence.model.ServiceType)) {
                throw new java.lang.IllegalArgumentException("Invalid type for p_model.ServiceType: " + value.getClass().getName());
            }
            mDeclService = (net.morimekta.providence.model.ServiceType) value;
            mDeclService_builder = null;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>decl_service</code> field.
         *
         * @return True if decl_service has been set.
         */
        public boolean isSetDeclService() {
            return tUnionField == Declaration._Field.DECL_SERVICE;
        }

        /**
         * Checks for presence of the <code>decl_service</code> field.
         *
         * @return True if decl_service is present.
         */
        public boolean hasDeclService() {
            return tUnionField == Declaration._Field.DECL_SERVICE;
        }

        /**
         * Clear the <code>decl_service</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Declaration._Builder clearDeclService() {
            if (tUnionField == Declaration._Field.DECL_SERVICE) tUnionField = null;
            modified = true;
            mDeclService = null;
            mDeclService_builder = null;
            return this;
        }

        /**
         * Get the builder for the contained <code>decl_service</code> message field.
         *
         * @return The field message builder
         */
        @javax.annotation.Nonnull
        public net.morimekta.providence.model.ServiceType._Builder mutableDeclService() {
            if (tUnionField != Declaration._Field.DECL_SERVICE) {
                clearDeclService();
            }
            tUnionField = Declaration._Field.DECL_SERVICE;
            modified = true;

            if (mDeclService != null) {
                mDeclService_builder = mDeclService.mutate();
                mDeclService = null;
            } else if (mDeclService_builder == null) {
                mDeclService_builder = net.morimekta.providence.model.ServiceType.builder();
            }
            return mDeclService_builder;
        }

        /**
         * @return The <code>decl_service</code> field value
         */
        public net.morimekta.providence.model.ServiceType getDeclService() {
            return mDeclService_builder != null ? mDeclService_builder.build() : mDeclService;
        }

        /**
         * @return Optional <code>decl_service</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<net.morimekta.providence.model.ServiceType> optionalDeclService() {
            return java.util.Optional.ofNullable(mDeclService_builder != null ? mDeclService_builder.build() : mDeclService);
        }

        /**
         * Set the <code>decl_const</code> field value.
         *
         * @param value The new value
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Declaration._Builder setDeclConst(net.morimekta.providence.model.ConstType_OrBuilder value) {
            if (value == null) {
                return clearDeclConst();
            }

            tUnionField = Declaration._Field.DECL_CONST;
            modified = true;
            if (value instanceof net.morimekta.providence.model.ConstType._Builder) {
                value = ((net.morimekta.providence.model.ConstType._Builder) value).build();
            } else if (!(value instanceof net.morimekta.providence.model.ConstType)) {
                throw new java.lang.IllegalArgumentException("Invalid type for p_model.ConstType: " + value.getClass().getName());
            }
            mDeclConst = (net.morimekta.providence.model.ConstType) value;
            mDeclConst_builder = null;
            return this;
        }

        /**
         * Checks for explicit presence of the <code>decl_const</code> field.
         *
         * @return True if decl_const has been set.
         */
        public boolean isSetDeclConst() {
            return tUnionField == Declaration._Field.DECL_CONST;
        }

        /**
         * Checks for presence of the <code>decl_const</code> field.
         *
         * @return True if decl_const is present.
         */
        public boolean hasDeclConst() {
            return tUnionField == Declaration._Field.DECL_CONST;
        }

        /**
         * Clear the <code>decl_const</code> field.
         *
         * @return The builder
         */
        @javax.annotation.Nonnull
        public Declaration._Builder clearDeclConst() {
            if (tUnionField == Declaration._Field.DECL_CONST) tUnionField = null;
            modified = true;
            mDeclConst = null;
            mDeclConst_builder = null;
            return this;
        }

        /**
         * Get the builder for the contained <code>decl_const</code> message field.
         *
         * @return The field message builder
         */
        @javax.annotation.Nonnull
        public net.morimekta.providence.model.ConstType._Builder mutableDeclConst() {
            if (tUnionField != Declaration._Field.DECL_CONST) {
                clearDeclConst();
            }
            tUnionField = Declaration._Field.DECL_CONST;
            modified = true;

            if (mDeclConst != null) {
                mDeclConst_builder = mDeclConst.mutate();
                mDeclConst = null;
            } else if (mDeclConst_builder == null) {
                mDeclConst_builder = net.morimekta.providence.model.ConstType.builder();
            }
            return mDeclConst_builder;
        }

        /**
         * @return The <code>decl_const</code> field value
         */
        public net.morimekta.providence.model.ConstType getDeclConst() {
            return mDeclConst_builder != null ? mDeclConst_builder.build() : mDeclConst;
        }

        /**
         * @return Optional <code>decl_const</code> field value
         */
        @javax.annotation.Nonnull
        public java.util.Optional<net.morimekta.providence.model.ConstType> optionalDeclConst() {
            return java.util.Optional.ofNullable(mDeclConst_builder != null ? mDeclConst_builder.build() : mDeclConst);
        }

        /**
         * Checks if the <code>Declaration</code> union has been modified since the
         * builder was created.
         *
         * @return True if Declaration has been modified.
         */
        public boolean isUnionModified() {
            return modified;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) return true;
            if (o == null || !o.getClass().equals(getClass())) return false;
            Declaration._Builder other = (Declaration._Builder) o;
            return java.util.Objects.equals(tUnionField, other.tUnionField) &&
                   java.util.Objects.equals(getDeclEnum(), other.getDeclEnum()) &&
                   java.util.Objects.equals(getDeclTypedef(), other.getDeclTypedef()) &&
                   java.util.Objects.equals(getDeclMessage(), other.getDeclMessage()) &&
                   java.util.Objects.equals(getDeclService(), other.getDeclService()) &&
                   java.util.Objects.equals(getDeclConst(), other.getDeclConst());
        }

        @Override
        public int hashCode() {
            return java.util.Objects.hash(
                    Declaration.class,
                    Declaration._Field.DECL_ENUM, getDeclEnum(),
                    Declaration._Field.DECL_TYPEDEF, getDeclTypedef(),
                    Declaration._Field.DECL_MESSAGE, getDeclMessage(),
                    Declaration._Field.DECL_SERVICE, getDeclService(),
                    Declaration._Field.DECL_CONST, getDeclConst());
        }

        @Override
        @SuppressWarnings("unchecked")
        public net.morimekta.providence.PMessageBuilder mutator(int key) {
            switch (key) {
                case 1: return mutableDeclEnum();
                case 2: return mutableDeclTypedef();
                case 3: return mutableDeclMessage();
                case 4: return mutableDeclService();
                case 5: return mutableDeclConst();
                default: throw new IllegalArgumentException("Not a message field ID: " + key);
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public Declaration._Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setDeclEnum((net.morimekta.providence.model.EnumType) value); break;
                case 2: setDeclTypedef((net.morimekta.providence.model.TypedefType) value); break;
                case 3: setDeclMessage((net.morimekta.providence.model.MessageType) value); break;
                case 4: setDeclService((net.morimekta.providence.model.ServiceType) value); break;
                case 5: setDeclConst((net.morimekta.providence.model.ConstType) value); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean isSet(int key) {
            switch (key) {
                case 1: return tUnionField == Declaration._Field.DECL_ENUM;
                case 2: return tUnionField == Declaration._Field.DECL_TYPEDEF;
                case 3: return tUnionField == Declaration._Field.DECL_MESSAGE;
                case 4: return tUnionField == Declaration._Field.DECL_SERVICE;
                case 5: return tUnionField == Declaration._Field.DECL_CONST;
                default: break;
            }
            return false;
        }

        @Override
        public boolean isModified(int key) {
            return modified;
        }

        @Override
        @SuppressWarnings("unchecked")
        public <T> T get(int key) {
            switch(key) {
                case 1: return (T) getDeclEnum();
                case 2: return (T) getDeclTypedef();
                case 3: return (T) getDeclMessage();
                case 4: return (T) getDeclService();
                case 5: return (T) getDeclConst();
                default: return null;
            }
        }

        @Override
        public boolean has(int key) {
            switch(key) {
                case 1: return tUnionField == _Field.DECL_ENUM;
                case 2: return tUnionField == _Field.DECL_TYPEDEF;
                case 3: return tUnionField == _Field.DECL_MESSAGE;
                case 4: return tUnionField == _Field.DECL_SERVICE;
                case 5: return tUnionField == _Field.DECL_CONST;
                default: return false;
            }
        }

        @javax.annotation.Nonnull
        @Override
        @SuppressWarnings("unchecked")
        public Declaration._Builder addTo(int key, Object value) {
            switch (key) {
                default: break;
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public Declaration._Builder clear(int key) {
            switch (key) {
                case 1: clearDeclEnum(); break;
                case 2: clearDeclTypedef(); break;
                case 3: clearDeclMessage(); break;
                case 4: clearDeclService(); break;
                case 5: clearDeclConst(); break;
                default: break;
            }
            return this;
        }

        @Override
        public boolean valid() {
            if (tUnionField == null) {
                return false;
            }

            switch (tUnionField) {
                case DECL_ENUM: return mDeclEnum != null || mDeclEnum_builder != null;
                case DECL_TYPEDEF: return mDeclTypedef != null || mDeclTypedef_builder != null;
                case DECL_MESSAGE: return mDeclMessage != null || mDeclMessage_builder != null;
                case DECL_SERVICE: return mDeclService != null || mDeclService_builder != null;
                case DECL_CONST: return mDeclConst != null || mDeclConst_builder != null;
                default: return true;
            }
        }

        @Override
        public Declaration._Builder validate() {
            if (!valid()) {
                throw new java.lang.IllegalStateException("No union field set in p_model.Declaration");
            }
            return this;
        }

        @javax.annotation.Nonnull
        @Override
        public net.morimekta.providence.descriptor.PUnionDescriptor<Declaration> descriptor() {
            return Declaration.kDescriptor;
        }

        @Override
        public void readBinary(net.morimekta.util.io.BigEndianBinaryReader reader, boolean strict) throws java.io.IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                int field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 12) {
                            mDeclEnum = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.model.EnumType.kDescriptor, strict);
                            tUnionField = Declaration._Field.DECL_ENUM;
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for p_model.Declaration.decl_enum, should be struct(12)");
                        }
                        break;
                    }
                    case 2: {
                        if (type == 12) {
                            mDeclTypedef = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.model.TypedefType.kDescriptor, strict);
                            tUnionField = Declaration._Field.DECL_TYPEDEF;
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for p_model.Declaration.decl_typedef, should be struct(12)");
                        }
                        break;
                    }
                    case 3: {
                        if (type == 12) {
                            mDeclMessage = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.model.MessageType.kDescriptor, strict);
                            tUnionField = Declaration._Field.DECL_MESSAGE;
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for p_model.Declaration.decl_message, should be struct(12)");
                        }
                        break;
                    }
                    case 4: {
                        if (type == 12) {
                            mDeclService = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.model.ServiceType.kDescriptor, strict);
                            tUnionField = Declaration._Field.DECL_SERVICE;
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for p_model.Declaration.decl_service, should be struct(12)");
                        }
                        break;
                    }
                    case 5: {
                        if (type == 12) {
                            mDeclConst = net.morimekta.providence.serializer.binary.BinaryFormatUtils.readMessage(reader, net.morimekta.providence.model.ConstType.kDescriptor, strict);
                            tUnionField = Declaration._Field.DECL_CONST;
                        } else {
                            throw new net.morimekta.providence.serializer.SerializerException("Wrong type " + net.morimekta.providence.serializer.binary.BinaryType.asString(type) + " for p_model.Declaration.decl_const, should be struct(12)");
                        }
                        break;
                    }
                    default: {
                        net.morimekta.providence.serializer.binary.BinaryFormatUtils.readFieldValue(reader, new net.morimekta.providence.serializer.binary.BinaryFormatUtils.FieldInfo(field, type), null, false);
                        break;
                    }
                }
                type = reader.expectByte();
            }
        }

        @Override
        @javax.annotation.Nonnull
        public Declaration build() {
            return new Declaration(this);
        }
    }
}
