/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.jar.Manifest;

public class FactoryLoader<Factory> {
    private final String manifestProperty;

    public FactoryLoader(String manifestProperty) {
        this.manifestProperty = manifestProperty;
    }

    public List<Factory> getFactories(File path) {
        try {
            List<File> jars = this.findJarFiles(path);
            ArrayList<Factory> factories = new ArrayList<Factory>();
            for (File jar : jars) {
                URLClassLoader classLoader = this.getClassLoader(jar);
                Factory factory = this.getFactory(classLoader);
                if (factory == null) continue;
                factories.add(factory);
            }
            return factories;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Factory getFactory(File file) {
        try {
            return this.getFactory(this.getClassLoader(file));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private List<File> findJarFiles(File path) {
        ArrayList<File> out = new ArrayList<File>();
        if (path.isFile()) {
            out.add(path);
        } else {
            File[] files = path.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.getName().toLowerCase(Locale.US).endsWith(".jar")) continue;
                    out.add(file);
                }
            }
        }
        return out;
    }

    private URLClassLoader getClassLoader(File file) throws MalformedURLException {
        return URLClassLoader.newInstance(new URL[]{file.toURI().toURL()}, ClassLoader.getSystemClassLoader());
    }

    private Factory getFactory(URLClassLoader classLoader) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        URL url = classLoader.findResource("META-INF/MANIFEST.MF");
        Manifest manifest = new Manifest(url.openStream());
        String factoryClass = manifest.getMainAttributes().getValue(this.manifestProperty);
        if (factoryClass == null) {
            return null;
        }
        Class<?> klass = classLoader.loadClass(factoryClass);
        try {
            return (Factory)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

