/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.json;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.generator.Generator;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.util.FileManager;
import net.morimekta.providence.model.ConstType;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.model.EnumType;
import net.morimekta.providence.model.EnumValue;
import net.morimekta.providence.model.FieldRequirement;
import net.morimekta.providence.model.FieldType;
import net.morimekta.providence.model.FunctionType;
import net.morimekta.providence.model.MessageType;
import net.morimekta.providence.model.MessageVariant;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.model.ServiceType;
import net.morimekta.providence.model.TypedefType;
import net.morimekta.providence.reflect.ProgramRegistry;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.model.AnnotationDeclaration;
import net.morimekta.providence.reflect.model.ConstDeclaration;
import net.morimekta.providence.reflect.model.EnumDeclaration;
import net.morimekta.providence.reflect.model.EnumValueDeclaration;
import net.morimekta.providence.reflect.model.FieldDeclaration;
import net.morimekta.providence.reflect.model.IncludeDeclaration;
import net.morimekta.providence.reflect.model.MessageDeclaration;
import net.morimekta.providence.reflect.model.MethodDeclaration;
import net.morimekta.providence.reflect.model.NamespaceDeclaration;
import net.morimekta.providence.reflect.model.ProgramDeclaration;
import net.morimekta.providence.reflect.model.ServiceDeclaration;
import net.morimekta.providence.reflect.model.TypedefDeclaration;
import net.morimekta.providence.reflect.util.ReflectionUtils;
import net.morimekta.providence.serializer.JsonSerializer;

public class JsonGenerator
extends Generator {
    private final JsonSerializer serializer = new JsonSerializer().pretty();

    public JsonGenerator(FileManager fileManager) {
        super(fileManager);
    }

    @Override
    public void generate(ProgramRegistry registry) throws IOException, GeneratorException {
        ProgramType doc = this.convertProgram(registry.getProgramType());
        CProgram program = registry.getProgram();
        Path programFile = Paths.get(program.getProgramFilePath(), new String[0]);
        String programName = ReflectionUtils.programNameFromPath((String)programFile.toString());
        this.getFileManager().createIfMissingOrOutdated(programFile, null, programName + ".json", out -> {
            this.serializer.serialize(out, (PMessageOrBuilder)doc);
            out.write(10);
        });
    }

    private ProgramType convertProgram(ProgramDeclaration declaration) {
        ProgramType._Builder program = ProgramType.builder();
        program.setProgramName(declaration.getProgramName());
        for (IncludeDeclaration include : declaration.getIncludes()) {
            String includedProgram = ReflectionUtils.programNameFromPath((String)include.getFilePath());
            program.putInIncludes(include.getProgramName(), includedProgram + ".json");
        }
        for (NamespaceDeclaration namespace : declaration.getNamespaces()) {
            program.putInNamespaces(namespace.getLanguage(), namespace.getNamespace());
        }
        for (net.morimekta.providence.reflect.model.Declaration decl : declaration.getDeclarationList()) {
            if (decl instanceof TypedefDeclaration) {
                program.addToDecl(this.convertTypedef((TypedefDeclaration)decl));
                continue;
            }
            if (decl instanceof EnumDeclaration) {
                program.addToDecl(this.convertEnum((EnumDeclaration)decl));
                continue;
            }
            if (decl instanceof MessageDeclaration) {
                program.addToDecl(this.convertMessage((MessageDeclaration)decl));
                continue;
            }
            if (decl instanceof ConstDeclaration) {
                program.addToDecl(this.convertConst((ConstDeclaration)decl));
                continue;
            }
            if (!(decl instanceof ServiceDeclaration)) continue;
            program.addToDecl(this.convertService((ServiceDeclaration)decl));
        }
        return program.build();
    }

    private Declaration convertService(ServiceDeclaration decl) {
        return Declaration.withDeclService(ServiceType.builder().setDocumentation(decl.getDocumentation()).setName(decl.getName()).setExtend(decl.getExtending()).setMethods(this.convertMethods(decl.getMethods())).setAnnotations(this.makeAnnotations(decl.getAnnotations())).build());
    }

    private List<FunctionType> convertMethods(List<MethodDeclaration> methods) {
        ArrayList<FunctionType> functions = new ArrayList<FunctionType>();
        for (MethodDeclaration method : methods) {
            functions.add(FunctionType.builder().setDocumentation(method.getDocumentation()).setOneWay(method.isOneWay() ? Boolean.TRUE : null).setReturnType(method.getReturnType()).setName(method.getName()).setParams(this.convertFields(method.getParams())).setExceptions(method.getThrowing() != null && !method.getThrowing().isEmpty() ? this.convertFields(method.getThrowing()) : null).setAnnotations(this.makeAnnotations(method.getAnnotations())).build());
        }
        return functions;
    }

    private Declaration convertConst(ConstDeclaration decl) {
        return Declaration.withDeclConst(ConstType.builder().setDocumentation(decl.getDocumentation()).setName(decl.getName()).setType(decl.getType()).setValue(decl.getValue()).setAnnotations(this.makeAnnotations(decl.getAnnotations())).build());
    }

    private Declaration convertMessage(MessageDeclaration decl) {
        return Declaration.withDeclMessage(MessageType.builder().setDocumentation(decl.getDocumentation()).setVariant(MessageVariant.findByName(decl.getVariant().toString())).setName(decl.getName()).setImplementing(decl.getImplementing() == null ? null : decl.getImplementing().toString()).setFields(this.convertFields(decl.getFields())).setAnnotations(this.makeAnnotations(decl.getAnnotations())).build());
    }

    private Declaration convertEnum(EnumDeclaration decl) {
        ArrayList<EnumValue> values = new ArrayList<EnumValue>();
        for (EnumValueDeclaration value : decl.getValues()) {
            values.add(EnumValue.builder().setDocumentation(value.getDocumentation()).setName(value.getName()).setId(value.getIdToken() == null ? null : Integer.valueOf(value.getId())).setAnnotations(this.makeAnnotations(value.getAnnotations())).build());
        }
        return Declaration.withDeclEnum(EnumType.builder().setDocumentation(decl.getDocumentation()).setName(decl.getName()).setValues(values).setAnnotations(this.makeAnnotations(decl.getAnnotations())).build());
    }

    private List<FieldType> convertFields(List<FieldDeclaration> fields) {
        if (fields == null) {
            return null;
        }
        ArrayList<FieldType> out = new ArrayList<FieldType>();
        for (FieldDeclaration field : fields) {
            out.add(this.convertField(field));
        }
        return out;
    }

    private FieldType convertField(FieldDeclaration decl) {
        return FieldType.builder().setDocumentation(decl.getDocumentation()).setId(decl.getIdToken() == null ? null : Integer.valueOf(decl.getId())).setRequirement(decl.getRequirementToken() == null ? null : FieldRequirement.findByName(decl.getRequirement().name())).setType(decl.getType()).setName(decl.getName()).setDefaultValue(decl.getDefaultValue()).setAnnotations(this.makeAnnotations(decl.getAnnotations())).build();
    }

    private Map<String, String> makeAnnotations(List<AnnotationDeclaration> annotations) {
        if (annotations == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (AnnotationDeclaration annotation : annotations) {
            map.put(annotation.getTag(), annotation.getValue());
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    private Declaration convertTypedef(TypedefDeclaration declaration) {
        return Declaration.withDeclTypedef(TypedefType.builder().setDocumentation(declaration.getDocumentation()).setName(declaration.getName()).setType(declaration.getType()).build());
    }
}

