/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import net.morimekta.util.FileUtil;

public class FileManager {
    private final Path root;
    private final Set<Path> generatedFiles;

    public FileManager(Path root) {
        this.root = root;
        this.generatedFiles = new HashSet<Path>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIfMissingOrOutdated(Path programFile, String subPath, String fileName, CreateHandler create) throws IOException {
        long outputModified;
        long programModified;
        Path outputFile = this.absolutePath(subPath, fileName);
        if (Files.exists(outputFile, new LinkOption[0]) && (programModified = Files.getLastModifiedTime(programFile, new LinkOption[0]).toMillis()) < (outputModified = Files.getLastModifiedTime(outputFile, new LinkOption[0]).toMillis())) {
            return;
        }
        try (OutputStream out = this.createInternal(outputFile);){
            try {
                create.create(out);
            }
            finally {
                out.flush();
            }
        }
    }

    private Path relativePath(Path path) {
        return path.relativize(this.root);
    }

    private Path absolutePath(String path, String name) throws IOException {
        Path tmp = this.root;
        if (path != null) {
            tmp = tmp.resolve(path);
        }
        tmp = tmp.resolve(name);
        return FileUtil.readCanonicalPath((Path)tmp);
    }

    private OutputStream createInternal(Path file) throws IOException {
        if (this.generatedFiles.contains(file)) {
            throw new IOException("File " + this.relativePath(file) + " already created.");
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        this.generatedFiles.add(file);
        return Files.newOutputStream(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @FunctionalInterface
    public static interface CreateHandler {
        public void create(OutputStream var1) throws IOException;
    }
}

