/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class FileManager {
    private final File root;
    private final Set<String> generatedFiles;

    public FileManager(File root) {
        this.root = root;
        this.generatedFiles = new HashSet<String>();
    }

    protected String relativePath(String path, String name) {
        if (path == null || path.isEmpty()) {
            return name;
        }
        return String.format(Locale.US, "%s%c%s", path, Character.valueOf(File.separatorChar), name);
    }

    protected String absolutePath(String path, String name) throws IOException {
        return new File(this.root, this.relativePath(path, name)).getCanonicalPath();
    }

    public OutputStream create(String path, String name) throws IOException {
        File file = new File(this.absolutePath(path, name));
        if (this.generatedFiles.contains(file.getCanonicalPath())) {
            throw new IOException("File " + path + File.separator + name + " already created.");
        }
        Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        if (!Files.exists(file.toPath(), new LinkOption[0])) {
            Files.createFile(file.toPath(), new FileAttribute[0]);
        }
        this.generatedFiles.add(file.getCanonicalPath());
        return new FileOutputStream(file, false);
    }

    public void finalize(OutputStream stream) throws IOException {
        stream.flush();
        stream.close();
    }
}

