/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.json;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.stream.Collectors;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.generator.Generator;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.util.FileManager;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.reflect.util.ProgramTypeRegistry;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.SerializerException;

public class JsonGenerator
extends Generator {
    private final JsonSerializer serializer = new JsonSerializer().pretty();

    public JsonGenerator(FileManager fileManager) {
        super(fileManager);
    }

    @Override
    public void generate(ProgramTypeRegistry registry) throws IOException, GeneratorException {
        ProgramType doc = registry.getProgramType();
        if (doc.hasIncludes()) {
            doc = doc.mutate().setIncludes((Collection)doc.getIncludes().stream().map(path -> path.replaceAll("(\\.thrift)$", ".json")).collect(Collectors.toList())).build();
        }
        OutputStream out = this.getFileManager().create(null, doc.getProgramName() + ".json");
        try {
            this.serializer.serialize(out, (PMessage)doc);
            out.write(10);
        }
        catch (SerializerException e) {
            throw new GeneratorException("Unable to serialize document.", e);
        }
        this.getFileManager().finalize(out);
    }
}

