/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class FileManager {
    private final File root;
    private final Set<String> generatedFiles;

    public FileManager(File root) {
        this.root = root;
        this.generatedFiles = new HashSet<String>();
    }

    protected String relativePath(String path, String name) {
        if (path == null || path.isEmpty()) {
            return name;
        }
        return String.format("%s%c%s", path, Character.valueOf(File.separatorChar), name);
    }

    protected String absolutePath(String path, String name) throws IOException {
        return new File(this.root, this.relativePath(path, name)).getCanonicalPath();
    }

    public OutputStream create(String path, String name) throws IOException {
        File file = new File(this.absolutePath(path, name));
        if (this.generatedFiles.contains(file.getCanonicalPath())) {
            throw new IOException("File " + path + File.separator + name + " already created.");
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
        this.generatedFiles.add(file.getCanonicalPath());
        return new FileOutputStream(file, false);
    }

    public void finalize(OutputStream stream) throws IOException {
        stream.flush();
        stream.close();
    }
}

