/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.tiny;

import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.generator.Generator;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.tiny.TinyConstantsFormat;
import net.morimekta.providence.generator.format.java.tiny.TinyEnumFormat;
import net.morimekta.providence.generator.format.java.tiny.TinyMessageFormat;
import net.morimekta.providence.generator.format.java.tiny.TinyOptions;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.generator.util.FileManager;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.util.TypeRegistry;
import net.morimekta.util.io.IndentedPrintWriter;

public class TinyGenerator
extends Generator {
    private final TinyOptions options;
    private final JHelper helper;

    public TinyGenerator(FileManager manager, TypeRegistry registry, TinyOptions options) {
        super(manager);
        this.options = options;
        this.helper = new JHelper(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(CDocument document) throws IOException, GeneratorException {
        String javaPackage = JUtils.getJavaPackage(document);
        TinyMessageFormat messageFormatter = new TinyMessageFormat(this.helper, this.options);
        TinyEnumFormat enumFormatter = new TinyEnumFormat(this.helper, this.options);
        String path = JUtils.getPackageClassPath(javaPackage);
        if (document.getConstants().size() > 0) {
            String file = this.helper.getConstantsClassName(document) + ".java";
            OutputStream out = this.getFileManager().create(path, file);
            try {
                TinyConstantsFormat constFormat = new TinyConstantsFormat(this.helper);
                IndentedPrintWriter writer = new IndentedPrintWriter(out);
                constFormat.format(writer, document);
                writer.flush();
            }
            finally {
                try {
                    this.getFileManager().finalize(out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (PDeclaredDescriptor type : document.getDeclaredTypes()) {
            String file = JUtils.getClassName(type) + ".java";
            OutputStream out = this.getFileManager().create(path, file);
            IndentedPrintWriter writer = new IndentedPrintWriter(out);
            try {
                this.appendFileHeader(writer, document);
                switch (type.getType()) {
                    case MESSAGE: {
                        messageFormatter.format(writer, (PStructDescriptor)type);
                        break;
                    }
                    case ENUM: {
                        enumFormatter.format(writer, (CEnumDescriptor)type);
                        break;
                    }
                    default: {
                        throw new GeneratorException("Unhandled declaration type.");
                    }
                }
                writer.flush();
            }
            finally {
                try {
                    writer.flush();
                    this.getFileManager().finalize(out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void appendFileHeader(IndentedPrintWriter writer, CDocument document) throws GeneratorException, IOException {
        writer.format("package %s;", new Object[]{this.helper.getJavaPackage(document)}).newline();
    }
}

