/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.tiny;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.tiny.TinyOptions;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CEnumValue;
import net.morimekta.util.Numeric;
import net.morimekta.util.Stringable;
import net.morimekta.util.io.IndentedPrintWriter;

public class TinyEnumFormat {
    private final JHelper helper;
    private final TinyOptions options;

    public TinyEnumFormat(JHelper helper, TinyOptions options) {
        this.helper = helper;
        this.options = options;
    }

    public void format(IndentedPrintWriter writer, CEnumDescriptor type) throws GeneratorException {
        String simpleClass = JUtils.getClassName(type);
        if (type.getComment() != null) {
            new BlockCommentBuilder(writer).comment(type.getComment()).finish();
        }
        if (this.options.jackson) {
            writer.formatln("@%s(", new Object[]{JsonDeserialize.class.getName()}).formatln("        using = %s._Deserializer.class)", new Object[]{simpleClass});
        }
        if (JAnnotation.isDeprecated((CAnnotatedDescriptor)type)) {
            writer.appendln((CharSequence)"@Deprecated");
        }
        writer.formatln("public enum %s implements %s, %s {", new Object[]{simpleClass, Stringable.class.getName(), Numeric.class.getName()}).begin();
        for (CEnumValue v : type.getValues()) {
            if (v.getComment() != null) {
                new BlockCommentBuilder(writer).comment(type.getComment()).finish();
            }
            if (JAnnotation.isDeprecated((CAnnotatedDescriptor)v)) {
                writer.appendln((CharSequence)"@Deprecated");
            }
            writer.formatln("%s(%d, \"%s\"),", new Object[]{JUtils.enumConst((PEnumValue)v), v.getValue(), v.getName()});
        }
        writer.appendln(';').newline();
        writer.appendln((CharSequence)"private final int mValue;").appendln((CharSequence)"private final String mName;").newline().formatln("%s(int value, String name) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"mValue = value;").appendln((CharSequence)"mName = name;").end().appendln((CharSequence)"}").newline();
        if (this.options.jackson) {
            writer.formatln("@%s", new Object[]{JsonValue.class.getName()});
        }
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int asInteger() {").begin().appendln((CharSequence)"return mValue;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String asString() {").begin().appendln((CharSequence)"return mName;").end().appendln('}').newline();
        if (this.options.jackson) {
            this.appendJacksonDeserializer(writer, type);
        }
        writer.formatln("public static %s forValue(int value) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"switch (value) {").begin();
        for (CEnumValue value : type.getValues()) {
            writer.formatln("case %d: return %s.%s;", new Object[]{value.getValue(), simpleClass, value.getName().toUpperCase()});
        }
        writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
        writer.formatln("public static %s forName(String name) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"switch (name) {").begin();
        for (CEnumValue value : type.getValues()) {
            writer.formatln("case \"%s\": return %s.%s;", new Object[]{value.getName(), simpleClass, value.getName().toUpperCase()});
        }
        writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}');
        writer.end().appendln('}').newline();
    }

    private void appendJacksonDeserializer(IndentedPrintWriter writer, CEnumDescriptor type) throws GeneratorException {
        String instanceType = JUtils.getClassName(type);
        writer.formatln("public static class _Deserializer extends %s<%s> {", new Object[]{JsonDeserializer.class.getName(), instanceType}).begin();
        writer.appendln((CharSequence)"@Override").formatln("public %s deserialize(%s jp,", new Object[]{instanceType, JsonParser.class.getName()}).formatln("       %s             %s ctxt)", new Object[]{instanceType.replaceAll("[\\S]", " "), DeserializationContext.class.getName()}).formatln("        throws %s,", new Object[]{IOException.class.getName()}).formatln("               %s {", new Object[]{JsonProcessingException.class.getName()}).begin();
        writer.formatln("if (jp.getCurrentToken() == %s.VALUE_NUMBER_INT) {", new Object[]{JsonToken.class.getName()}).formatln("    return %s.forValue(jp.getIntValue());", new Object[]{instanceType}).formatln("} else if (jp.getCurrentToken() == %s.VALUE_STRING) {", new Object[]{JsonToken.class.getName()}).formatln("    return %s.forName(jp.getText());", new Object[]{instanceType}).appendln((CharSequence)"} else {").formatln("    throw new %s(jp, \"Invalid token for enum deserialization \" + jp.getText());", new Object[]{JsonParseException.class.getName()}).appendln('}');
        writer.end().formatln("}", new Object[0]).end().formatln("}", new Object[0]).newline();
    }
}

