/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumBuilderFactory;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptorProvider;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CEnumValue;
import net.morimekta.util.io.IndentedPrintWriter;

public class JEnumFormat {
    private final JOptions options;

    JEnumFormat(JOptions options) {
        this.options = options;
    }

    public void format(IndentedPrintWriter writer, CEnumDescriptor type) throws GeneratorException {
        String simpleClass = JUtils.getClassName(type);
        if (type.getComment() != null) {
            new BlockCommentBuilder(writer).comment(type.getComment()).finish();
        }
        if (JAnnotation.isDeprecated((CAnnotatedDescriptor)type)) {
            writer.appendln((CharSequence)"@Deprecated");
        }
        writer.formatln("public enum %s implements %s<%s> {", new Object[]{simpleClass, PEnumValue.class.getName(), simpleClass}).begin();
        for (CEnumValue v : type.getValues()) {
            if (v.getComment() != null) {
                new BlockCommentBuilder(writer).comment(type.getComment()).finish();
            }
            if (JAnnotation.isDeprecated((CAnnotatedDescriptor)v)) {
                writer.appendln((CharSequence)"@Deprecated");
            }
            writer.formatln("%s(%d, \"%s\"),", new Object[]{JUtils.enumConst((PEnumValue)v), v.getValue(), v.getName()});
        }
        writer.appendln(';').newline();
        writer.appendln((CharSequence)"private final int mValue;").appendln((CharSequence)"private final String mName;").newline().formatln("%s(int value, String name) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"mValue = value;").appendln((CharSequence)"mName = name;").end().appendln((CharSequence)"}").newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int getValue() {").begin().appendln((CharSequence)"return mValue;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String getName() {").begin().appendln((CharSequence)"return mName;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int asInteger() {").begin().appendln((CharSequence)"return mValue;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String asString() {").begin().appendln((CharSequence)"return mName;").end().appendln('}').newline();
        writer.formatln("public static %s forValue(int value) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"switch (value) {").begin();
        for (CEnumValue value : type.getValues()) {
            writer.formatln("case %d: return %s.%s;", new Object[]{value.getValue(), simpleClass, JUtils.enumConst((PEnumValue)value)});
        }
        writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
        writer.formatln("public static %s forName(String name) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"switch (name) {").begin();
        for (CEnumValue value : type.getValues()) {
            writer.formatln("case \"%s\": return %s.%s;", new Object[]{value.getName(), simpleClass, JUtils.enumConst((PEnumValue)value)});
        }
        writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
        this.appendBuilder(writer, (PEnumDescriptor<?>)type);
        this.appendDescriptor(writer, (PEnumDescriptor<?>)type);
        writer.end().appendln('}').newline();
    }

    private void appendDescriptor(IndentedPrintWriter writer, PEnumDescriptor<?> type) {
        String simpleClass = JUtils.getClassName(type);
        writer.formatln("public static final %s<%s> kDescriptor;", new Object[]{PEnumDescriptor.class.getName(), simpleClass}).newline();
        writer.appendln((CharSequence)"@Override").formatln("public %s<%s> descriptor() {", new Object[]{PEnumDescriptor.class.getName(), simpleClass}).begin().appendln((CharSequence)"return kDescriptor;").end().appendln('}').newline();
        writer.formatln("public static %s<%s> provider() {", new Object[]{PEnumDescriptorProvider.class.getName(), simpleClass}).begin().formatln("return new %s<%s>(kDescriptor);", new Object[]{PEnumDescriptorProvider.class.getName(), simpleClass}).end().appendln('}').newline();
        writer.appendln((CharSequence)"private static class _Factory").begin().formatln("    extends %s<%s> {", new Object[]{PEnumBuilderFactory.class.getName(), simpleClass}).appendln((CharSequence)"@Override").formatln("public %s._Builder builder() {", new Object[]{simpleClass}).begin().formatln("return new %s._Builder();", new Object[]{simpleClass}).end().appendln('}').end().appendln('}').newline();
        writer.appendln((CharSequence)"private static class _Descriptor").formatln("        extends %s<%s> {", new Object[]{PEnumDescriptor.class.getName(), simpleClass}).begin().appendln((CharSequence)"public _Descriptor() {").begin().formatln("super(\"%s\", \"%s\", new _Factory());", new Object[]{type.getPackageName(), type.getName(), simpleClass}).end().appendln('}').newline().appendln((CharSequence)"@Override").formatln("public %s[] getValues() {", new Object[]{simpleClass}).begin().formatln("return %s.values();", new Object[]{simpleClass}).end().appendln('}').newline().appendln((CharSequence)"@Override").formatln("public %s getValueById(int id) {", new Object[]{simpleClass}).begin().formatln("return %s.forValue(id);", new Object[]{simpleClass}).end().appendln('}').newline().appendln((CharSequence)"@Override").formatln("public %s getValueByName(String name) {", new Object[]{simpleClass}).begin().formatln("return %s.forName(name);", new Object[]{simpleClass}).end().appendln('}').end().appendln('}').newline();
        writer.formatln("static {", new Object[]{simpleClass}).begin();
        writer.appendln((CharSequence)"kDescriptor = new _Descriptor();").end().appendln('}');
    }

    private void appendBuilder(IndentedPrintWriter writer, PEnumDescriptor<?> type) {
        String simpleClass = JUtils.getClassName(type);
        writer.formatln("public static class _Builder extends %s<%s> {", new Object[]{PEnumBuilder.class.getName(), simpleClass}).begin().formatln("%s mValue;", new Object[]{simpleClass}).newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder setByValue(int value) {").begin().formatln("mValue = %s.forValue(value);", new Object[]{simpleClass}).appendln((CharSequence)"return this;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public _Builder setByName(String name) {").begin().formatln("mValue = %s.forName(name);", new Object[]{simpleClass}).appendln((CharSequence)"return this;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean isValid() {").begin().appendln((CharSequence)"return mValue != null;").end().appendln('}').newline();
        writer.appendln((CharSequence)"@Override").formatln("public %s build() {", new Object[]{simpleClass}).begin().appendln((CharSequence)"return mValue;").end().appendln('}');
        writer.end().appendln('}').newline();
    }
}

