/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.tiny;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.tiny.TinyMessageBuilderFormat;
import net.morimekta.providence.generator.format.java.tiny.TinyMessageOverridesFormat;
import net.morimekta.providence.generator.format.java.tiny.TinyValueFormat;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.ContainerType;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JOptions;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.util.Stringable;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class TinyMessageFormat {
    public static final String DBL_INDENT = "        ";
    private final JHelper helper;
    private final JOptions options;

    public TinyMessageFormat(JHelper helper, JOptions options) {
        this.helper = helper;
        this.options = options;
    }

    public void format(IndentedPrintWriter writer, PStructDescriptor<?, ?> descriptor) throws GeneratorException, IOException {
        JMessage message = new JMessage(descriptor, this.helper);
        TinyMessageOverridesFormat overrides = new TinyMessageOverridesFormat(writer, this.options, this.helper);
        TinyMessageBuilderFormat builder = new TinyMessageBuilderFormat(writer, this.helper, this.options);
        TinyValueFormat values = new TinyValueFormat(writer, this.options, this.helper);
        CAnnotatedDescriptor annotatedDescriptor = (CAnnotatedDescriptor)descriptor;
        if (annotatedDescriptor.getComment() != null) {
            new BlockCommentBuilder(writer).comment(annotatedDescriptor.getComment()).finish();
        }
        if (JAnnotation.isDeprecated(annotatedDescriptor)) {
            writer.appendln((CharSequence)"@Deprecated");
        }
        if (this.options.jackson) {
            writer.formatln("@%s(ignoreUnknown = true)", new Object[]{JsonIgnoreProperties.class.getName()}).formatln("@%s(%s.%s)", new Object[]{JsonInclude.class.getName(), JsonInclude.Include.class.getName().replaceAll("[$]", "."), JsonInclude.Include.NON_EMPTY.name()}).formatln("@%s(", new Object[]{JsonDeserialize.class.getName()}).formatln("        builder = %s._Builder.class)", new Object[]{message.instanceType()});
        }
        if (JAnnotation.isDeprecated(message.descriptor())) {
            writer.appendln((CharSequence)"@Deprecated");
        }
        writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")").formatln("public class %s", new Object[]{message.instanceType()}).begin(DBL_INDENT);
        if (message.variant().equals((Object)PMessageVariant.EXCEPTION)) {
            writer.appendln((CharSequence)("extends " + Exception.class.getName()));
        }
        writer.formatln("implements %s, %s, Comparable<%s>", new Object[]{Serializable.class.getName(), Stringable.class.getName(), message.instanceType()});
        writer.append((CharSequence)" {").end().begin();
        writer.formatln("private final static long serialVersionUID = %dL;", new Object[]{JUtils.generateSerialVersionUID(message.descriptor())}).newline();
        values.appendDefaultConstants(message.fields());
        this.appendFieldDeclarations(writer, message);
        this.appendBuilderConstructor(writer, message);
        this.appendCreateConstructor(writer, message);
        if (message.isException()) {
            this.appendCreateMessage(writer, message);
        }
        this.appendFieldGetters(writer, message);
        overrides.appendOverrides(message);
        this.appendFieldEnum(writer, message);
        builder.appendBuilder(message);
        writer.end().appendln('}').newline();
    }

    private void appendFieldEnum(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        writer.formatln("public enum _Field {", new Object[0]).begin();
        for (JField field : message.fields()) {
            writer.formatln("%s(%d, \"%s\"),", new Object[]{field.fieldEnum(), field.id(), field.name()});
        }
        writer.appendln(';').newline();
        writer.appendln((CharSequence)"private final int mKey;").appendln((CharSequence)"private final String mName;").newline().formatln("_Field(int key, String name) {", new Object[0]).begin().appendln((CharSequence)"mKey = key;").appendln((CharSequence)"mName = name;").end().appendln('}').newline();
        writer.appendln((CharSequence)"public int getKey() { return mKey; }").newline();
        writer.appendln((CharSequence)"public String getName() { return mName; }").newline();
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String toString() {").appendln((CharSequence)"    StringBuilder builder = new StringBuilder();").formatln("    builder.append(\"%s._Field(\")", new Object[]{message.instanceType()}).appendln((CharSequence)"           .append(mKey)").appendln((CharSequence)"           .append(':')").appendln((CharSequence)"           .append(mName)").appendln((CharSequence)"           .append(')');").appendln((CharSequence)"    return builder.toString();").appendln('}').newline();
        writer.appendln((CharSequence)"public static _Field forKey(int key) {").begin().appendln((CharSequence)"switch (key) {").begin();
        for (JField field : message.fields()) {
            writer.formatln("case %d: return _Field.%s;", new Object[]{field.id(), field.fieldEnum()});
        }
        writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}').newline();
        writer.appendln((CharSequence)"public static _Field forName(String name) {").begin().appendln((CharSequence)"switch (name) {").begin();
        for (JField field : message.fields()) {
            writer.formatln("case \"%s\": return _Field.%s;", new Object[]{field.name(), field.fieldEnum()});
        }
        writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}');
        writer.end().appendln('}').newline();
    }

    private void appendFieldGetters(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        for (JField field : message.fields()) {
            if (field.hasComment()) {
                new BlockCommentBuilder(writer).comment(field.comment()).finish();
            }
            if (JAnnotation.isDeprecated(field)) {
                writer.appendln((CharSequence)"@Deprecated");
            }
            if (this.options.jackson) {
                writer.formatln("@com.fasterxml.jackson.annotation.JsonProperty(\"%s\")", new Object[]{field.name()});
                if (field.binary()) {
                    writer.appendln((CharSequence)"@com.fasterxml.jackson.databind.annotation.JsonSerialize(using = net.morimekta.providence.jackson.BinaryJsonSerializer.class) ");
                }
            }
            writer.formatln("public %s %s() {", new Object[]{field.valueType(), field.getter()});
            if (!field.container() && !field.alwaysPresent() && field.getPField().hasDefaultValue()) {
                writer.formatln("    return %s != null ? %s : %s;", new Object[]{field.member(), field.member(), field.kDefault()});
            } else {
                writer.formatln("    return %s;", new Object[]{field.member()});
            }
            writer.appendln('}').newline();
        }
        if (message.isUnion()) {
            writer.appendln((CharSequence)"public _Field unionField() {").appendln((CharSequence)"    return tUnionField;").appendln('}').newline();
        }
    }

    private void appendFieldDeclarations(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        for (JField field : message.fields()) {
            writer.formatln("private final %s %s;", new Object[]{field.fieldType(), field.member()});
        }
        if (message.isUnion()) {
            writer.newline().appendln((CharSequence)"private final _Field tUnionField;");
        }
        writer.appendln().appendln((CharSequence)"private volatile int tHashCode;").newline();
    }

    private void appendBuilderConstructor(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        writer.formatln("private %s(_Builder builder) {", new Object[]{message.instanceType()}).begin();
        if (message.isUnion()) {
            writer.appendln((CharSequence)"tUnionField = builder.tUnionField;").newline();
            for (JField jField : message.fields()) {
                if (jField.alwaysPresent()) {
                    writer.formatln("%s = tUnionField == _Field.%s ? builder.%s : %s;", new Object[]{jField.member(), jField.fieldEnum(), jField.member(), jField.kDefault()});
                    continue;
                }
                writer.formatln("%s = tUnionField == _Field.%s ? builder.%s : null;", new Object[]{jField.member(), jField.fieldEnum(), jField.member()});
            }
        } else {
            if (message.isException()) {
                writer.appendln((CharSequence)"super(createMessage(").begin("                    ");
                boolean first = true;
                for (JField field : message.fields()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(',').appendln();
                    }
                    if (field.container()) {
                        writer.format("builder.optionals.get(%d) ? builder.%s.build() : null", new Object[]{field.index(), field.member()});
                        continue;
                    }
                    writer.format("builder.%s", new Object[]{field.member()});
                }
                writer.append((CharSequence)"));").end().newline();
            }
            for (JField jField : message.fields()) {
                writer.formatln("%s = builder.%s;", new Object[]{jField.member(), jField.member()});
            }
        }
        writer.end().appendln('}').newline();
    }

    private void appendCreateMessage(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        writer.appendln((CharSequence)"private static String createMessage(").begin("                                    ");
        boolean first = true;
        for (JField fld : message.fields()) {
            if (first) {
                first = false;
            } else {
                writer.append(',').appendln();
            }
            writer.format("%s %s", new Object[]{fld.valueType(), fld.param()});
        }
        writer.append((CharSequence)") {").end().begin().appendln((CharSequence)"StringBuilder out = new StringBuilder();").appendln((CharSequence)"out.append('{');");
        boolean firstFirstCheck = true;
        boolean alwaysAfter = false;
        JField[] fields = message.fields().toArray(new JField[message.fields().size()]);
        for (int i = 0; i < fields.length; ++i) {
            first = i == 0;
            boolean last = i == fields.length - 1;
            JField field = fields[i];
            if (!field.alwaysPresent()) {
                if (!alwaysAfter && firstFirstCheck && !last) {
                    writer.appendln((CharSequence)"boolean first = true;");
                }
                if (field.container()) {
                    writer.formatln("if (%s != null && %s.size() > 0) {", new Object[]{field.param(), field.param()});
                } else {
                    writer.formatln("if (%s != null) {", new Object[]{field.param()});
                }
                writer.begin();
            }
            if (alwaysAfter) {
                writer.appendln((CharSequence)"out.append(',');");
            } else if (!field.alwaysPresent()) {
                if (firstFirstCheck || first) {
                    if (!last) {
                        writer.appendln((CharSequence)"first = false;");
                    }
                } else if (last) {
                    writer.appendln((CharSequence)"if (!first) out.append(',');");
                } else {
                    writer.appendln((CharSequence)"if (first) first = false;").appendln((CharSequence)"else out.append(',');");
                }
            }
            writer.formatln("out.append(\"%s:\")", new Object[]{field.name()});
            switch (field.type()) {
                case BOOL: 
                case I32: 
                case I64: {
                    writer.formatln("   .append(%s);", new Object[]{field.param()});
                    break;
                }
                case BYTE: 
                case I16: {
                    writer.formatln("   .append((int) %s);", new Object[]{field.param()});
                    break;
                }
                case DOUBLE: 
                case MAP: 
                case SET: 
                case LIST: {
                    writer.formatln("   .append(%s.asString(%s));", new Object[]{Strings.class.getName(), field.param()});
                    break;
                }
                case STRING: {
                    writer.formatln("   .append('\\\"')", new Object[0]).formatln("   .append(%s.escape(%s))", new Object[]{Strings.class.getName(), field.param()}).appendln((CharSequence)"   .append('\\\"');");
                    break;
                }
                case BINARY: {
                    writer.appendln((CharSequence)"   .append(\"b64(\")").formatln("   .append(%s.toBase64())", new Object[]{field.param()}).appendln((CharSequence)"   .append(')');");
                    break;
                }
                case MESSAGE: {
                    writer.formatln("   .append(%s.asString());", new Object[]{field.param()});
                    break;
                }
                default: {
                    writer.formatln("   .append(%s.toString());", new Object[]{field.param()});
                }
            }
            if (!field.alwaysPresent()) {
                writer.end().appendln('}');
                if (alwaysAfter || !firstFirstCheck) continue;
                firstFirstCheck = false;
                continue;
            }
            alwaysAfter = true;
        }
        writer.appendln((CharSequence)"out.append('}');").appendln((CharSequence)"return out.toString();").end().appendln('}').newline();
    }

    private void appendCreateConstructor(IndentedPrintWriter writer, JMessage<?> message) throws GeneratorException {
        if (message.isUnion()) {
            for (JField field : message.fields()) {
                BlockCommentBuilder block = new BlockCommentBuilder(writer);
                if (field.hasComment()) {
                    block.comment(field.comment());
                }
                block.param_("value", "The union value").return_("The created union.").finish();
                writer.formatln("public static %s %s(%s value) {", new Object[]{message.instanceType(), JUtils.camelCase("with", field.name()), field.valueType()}).formatln("    return new _Builder().%s(value).build();", new Object[]{field.setter()}).appendln('}').newline();
            }
        } else {
            String spaces = message.instanceType().replaceAll("[\\S]", " ");
            writer.formatln("public %s(", new Object[]{message.instanceType()}).begin(DBL_INDENT + spaces);
            boolean first = true;
            for (JField field : message.fields()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(',').appendln();
                }
                writer.format("%s %s", new Object[]{field.valueType(), field.param()});
            }
            writer.end().append((CharSequence)") {").begin();
            if (message.isException()) {
                writer.appendln((CharSequence)"super(createMessage(").begin("                    ");
                first = true;
                for (JField field : message.fields()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(',').appendln();
                    }
                    writer.format("%s", new Object[]{field.param()});
                }
                writer.append((CharSequence)"));").end().newline();
            }
            block8: for (JField field : message.fields()) {
                switch (field.type()) {
                    case LIST: {
                        writer.formatln("if (%s != null) {", new Object[]{field.param()}).formatln("    %s = %s.copyOf(%s);", new Object[]{field.member(), field.fieldInstanceType(), field.param()}).appendln((CharSequence)"} else {").formatln("    %s = null;", new Object[]{field.member()}).appendln('}');
                        continue block8;
                    }
                    case SET: {
                        writer.formatln("if (%s != null) {", new Object[]{field.param()}).begin();
                        if (field.containerType() == ContainerType.ORDERED) {
                            writer.formatln("%s = %s.unmodifiableSet(%s);", new Object[]{field.member(), Collections.class.getName(), field.param()});
                        } else {
                            writer.formatln("%s = %s.copyOf(%s);", new Object[]{field.member(), field.fieldInstanceType(), field.param()});
                        }
                        writer.end().appendln((CharSequence)"} else {").formatln("    %s = null;", new Object[]{field.member()}).appendln('}');
                        continue block8;
                    }
                    case MAP: {
                        writer.formatln("if (%s != null) {", new Object[]{field.param()}).begin();
                        if (field.containerType() == ContainerType.ORDERED) {
                            writer.formatln("%s = %s.unmodifiableMap(%s);", new Object[]{field.member(), Collections.class.getName(), field.param()});
                        } else {
                            writer.formatln("%s = %s.copyOf(%s);", new Object[]{field.member(), field.fieldInstanceType(), field.param()});
                        }
                        writer.end().appendln((CharSequence)"} else {").formatln("    %s = null;", new Object[]{field.member()}).appendln('}');
                        continue block8;
                    }
                }
                writer.formatln("%s = %s;", new Object[]{field.member(), field.param()});
            }
            writer.end().appendln('}').newline();
        }
    }
}

