/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.tiny;

import java.util.BitSet;
import java.util.Collection;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JOptions;
import net.morimekta.util.io.IndentedPrintWriter;

public class TinyMessageBuilderFormat {
    private final JOptions options;
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public TinyMessageBuilderFormat(IndentedPrintWriter writer, JHelper helper, JOptions options) {
        this.writer = writer;
        this.helper = helper;
        this.options = options;
    }

    public void appendBuilder(JMessage<?> message) throws GeneratorException {
        this.appendMutators();
        if (this.options.jackson) {
            this.writer.appendln((CharSequence)"@com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = \"set\")");
        }
        if (JAnnotation.isDeprecated(message.descriptor())) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        this.writer.appendln((CharSequence)"public static class _Builder {").begin();
        this.appendFields(message);
        this.appendDefaultConstructor(message);
        this.appendMutateConstructor(message);
        for (JField field : message.fields()) {
            this.appendSetter(message, field);
            this.appendResetter(message, field);
        }
        this.writer.formatln("public %s build() {", new Object[]{message.instanceType()}).begin().formatln("return new %s(this);", new Object[]{message.instanceType()}).end().appendln('}');
        this.writer.end().appendln('}');
    }

    private void appendMutators() {
        this.writer.appendln((CharSequence)"public _Builder mutate() {").begin().appendln((CharSequence)"return new _Builder(this);").end().appendln('}').newline();
        this.writer.formatln("public static _Builder builder() {", new Object[0]).begin().appendln((CharSequence)"return new _Builder();").end().appendln('}').newline();
    }

    private void appendFields(JMessage<?> message) throws GeneratorException {
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"private _Field tUnionField;");
        } else {
            this.writer.formatln("private %s optionals;", new Object[]{BitSet.class.getName()});
        }
        this.writer.newline();
        for (JField field : message.fields()) {
            this.writer.formatln("private %s %s;", new Object[]{field.fieldType(), field.member()});
        }
        if (message.fields().size() > 0) {
            this.writer.newline();
        }
    }

    private void appendDefaultConstructor(JMessage<?> message) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a " + message.descriptor().getQualifiedName(null) + " builder.").finish();
        this.writer.appendln((CharSequence)"public _Builder() {").begin();
        if (!message.isUnion()) {
            this.writer.formatln("optionals = new %s(%d);", new Object[]{BitSet.class.getName(), message.fields().size()});
        }
        message.fields().stream().filter(JField::hasDefault).forEachOrdered(field -> this.writer.formatln("%s = %s;", new Object[]{field.member(), field.kDefault()}));
        this.writer.end().appendln('}').newline();
    }

    private void appendMutateConstructor(JMessage<?> message) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a mutating builder off a base " + message.descriptor().getQualifiedName(null) + ".").newline().param_("base", "The base " + message.descriptor().getName()).finish();
        this.writer.formatln("public _Builder(%s base) {", new Object[]{message.instanceType()}).begin().appendln((CharSequence)"this();").newline();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"tUnionField = base.tUnionField;").newline();
        }
        for (JField field : message.fields()) {
            boolean checkPresence;
            boolean bl = checkPresence = !field.alwaysPresent();
            if (checkPresence) {
                this.writer.formatln("if (base.%s != null) {", new Object[]{field.member()}).begin();
            }
            if (!message.isUnion()) {
                this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
            }
            this.writer.formatln("%s = base.%s;", new Object[]{field.member(), field.member()});
            if (!checkPresence) continue;
            this.writer.end().appendln('}');
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendSetter(JMessage message, JField field) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Sets the value of " + field.name() + ".").newline();
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.param_("value", "The new value").return_("The builder").finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln((CharSequence)"@Deprecated");
        }
        if (this.options.jackson) {
            this.writer.formatln("@com.fasterxml.jackson.annotation.JsonProperty(\"%s\") ", new Object[]{field.name()});
            if (field.binary()) {
                this.writer.appendln((CharSequence)"@com.fasterxml.jackson.databind.annotation.JsonDeserialize(using = net.morimekta.providence.jackson.BinaryJsonDeserializer.class) ");
            }
        }
        if (field.type() == PType.SET || field.type() == PType.LIST) {
            PContainer cType = (PContainer)field.getPField().getDescriptor();
            String iType = this.helper.getFieldType(cType.itemDescriptor());
            this.writer.formatln("public _Builder %s(%s<%s> value) {", new Object[]{field.setter(), Collection.class.getName(), iType});
        } else {
            this.writer.formatln("public _Builder %s(%s value) {", new Object[]{field.setter(), field.valueType()});
        }
        this.writer.begin();
        if (message.isUnion()) {
            this.writer.formatln("tUnionField = _Field.%s;", new Object[]{field.fieldEnum()});
        } else {
            this.writer.formatln("optionals.set(%d);", new Object[]{field.index()});
        }
        this.writer.formatln("%s = %s;", new Object[]{field.member(), field.copyOfUnsafe("value")});
        this.writer.appendln((CharSequence)"return this;").end().appendln('}').newline();
    }

    private void appendResetter(JMessage message, JField field) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Clears the " + field.name() + " field.").newline();
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.return_("The builder").finish();
        this.writer.formatln("public _Builder %s() {", new Object[]{field.resetter()}).begin();
        if (message.isUnion()) {
            this.writer.formatln("if (tUnionField == _Field.%s) tUnionField = null;", new Object[]{field.fieldEnum()});
        } else {
            this.writer.formatln("optionals.clear(%d);", new Object[]{field.index()});
        }
        if (field.hasDefault()) {
            this.writer.formatln("%s = %s;", new Object[]{field.member(), field.kDefault()});
        } else {
            this.writer.formatln("%s = null;", new Object[]{field.member()});
        }
        this.writer.appendln((CharSequence)"return this;").end().appendln('}').newline();
    }
}

