/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.tiny;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JOptions;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CEnumValue;
import net.morimekta.util.Stringable;
import net.morimekta.util.io.IndentedPrintWriter;

public class TinyEnumFormat {
    private final JHelper helper;
    private final JOptions options;

    public TinyEnumFormat(JHelper helper, JOptions options) {
        this.helper = helper;
        this.options = options;
    }

    public void format(IndentedPrintWriter writer, CEnumDescriptor type) throws GeneratorException {
        String simpleClass = JUtils.getClassName(type);
        if (type.getComment() != null) {
            new BlockCommentBuilder(writer).comment(type.getComment()).finish();
        }
        if (JAnnotation.isDeprecated((CAnnotatedDescriptor)type)) {
            writer.appendln((CharSequence)"@Deprecated");
        }
        writer.formatln("public enum %s implements %s {", new Object[]{simpleClass, Stringable.class.getName()}).begin();
        for (CEnumValue v : type.getValues()) {
            if (v.getComment() != null) {
                new BlockCommentBuilder(writer).comment(type.getComment()).finish();
            }
            if (JAnnotation.isDeprecated((CAnnotatedDescriptor)v)) {
                writer.appendln((CharSequence)"@Deprecated");
            }
            writer.formatln("%s(%d, \"%s\"),", new Object[]{JUtils.enumConst((PEnumValue)v), v.getValue(), v.getName()});
        }
        writer.appendln(';').newline();
        writer.appendln((CharSequence)"private final int mValue;").appendln((CharSequence)"private final String mName;").newline().formatln("%s(int value, String name) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"mValue = value;").appendln((CharSequence)"mName = name;").end().appendln((CharSequence)"}").newline();
        writer.appendln((CharSequence)"public int asInteger() {").begin().appendln((CharSequence)"return mValue;").end().appendln('}').newline();
        if (this.options.jackson) {
            writer.formatln("@%s", new Object[]{JsonValue.class.getName()});
        }
        writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String asString() {").begin().appendln((CharSequence)"return mName;").end().appendln('}').newline();
        writer.formatln("public static %s forValue(int value) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"switch (value) {").begin();
        for (CEnumValue value : type.getValues()) {
            writer.formatln("case %d: return %s.%s;", new Object[]{value.getValue(), simpleClass, value.getName().toUpperCase()});
        }
        writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
        if (this.options.jackson) {
            writer.formatln("@%s", new Object[]{JsonCreator.class.getName()});
        }
        writer.formatln("public static %s forName(String name) {", new Object[]{simpleClass}).begin().appendln((CharSequence)"switch (name) {").begin();
        for (CEnumValue value : type.getValues()) {
            writer.formatln("case \"%s\": return %s.%s;", new Object[]{value.getName(), simpleClass, value.getName().toUpperCase()});
        }
        writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').end().appendln('}').newline();
    }
}

