/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.util.Collection;
import java.util.Map;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JValueFormat;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JOptions;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.util.io.IndentedPrintWriter;

public class JConstantsFormat {
    private static final String DBL_INDENT = "        ";
    private final JOptions options;
    private final JHelper helper;

    JConstantsFormat(JHelper helper, JOptions options) {
        this.helper = helper;
        this.options = options;
    }

    public void format(IndentedPrintWriter writer, CDocument document) throws GeneratorException {
        JValueFormat value = new JValueFormat(writer, this.options, this.helper);
        writer.format("package %s;", new Object[]{this.helper.getJavaPackage(document)}).newline();
        if (document.getComment() != null) {
            new BlockCommentBuilder(writer).comment(document.getComment()).finish();
        }
        writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")").formatln("public class %s {", new Object[]{this.helper.getConstantsClassName(document)}).begin().formatln("private %s() {}", new Object[]{this.helper.getConstantsClassName(document)});
        block5: for (CField c : document.getConstants()) {
            writer.newline();
            String name = c.getName();
            JField constant = new JField(c, this.helper, 1);
            switch (c.getType()) {
                case MESSAGE: {
                    String instance = this.helper.getValueType(c.getDescriptor());
                    writer.formatln("public static final %s %s;", new Object[]{this.helper.getValueType(c.getDescriptor()), name}).appendln((CharSequence)"static {").begin().formatln("%s = %s.builder()", new Object[]{name, instance}).begin(DBL_INDENT);
                    PMessage message = (PMessage)c.getDefaultValue();
                    int i = 0;
                    for (PField f : message.descriptor().getFields()) {
                        CField cField = (CField)f;
                        JField field = new JField(cField, this.helper, i++);
                        if (!message.has(f.getKey())) continue;
                        writer.formatln(".%s(", new Object[]{field.setter()});
                        value.appendTypedValue(message.get(f.getKey()), f.getDescriptor());
                        writer.append((CharSequence)")");
                    }
                    writer.formatln(".build();", new Object[]{name}).end().end().appendln('}');
                    continue block5;
                }
                case LIST: 
                case SET: {
                    PContainer lDesc = (PContainer)c.getDescriptor();
                    PDescriptor itemDesc = lDesc.itemDescriptor();
                    writer.formatln("public static final %s %s;", new Object[]{this.helper.getValueType(c.getDescriptor()), name}).appendln((CharSequence)"static {").begin().formatln("%s = new %s<%s>()", new Object[]{name, constant.builderInstanceType(), this.helper.getFieldType(itemDesc)}).begin(DBL_INDENT);
                    Collection items = (Collection)c.getDefaultValue();
                    for (Object item : items) {
                        writer.appendln((CharSequence)".add(").begin();
                        value.appendTypedValue(item, itemDesc);
                        writer.end().append((CharSequence)")");
                    }
                    writer.formatln(".build();", new Object[]{name});
                    writer.end().end().appendln('}');
                    continue block5;
                }
                case MAP: {
                    JField field = new JField(c, this.helper, 1);
                    PMap mDesc = (PMap)c.getDescriptor();
                    PDescriptor itemDesc = mDesc.itemDescriptor();
                    PDescriptor keyDesc = mDesc.keyDescriptor();
                    writer.formatln("public static final %s %s;", new Object[]{this.helper.getValueType(c.getDescriptor()), name}).appendln((CharSequence)"static {").begin().formatln("%s = new %s<>()", new Object[]{name, field.builderInstanceType()}).begin(DBL_INDENT);
                    Map items = (Map)c.getDefaultValue();
                    for (Map.Entry item : items.entrySet()) {
                        writer.appendln((CharSequence)".put(").begin();
                        value.appendTypedValue(item.getKey(), keyDesc);
                        writer.append((CharSequence)", ");
                        value.appendTypedValue(item.getValue(), itemDesc);
                        writer.end().append((CharSequence)")");
                    }
                    writer.formatln(".build();", new Object[]{name});
                    writer.end().end().appendln('}');
                    continue block5;
                }
            }
            writer.formatln("public static final %s %s = ", new Object[]{this.helper.getValueType(c.getDescriptor()), c.getName()}).begin(DBL_INDENT);
            value.appendTypedValue(c.getDefaultValue(), c.getDescriptor());
            writer.append(';').end();
        }
        writer.end().appendln('}');
    }
}

