/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.io.IOException;
import net.morimekta.providence.PClient;
import net.morimekta.providence.PClientHandler;
import net.morimekta.providence.PProcessor;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JField;
import net.morimekta.providence.generator.format.java.JHelper;
import net.morimekta.providence.generator.format.java.JMessage;
import net.morimekta.providence.generator.format.java.JMessageFormat;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.generator.format.java.JService;
import net.morimekta.providence.generator.format.java.JServiceMethod;
import net.morimekta.providence.generator.format.java.JUtils;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.serializer.MessageReader;
import net.morimekta.providence.serializer.MessageWriter;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class JServiceFormat {
    private final JHelper helper;
    private final JOptions options;
    private final JMessageFormat messageFormat;

    public JServiceFormat(JHelper helper, JOptions options, JMessageFormat messageFormat) {
        this.helper = helper;
        this.options = options;
        this.messageFormat = messageFormat;
    }

    public void format(IndentedPrintWriter writer, CService cs) throws GeneratorException, IOException {
        JService service = new JService(cs, this.helper);
        if (cs.getComment() != null) {
            JUtils.appendBlockComment(writer, cs.getComment());
        }
        writer.appendln((CharSequence)"@SuppressWarnings(\"unused\")").formatln("public class %s {", new Object[]{service.className()}).begin();
        this.appendIface(writer, service);
        this.appendClient(writer, service);
        this.appendProcessor(writer, service);
        this.appendDescriptor(writer, service);
        this.appendStructs(writer, service);
        writer.formatln("private %s() {}", new Object[]{service.className()});
        writer.end().appendln('}');
    }

    private void appendClient(IndentedPrintWriter writer, JService service) throws GeneratorException {
        writer.appendln((CharSequence)"public static class Client").formatln("        extends %s", new Object[]{PClient.class.getName()}).formatln("        implements Iface {", new Object[0]).begin();
        writer.formatln("private final %s handler;", new Object[]{PClientHandler.class.getName()}).newline();
        writer.formatln("public Client(%s handler) {", new Object[]{PClientHandler.class.getName()}).appendln((CharSequence)"    this.handler = handler;").appendln('}').newline();
        boolean firstMethod = true;
        for (JServiceMethod method : service.methods()) {
            if (firstMethod) {
                firstMethod = false;
            } else {
                writer.newline();
            }
            writer.appendln((CharSequence)"@Override");
            JField ret = method.getResponse();
            writer.appendln((CharSequence)"public ");
            if (ret != null) {
                writer.append((CharSequence)ret.valueType());
            } else {
                writer.append((CharSequence)"void");
            }
            writer.format(" %s(", new Object[]{method.methodName()}).begin("        ");
            boolean first = true;
            for (JField param : method.params()) {
                if (first) {
                    first = false;
                } else {
                    writer.append((CharSequence)",");
                }
                writer.formatln("%s %s", new Object[]{param.valueType(), param.param()});
            }
            writer.end().format(")", new Object[0]).formatln("        throws %s", new Object[]{IOException.class.getName()}).begin("               ");
            for (JField ex : method.exceptions()) {
                writer.append((CharSequence)",");
                writer.appendln((CharSequence)ex.instanceType());
            }
            writer.format(" {", new Object[0]).end().begin().appendln((CharSequence)"try {").begin();
            writer.formatln("%s._Builder rq = %s.builder();", new Object[]{method.getRequestClass(), method.getRequestClass()});
            for (JField param : method.params()) {
                writer.formatln("rq.%s(%s);", new Object[]{param.setter(), param.param()});
            }
            String type = method.getMethod().isOneway() ? PServiceCallType.ONEWAY.name() : PServiceCallType.CALL.name();
            writer.newline().formatln("%s call = new %s(\"%s\", %s.%s, getNextSequenceId(), rq.build());", new Object[]{PServiceCall.class.getName(), PServiceCall.class.getName(), method.name(), PServiceCallType.class.getName(), type}).appendln();
            if (method.getResponseClass() != null) {
                writer.format("%s resp = ", new Object[]{PServiceCall.class.getName()});
            }
            writer.format("handler.handleCall(call, %s.kDescriptor);", new Object[]{service.className()});
            if (method.getResponseClass() != null) {
                writer.formatln("%s msg = (%s) resp.getMessage();", new Object[]{method.getResponseClass(), method.getResponseClass()});
                if (method.exceptions().length > 0) {
                    writer.newline().formatln("if (resp.getType() == %s.%s) {", new Object[]{PServiceCallType.class.getName(), PServiceCallType.EXCEPTION.name()}).begin();
                    writer.appendln((CharSequence)"switch (msg.unionField()) {").begin();
                    for (JField ex : method.exceptions()) {
                        writer.formatln("case %s:", new Object[]{ex.fieldEnum()}).formatln("    throw msg.%s();", new Object[]{ex.getter()});
                    }
                    writer.formatln("default: throw new %s(\"Unknown exception field: \" + msg.unionField().toString());", new Object[]{IOException.class.getName()}).end().appendln('}');
                    writer.end().appendln((CharSequence)"}");
                }
                if (method.getResponse() != null) {
                    writer.newline().formatln("return msg.%s();", new Object[]{method.getResponse().getter()});
                }
            }
            writer.end().formatln("} catch (%s e) {", new Object[]{SerializerException.class.getName()}).formatln("    throw new %s(e);", new Object[]{IOException.class.getName()}).appendln('}').end().appendln('}');
        }
        writer.end().appendln('}').newline();
    }

    private void appendProcessor(IndentedPrintWriter writer, JService service) throws GeneratorException {
        writer.formatln("public static class Processor implements %s {", new Object[]{PProcessor.class.getName()}).begin().appendln((CharSequence)"private final Iface impl;");
        writer.formatln("public Processor(Iface impl) {", new Object[0]).appendln((CharSequence)"    this.impl = impl;").appendln('}').newline();
        writer.appendln((CharSequence)"@Override").formatln("public boolean process(%s reader, %s writer) throws %s {", new Object[]{MessageReader.class.getName(), MessageWriter.class.getName(), IOException.class.getName()}).begin().appendln((CharSequence)"try {").begin();
        writer.formatln("%s type = %s.%s;", new Object[]{PServiceCallType.class.getName(), PServiceCallType.class.getName(), PServiceCallType.EXCEPTION.name()});
        writer.formatln("%s call = reader.read(%s.kDescriptor);", new Object[]{PServiceCall.class.getName(), service.className()}).newline().appendln((CharSequence)"switch(call.getMethod()) {").begin();
        for (JServiceMethod method : service.methods()) {
            writer.formatln("case \"%s\": {", new Object[]{method.name()}).begin();
            if (method.getResponseClass() != null) {
                writer.formatln("%s._Builder rsp = %s.builder();", new Object[]{method.getResponseClass(), method.getResponseClass()});
            }
            if (method.exceptions().length > 0) {
                writer.appendln((CharSequence)"try {").begin();
            }
            writer.formatln("%s req = (%s) call.getMessage();", new Object[]{method.getRequestClass(), method.getRequestClass()});
            String indent = "      " + Strings.times((String)" ", (int)method.methodName().length());
            if (method.getResponse() != null) {
                writer.formatln("%s result =", new Object[]{method.getResponse().valueType()});
                writer.appendln((CharSequence)"        ");
                indent = indent + "        ";
            } else {
                writer.appendln();
            }
            writer.format("impl.%s(", new Object[]{method.methodName()}).begin(indent);
            boolean first = true;
            for (JField param : method.params()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(',').appendln();
                }
                writer.format("req.%s()", new Object[]{param.getter()});
            }
            writer.end().append((CharSequence)");");
            if (method.getResponse() != null) {
                writer.formatln("rsp.%s(result);", new Object[]{method.getResponse().setter()});
            }
            writer.formatln("type = %s.%s;", new Object[]{PServiceCallType.class.getName(), PServiceCallType.REPLY.name()});
            if (method.exceptions().length > 0) {
                writer.end();
                for (JField ex : method.exceptions()) {
                    writer.formatln("} catch (%s e) {", new Object[]{ex.instanceType()}).begin().formatln("rsp.%s(e);", new Object[]{ex.setter()}).end();
                }
                writer.appendln('}');
            }
            if (method.getResponseClass() != null) {
                writer.formatln("%s reply = new %s(call.getMethod(), type, call.getSequence(), rsp.build());", new Object[]{PServiceCall.class.getName(), PServiceCall.class.getName()}).appendln((CharSequence)"writer.write(reply);");
            }
            writer.formatln("break;", new Object[0]).end().appendln('}');
        }
        writer.formatln("default: throw new %s(\"Method call not handled: \" + call.getMethod());", new Object[]{IOException.class.getName()}).end().appendln('}');
        writer.appendln((CharSequence)"return true;").end().formatln("} catch (%s se) {", new Object[]{SerializerException.class.getName()}).formatln("    throw new %s(se);", new Object[]{IOException.class.getName()}).appendln('}').end().appendln('}');
        writer.end().appendln('}').newline();
    }

    private void appendDescriptor(IndentedPrintWriter writer, JService service) throws GeneratorException {
        writer.formatln("public enum Method implements %s {", new Object[]{PServiceMethod.class.getName()}).begin();
        for (JServiceMethod method : service.methods()) {
            String responseDesc = method.getResponseClass() == null ? "null" : method.getResponseClass() + ".kDescriptor";
            writer.formatln("%s(\"%s\", %b, %s.kDescriptor, %s),", new Object[]{method.constant(), method.name(), method.getMethod().isOneway(), method.getRequestClass(), responseDesc});
        }
        writer.appendln(';').newline();
        writer.appendln((CharSequence)"private final String name;").appendln((CharSequence)"private final boolean oneway;").formatln("private final %s request;", new Object[]{PStructDescriptor.class.getName()}).formatln("private final %s response;", new Object[]{PUnionDescriptor.class.getName()}).newline();
        writer.formatln("private Method(String name, boolean oneway, %s request, %s response) {", new Object[]{PStructDescriptor.class.getName(), PUnionDescriptor.class.getName()}).appendln((CharSequence)"    this.name = name;").appendln((CharSequence)"    this.oneway = oneway;").appendln((CharSequence)"    this.request = request;").appendln((CharSequence)"    this.response = response;").appendln('}').newline();
        writer.appendln((CharSequence)"public String getName() {").appendln((CharSequence)"    return name;").appendln('}').newline().appendln((CharSequence)"public boolean isOneway() {").appendln((CharSequence)"    return oneway;").appendln('}').newline().formatln("public %s getRequestType() {", new Object[]{PStructDescriptor.class.getName()}).formatln("    return request;", new Object[0]).appendln('}').newline().formatln("public %s getResponseType() {", new Object[]{PUnionDescriptor.class.getName()}).formatln("    return response;", new Object[0]).appendln('}').newline();
        writer.appendln((CharSequence)"public static Method forName(String name) {").begin().appendln((CharSequence)"switch (name) {").begin();
        for (JServiceMethod method : service.methods()) {
            writer.formatln("case \"%s\": return %s;", new Object[]{method.name(), method.constant()});
        }
        writer.end().appendln('}').appendln((CharSequence)"return null;").end().appendln('}');
        writer.end().appendln('}').newline();
        String inherits = "null";
        if (service.getService().getExtendsService() != null) {
            CService other = (CService)service.getService().getExtendsService();
            inherits = this.helper.getJavaPackage((PService)other) + "." + new JService(other, this.helper).className() + ".kDescriptor";
        }
        writer.formatln("private static class _Descriptor extends %s {", new Object[]{PService.class.getName()}).begin().appendln((CharSequence)"private _Descriptor() {").formatln("    super(\"%s\", \"%s\", %s, Method.values());", new Object[]{service.getService().getPackageName(), service.getService().getName(), inherits}).appendln('}').newline().appendln((CharSequence)"@Override").appendln((CharSequence)"public Method getMethod(String name) {").appendln((CharSequence)"    return Method.forName(name);").appendln((CharSequence)"}").end().appendln('}').newline();
        writer.formatln("public static final %s kDescriptor = new _Descriptor();", new Object[]{PService.class.getName()}).newline();
    }

    private void appendStructs(IndentedPrintWriter writer, JService service) throws GeneratorException, IOException {
        for (JServiceMethod method : service.methods()) {
            JMessage request = new JMessage(method.getMethod().getRequestType(), this.helper);
            writer.formatln("// type --> %s", new Object[]{request.descriptor().getName()});
            this.messageFormat.format(writer, (PStructDescriptor<?, ?>)method.getMethod().getRequestType(), service.getService());
            if (method.getMethod().getResponseType() == null) continue;
            JMessage response = new JMessage(method.getMethod().getResponseType(), this.helper);
            writer.formatln("// type <-- %s", new Object[]{response.descriptor().getName()});
            this.messageFormat.format(writer, (PStructDescriptor<?, ?>)method.getMethod().getResponseType(), service.getService());
        }
    }

    private void appendIface(IndentedPrintWriter writer, JService service) throws GeneratorException {
        String inherits = "";
        if (service.getService().getExtendsService() != null) {
            CService other = (CService)service.getService().getExtendsService();
            inherits = "extends " + this.helper.getJavaPackage((PService)other) + "." + new JService(other, this.helper).className() + ".Iface ";
        }
        writer.formatln("public interface Iface %s{", new Object[]{inherits}).begin();
        boolean firstMethod = true;
        for (JServiceMethod method : service.methods()) {
            JField ret;
            if (firstMethod) {
                firstMethod = false;
            } else {
                writer.newline();
            }
            if (method.getMethod().getComment() != null) {
                JUtils.appendBlockComment(writer, method.getMethod().getComment());
            }
            if ((ret = method.getResponse()) != null) {
                writer.appendln((CharSequence)ret.valueType());
            } else {
                writer.appendln((CharSequence)"void");
            }
            writer.format(" %s(", new Object[]{method.methodName()}).begin("        ");
            boolean first = true;
            for (JField param : method.params()) {
                if (first) {
                    first = false;
                } else {
                    writer.append((CharSequence)",");
                }
                writer.formatln("%s %s", new Object[]{param.valueType(), param.param()});
            }
            writer.end().format(")", new Object[0]).formatln("        throws %s", new Object[]{IOException.class.getName()}).begin("               ");
            for (JField ex : method.exceptions()) {
                writer.append((CharSequence)",");
                writer.appendln((CharSequence)ex.instanceType());
            }
            writer.format(";", new Object[0]).end();
        }
        writer.end().appendln('}').newline();
    }
}

