/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.util.Objects;
import net.morimekta.providence.generator.format.java.JField;
import net.morimekta.providence.generator.format.java.JHelper;
import net.morimekta.providence.generator.format.java.JMessage;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.util.TypeUtils;
import net.morimekta.util.io.IndentedPrintWriter;

public class JMessageOverridesFormat {
    private final IndentedPrintWriter writer;
    private final JOptions options;
    private final JHelper helper;

    public JMessageOverridesFormat(IndentedPrintWriter writer, JOptions options, JHelper helper) {
        this.writer = writer;
        this.options = options;
        this.helper = helper;
    }

    public void appendOverrides(JMessage message) {
        this.appendPresence(message);
        this.appendCounter(message);
        this.appendGetter(message);
        this.appendCompact(message);
        this.appendEquals(message);
        this.appendHashCode(message);
        this.appendToString(message);
        this.appendAsString(message);
        this.appendCompareTo(message);
    }

    private void appendCompact(JMessage<?> message) {
        if (this.options.jackson) {
            this.writer.appendln((CharSequence)"@com.fasterxml.jackson.annotation.JsonIgnore");
        }
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean compact() {").begin();
        if (message.descriptor().isCompactible()) {
            this.writer.appendln((CharSequence)"boolean missing = false;");
            boolean hasCheck = false;
            for (JField field : message.fields()) {
                if (!field.alwaysPresent()) {
                    hasCheck = true;
                    this.writer.formatln("if (%s()) {", new Object[]{field.presence()}).appendln((CharSequence)"    if (missing) return false;").appendln((CharSequence)"} else {").appendln((CharSequence)"    missing = true;").appendln('}');
                    continue;
                }
                if (!hasCheck) continue;
                this.writer.appendln((CharSequence)"if (missing) return false;");
                hasCheck = false;
            }
            this.writer.appendln((CharSequence)"return true;");
        } else {
            this.writer.appendln((CharSequence)"return false;");
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendGetter(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public Object get(int key) {").begin().appendln((CharSequence)"switch(key) {").begin();
        for (JField field : message.fields()) {
            this.writer.formatln("case %d: return %s();", new Object[]{field.id(), field.getter()});
        }
        this.writer.appendln((CharSequence)"default: return null;").end().appendln('}').end().appendln('}').newline();
    }

    private void appendPresence(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean has(int key) {").begin().appendln((CharSequence)"switch(key) {").begin();
        for (JField field : message.fields()) {
            if (field.container()) {
                this.writer.formatln("case %d: return %s() > 0;", new Object[]{field.id(), field.counter()});
                continue;
            }
            if (field.alwaysPresent() && !message.isUnion()) {
                this.writer.formatln("case %d: return true;", new Object[]{field.id()});
                continue;
            }
            this.writer.formatln("case %d: return %s();", new Object[]{field.id(), field.presence()});
        }
        this.writer.appendln((CharSequence)"default: return false;").end().appendln('}').end().appendln('}').newline();
    }

    private void appendCounter(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int num(int key) {").begin().appendln((CharSequence)"switch(key) {").begin();
        for (JField field : message.fields()) {
            if (field.container()) {
                this.writer.formatln("case %d: return %s();", new Object[]{field.id(), field.counter()});
                continue;
            }
            if (field.alwaysPresent() && !message.isUnion()) {
                this.writer.formatln("case %d: return 1;", new Object[]{field.id()});
                continue;
            }
            this.writer.formatln("case %d: return %s() ? 1 : 0;", new Object[]{field.id(), field.presence()});
        }
        this.writer.appendln((CharSequence)"default: return 0;").end().appendln('}').end().appendln('}').newline();
    }

    private void appendEquals(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public boolean equals(Object o) {").begin().formatln("if (o == null || !(o instanceof %s)) return false;", new Object[]{message.instanceType()});
        if (message.fields().size() > 0) {
            boolean first = true;
            this.writer.formatln("%s other = (%s) o;", new Object[]{message.instanceType(), message.instanceType()}).appendln((CharSequence)"return ");
            if (message.isUnion()) {
                this.writer.format("%s.equals(tUnionField, other.tUnionField)", new Object[]{Objects.class.getName()});
                first = false;
            }
            for (JField field : message.fields()) {
                if (first) {
                    first = false;
                } else {
                    this.writer.append((CharSequence)" &&").appendln((CharSequence)"       ");
                }
                if (field.container()) {
                    this.writer.format("%s.equals(%s, other.%s)", new Object[]{TypeUtils.class.getName(), field.member(), field.member()});
                    continue;
                }
                this.writer.format("%s.equals(%s, other.%s)", new Object[]{Objects.class.getName(), field.member(), field.member()});
            }
            this.writer.append(';');
        } else {
            this.writer.appendln((CharSequence)"return true;");
        }
        this.writer.end().appendln((CharSequence)"}").newline();
    }

    private void appendHashCode(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public int hashCode() {").begin().appendln((CharSequence)"if (tHashCode == 0) {").begin().formatln("tHashCode = %s.hash(", new Object[]{Objects.class.getName()}).begin("        ").formatln("%s.class", new Object[]{message.instanceType()});
        for (JField field : message.fields()) {
            this.writer.append((CharSequence)",");
            if (field.container()) {
                this.writer.formatln("_Field.%s, %s.hashCode(%s)", new Object[]{field.fieldEnum(), TypeUtils.class.getName(), field.member()});
                continue;
            }
            this.writer.formatln("_Field.%s, %s", new Object[]{field.fieldEnum(), field.member()});
        }
        this.writer.end().append((CharSequence)");").end().appendln('}').appendln((CharSequence)"return tHashCode;").end().appendln((CharSequence)"}").newline();
    }

    private void appendToString(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String toString() {").begin().formatln("return \"%s\" + asString();", new Object[]{message.descriptor().getQualifiedName(null)}).end().appendln('}').newline();
    }

    private void appendAsString(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").appendln((CharSequence)"public String asString() {").begin().appendln((CharSequence)"StringBuilder out = new StringBuilder();").appendln((CharSequence)"out.append(\"{\");").newline();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"switch (tUnionField) {").begin();
            for (JField field : message.fields()) {
                this.writer.formatln("case %s: {", new Object[]{field.fieldEnum()}).begin().formatln("out.append(\"%s:\");", new Object[]{field.name()});
                switch (field.type()) {
                    case BOOL: {
                        this.writer.formatln("out.append(%s);", new Object[]{field.member()});
                        break;
                    }
                    case BYTE: {
                        this.writer.formatln("out.append(%s);", new Object[]{field.member()});
                        break;
                    }
                    case I16: {
                        this.writer.formatln("out.append(%s);", new Object[]{field.member()});
                        break;
                    }
                    case I32: {
                        this.writer.formatln("out.append(%s);", new Object[]{field.member()});
                        break;
                    }
                    case I64: {
                        this.writer.formatln("out.append(%s);", new Object[]{field.member()});
                        break;
                    }
                    case DOUBLE: {
                        this.writer.formatln("out.append(%s.toString(%s));", new Object[]{TypeUtils.class.getName(), field.member()});
                        break;
                    }
                    case STRING: {
                        this.writer.formatln("out.append('\\\"').append(%s).append('\\\"');", new Object[]{field.member()});
                        break;
                    }
                    case BINARY: {
                        this.writer.formatln("out.append(\"b64(\").append(%s.toBase64()).append(')');", new Object[]{field.member()});
                        break;
                    }
                    case ENUM: {
                        this.writer.formatln("out.append(%s.getName());", new Object[]{field.member()});
                        break;
                    }
                    case MESSAGE: {
                        this.writer.formatln("out.append(%s.asString());", new Object[]{field.member()});
                        break;
                    }
                    case SET: 
                    case LIST: 
                    case MAP: {
                        this.writer.formatln("out.append(%s.toString(%s));", new Object[]{TypeUtils.class.getName(), field.member()});
                    }
                }
                this.writer.appendln((CharSequence)"break;").end().appendln('}');
            }
            this.writer.end().appendln('}');
        } else {
            this.writer.appendln((CharSequence)"boolean first = true;");
            boolean first = true;
            for (JField field : message.fields()) {
                if (field.container()) {
                    this.writer.formatln("if (%s() > 0) {", new Object[]{field.counter()});
                } else {
                    this.writer.formatln("if (%s()) {", new Object[]{field.presence()});
                }
                this.writer.begin();
                if (first) {
                    first = false;
                } else {
                    this.writer.appendln((CharSequence)"if (!first) out.append(',');");
                }
                this.writer.appendln((CharSequence)"first = false;").formatln("out.append(\"%s:\");", new Object[]{field.name()});
                switch (field.type()) {
                    case BOOL: {
                        this.writer.formatln("out.append(%s ? \"true\" : \"false\");", new Object[]{field.member()});
                        break;
                    }
                    case BYTE: {
                        this.writer.formatln("out.append(Byte.toString(%s));", new Object[]{field.member()});
                        break;
                    }
                    case I16: {
                        this.writer.formatln("out.append(Short.toString(%s));", new Object[]{field.member()});
                        break;
                    }
                    case I32: {
                        this.writer.formatln("out.append(Integer.toString(%s));", new Object[]{field.member()});
                        break;
                    }
                    case I64: {
                        this.writer.formatln("out.append(Long.toString(%s));", new Object[]{field.member()});
                        break;
                    }
                    case DOUBLE: {
                        this.writer.formatln("out.append(%s.toString(%s));", new Object[]{TypeUtils.class.getName(), field.member()});
                        break;
                    }
                    case STRING: {
                        this.writer.formatln("out.append('\\\"').append(%s).append('\\\"');", new Object[]{field.member()});
                        break;
                    }
                    case BINARY: {
                        this.writer.formatln("out.append(\"hex(\").append(%s.toHexString()).append(')');", new Object[]{field.member()});
                        break;
                    }
                    case ENUM: {
                        this.writer.formatln("out.append(%s.getName());", new Object[]{field.member()});
                        break;
                    }
                    case MESSAGE: {
                        this.writer.formatln("out.append(%s.asString());", new Object[]{field.member()});
                        break;
                    }
                    case SET: 
                    case LIST: 
                    case MAP: {
                        this.writer.formatln("out.append(%s.toString(%s));", new Object[]{TypeUtils.class.getName(), field.member()});
                    }
                }
                this.writer.end().appendln('}');
            }
        }
        this.writer.appendln((CharSequence)"out.append('}');").appendln((CharSequence)"return out.toString();").end().appendln((CharSequence)"}").newline();
    }

    private void appendCompareTo(JMessage<?> message) {
        this.writer.appendln((CharSequence)"@Override").formatln("public int compareTo(%s other) {", new Object[]{message.instanceType()}).begin();
        if (message.isUnion()) {
            this.writer.appendln((CharSequence)"int c = Integer.compare(tUnionField.getKey(), other.tUnionField.getKey());").appendln((CharSequence)"if (c != 0) return c;").newline().appendln((CharSequence)"switch (tUnionField) {").begin();
            for (JField field : message.fields()) {
                this.writer.formatln("case %s:", new Object[]{field.fieldEnum()}).begin();
                switch (field.type()) {
                    case BOOL: {
                        this.writer.formatln("return Boolean.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case BYTE: {
                        this.writer.formatln("return Byte.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case I16: {
                        this.writer.formatln("return Short.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case I32: {
                        this.writer.formatln("return Integer.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case I64: {
                        this.writer.formatln("return Long.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case DOUBLE: {
                        this.writer.formatln("return Double.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case STRING: 
                    case BINARY: 
                    case MESSAGE: {
                        this.writer.formatln("return %s.compareTo(other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case ENUM: {
                        this.writer.formatln("return Integer.compare(%s.getValue(), other.%s.getValue());", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case SET: 
                    case LIST: 
                    case MAP: {
                        this.writer.formatln("return Integer.compare(%s.hashCode(), other.%s.hashCode());", new Object[]{field.member(), field.member()});
                    }
                }
                this.writer.end();
            }
            this.writer.appendln((CharSequence)"default: return 0;").end().appendln('}');
        } else {
            this.writer.appendln((CharSequence)"int c;");
            for (JField field : message.fields()) {
                this.writer.newline();
                if (!field.alwaysPresent()) {
                    this.writer.formatln("c = Boolean.compare(%s != null, other.%s != null);", new Object[]{field.member(), field.member()}).appendln((CharSequence)"if (c != 0) return c;").formatln("if (%s != null) {", new Object[]{field.member()}).begin();
                }
                switch (field.type()) {
                    case BOOL: {
                        this.writer.formatln("c = Boolean.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case BYTE: {
                        this.writer.formatln("c = Byte.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case I16: {
                        this.writer.formatln("c = Short.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case I32: {
                        this.writer.formatln("c = Integer.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case I64: {
                        this.writer.formatln("c = Long.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case DOUBLE: {
                        this.writer.formatln("c = Double.compare(%s, other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case STRING: 
                    case BINARY: 
                    case MESSAGE: {
                        this.writer.formatln("c = %s.compareTo(other.%s);", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case ENUM: {
                        this.writer.formatln("c = Integer.compare(%s.getValue(), %s.getValue());", new Object[]{field.member(), field.member()});
                        break;
                    }
                    case SET: 
                    case LIST: 
                    case MAP: {
                        this.writer.formatln("c = Integer.compare(%s.hashCode(), other.%s.hashCode());", new Object[]{field.member(), field.member()});
                    }
                }
                this.writer.appendln((CharSequence)"if (c != 0) return c;");
                if (field.alwaysPresent()) continue;
                this.writer.end().appendln('}');
            }
            this.writer.newline().appendln((CharSequence)"return 0;");
        }
        this.writer.end().appendln((CharSequence)"}").newline();
    }
}

