/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.util.ArrayList;
import java.util.List;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.generator.format.java.JField;
import net.morimekta.providence.generator.format.java.JHelper;
import net.morimekta.providence.generator.format.java.JUtils;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessage;

public class JMessage<T extends CMessage<T>> {
    private final PStructDescriptor<?, ?> struct;
    private final JHelper helper;
    private final ArrayList<JField> fields;

    public JMessage(PStructDescriptor<T, CField> struct, JHelper helper) {
        this.struct = struct;
        this.helper = helper;
        this.fields = new ArrayList(((CField[])struct.getFields()).length);
        CField[] fields = (CField[])struct.getFields();
        for (int i = 0; i < fields.length; ++i) {
            this.fields.add(new JField(fields[i], helper, i));
        }
    }

    public PStructDescriptor<?, ?> descriptor() {
        return this.struct;
    }

    public PMessageVariant variant() {
        return this.struct.getVariant();
    }

    public boolean isException() {
        return this.struct.getVariant() == PMessageVariant.EXCEPTION;
    }

    public boolean isUnion() {
        return this.struct.getVariant() == PMessageVariant.UNION;
    }

    public String instanceType() {
        return JUtils.getClassName(this.struct);
    }

    public List<JField> fields() {
        return this.fields;
    }
}

