/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.ContainerType;
import net.morimekta.providence.generator.format.java.JAnnotation;
import net.morimekta.providence.generator.format.java.JHelper;
import net.morimekta.providence.generator.format.java.JUtils;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.util.Strings;

public class JField {
    private final CField field;
    private final JHelper helper;
    private final int index;

    public JField(CField field, JHelper helper, int index) {
        this.field = field;
        this.helper = helper;
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public PField getPField() {
        return this.field;
    }

    public PType type() {
        return this.field.getType();
    }

    public boolean binary() {
        return this.field.getType() == PType.BINARY;
    }

    public int id() {
        return this.field.getKey();
    }

    public String name() {
        return this.field.getName();
    }

    public String param() {
        return JUtils.camelCase("p", this.field.getName());
    }

    public String member() {
        return JUtils.camelCase("m", this.field.getName());
    }

    public String isSet() {
        return JUtils.camelCase("isSet", this.field.getName());
    }

    public String getter() {
        if (this.field.getType() == PType.BOOL) {
            return JUtils.camelCase("is", this.field.getName());
        }
        return JUtils.camelCase("get", this.field.getName());
    }

    public String presence() {
        return JUtils.camelCase("has", this.field.getName());
    }

    public String counter() {
        return JUtils.camelCase("num", this.field.getName());
    }

    public String setter() {
        return JUtils.camelCase("set", this.field.getName());
    }

    public String adder() {
        if (this.field.getType() == PType.MAP) {
            return JUtils.camelCase("putIn", this.field.getName());
        }
        return JUtils.camelCase("addTo", this.field.getName());
    }

    public String resetter() {
        return JUtils.camelCase("clear", this.field.getName());
    }

    public String fieldEnum() {
        return Strings.c_case((String)"", (String)this.field.getName()).toUpperCase();
    }

    public String kDefault() {
        return JUtils.camelCase("kDefault", this.field.getName());
    }

    public boolean hasDefault() {
        return this.alwaysPresent() || this.field.hasDefaultValue();
    }

    public boolean isRequired() {
        return this.field.getRequirement() == PRequirement.REQUIRED;
    }

    public boolean container() {
        switch (this.field.getType()) {
            case MAP: 
            case SET: 
            case LIST: {
                return true;
            }
        }
        return false;
    }

    public ContainerType containerType() {
        return JAnnotation.containerType(this);
    }

    public boolean alwaysPresent() {
        return this.field.getRequirement() != PRequirement.OPTIONAL && this.field.getDescriptor() instanceof PPrimitive && ((PPrimitive)this.field.getDescriptor()).getDefaultValue() != null;
    }

    public String valueType() throws GeneratorException {
        return this.helper.getValueType(this.field.getDescriptor());
    }

    public String fieldType() throws GeneratorException {
        if (this.alwaysPresent()) {
            return this.valueType();
        }
        return this.helper.getFieldType(this.field.getDescriptor());
    }

    public String instanceType() throws GeneratorException {
        return this.helper.getInstanceClassName((PField)this.field);
    }

    public String builderFieldType() throws GeneratorException {
        switch (this.field.getType()) {
            case MAP: {
                return PMap.Builder.class.getName().replace('$', '.');
            }
            case SET: {
                return PSet.Builder.class.getName().replace('$', '.');
            }
            case LIST: {
                return PList.Builder.class.getName().replace('$', '.');
            }
        }
        return this.fieldType();
    }

    public String fieldInstanceType() throws GeneratorException {
        switch (this.field.getType()) {
            case MAP: {
                switch (this.containerType()) {
                    case DEFAULT: {
                        return ImmutableMap.class.getName().replace('$', '.');
                    }
                    case SORTED: {
                        return ImmutableSortedMap.class.getName().replace('$', '.');
                    }
                    case ORDERED: {
                        return LinkedHashMap.class.getName().replace('$', '.');
                    }
                }
            }
            case SET: {
                switch (this.containerType()) {
                    case DEFAULT: {
                        return ImmutableSet.class.getName().replace('$', '.');
                    }
                    case SORTED: {
                        return ImmutableSortedSet.class.getName().replace('$', '.');
                    }
                    case ORDERED: {
                        return LinkedHashSet.class.getName().replace('$', '.');
                    }
                }
            }
            case LIST: {
                return ImmutableList.class.getName().replace('$', '.');
            }
        }
        return this.fieldType();
    }

    public String getProvider() throws GeneratorException {
        String container = this.field.getAnnotationValue("container");
        String containerProvider = "provider";
        if (container != null) {
            ContainerType containerType = ContainerType.valueOf(container.toUpperCase());
            if (containerType == null) {
                throw new GeneratorException("Unknown container type: " + container);
            }
            switch (containerType) {
                case DEFAULT: {
                    containerProvider = "provider";
                    break;
                }
                case SORTED: {
                    containerProvider = "sortedProvider";
                    break;
                }
                case ORDERED: {
                    containerProvider = "orderedProvider";
                }
            }
        }
        switch (this.field.getType()) {
            case ENUM: 
            case MESSAGE: {
                return String.format("%s.provider()", this.helper.getFieldType(this.field.getDescriptor()));
            }
            case LIST: {
                PList lType = (PList)this.field.getDescriptor();
                return String.format("%s.provider(%s)", PList.class.getName(), this.helper.getProviderName(lType.itemDescriptor()));
            }
            case SET: {
                PSet sType = (PSet)this.field.getDescriptor();
                return String.format("%s.%s(%s)", PSet.class.getName(), containerProvider, this.helper.getProviderName(sType.itemDescriptor()));
            }
            case MAP: {
                PMap mType = (PMap)this.field.getDescriptor();
                return String.format("%s.%s(%s,%s)", PMap.class.getName(), containerProvider, this.helper.getProviderName(mType.keyDescriptor()), this.helper.getProviderName(mType.itemDescriptor()));
            }
        }
        if (!(this.field.getDescriptor() instanceof PPrimitive)) {
            throw new IllegalArgumentException("Unhandled type group " + this.field.getType());
        }
        return String.format("%s.%s.provider()", PPrimitive.class.getName(), this.field.getDescriptor().getName().toUpperCase());
    }

    public String builderInstanceType() throws GeneratorException {
        switch (this.field.getType()) {
            case MAP: {
                switch (this.containerType()) {
                    case DEFAULT: {
                        return PMap.ImmutableMapBuilder.class.getName().replace('$', '.');
                    }
                    case SORTED: {
                        return PMap.ImmutableSortedMapBuilder.class.getName().replace('$', '.');
                    }
                    case ORDERED: {
                        return PMap.LinkedHashMapBuilder.class.getName().replace('$', '.');
                    }
                }
            }
            case SET: {
                switch (this.containerType()) {
                    case DEFAULT: {
                        return PSet.ImmutableSetBuilder.class.getName().replace('$', '.');
                    }
                    case SORTED: {
                        return PSet.ImmutableSortedSetBuilder.class.getName().replace('$', '.');
                    }
                    case ORDERED: {
                        return PSet.LinkedHashSetBuilder.class.getName().replace('$', '.');
                    }
                }
            }
            case LIST: {
                return PList.ImmutableListBuilder.class.getName().replace('$', '.');
            }
        }
        return this.fieldType();
    }

    public boolean hasComment() {
        return this.field.getComment() != null;
    }

    public String comment() {
        return this.field.getComment();
    }
}

