/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.thrift;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.util.Binary;
import net.morimekta.util.io.IndentedPrintWriter;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonWriter;

public class ThriftFormatter {
    private static final String BLOCK_COMMENT_START = "/**";
    private static final String BLOCK_COMMENT_LINE = " * ";
    private static final String BLOCK_COMMENT_END = " */";
    private static final String REQUIRED = "required";
    private final EnumValuePresence mEnumValuePresence;

    public ThriftFormatter() {
        this(EnumValuePresence.NON_DEFAULT);
    }

    public ThriftFormatter(EnumValuePresence presence) {
        this.mEnumValuePresence = presence;
    }

    public void format(OutputStream out, CDocument document) {
        IndentedPrintWriter writer = new IndentedPrintWriter(out);
        try {
            this.appendDocument(writer, document);
            writer.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write to stream", e);
        }
        catch (JsonException e) {
            throw new IllegalStateException("Unable to write json constant", e);
        }
    }

    private void appendDocument(IndentedPrintWriter builder, CDocument document) throws IOException, JsonException {
        boolean first = true;
        if (document.getComment() != null) {
            this.appendBlockComment(builder, document.getComment(), first);
            first = false;
        }
        if (document.getNamespaces().size() > 0) {
            for (Map.Entry namespace : document.getNamespaces().entrySet()) {
                if (first) {
                    builder.format("namespace %s %s", new Object[]{namespace.getKey(), namespace.getValue()});
                    first = false;
                    continue;
                }
                builder.formatln("namespace %s %s", new Object[]{namespace.getKey(), namespace.getValue()});
            }
            builder.newline();
        }
        if (document.getIncludes().size() > 0) {
            for (String include : document.getIncludes()) {
                builder.formatln("include \"%s.thrift\"", new Object[]{include});
            }
            builder.newline();
        }
        builder.newline();
        for (PDeclaredDescriptor type : document.getDeclaredTypes()) {
            switch (type.getType()) {
                case ENUM: {
                    this.appendEnum(builder, (PEnumDescriptor)type);
                    break;
                }
                case MESSAGE: {
                    this.appendStruct(builder, (PStructDescriptor)type);
                    break;
                }
                default: {
                    throw new IllegalStateException("Document " + document.getPackageName() + ".thrift contains invalid declared type " + type.getName());
                }
            }
            builder.newline();
        }
        for (PField constant : document.getConstants()) {
            builder.formatln("const %s %s = ", new Object[]{constant.getDescriptor().getQualifiedName(document.getPackageName()), constant.getName()});
            JsonWriter json = new JsonWriter((PrintWriter)builder);
            this.appendTypedValue(json, constant.getDefaultValue(), constant.getDescriptor(), document.getPackageName());
            json.flush();
            builder.newline();
        }
    }

    private void appendBlockComment(IndentedPrintWriter builder, String comment, boolean first) throws IOException {
        String[] lines = comment.split("\n");
        if (first) {
            builder.append((CharSequence)BLOCK_COMMENT_START);
        } else {
            builder.appendln((CharSequence)BLOCK_COMMENT_START);
        }
        if (lines.length == 1) {
            builder.append(' ').append((CharSequence)comment).append((CharSequence)BLOCK_COMMENT_END);
        } else {
            for (String line : lines) {
                builder.appendln((CharSequence)BLOCK_COMMENT_LINE).append((CharSequence)line);
            }
            builder.appendln((CharSequence)BLOCK_COMMENT_END);
        }
    }

    private void appendStruct(IndentedPrintWriter builder, PStructDescriptor<?, ?> type) throws IOException, JsonException {
        if (type.getComment() != null) {
            this.appendBlockComment(builder, type.getComment(), false);
        }
        builder.formatln("%s %s {", new Object[]{type.getVariant().getName(), type.getName()}).begin();
        for (PField field : type.getFields()) {
            if (field.getComment() != null) {
                this.appendBlockComment(builder, field.getComment(), false);
            }
            builder.formatln("%d: ", new Object[]{field.getKey()});
            if (field.getRequirement() != PRequirement.DEFAULT) {
                builder.format("%s ", new Object[]{field.getRequirement().label});
            }
            builder.format("%s %s", new Object[]{field.getDescriptor().getQualifiedName(type.getPackageName()), field.getName()});
            if (field.getDefaultValue() != null) {
                builder.append((CharSequence)" = ");
                JsonWriter json = new JsonWriter((PrintWriter)builder);
                this.appendTypedValue(json, field.getDefaultValue(), field.getDescriptor(), field.getDescriptor().getPackageName());
                json.flush();
            }
            builder.append(';');
        }
        builder.end().appendln('}');
    }

    private void appendEnum(IndentedPrintWriter builder, PEnumDescriptor<?> type) throws IOException {
        if (type.getComment() != null) {
            this.appendBlockComment(builder, type.getComment(), false);
        }
        builder.formatln("enum %s {", new Object[]{type.getName()}).begin();
        int nextValue = this.mEnumValuePresence.equals((Object)EnumValuePresence.FIRST) ? -1 : 0;
        for (PEnumValue value : type.getValues()) {
            if (value.getComment() != null) {
                this.appendBlockComment(builder, value.getComment(), false);
            }
            builder.appendln((CharSequence)value.getName());
            if (value.getValue() != nextValue || this.mEnumValuePresence.equals((Object)EnumValuePresence.ALWAYS)) {
                builder.format(" = %d", new Object[]{value.getValue()});
                nextValue = value.getValue() + 1;
            } else {
                ++nextValue;
            }
            builder.append(';');
        }
        builder.end().appendln('}');
    }

    protected void appendTypedValue(JsonWriter writer, Object value, PDescriptor type, String packageContext) throws IOException, JsonException {
        switch (type.getType()) {
            case ENUM: {
                writer.valueLiteral((CharSequence)String.format("%s.%s", type.getQualifiedName(packageContext), value.toString()));
                break;
            }
            case LIST: 
            case SET: {
                PContainer cType = (PContainer)type;
                Collection collection = (Collection)value;
                writer.array();
                for (Object item : collection) {
                    this.appendTypedValue(writer, item, cType.itemDescriptor(), packageContext);
                }
                writer.endArray();
                break;
            }
            case MAP: {
                PMap mType = (PMap)type;
                Map map = (Map)value;
                writer.object();
                for (Map.Entry entry : map.entrySet()) {
                    this.appendMapKey(writer, entry.getKey());
                    this.appendTypedValue(writer, entry.getValue(), mType.itemDescriptor(), packageContext);
                }
                writer.endObject();
                break;
            }
            case MESSAGE: {
                this.appendMessage(writer, (PMessage)value, packageContext);
                break;
            }
            default: {
                this.appendPrimitive(writer, value);
            }
        }
    }

    private void appendMapKey(JsonWriter writer, Object key) throws IOException, JsonException {
        if (key instanceof PEnumValue) {
            PEnumValue ev = (PEnumValue)key;
            writer.keyLiteral((CharSequence)String.format("%s.%s", ev.descriptor().getName(), ev.toString()));
        } else if (key instanceof Boolean) {
            writer.key(((Boolean)key).booleanValue());
        } else if (key instanceof Byte) {
            writer.key(((Byte)key).byteValue());
        } else if (key instanceof Short) {
            writer.key(((Short)key).shortValue());
        } else if (key instanceof Integer) {
            writer.key(((Integer)key).intValue());
        } else if (key instanceof Long) {
            writer.key(((Long)key).longValue());
        } else if (key instanceof Double) {
            writer.key(((Double)key).doubleValue());
        } else if (key instanceof String) {
            writer.key((CharSequence)((String)key));
        } else if (key instanceof Binary) {
            writer.key((Binary)key);
        } else {
            throw new IllegalArgumentException("No such primitive value type: " + key.getClass().getSimpleName());
        }
    }

    private void appendPrimitive(JsonWriter writer, Object value) throws IOException, JsonException {
        if (value instanceof PEnumValue) {
            PEnumValue ev = (PEnumValue)value;
            writer.valueLiteral((CharSequence)String.format("%s.%s", ev.descriptor().getName(), ev.toString()));
        } else if (value instanceof Boolean) {
            writer.value(((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            writer.value(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            writer.value(((Short)value).shortValue());
        } else if (value instanceof Integer) {
            writer.value(((Integer)value).intValue());
        } else if (value instanceof Long) {
            writer.value(((Long)value).longValue());
        } else if (value instanceof Double) {
            writer.value(((Double)value).doubleValue());
        } else if (value instanceof String) {
            writer.value((CharSequence)((String)value));
        } else if (value instanceof Binary) {
            writer.value((Binary)value);
        } else {
            throw new IllegalArgumentException("No such primitive value type: " + value.getClass().getSimpleName());
        }
    }

    private void appendMessage(JsonWriter writer, PMessage<?> message, String packageContext) throws IOException, JsonException {
        writer.object();
        for (PField field : message.descriptor().getFields()) {
            if (!message.has(field.getKey())) continue;
            writer.key((CharSequence)field.getName());
            this.appendTypedValue(writer, message.get(field.getKey()), field.getDescriptor(), packageContext);
        }
        writer.endObject();
    }

    public static enum EnumValuePresence {
        ALWAYS,
        FIRST,
        NON_DEFAULT;

    }
}

