/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JField;
import net.morimekta.providence.generator.format.java.JHeader;
import net.morimekta.providence.generator.format.java.JHelper;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.util.Binary;
import net.morimekta.util.io.IndentedPrintWriter;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonWriter;

public class JValueFormat {
    private final JOptions options;
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public JValueFormat(IndentedPrintWriter writer, JOptions options, JHelper helper) {
        this.writer = writer;
        this.options = options;
        this.helper = helper;
    }

    public void appendDefaultConstants(List<JField> fields) throws GeneratorException {
        boolean hasDefault = false;
        for (JField field : fields) {
            Object defaultValue;
            if (!field.hasDefault() || (defaultValue = this.helper.getDefaultValue(field.getPField())) == null) continue;
            hasDefault = true;
            this.writer.formatln("private final static %s %s = ", new Object[]{field.valueType(), field.kDefault()}).begin("        ");
            this.appendTypedValue(defaultValue, field.getPField().getDescriptor());
            this.writer.append(';').end();
        }
        if (hasDefault) {
            this.writer.newline();
        }
    }

    public void addTypeImports(JHeader header, PDescriptor<?> descriptor) throws GeneratorException {
        switch (descriptor.getType()) {
            case ENUM: 
            case MESSAGE: {
                header.include(this.helper.getQualifiedInstanceClassName(descriptor));
                header.include(this.helper.getQualifiedValueTypeName(descriptor));
                break;
            }
            case LIST: {
                PContainer lType = (PContainer)descriptor;
                header.include(Collection.class.getName());
                header.include(Collections.class.getName());
                header.include(PList.class.getName());
                header.include(this.helper.getQualifiedInstanceClassName(descriptor));
                header.include(this.helper.getQualifiedValueTypeName(descriptor));
                this.addTypeImports(header, lType.itemDescriptor());
                break;
            }
            case SET: {
                PContainer sType = (PContainer)descriptor;
                header.include(Collection.class.getName());
                header.include(Collections.class.getName());
                header.include(PSet.class.getName());
                header.include(this.helper.getQualifiedInstanceClassName(descriptor));
                header.include(this.helper.getQualifiedValueTypeName(descriptor));
                if (this.options.android) {
                    header.include(ArrayList.class.getName());
                }
                this.addTypeImports(header, sType.itemDescriptor());
                break;
            }
            case MAP: {
                PMap mType = (PMap)descriptor;
                header.include(Collections.class.getName());
                header.include(PMap.class.getName());
                header.include(this.helper.getQualifiedInstanceClassName(descriptor));
                header.include(this.helper.getQualifiedValueTypeName(descriptor));
                header.include(this.helper.getQualifiedInstanceClassName(mType.itemDescriptor()));
                header.include(this.helper.getQualifiedInstanceClassName(mType.keyDescriptor()));
                this.addTypeImports(header, mType.keyDescriptor());
                this.addTypeImports(header, mType.itemDescriptor());
                break;
            }
            case BINARY: {
                header.include(PPrimitive.class.getName());
                header.include(Binary.class.getName());
                break;
            }
            default: {
                header.include(PPrimitive.class.getName());
            }
        }
    }

    public void appendTypedValue(Object value, PDescriptor<?> type) throws GeneratorException {
        switch (type.getType()) {
            case BOOL: {
                this.writer.append((CharSequence)value.toString());
                break;
            }
            case BYTE: {
                this.writer.append((CharSequence)"(byte)").append((CharSequence)value.toString());
                break;
            }
            case I16: {
                this.writer.append((CharSequence)"(short)").append((CharSequence)value.toString());
                break;
            }
            case I32: {
                this.writer.append((CharSequence)value.toString());
                break;
            }
            case I64: {
                this.writer.append((CharSequence)value.toString()).append((CharSequence)"L");
                break;
            }
            case DOUBLE: {
                this.writer.append((CharSequence)value.toString()).append((CharSequence)"d");
                break;
            }
            case BINARY: {
                this.writer.append((CharSequence)"Binary.wrap(new byte[]{");
                byte[] bytes = (byte[])value;
                boolean first = true;
                for (byte b : bytes) {
                    if (first) {
                        first = false;
                    } else {
                        this.writer.append(',');
                    }
                    this.writer.format("0x%02x", new Object[]{b});
                }
                this.writer.append((CharSequence)"})");
                break;
            }
            case STRING: {
                try {
                    JsonWriter json = new JsonWriter((PrintWriter)this.writer);
                    json.value((CharSequence)value.toString());
                    json.flush();
                    break;
                }
                catch (JsonException je) {
                    throw new GeneratorException("Unable to format string value");
                }
            }
            case ENUM: {
                this.writer.format("%s.%s", new Object[]{this.helper.getInstanceClassName(type), value.toString()});
                break;
            }
            case MESSAGE: {
                throw new GeneratorException("Message structs cannot have default values");
            }
            case LIST: 
            case SET: 
            case MAP: {
                throw new GeneratorException("Collections cannot have default value.");
            }
        }
    }
}

