/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.io.File;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class JUtils {
    public static long generateSerialVersionUID(PStructDescriptor<?, ?> type) {
        String string = type.getVariant().getName() + " " + type.getQualifiedName(null);
        long hash = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            hash = 4909L * hash + 7919L * (long)string.charAt(i);
        }
        return hash;
    }

    public static String getClassName(PDeclaredDescriptor<?> type) {
        return Strings.camelCase((String)"", (String)type.getName());
    }

    public static String getJavaPackage(CDocument document) throws GeneratorException {
        String javaPackage = document.getNamespaceForLanguage("java");
        if (javaPackage == null) {
            throw new GeneratorException("No java namespace for thrift package " + document.getPackageName());
        }
        return javaPackage;
    }

    public static String getPackageClassPath(String javaPackage) throws GeneratorException {
        String[] parts = javaPackage.split("[.]");
        return Strings.join((String)File.separator, (String[])parts);
    }

    public static void appendBlockComment(IndentedPrintWriter writer, String comment) {
        String[] lines = comment.split("\n");
        if (lines.length == 1) {
            writer.formatln("/** %s */", new Object[]{comment});
        } else {
            writer.appendln((CharSequence)"/**");
            for (String l : lines) {
                writer.formatln(" * %s", new Object[]{l});
            }
            writer.appendln((CharSequence)" */");
        }
    }
}

